/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer;

import java.io.Flushable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.util.Keyable;
import pyrosim.legacy_2012_1.thunderheadeng.util.KeyableObject;

public abstract class ABufferedNativeStream
implements INativeStream,
Flushable {
    public static final int DEFAULT_CAPACITY = 0x100000;
    private ByteBuffer d_writeBuffer;
    private final ReentrantLock d_bufferLock = new ReentrantLock();
    private ByteBuffer d_readBuffer;
    private Timer d_flushTimer = null;
    private final CustomList<Keyable> d_strongReferences = new CustomList(262144);
    private int d_numStrongRefsFinished = 0;

    public ABufferedNativeStream() {
        this(0x100000, 0x100000);
    }

    public ABufferedNativeStream(int writeCapacity, int readCapacity) {
        this.d_writeBuffer = ByteBuffer.allocateDirect(writeCapacity).order(ByteOrder.nativeOrder());
        this.d_readBuffer = ByteBuffer.allocateDirect(readCapacity).order(ByteOrder.nativeOrder());
    }

    public boolean setWriteCapacity(int capacity) {
        this.lockWriteBuffer();
        if (this.getWritePosition() != 0) {
            this.unlockWriteBuffer();
            return false;
        }
        this.d_writeBuffer = ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
        this.unlockWriteBuffer();
        return true;
    }

    public void lockWriteBuffer() {
        this.d_bufferLock.lock();
    }

    public void unlockWriteBuffer() {
        this.d_bufferLock.unlock();
    }

    public final int getWritePosition() {
        return this.d_writeBuffer.position();
    }

    @Override
    public final void write(Keyable val) {
        this.d_strongReferences.add(val);
        this.checkBuffer(4);
        this.d_writeBuffer.putInt(val != null ? val.getKey() : 0);
    }

    @Override
    public final void write(Keyable ... vals) {
        for (Keyable val : vals) {
            this.write(val);
        }
    }

    @Override
    public void write(Collection<? extends Keyable> vals) {
        for (Keyable keyable : vals) {
            this.write(keyable);
        }
    }

    @Override
    public final void writeBoolean(boolean val) {
        this.checkBuffer(1);
        this.d_writeBuffer.put(val ? (byte)1 : 0);
    }

    @Override
    public final void writeBooleans(boolean ... vals) {
        for (boolean val : vals) {
            this.writeBoolean(val);
        }
    }

    @Override
    public final void writeByte(byte val) {
        this.checkBuffer(1);
        this.d_writeBuffer.put(val);
    }

    @Override
    public final void writeBytes(byte ... vals) {
        for (byte val : vals) {
            this.writeByte(val);
        }
    }

    @Override
    public final void writeShort(short val) {
        this.checkBuffer(2);
        this.d_writeBuffer.putShort(val);
    }

    @Override
    public final void writeShorts(short ... vals) {
        for (short val : vals) {
            this.writeShort(val);
        }
    }

    @Override
    public final void writeLong(long val) {
        this.checkBuffer(8);
        this.d_writeBuffer.putLong(val);
    }

    @Override
    public final void writeLongs(long ... vals) {
        for (long val : vals) {
            this.writeLong(val);
        }
    }

    @Override
    public void writeChar(char val) {
        this.checkBuffer(2);
        this.d_writeBuffer.putChar(val);
    }

    @Override
    public void writeChars(char ... vals) {
        for (char val : vals) {
            this.writeChar(val);
        }
    }

    @Override
    public final void writeInt(int val) {
        this.checkBuffer(4);
        this.d_writeBuffer.putInt(val);
    }

    @Override
    public final void writeInts(int ... vals) {
        for (int val : vals) {
            this.writeInt(val);
        }
    }

    @Override
    public final void writeFloat(float val) {
        this.checkBuffer(4);
        this.d_writeBuffer.putFloat(val);
    }

    @Override
    public final void writeFloats(float ... vals) {
        for (float val : vals) {
            this.writeFloat(val);
        }
    }

    @Override
    public final void writeDouble(double val) {
        this.checkBuffer(8);
        this.d_writeBuffer.putDouble(val);
    }

    @Override
    public final void writeDoubles(double ... vals) {
        for (double val : vals) {
            this.writeDouble(val);
        }
    }

    @Override
    public void writeString(String str) {
        if (str == null) {
            this.writeInt(0);
            return;
        }
        this.writeInt(str.length());
        for (int m = 0; m < str.length(); ++m) {
            char c = str.charAt(m);
            this.writeChar(c);
        }
    }

    @Override
    public void writeStrings(String ... strs) {
        for (String s : strs) {
            this.writeString(s);
        }
    }

    @Override
    public void writeObject(Object obj) {
        if (obj == null) {
            this.writeInt(0);
        } else if (obj instanceof Byte) {
            this.writeByte((Byte)obj);
        } else if (obj instanceof byte[]) {
            this.writeBytes((byte[])obj);
        } else if (obj instanceof Short) {
            this.writeShort((Short)obj);
        } else if (obj instanceof short[]) {
            this.writeShorts((short[])obj);
        } else if (obj instanceof Long) {
            this.writeLong((Long)obj);
        } else if (obj instanceof long[]) {
            this.writeLongs((long[])obj);
        } else if (obj instanceof Boolean) {
            this.writeBoolean((Boolean)obj);
        } else if (obj instanceof boolean[]) {
            this.writeBooleans((boolean[])obj);
        } else if (obj instanceof Character) {
            this.writeChar(((Character)obj).charValue());
        } else if (obj instanceof char[]) {
            this.writeChars((char[])obj);
        } else if (obj instanceof Integer) {
            this.writeInt((Integer)obj);
        } else if (obj instanceof int[]) {
            this.writeInts((int[])obj);
        } else if (obj instanceof Float) {
            this.writeFloat(((Float)obj).floatValue());
        } else if (obj instanceof float[]) {
            this.writeFloats((float[])obj);
        } else if (obj instanceof Double) {
            this.writeDouble((Double)obj);
        } else if (obj instanceof double[]) {
            this.writeDoubles((double[])obj);
        } else if (obj instanceof Keyable) {
            this.write((Keyable)obj);
        } else if (obj instanceof Keyable[]) {
            this.write((Keyable[])obj);
        } else if (obj instanceof String) {
            this.writeString((String)obj);
        } else if (obj instanceof String[]) {
            this.writeStrings((String[])obj);
        } else if (obj instanceof Object[]) {
            this.writeObjects((Object[])obj);
        } else assert (false) : "ABufferedNativeStream.writeObject failed: didn't recognize object type, " + obj.getClass();
    }

    @Override
    public void writeObjects(Object ... objs) {
        for (Object obj : objs) {
            this.writeObject(obj);
        }
    }

    @Override
    public Keyable read() {
        int key = this.d_readBuffer.getInt();
        return KeyableObject.KEY_GENERATOR.get(key);
    }

    @Override
    public void read(Keyable ... vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.read();
        }
    }

    @Override
    public void read(int count, Collection<Keyable> vals) {
        for (int m = 0; m < count; ++m) {
            vals.add(this.read());
        }
    }

    @Override
    public boolean readBoolean() {
        return this.d_readBuffer.get() != 0;
    }

    @Override
    public void readBooleans(boolean[] vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.d_readBuffer.get() != 0;
        }
    }

    @Override
    public byte readByte() {
        return this.d_readBuffer.get();
    }

    @Override
    public void readBytes(byte[] vals) {
        this.d_readBuffer.get(vals, 0, vals.length);
    }

    @Override
    public short readShort() {
        return this.d_readBuffer.getShort();
    }

    @Override
    public void readShorts(short[] vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.d_readBuffer.getShort();
        }
    }

    @Override
    public long readLong() {
        return this.d_readBuffer.getLong();
    }

    @Override
    public void readLongs(long[] vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.d_readBuffer.getLong();
        }
    }

    @Override
    public char readChar() {
        return this.d_readBuffer.getChar();
    }

    @Override
    public void readChars(char[] vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.d_readBuffer.getChar();
        }
    }

    @Override
    public int readInt() {
        return this.d_readBuffer.getInt();
    }

    @Override
    public void readInts(int[] vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.d_readBuffer.getInt();
        }
    }

    @Override
    public float readFloat() {
        return this.d_readBuffer.getFloat();
    }

    @Override
    public void readFloats(float[] vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.d_readBuffer.getFloat();
        }
    }

    @Override
    public double readDouble() {
        return this.d_readBuffer.getDouble();
    }

    @Override
    public void readDoubles(double[] vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.d_readBuffer.getDouble();
        }
    }

    public double[] readDoubles(int count) {
        double[] vals = new double[count];
        this.readDoubles(vals);
        return vals;
    }

    @Override
    public String readString() {
        int count = this.readInt();
        char[] chars = new char[count];
        for (int m = 0; m < count; ++m) {
            chars[m] = this.readChar();
        }
        return new String(chars);
    }

    @Override
    public void readStrings(String[] vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.readString();
        }
    }

    private final void checkBuffer(int desiredWriteCount) {
        assert (desiredWriteCount <= this.d_writeBuffer.capacity());
        if (desiredWriteCount > this.d_writeBuffer.remaining()) {
            this.forceFlush();
        }
    }

    protected void markStrongRefsFinished() {
        this.d_numStrongRefsFinished = this.d_strongReferences.size();
    }

    private void clearFinishedStrongRefs() {
        int numUnfinished = this.d_strongReferences.size() - this.d_numStrongRefsFinished;
        if (numUnfinished == 0) {
            this.d_strongReferences.clear();
        } else {
            this.d_strongReferences.removeRange(0, this.d_numStrongRefsFinished);
        }
        this.d_numStrongRefsFinished = numUnfinished;
    }

    @Override
    public void flush() {
        this.lockWriteBuffer();
        this.forceFlush();
        this.unlockWriteBuffer();
    }

    protected final void forceFlush() {
        this.cancelScheduledFlush();
        if (this.d_writeBuffer.position() == 0) {
            return;
        }
        this.dispatch(this.d_writeBuffer, this.d_readBuffer);
        this.clearFinishedStrongRefs();
        this.d_writeBuffer.position(0);
        this.d_readBuffer.position(0);
    }

    protected abstract void dispatch(ByteBuffer var1, ByteBuffer var2);

    public final synchronized void scheduleFlush(long delayms) {
        if (this.d_flushTimer == null) {
            this.d_flushTimer = new Timer();
            this.d_flushTimer.schedule((TimerTask)new FlushTask(), delayms);
        }
    }

    public final synchronized void cancelScheduledFlush() {
        if (this.d_flushTimer != null) {
            this.d_flushTimer.cancel();
            this.d_flushTimer = null;
        }
    }

    private static class CustomList<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = -5364222441192552349L;

        public CustomList(int capacity) {
            super(capacity);
        }

        @Override
        public void removeRange(int from, int to) {
            super.removeRange(from, to);
        }
    }

    private final class FlushTask
    extends TimerTask {
        private FlushTask() {
        }

        @Override
        public void run() {
            ABufferedNativeStream.this.d_flushTimer = null;
            ABufferedNativeStream.this.lockWriteBuffer();
            ABufferedNativeStream.this.forceFlush();
            ABufferedNativeStream.this.unlockWriteBuffer();
        }
    }
}

