/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.table;

import java.awt.Component;
import java.text.ParseException;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.guiTable;
import pyrosim.legacy_2012_1.thunderheadeng.gui.table.guiTableClipboard;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;

public class DefaultTableClipboard
implements guiTableClipboard {
    @Override
    public boolean pasteObject(guiTable table, Object data, int pasteRow, int pasteCol) {
        try {
            if (data != null) {
                if ((data = this.formatData(table, data, pasteRow, pasteCol)) == null) {
                    return false;
                }
                if ((data = this.checkData(table, data, pasteRow, pasteCol)) == null) {
                    return false;
                }
            }
            table.getModel().setValueAt(data, table.convertRowIndexToModel(pasteRow), table.convertColumnIndexToModel(pasteCol));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Object formatData(guiTable table, Object data, int row, int column) {
        Component c;
        Class<Object> columnClass = table.getColumnClass(column);
        if (columnClass.isInstance(data)) {
            return data;
        }
        TableCellEditor editor = table.getCellEditor(row, column);
        if (editor != null && (c = table.prepareEditor(editor, row, column)) instanceof JTextComponent) {
            JTextComponent tc = (JTextComponent)c;
            tc.setText(data.toString());
            if (editor.stopCellEditing()) {
                return editor.getCellEditorValue();
            }
            editor.cancelCellEditing();
        }
        if (columnClass.isAssignableFrom(String.class)) {
            return data.toString();
        }
        if (Number.class.isAssignableFrom(columnClass)) {
            if (data instanceof Number) {
                return this.castNumberToDesiredNumberType(columnClass, (Number)data);
            }
            try {
                return this.getStringAsNumber(columnClass, data.toString());
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (columnClass.isAssignableFrom(UnitDouble.class)) {
            try {
                return Global.parseUnitDouble(data.toString(), null);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private Object checkData(guiTable table, Object data, int pasteRow, int pasteCol) {
        TableCellEditor editor;
        if (data instanceof UnitDouble && (editor = table.getCellEditor(pasteRow, pasteCol)) instanceof guiTable.UnitDoubleEditor) {
            UnitDouble ud = (UnitDouble)data;
            Unit unit = ((guiTable.UnitDoubleEditor)editor).getDefaultUnit();
            return ud.reinterpret(unit);
        }
        return data;
    }

    private Object getStringAsNumber(Class numberType, String string) throws NumberFormatException {
        if (numberType.isAssignableFrom(Double.class)) {
            try {
                return Global.parseDouble(string);
            }
            catch (ParseException e) {
                return Double.valueOf(string);
            }
        }
        if (numberType.isAssignableFrom(Float.class)) {
            return Float.valueOf(string);
        }
        if (numberType.isAssignableFrom(Integer.class)) {
            return Integer.valueOf(string);
        }
        if (numberType.isAssignableFrom(Long.class)) {
            return Long.valueOf(string);
        }
        if (numberType.isAssignableFrom(Short.class)) {
            return Short.valueOf(string);
        }
        if (numberType.isAssignableFrom(Byte.class)) {
            return Byte.valueOf(string);
        }
        assert (false);
        return null;
    }

    public Object castNumberToDesiredNumberType(Class desiredNumberType, Number number) {
        if (desiredNumberType.isAssignableFrom(Double.class)) {
            return number.doubleValue();
        }
        if (desiredNumberType.isAssignableFrom(Float.class)) {
            return Float.valueOf(number.floatValue());
        }
        if (desiredNumberType.isAssignableFrom(Integer.class)) {
            return number.intValue();
        }
        if (desiredNumberType.isAssignableFrom(Long.class)) {
            return number.longValue();
        }
        if (desiredNumberType.isAssignableFrom(Short.class)) {
            return number.shortValue();
        }
        if (desiredNumberType.isAssignableFrom(Byte.class)) {
            return number.byteValue();
        }
        assert (false);
        return null;
    }
}

