/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.AbstractCommand;
import pyrosim.legacy_2012_1.thunderheadeng.gui.CmdButton;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.Validateable;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiPanel;

public class guiHelpDialog
extends JDialog
implements Validateable {
    private static final long serialVersionUID = -3700437934151841702L;
    private static String PAGE_NOT_FOUND = "/pyrosim.legacy_2012_1.thunderheadeng/gui/pageNotFound.html";
    private guiPanel d_btnPanel;
    private guiPanel d_dialogPane;
    private Window d_owner;
    private Vector d_history;
    private int d_historyPos;
    private JEditorPane d_htmlView;
    private CmdButton d_forward;
    private CmdButton d_back;
    private URL d_notFoundURL;

    public guiHelpDialog(Dialog owner, URL helpFile) {
        super(owner, Intl.intl("Help"));
        this.d_owner = owner;
        this.d_history = new Vector(1);
        this.d_history.add(helpFile);
        this.d_historyPos = this.d_history.indexOf(helpFile);
        this.d_notFoundURL = this.getClass().getResource(PAGE_NOT_FOUND);
        this.getContentPane().setLayout(new BorderLayout());
        this.d_btnPanel = new guiPanel(new FlowLayout(2, 0, 0));
        JPanel btnGrid = new JPanel(new GridLayout(1, 0, 5, 5));
        this.d_btnPanel.setBorder(BorderFactory.createEmptyBorder(6, 12, 11, 11));
        this.d_btnPanel.add(btnGrid);
        JButton sizer = new JButton(Intl.intl("Cancel"));
        JButton button = new JButton(Intl.intl("OK"));
        button.setPreferredSize(sizer.getPreferredSize());
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (guiHelpDialog.this.validateData(true, true)) {
                    guiHelpDialog.this.dispose();
                }
            }
        });
        btnGrid.add(button);
        this.getRootPane().setDefaultButton(button);
        this.d_dialogPane = new guiPanel(new BorderLayout());
        this.d_dialogPane.setBorder(BorderFactory.createEmptyBorder(8, 2, 12, 2));
        this.getContentPane().add((Component)this.d_dialogPane, "Center");
        this.getContentPane().add((Component)this.d_btnPanel, "South");
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                guiHelpDialog.this.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.d_dialogPane.add((Component)this.getToolBar(), "North");
        if (helpFile != null) {
            try {
                this.d_htmlView = new JEditorPane(helpFile);
                this.d_htmlView.addHyperlinkListener(new Hyperactive());
                this.d_htmlView.setEditable(false);
                JScrollPane scroll = new JScrollPane(this.d_htmlView);
                scroll.setVerticalScrollBarPolicy(22);
                scroll.setHorizontalScrollBarPolicy(32);
                scroll.setPreferredSize(new Dimension(600, 500));
                this.d_dialogPane.add((Component)scroll, "Center");
            }
            catch (IOException e) {
                e.printStackTrace();
                this.dispose();
            }
        }
    }

    private JToolBar getToolBar() {
        JToolBar bar = new JToolBar(1);
        bar.setFloatable(false);
        bar.setLayout(new GridBagLayout());
        this.d_back = new CmdButton(new HelpBackCmd());
        this.d_forward = new CmdButton(new HelpForwardCmd());
        this.d_back.setToolTipText("Back");
        this.d_forward.setToolTipText("Forward");
        this.d_back.updateEnabled();
        this.d_forward.updateEnabled();
        GridBagUtil.add(bar, this.d_back, 0, 0, 1, 1, 2, 0, 2, 2, 0, 0.0, 0.0);
        GridBagUtil.add(bar, this.d_forward, 1, 0, 1, 1, 2, 0, 2, 12, 0, 0.0, 0.0);
        GridBagUtil.add(bar, Box.createGlue(), 10, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0);
        return bar;
    }

    public void center() {
        Point location;
        Dimension screenSize;
        Dimension dialogSize = this.getSize();
        if (this.d_owner == null) {
            screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            location = new Point(0, 0);
        } else {
            screenSize = this.d_owner.getSize();
            location = this.d_owner.getLocation();
        }
        this.setLocation(location.x + screenSize.width / 2 - dialogSize.width / 2, location.y + screenSize.height / 2 - dialogSize.height / 2);
    }

    public void showHelp() {
        this.pack();
        this.center();
        this.setResizable(true);
        this.setModal(false);
        this.setVisible(true);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        return this.d_dialogPane.validateData(showWarn, allowModify);
    }

    private Vector truncate(Vector v, int pos) {
        if (pos < 0 || pos >= v.size()) {
            return v;
        }
        for (int i = pos + 1; i < v.size(); ++i) {
            v.removeElementAt(i);
        }
        return v;
    }

    private class Hyperactive
    implements HyperlinkListener {
        private Hyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        pane.setPage(e.getURL());
                    }
                    catch (Throwable t) {
                        if (guiHelpDialog.this.d_notFoundURL != null) {
                            try {
                                guiHelpDialog.this.d_htmlView.setPage(guiHelpDialog.this.d_notFoundURL);
                            }
                            catch (IOException ioe) {
                                guiHelpDialog.this.d_htmlView.setText("");
                            }
                        }
                        guiHelpDialog.this.d_htmlView.setText("");
                    }
                }
                guiHelpDialog.this.d_history = guiHelpDialog.this.truncate(guiHelpDialog.this.d_history, guiHelpDialog.this.d_historyPos);
                guiHelpDialog.this.d_history.add(e.getURL());
                guiHelpDialog.this.d_historyPos = guiHelpDialog.this.d_history.indexOf(e.getURL());
                guiHelpDialog.this.d_back.updateEnabled();
                guiHelpDialog.this.d_forward.updateEnabled();
            }
        }
    }

    private class HelpForwardCmd
    extends AbstractCommand {
        public HelpForwardCmd() {
            super("", "/pyrosim.legacy_2012_1.thunderheadeng/gui/graphics/right.gif");
        }

        @Override
        public boolean isEnabled() {
            return guiHelpDialog.this.d_history.size() - 1 > guiHelpDialog.this.d_historyPos;
        }

        @Override
        public void execute() {
            if (guiHelpDialog.this.d_history.size() - 1 <= guiHelpDialog.this.d_historyPos) {
                return;
            }
            ++guiHelpDialog.this.d_historyPos;
            try {
                guiHelpDialog.this.d_htmlView.setPage((URL)guiHelpDialog.this.d_history.get(guiHelpDialog.this.d_historyPos));
            }
            catch (Throwable t) {
                if (guiHelpDialog.this.d_notFoundURL != null) {
                    try {
                        guiHelpDialog.this.d_htmlView.setPage(guiHelpDialog.this.d_notFoundURL);
                    }
                    catch (IOException ioe) {
                        guiHelpDialog.this.d_htmlView.setText("");
                    }
                }
                guiHelpDialog.this.d_htmlView.setText("");
            }
            guiHelpDialog.this.d_back.updateEnabled();
            guiHelpDialog.this.d_forward.updateEnabled();
        }
    }

    private class HelpBackCmd
    extends AbstractCommand {
        public HelpBackCmd() {
            super("", "/pyrosim.legacy_2012_1.thunderheadeng/gui/graphics/left.gif");
        }

        @Override
        public boolean isEnabled() {
            return guiHelpDialog.this.d_historyPos > 0;
        }

        @Override
        public void execute() {
            if (guiHelpDialog.this.d_historyPos <= 0) {
                return;
            }
            --guiHelpDialog.this.d_historyPos;
            try {
                guiHelpDialog.this.d_htmlView.setPage((URL)guiHelpDialog.this.d_history.get(guiHelpDialog.this.d_historyPos));
            }
            catch (Throwable t) {
                if (guiHelpDialog.this.d_notFoundURL != null) {
                    try {
                        guiHelpDialog.this.d_htmlView.setPage(guiHelpDialog.this.d_notFoundURL);
                    }
                    catch (IOException ioe) {
                        guiHelpDialog.this.d_htmlView.setText("");
                    }
                }
                guiHelpDialog.this.d_htmlView.setText("");
            }
            guiHelpDialog.this.d_back.updateEnabled();
            guiHelpDialog.this.d_forward.updateEnabled();
        }
    }
}

