/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.JColorChooser;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagUtil;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.ColorHistory;
import pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme.DoubleRGBChooser;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDialog;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDoubleField;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiLabel;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiPanel;
import pyrosim.legacy_2012_1.thunderheadeng.util.ColorPool;
import pyrosim.legacy_2012_1.thunderheadeng.util.DoubleVR;

public class SimpleColorChooser
extends guiDialog {
    private static final long serialVersionUID = 324998146549309706L;
    private final guiDoubleField d_alphaFld;
    private final JColorChooser d_chooser;
    private static JColorChooser s_chooser;

    public SimpleColorChooser(Window owner, String title) {
        this(owner, title, true);
    }

    public SimpleColorChooser(Window owner, String title, boolean sharedChooser) {
        super(owner, title, 9);
        this.d_chooser = SimpleColorChooser.getChooser(sharedChooser);
        AbstractColorChooserPanel[] panels = this.d_chooser.getChooserPanels();
        JTabbedPane tabs = new JTabbedPane();
        tabs.add("RGB", panels[3]);
        tabs.add(Intl.intl("Palette"), panels[0]);
        tabs.add(Intl.intl("Sliders"), panels[2]);
        this.d_alphaFld = new guiDoubleField(1.0, DoubleVR.between(0.0, 1.0, true, true));
        guiPanel alphaPanel = new guiPanel(new GridBagLayout());
        GridBagUtil.add(alphaPanel, new guiLabel(Intl.intl("Alpha") + ":"), 0, 0, 1, 1, 0, 0, 0, 6, 0, 1.0, 1.0, 17);
        GridBagUtil.add(alphaPanel, this.d_alphaFld, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1.0, 1.0, 17);
        this.getDialogPane().setLayout(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(this.getDialogPane(), alphaPanel, 0, ++row, 1, 1, 0, 6, 11, 0, 0, 1.0, 1.0, 17);
        GridBagUtil.add(this.getDialogPane(), tabs, 0, ++row, 2, 1, 0, 0, 11, 0);
        GridBagUtil.add(this.getDialogPane(), this.d_chooser.getPreviewPanel(), 0, ++row, 1, 1, 0, 0, 0, 0, 0, 1.0, 1.0, 10);
    }

    @Override
    public int doModal() {
        return super.doModal();
    }

    public Color getColor() {
        Color chooserColor = this.d_chooser.getColor();
        float[] comps = new float[3];
        chooserColor.getRGBColorComponents(comps);
        Color color = new Color(comps[0], comps[1], comps[2], (float)((Double)this.d_alphaFld.getValue()).doubleValue());
        return ColorPool.get(color);
    }

    public void setColor(Color c) {
        this.d_chooser.setColor(c);
        float[] comps = new float[4];
        c.getComponents(comps);
        this.d_alphaFld.setValue(comps[3]);
    }

    private static JColorChooser getChooser(boolean shared) {
        if (!shared) {
            return SimpleColorChooser.createChooser();
        }
        if (s_chooser == null) {
            s_chooser = SimpleColorChooser.createChooser();
            s_chooser.getSelectionModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SimpleColorChooser scc = (SimpleColorChooser)SwingUtilities.getAncestorOfClass(SimpleColorChooser.class, s_chooser);
                    Color newColor = scc != null ? scc.getColor() : s_chooser.getColor();
                    ColorHistory.add(newColor);
                }
            });
        }
        return s_chooser;
    }

    private static JColorChooser createChooser() {
        JColorChooser chooser = new JColorChooser();
        chooser.addChooserPanel(new DoubleRGBChooser());
        return chooser;
    }
}

