/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui.colorscheme;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ColorScheme
implements Cloneable {
    private String d_name;
    private Hashtable d_colors;
    public static final String SEPARATOR = ".";

    public ColorScheme(String name) {
        this.d_name = name;
        this.d_colors = new Hashtable();
    }

    public Object clone(String name) {
        try {
            ColorScheme cs = (ColorScheme)super.clone();
            cs.d_name = name;
            return cs;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getName() {
        return this.d_name;
    }

    public String toString() {
        return "ColorScheme: " + this.getName() + " (" + this.d_colors.size() + " colors)";
    }

    public Color getColor(String colorName) {
        return (Color)this.d_colors.get(colorName);
    }

    public void setColor(String colorName, Color value) {
        this.d_colors.put(colorName, value);
    }

    public String[] getColorNames() {
        return this.d_colors.keySet().toArray(new String[this.d_colors.size()]);
    }

    public void load(Properties props, String prefix) {
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(prefix)) continue;
            String colorName = key.substring(prefix.length());
            try {
                Color color = Color.decode((String)props.get(key));
                this.d_colors.put(colorName, color);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void store(Properties props, String prefix) {
        Enumeration colors = this.d_colors.keys();
        while (colors.hasMoreElements()) {
            String colorName = (String)colors.nextElement();
            props.setProperty(prefix + this.d_name + SEPARATOR + colorName, this.encodeColor((Color)this.d_colors.get(colorName)));
        }
    }

    private String encodeColor(Color c) {
        int val = (c.getRed() << 16) + (c.getGreen() << 8) + c.getBlue();
        return "0x" + Integer.toHexString(val);
    }
}

