/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiStatusBar;

public class StatusBarTips {
    private final guiStatusBar d_statusBar;
    private final int d_statusBarPane;

    public StatusBarTips(guiStatusBar target, int targetPane) {
        this.d_statusBar = target;
        this.d_statusBarPane = targetPane;
    }

    public void addTrigger(AbstractButton trigger) {
        Action a = trigger.getAction();
        if (a != null) {
            StatusBarUpdater updater = new StatusBarUpdater(this);
            this.putTriggerImpl(trigger, updater);
        }
    }

    public void addTrigger(Component trigger, String tip) {
        if (tip != null) {
            ConstantUpdater updater = new ConstantUpdater(this, tip);
            this.putTriggerImpl(trigger, updater);
        }
    }

    private void putTriggerImpl(Component trigger, StatusBarUpdater updater) {
        trigger.addMouseListener(updater);
        if (trigger instanceof JMenuItem) {
            ((JMenuItem)trigger).addActionListener(updater);
        }
    }

    public void removeTrigger(Component trigger) {
        for (MouseListener list : trigger.getMouseListeners()) {
            if (!this.isListener(list)) continue;
            trigger.removeMouseListener(list);
        }
        if (trigger instanceof JMenuItem) {
            JMenuItem item = (JMenuItem)trigger;
            for (ActionListener list : item.getActionListeners()) {
                if (!this.isListener(list)) continue;
                item.removeActionListener(list);
            }
        }
    }

    protected boolean isListener(EventListener list) {
        return list instanceof StatusBarUpdater && ((StatusBarUpdater)list).getTips() == this;
    }

    protected void setTip(String tip) {
        this.d_statusBar.setMessage(this.d_statusBarPane, tip);
    }

    private static class ConstantUpdater
    extends StatusBarUpdater {
        private final String d_tip;

        public ConstantUpdater(StatusBarTips tips, String tip) {
            super(tips);
            this.d_tip = tip;
        }

        @Override
        protected Object getTip(Object arg0) {
            return this.d_tip;
        }
    }

    private static class StatusBarUpdater
    extends MouseAdapter
    implements ActionListener {
        private final StatusBarTips d_tips;

        public StatusBarUpdater(StatusBarTips tips) {
            this.d_tips = tips;
        }

        public StatusBarTips getTips() {
            return this.d_tips;
        }

        protected Object getTip(Object src) {
            if (src instanceof AbstractButton) {
                return ((AbstractButton)src).getAction();
            }
            return null;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Object tip = this.getTip(e.getSource());
            if (tip instanceof Action) {
                tip = ((Action)tip).getValue("LongDescription");
            }
            if (tip != null) {
                this.d_tips.setTip(tip.toString());
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.d_tips.setTip("");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.d_tips.setTip("");
        }
    }
}

