/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ACurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ILinearCurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;

public class LineSeg
extends ACurve
implements ILinearCurve,
IManipulatable {
    static final long serialVersionUID = 1L;
    public final Point3d p1;
    public final Point3d p2;

    public LineSeg(Point3d p1, Point3d p2) {
        this.p1 = p1;
        this.p2 = p2;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 dict) {
        return new thunderheadeng.geometry.objs.LineSeg(this.p1, this.p2);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LineSeg)) {
            return false;
        }
        return this.equals((LineSeg)obj, true);
    }

    public boolean equals(LineSeg seg, boolean compareOrient) {
        if (seg == this) {
            return true;
        }
        if (!compareOrient) {
            return this.p1.equals(seg.p1) && this.p2.equals(seg.p2) || this.p1.equals(seg.p2) && this.p2.equals(seg.p1);
        }
        return this.p1.equals(seg.p1) && this.p2.equals(seg.p2);
    }

    @Override
    public int getNumVerts() {
        return 2;
    }

    @Override
    public Point3d getVert(int ix) {
        return ix == 0 ? this.p1 : this.p2;
    }

    public double getT(Point3d p) {
        return Util3D.tOnLineSeg(this.p1, this.p2, p);
    }

    @Override
    public LineSeg optimize(IPointOptimizer pool) {
        Point3d np1 = pool.getExisting(this.p1);
        Point3d np2 = pool.getExisting(this.p2);
        return np1 != this.p1 || np2 != this.p2 ? new LineSeg(np1, np2) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aabb) {
        aabb.add(this.p1);
        aabb.add(this.p2);
        return aabb;
    }

    public Vector3d getTangent(double t, ICurve.Orient orient, boolean normalize) {
        Vector3d tan;
        switch (orient) {
            case POSITIVE: {
                tan = Util3D.vector(this.p1, this.p2);
                break;
            }
            default: {
                tan = Util3D.vector(this.p2, this.p1);
            }
        }
        if (normalize) {
            tan.normalize();
        }
        return tan;
    }

    public Point3d evaluate(double t) {
        if (t == 0.0) {
            return new Point3d(this.p1);
        }
        if (t == 1.0) {
            return new Point3d(this.p2);
        }
        return Util3D.linesegPoint(this.p1, this.p2, t);
    }

    public LineSeg negate() {
        return new LineSeg(this.p2, this.p1);
    }

    public LineSeg trim(double t1, double t2) {
        if (t1 == 0.0 && t2 == 1.0) {
            return this;
        }
        return new LineSeg(this.evaluate(t1), this.evaluate(t2));
    }

    public double length() {
        return this.p1.distance(this.p2);
    }

    public double lengthSq() {
        return this.p1.distanceSquared(this.p2);
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public LineSeg transform(Matrix4d xform) {
        return new LineSeg(Util3D.xform(xform, this.p1), Util3D.xform(xform, this.p2));
    }

    @Override
    public Mesh getSegments(double errorTol) {
        Point3d[] points = new Point3d[]{this.p1, this.p2};
        return new Mesh(points, new int[]{0, 1}, 1);
    }

    @Override
    public boolean intersectsBox(Object source, IIsectFilter filter, ConvexHull region) {
        if (filter.acceptGeomType(source, GeomType.EDGE)) {
            return region.intersectsLineSeg(this.p1, this.p2, 1.0E-6);
        }
        return false;
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        double[] isect;
        if (filter.acceptGeomType(source, GeomType.VERTEX)) {
            isects.add(source, this.p1, GeomType.VERTEX, this);
            isects.add(source, this.p2, GeomType.VERTEX, this);
        }
        if (filter.acceptGeomType(source, GeomType.EDGE) && (isect = Inter3D.lineSegLineSegProximityT(rayBegin, rayEnd, this.p1, this.p2, 1.0E-6)) != null) {
            Point3d ip = Util3D.linesegPoint(this.p1, this.p2, isect[1]);
            isects.add(source, ip, GeomType.EDGE, this);
        }
    }

    @Override
    public Point3d project(Point3d p, double tol) {
        return Inter3D.nearestPointOnLineSeg(this.p1, this.p2, p);
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return Arrays.asList(new Handle(this, 0), new Handle(this, 1));
    }

    private static class Handle
    implements IHandle {
        private LineSeg d_geom;
        private final int d_ix;

        public Handle(LineSeg geom, int ix) {
            this.d_geom = geom;
            this.d_ix = ix;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Handle && ((Handle)obj).d_ix == this.d_ix;
        }

        @Override
        public IGeom getGeom() {
            return new Point(this.getLocation());
        }

        protected Point3d getLocation() {
            return this.d_ix == 0 ? this.d_geom.p1 : this.d_geom.p2;
        }

        @Override
        public IIsectFilter getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return null;
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public Object modify(Point3d newLoc) throws Exception {
            Point3d[] points = new Point3d[]{this.d_geom.p1, this.d_geom.p2};
            points[this.d_ix] = newLoc;
            this.d_geom = new LineSeg(points[0], points[1]);
            return this.d_geom;
        }

        @Override
        public Object end() {
            return this.d_geom;
        }
    }
}

