/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.APlaneHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Quad;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.TransformedGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.PlanarConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class AARectangle
extends AFace
implements IPolygon,
IManipulatable {
    static final long serialVersionUID = 1L;
    public static final byte X = 0;
    public static final byte Y = 1;
    public static final byte Z = 2;
    public final byte d_plane;
    public final double d_planeVal;
    public final double d_minx;
    public final double d_miny;
    public final double d_maxx;
    public final double d_maxy;

    public AARectangle() {
        this(2, 0.0, 0.0, 0.0, 1.0, 1.0);
    }

    public AARectangle(byte plane, double planeVal, double minx, double miny, double maxx, double maxy) {
        this.d_minx = minx;
        this.d_miny = miny;
        this.d_maxx = maxx;
        this.d_maxy = maxy;
        this.d_plane = plane;
        this.d_planeVal = planeVal;
    }

    @Override
    public thunderheadeng.geometry.objs.AARectangle fromLegacy(LegacyDictionary_2012_1 dict) {
        return new thunderheadeng.geometry.objs.AARectangle(this.d_plane, this.d_planeVal, this.d_minx, this.d_miny, this.d_maxx, this.d_maxy, false);
    }

    @Override
    public IPolygon optimize(IPointOptimizer pool) {
        return this;
    }

    public static AARectangle construct(Point3d p1, Point3d p2) {
        double maxy;
        double miny;
        double maxx;
        double minx;
        double planeVal;
        byte plane;
        if (theUtil.eq(p1.x, p2.x, 1.0E-9)) {
            plane = 0;
            planeVal = p1.x;
            minx = Math.min(p1.y, p2.y);
            maxx = Math.max(p1.y, p2.y);
            miny = Math.min(p1.z, p2.z);
            maxy = Math.max(p1.z, p2.z);
        } else if (theUtil.eq(p1.y, p2.y, 1.0E-9)) {
            plane = 1;
            planeVal = p1.y;
            minx = Math.min(p1.x, p2.x);
            maxx = Math.max(p1.x, p2.x);
            miny = Math.min(p1.z, p2.z);
            maxy = Math.max(p1.z, p2.z);
        } else if (theUtil.eq(p1.z, p2.z, 1.0E-9)) {
            plane = 2;
            planeVal = p1.z;
            minx = Math.min(p1.x, p2.x);
            maxx = Math.max(p1.x, p2.x);
            miny = Math.min(p1.y, p2.y);
            maxy = Math.max(p1.y, p2.y);
        } else {
            return null;
        }
        return new AARectangle(plane, planeVal, minx, miny, maxx, maxy);
    }

    @Override
    public AABox getBoundingBox(AABox bb) {
        switch (this.d_plane) {
            case 0: {
                bb.addPoint(this.d_planeVal, this.d_minx, this.d_miny);
                bb.addPoint(this.d_planeVal, this.d_maxx, this.d_maxy);
                break;
            }
            case 1: {
                bb.addPoint(this.d_minx, this.d_planeVal, this.d_miny);
                bb.addPoint(this.d_maxx, this.d_planeVal, this.d_maxy);
                break;
            }
            case 2: {
                bb.addPoint(this.d_minx, this.d_miny, this.d_planeVal);
                bb.addPoint(this.d_maxx, this.d_maxy, this.d_planeVal);
            }
        }
        return bb;
    }

    @Override
    public void getBoundary(List<ICurve> boundary) {
        PolyUtil.getBoundary(boundary, this);
    }

    public Point2d getMin() {
        return new Point2d(this.d_minx, this.d_miny);
    }

    public Point2d getMax() {
        return new Point2d(this.d_maxx, this.d_maxy);
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    private AARectangle transformAligned(Matrix4d xform) {
        AABox bb = this.getBoundingBox(new AABox());
        Point3d min = Util3D.xform(xform, bb.getMin());
        Point3d max = Util3D.xform(xform, bb.getMax());
        return AARectangle.construct(min, max);
    }

    @Override
    public IPolygon transform(Matrix4d xform) {
        if (IDOF.ALIGNED.accept(xform)) {
            return this.transformAligned(xform);
        }
        return this.toQuad(xform);
    }

    @Override
    public IGeom transform(Matrix4d xform, IGeom.XformOp op) {
        if (IDOF.ALIGNED.accept(xform)) {
            return this.transformAligned(xform);
        }
        switch (op) {
            case RETAINED: {
                return new TransformedGeom(xform, this);
            }
        }
        return this.toQuad(xform);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AARectangle)) {
            return false;
        }
        AARectangle rect = (AARectangle)obj;
        return this.d_plane == rect.d_plane && this.d_planeVal == rect.d_planeVal && this.getMin().equals(rect.getMin()) && this.getMax().equals(rect.getMax());
    }

    public int hashCode() {
        return this.d_plane + theUtil.hashCode(this.d_planeVal) + this.getMin().hashCode() + this.getMax().hashCode();
    }

    public Quad toQuad(Matrix4d parentXform) {
        Point3d p4;
        Point3d p3;
        Point3d p2;
        Point3d p1;
        switch (this.d_plane) {
            case 0: {
                p1 = new Point3d(this.d_planeVal, this.d_minx, this.d_miny);
                p2 = new Point3d(this.d_planeVal, this.d_maxx, this.d_miny);
                p3 = new Point3d(this.d_planeVal, this.d_maxx, this.d_maxy);
                p4 = new Point3d(this.d_planeVal, this.d_minx, this.d_maxy);
                break;
            }
            case 1: {
                p1 = new Point3d(this.d_minx, this.d_planeVal, this.d_miny);
                p2 = new Point3d(this.d_maxx, this.d_planeVal, this.d_miny);
                p3 = new Point3d(this.d_maxx, this.d_planeVal, this.d_maxy);
                p4 = new Point3d(this.d_minx, this.d_planeVal, this.d_maxy);
                break;
            }
            default: {
                p1 = new Point3d(this.d_minx, this.d_miny, this.d_planeVal);
                p2 = new Point3d(this.d_maxx, this.d_miny, this.d_planeVal);
                p3 = new Point3d(this.d_maxx, this.d_maxy, this.d_planeVal);
                p4 = new Point3d(this.d_minx, this.d_maxy, this.d_planeVal);
            }
        }
        if (parentXform != null) {
            parentXform.transform(p1);
            parentXform.transform(p2);
            parentXform.transform(p3);
            parentXform.transform(p4);
        }
        return new Quad(p1, p2, p3, p4);
    }

    @Override
    public Vector3d getNormal() {
        switch (this.d_plane) {
            case 0: {
                return new Vector3d(1.0, 0.0, 0.0);
            }
            case 1: {
                return new Vector3d(0.0, 1.0, 0.0);
            }
        }
        return new Vector3d(0.0, 0.0, 1.0);
    }

    @Override
    public int getNumLoops() {
        return 1;
    }

    @Override
    public int getNumPoints(int loop) {
        assert (loop == 0);
        return 4;
    }

    @Override
    public Point3d getPoint(int loop, int ix) {
        assert (ix < 4 && loop == 0);
        switch (this.d_plane) {
            case 0: {
                switch (ix) {
                    case 0: {
                        return new Point3d(this.d_planeVal, this.d_minx, this.d_miny);
                    }
                    case 1: {
                        return new Point3d(this.d_planeVal, this.d_maxx, this.d_miny);
                    }
                    case 2: {
                        return new Point3d(this.d_planeVal, this.d_maxx, this.d_maxy);
                    }
                }
                return new Point3d(this.d_planeVal, this.d_minx, this.d_maxy);
            }
            case 1: {
                switch (ix) {
                    case 0: {
                        return new Point3d(this.d_minx, this.d_planeVal, this.d_miny);
                    }
                    case 1: {
                        return new Point3d(this.d_minx, this.d_planeVal, this.d_maxy);
                    }
                    case 2: {
                        return new Point3d(this.d_maxx, this.d_planeVal, this.d_maxy);
                    }
                }
                return new Point3d(this.d_maxx, this.d_planeVal, this.d_miny);
            }
        }
        switch (ix) {
            case 0: {
                return new Point3d(this.d_minx, this.d_miny, this.d_planeVal);
            }
            case 1: {
                return new Point3d(this.d_maxx, this.d_miny, this.d_planeVal);
            }
            case 2: {
                return new Point3d(this.d_maxx, this.d_maxy, this.d_planeVal);
            }
        }
        return new Point3d(this.d_minx, this.d_maxy, this.d_planeVal);
    }

    @Override
    public Mesh triangulate(double errorTol) {
        return this.toQuad(null).triangulate(errorTol);
    }

    @Override
    public boolean intersectsBox(Object source, IIsectFilter filter, ConvexHull region) {
        return PolyUtil.intersectsBox(source, this, filter, region);
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        PolyUtil.pickPoints(this, isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
    }

    @Override
    public Point3d project(Point3d p) {
        return this.getPlane().projectOntoPlane(p);
    }

    @Override
    public IFace.PointClassify classify(Point3d p, double tol) {
        switch (this.d_plane) {
            case 0: {
                return AARectangle.classify(p.y, p.z, this.d_minx, this.d_maxx, this.d_miny, this.d_maxy, tol);
            }
            case 1: {
                return AARectangle.classify(p.x, p.z, this.d_minx, this.d_maxx, this.d_miny, this.d_maxy, tol);
            }
        }
        return AARectangle.classify(p.x, p.y, this.d_minx, this.d_maxx, this.d_miny, this.d_maxy, tol);
    }

    private static IFace.PointClassify classify(double lx, double ly, double minx, double maxx, double miny, double maxy, double tol) {
        if (theUtil.ge(lx, minx, tol) && theUtil.le(lx, maxx, tol) && theUtil.ge(ly, miny, tol) && theUtil.le(ly, maxy, tol)) {
            if (theUtil.eq(lx, minx, tol) || theUtil.eq(lx, maxx, tol) || theUtil.eq(ly, miny, tol) || theUtil.eq(ly, maxy, tol)) {
                return IFace.PointClassify.ON_BOUNDARY;
            }
            return IFace.PointClassify.INSIDE;
        }
        return IFace.PointClassify.OUTSIDE;
    }

    public Plane3d getPlane() {
        switch (this.d_plane) {
            case 0: {
                return new Plane3d(1.0, 0.0, 0.0, -this.d_planeVal);
            }
            case 1: {
                return new Plane3d(0.0, 1.0, 0.0, -this.d_planeVal);
            }
            case 2: {
                return new Plane3d(0.0, 0.0, 1.0, -this.d_planeVal);
            }
        }
        return null;
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return Arrays.asList(new VertHandle(this, 0, 1), new VertHandle(this, 0, 3), new VertHandle(this, 2, 1), new VertHandle(this, 2, 3), new PlaneHandle(this));
    }

    public static class VertHandle
    implements IHandle {
        public static final int MIN_X = 0;
        public static final int MIN_Y = 1;
        public static final int MAX_X = 2;
        public static final int MAX_Y = 3;
        private AARectangle geom;
        private final double[] bounds;
        private final int[] coords;

        public VertHandle(AARectangle geom, int coordx, int coordy) {
            this.geom = geom;
            double[] maxBounds = new double[]{-1.7976931348623157E308, -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE};
            this.bounds = VertHandle.getCoords(geom);
            this.bounds[coordx] = maxBounds[coordx];
            this.bounds[coordy] = maxBounds[coordy];
            this.coords = new int[]{coordx, coordy};
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof VertHandle && Arrays.equals(((VertHandle)obj).coords, this.coords);
        }

        @Override
        public IIsectFilter getPickFilter() {
            return null;
        }

        private static double[] getCoords(AARectangle geom) {
            return new double[]{geom.d_minx, geom.d_miny, geom.d_maxx, geom.d_maxy};
        }

        @Override
        public IGeom getGeom() {
            return new Point(this.getLocation());
        }

        protected Point3d getLocation() {
            double[] verts = VertHandle.getCoords(this.geom);
            double lx = verts[this.coords[0]];
            double ly = verts[this.coords[1]];
            double lz = this.geom.d_planeVal;
            switch (this.geom.d_plane) {
                case 0: {
                    return new Point3d(lz, lx, ly);
                }
                case 1: {
                    return new Point3d(lx, lz, ly);
                }
                case 2: {
                    return new Point3d(lx, ly, lz);
                }
            }
            assert (false);
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return new PlanarConstraint(this.geom.getPlane());
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public AARectangle modify(Point3d newLoc) throws Exception {
            double ly;
            double lx;
            switch (this.geom.d_plane) {
                case 0: {
                    lx = newLoc.y;
                    ly = newLoc.z;
                    break;
                }
                case 1: {
                    lx = newLoc.x;
                    ly = newLoc.z;
                    break;
                }
                case 2: {
                    lx = newLoc.x;
                    ly = newLoc.y;
                    break;
                }
                default: {
                    throw new Exception();
                }
            }
            if (lx < this.bounds[0]) {
                lx = this.bounds[0];
            } else if (lx > this.bounds[2]) {
                lx = this.bounds[2];
            }
            if (ly < this.bounds[1]) {
                ly = this.bounds[1];
            } else if (ly > this.bounds[3]) {
                ly = this.bounds[3];
            }
            double[] verts = VertHandle.getCoords(this.geom);
            verts[this.coords[0]] = lx;
            verts[this.coords[1]] = ly;
            this.geom = new AARectangle(this.geom.d_plane, this.geom.d_planeVal, verts[0], verts[1], verts[2], verts[3]);
            return this.geom;
        }

        @Override
        public Object end() {
            return this.geom;
        }
    }

    public static class PlaneHandle
    extends APlaneHandle<AARectangle> {
        public PlaneHandle(AARectangle geom) {
            super(geom);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && obj instanceof PlaneHandle;
        }

        @Override
        public IGeom getGeom() {
            return (IGeom)this.getManipGeom();
        }

        @Override
        protected Vector3d getPlaneNormal(AARectangle geom) {
            return geom.getPlane().getNormal();
        }

        @Override
        protected AARectangle modify(AARectangle origGeom, double offset) {
            return new AARectangle(origGeom.d_plane, origGeom.d_planeVal + offset, origGeom.d_minx, origGeom.d_miny, origGeom.d_maxx, origGeom.d_maxy);
        }
    }
}

