/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.domain.output.ProfList;
import pyrosim.legacy_2012_1.domain.output.ProfRec;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class ProfParser
extends AFDS5Parser {
    public ProfParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("PROF");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        FDSArray xyz;
        UnitPoint3D xyzPt;
        IQuantity qMsre;
        int WARN_IOR = 2;
        int WARN_QUANTITY = 4;
        int WARN_XYZ = 8;
        int warn = 0;
        if (!rec.contains("IOR")) {
            warn |= 2;
        }
        if (!rec.contains("QUANTITY")) {
            warn |= 4;
        }
        if (!rec.contains("XYZ")) {
            warn |= 8;
        }
        String act = Intl.intl("PROF Record Ignored");
        if ((warn & 2) > 0) {
            this.addWarning(rec, Intl.intl("Unable to process PROF record: IOR missing"), act);
        }
        if ((warn & 4) > 0) {
            this.addWarning(rec, Intl.intl("Unable to process PROF record: QUANTITY missing"), act);
        }
        if ((warn & 8) > 0) {
            this.addWarning(rec, Intl.intl("Unable to process PROF record: XYZ missing"), act);
        }
        if (warn > 0) {
            return false;
        }
        String id = (String)rec.get("ID");
        if (id == null || id.trim().equals("")) {
            id = Util.getUniqueName(this.getContainer().getProfList(), Intl.intl("PROF"));
        }
        if ((qMsre = this.parseQuantity(rec, "QUANTITY", null, null, null, null, null, 256, act, true, false)) == null) {
            return false;
        }
        int ior = rec.getInteger("IOR");
        ProfRec prof = new ProfRec(id, ior, qMsre, xyzPt = new UnitPoint3D((UnitDouble)(xyz = rec.getArray("XYZ", true)).get(0), (UnitDouble)xyz.get(1), (UnitDouble)xyz.get(2)));
        int exists = this.existsStatus(rec, prof, ProfRec.class);
        if (exists != 0) {
            return this.convertToReturn(exists);
        }
        ProfList profList = this.getContainer().getProfList();
        profList.add(prof);
        this.flagObjectAdded(prof);
        return true;
    }
}

