/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.evac.Evss;
import pyrosim.legacy_2012_1.domain.evac.EvssList;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class EvssParser
extends AFDS5Parser {
    public EvssParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String id;
        if (!rec.contains("ID")) {
            this.addWarning(rec, Intl.intl("Unable to process EVSS record: ID missing"), Intl.intl("EVSS Record Ignored"));
            return false;
        }
        EvssList mgr = this.getContainer().getEvssList();
        if (mgr.get(id = rec.getString("ID")) != null) {
            int i = 1;
            String idBase = id;
            while (mgr.get(id = String.format("%s[%d]", idBase, i)) != null) {
            }
            this.addWarning(rec, Intl.intl("Invalid EVSS record: Duplicate ID"), String.format(Intl.intl("ID changed from \"%s\"to \"%s\""), idBase, id));
        }
        GridList grids = this.getContainer().getGridManager();
        Evss obj = new Evss(id);
        obj.setProp("FYI", rec.get("FYI"));
        if (rec.contains("XB")) {
            FDSArray<UnitDouble> xbRaw = rec.getArray("XB", false);
            obj.setProp("XB", xbRaw.toFlatArray(new UnitDouble[xbRaw.getTotalLength()]));
        }
        obj.setProp("IOR", rec.get("IOR", true));
        if (rec.contains("MESH_ID")) {
            obj.setProp("MESH_ID", grids.get(rec.getString("MESH_ID")));
        }
        obj.setProp("HEIGHT", rec.get("HEIGHT", true));
        obj.setProp("HEIGHT0", rec.get("HEIGHT0", true));
        obj.setProp("FAC_V0_UP", rec.get("FAC_V0_UP", true));
        obj.setProp("FAC_V0_DOWN", rec.get("FAC_V0_DOWN", true));
        obj.setProp("FAC_V0_HORI", rec.get("FAC_V0_HORI", true));
        obj.setProp("ESC_SPEED", rec.get("ESC_SPEED", true));
        mgr.add(obj);
        this.flagObjectAdded(obj);
        this.flagEvac();
        return true;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("EVSS");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }
}

