/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.evac.Door;
import pyrosim.legacy_2012_1.domain.evac.DoorList;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class DoorParser
extends AFDS5Parser {
    public DoorParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String id;
        if (!rec.contains("ID")) {
            this.addWarning(rec, Intl.intl("Unable to process DOOR record: ID missing"), Intl.intl("DOOR Record Ignored"));
            return false;
        }
        DoorList mgr = this.getContainer().getDoorList();
        if (mgr.get(id = rec.getString("ID")) != null) {
            this.addWarning(rec, Intl.intl("Unable to process DOOR record: Duplicate ID"), Intl.intl("DOOR Record Ignored"));
            return false;
        }
        Door obj = new Door(id);
        obj.setProp("FYI", rec.get("FYI"));
        if (rec.contains("XB")) {
            FDSArray<UnitDouble> xbRaw = rec.getArray("XB", false);
            obj.setProp("XB", xbRaw.toFlatArray(new UnitDouble[xbRaw.getTotalLength()]));
        }
        if (rec.contains("XYZ")) {
            FDSArray<UnitDouble> xyzRaw = rec.getArray("XYZ", false);
            obj.setProp("XYZ", xyzRaw.toFlatArray(new UnitDouble[xyzRaw.getTotalLength()]));
        }
        GridList gridList = this.getContainer().getGridManager();
        if (rec.contains("MESH_ID")) {
            obj.setProp("MESH_ID", gridList.get(rec.getString("MESH_ID")));
        }
        obj.setProp("IOR", rec.get("IOR", true));
        if (rec.contains("TO_NODE")) {
            String toNode = rec.getString("TO_NODE");
            NamedPyroObject objToNode = null;
            if (objToNode == null) {
                objToNode = (NamedPyroObject)this.getContainer().getDoorList().get(toNode);
            }
            if (objToNode == null) {
                objToNode = (NamedPyroObject)this.getContainer().getExitList().get(toNode);
            }
            if (objToNode == null) {
                objToNode = (NamedPyroObject)this.getContainer().getCorrList().get(toNode);
            }
            if (objToNode == null) {
                objToNode = (NamedPyroObject)this.getContainer().getEntrList().get(toNode);
            }
            if (objToNode != null) {
                obj.setProp("TO_NODE", objToNode);
            } else {
                this.addWarning(rec, String.format(Intl.intl("Invalid DOOR record: Unknown TO_NODE \"%s\""), toNode), Intl.intl("TO_NODE record dropped."));
            }
        }
        obj.setProp("EXIT_SIGN", rec.get("EXIT_SIGN", true));
        obj.setProp("KEEP_XY", rec.get("KEEP_XY", true));
        if (rec.contains("VENT_FFIELD")) {
            obj.setProp("VENT_FFIELD", gridList.get(rec.getString("VENT_FFIELD")));
        }
        if (rec.contains("FLOW_FIELD_ID")) {
            obj.setProp("FLOW_FIELD_ID", gridList.get(rec.getString("FLOW_FIELD_ID")));
        }
        obj.setProp("RGB", this.parseColor(rec, "RGB", "COLOR", null, false));
        obj.setProp("TIME_OPEN", rec.get("TIME_OPEN"));
        obj.setProp("TIME_CLOSE", rec.get("TIME_CLOSE"));
        mgr.add(obj);
        this.flagObjectAdded(obj);
        this.flagEvac();
        return true;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("DOOR");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }
}

