/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.io.fds.FDSGrammar;
import pyrosim.legacy_2012_1.io.fds.FDSParseException;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSParseResult;
import pyrosim.legacy_2012_1.io.fds.FDSParsingInfo;
import pyrosim.legacy_2012_1.io.fds.FDSRecordSpec;
import pyrosim.legacy_2012_1.io.fds.FDSRenderProps;
import pyrosim.legacy_2012_1.io.fds.FDSRenderRecord;
import pyrosim.legacy_2012_1.io.fds.FDSStringRenderer;
import pyrosim.legacy_2012_1.io.fds.IFDSRecordParser;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;

public abstract class FDSParser {
    private static final String DECODER_NAME = "UTF-8";
    private static Charset CHARSET = Charset.forName("UTF-8");
    private static CharsetDecoder DECODER = CHARSET.newDecoder();

    protected abstract FDSParsingInfo createParsingInfo(String var1, PyroMod var2, PyroMod var3);

    protected abstract List<? extends IFDSRecordParser> createParsers(FDSParsingInfo var1);

    protected abstract Map<String, FDSRecordSpec> getRecordSpecs();

    protected abstract String getFinishRecType();

    public FDSParseResult parseFile(String filename, PyroMod model) throws IOException, FDSParseException {
        return this.parseFile(filename, model, model);
    }

    public FDSParseResult parseFile(String filename, PyroMod writeModel, PyroMod readModel) throws IOException, FDSParseException {
        CharSequence buffer = FDSParser.getBufferFromFile(filename);
        return this.parseBuffer(filename, buffer, writeModel, readModel);
    }

    public FDSParseResult parseBuffer(CharSequence buffer, PyroMod model) throws IOException, FDSParseException {
        return this.parseBuffer(buffer, model, model);
    }

    public FDSParseResult parseBuffer(CharSequence buffer, PyroMod writeModel, PyroMod readModel) throws IOException, FDSParseException {
        return this.parseBuffer(null, buffer, writeModel, readModel);
    }

    public FDSParseResult parseRecords(List<FDSParseRecord> recs, PyroMod model) throws IOException, FDSParseException {
        return this.parseRecords(recs, model, model);
    }

    public FDSParseResult parseRecords(List<FDSParseRecord> recs, PyroMod writeModel, PyroMod readModel) throws IOException, FDSParseException {
        FDSParsingInfo pi = this.createParsingInfo(null, writeModel, readModel);
        this.parseRecords(recs, (String)null, pi);
        return pi.getParseResult();
    }

    protected FDSParseResult parseBuffer(String filename, CharSequence buffer, PyroMod writeModel, PyroMod readModel) throws IOException, FDSParseException {
        FDSParsingInfo pi = this.createParsingInfo(filename, writeModel, readModel);
        return this.parseBuffer(filename, buffer, pi);
    }

    protected FDSParseResult parseBuffer(String filename, CharSequence buffer, FDSParsingInfo pi) throws IOException, FDSParseException {
        List<FDSParseRecord> records = FDSGrammar.parse(buffer, filename, pi.getParseResult().warningReport, this.getRecordSpecs(), this.getFinishRecType());
        this.parseRecords(records, null, pi);
        return pi.getParseResult();
    }

    protected static CharSequence getBufferFromFile(String filename) throws IOException, CharacterCodingException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), DECODER_NAME));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
            StringBuilder stringBuilder = sb;
            return stringBuilder;
        }
    }

    protected void parseRecords(List<FDSParseRecord> records, String filename, FDSParsingInfo parsingInfo) throws IOException, FDSParseException {
        parsingInfo.getContainer().pauseUpdates(false);
        ArrayList<FDSParseRecord> unprocessedRecs = new ArrayList<FDSParseRecord>();
        this.parse(parsingInfo, records, unprocessedRecs);
        if (!unprocessedRecs.isEmpty()) {
            String unprocessedRecordsStr = parsingInfo.getContainer().getUnprocessedRecords();
            FDSStringRenderer props = new FDSStringRenderer(unprocessedRecordsStr, new FDSRenderProps());
            for (FDSParseRecord rec : unprocessedRecs) {
                FDSRenderRecord renRec = FDSRenderRecord.fromParseRecord(rec);
                props.render(renRec, null);
            }
            parsingInfo.getContainer().setUnprocessedRecords(props.toString());
        }
        parsingInfo.getContainer().resumeUpdates();
        parsingInfo.getContainer().getEvents().changed(parsingInfo.getContainer(), PyroMod.EVT_FILENAME_CHANGED, PyroMod.EVT_MODEL_CHANGED);
    }

    private void parse(FDSParsingInfo pi, List<FDSParseRecord> recs, List<FDSParseRecord> unprocessedRecs) throws FDSParseException {
        List<? extends IFDSRecordParser> parsers = this.createParsers(pi);
        IdentityHashMap parserRecMap = new IdentityHashMap();
        for (IFDSRecordParser iFDSRecordParser : parsers) {
            parserRecMap.put(iFDSRecordParser, new ArrayList());
        }
        HashMap<String, ArrayList<IFDSRecordParser>> typeParserMap = new HashMap<String, ArrayList<IFDSRecordParser>>();
        HashMap<String, LinkedHashSet<String>> hashMap = new HashMap<String, LinkedHashSet<String>>();
        for (IFDSRecordParser iFDSRecordParser : parsers) {
            HashSet<String> hashSet = new HashSet<String>();
            iFDSRecordParser.getRecordTypes(hashSet);
            for (String type : hashSet) {
                ArrayList<IFDSRecordParser> typeParsers = (ArrayList<IFDSRecordParser>)typeParserMap.get(type);
                if (typeParsers == null) {
                    typeParsers = new ArrayList<IFDSRecordParser>();
                    typeParserMap.put(type, typeParsers);
                }
                typeParsers.add(iFDSRecordParser);
                LinkedHashSet<String> unsupportedFields = (LinkedHashSet<String>)hashMap.get(type);
                if (unsupportedFields == null) {
                    unsupportedFields = new LinkedHashSet<String>();
                    hashMap.put(type, unsupportedFields);
                }
                iFDSRecordParser.getUnsupportedFields(type, unsupportedFields);
            }
        }
        for (FDSParseRecord fDSParseRecord : recs) {
            List list = (List)typeParserMap.get(fDSParseRecord.getType());
            if (list == null) {
                pi.addWarning(fDSParseRecord, String.format(Intl.intl("%s records are not yet supported."), fDSParseRecord.getType()), Intl.intl("Adding to additional records section."));
                unprocessedRecs.add(fDSParseRecord);
                continue;
            }
            LinkedHashSet unsupportedFields = new LinkedHashSet((Collection)hashMap.get(fDSParseRecord.getType()));
            unsupportedFields.retainAll(fDSParseRecord.getProperties().keySet());
            if (!unsupportedFields.isEmpty()) {
                String fieldsStr = "";
                for (String unsupportedField : unsupportedFields) {
                    if (fieldsStr.length() > 0) {
                        fieldsStr = fieldsStr + ", ";
                    }
                    fieldsStr = fieldsStr + unsupportedField;
                }
                pi.addWarning(fDSParseRecord, String.format(Intl.intl("These fields are not yet supported: %s"), fieldsStr), Intl.intl("Ignoring unsupported fields."));
            }
            for (IFDSRecordParser parser : list) {
                ((List)parserRecMap.get(parser)).add(fDSParseRecord);
            }
        }
        IdentityHashSet<FDSParseRecord> unparsedRecs = new IdentityHashSet<FDSParseRecord>();
        for (IFDSRecordParser iFDSRecordParser : parsers) {
            List records = (List)parserRecMap.get(iFDSRecordParser);
            iFDSRecordParser.process(records, unparsedRecs);
        }
        for (IFDSRecordParser iFDSRecordParser : parsers) {
            iFDSRecordParser.postProcess();
        }
        unprocessedRecs.addAll(unparsedRecs);
    }
}

