/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4d;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.Hierarchy;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.tasks.AddTask;
import pyrosim.legacy_2012_1.domain.tasks.AutoRenameTask;
import pyrosim.legacy_2012_1.domain.tasks.SelectTask;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theTimer;
import pyrosim.legacy_2012_1.util.Util;

public abstract class TransformTask
extends AUndoableTask {
    private final PyroMod d_mediator;
    private final Collection<? extends IPyroObject> d_objs;
    private List<IGeom> d_oldGeom = null;
    private Task d_copyTask = null;
    private final int d_n;

    public abstract Matrix4d getXFormForIteration(int var1);

    public TransformTask(PyroMod pyMod, Collection<? extends IPyroObject> objs, int numCopies) {
        this.d_mediator = pyMod;
        this.d_objs = new ArrayList<IPyroObject>(objs);
        this.d_n = numCopies;
    }

    @Override
    public int getEst() {
        return 1;
    }

    private static String generateName(INamed obj, int copyIx) {
        return obj.getName() + "[" + (copyIx + 1) + "]";
    }

    private void runCopyTask() {
        if (this.d_copyTask != null) {
            this.d_copyTask.run();
            return;
        }
        theTimer timer = new theTimer();
        System.out.print("Transforming/Copying...");
        CompositeTask<PyroMod> copies = new CompositeTask<PyroMod>(this.d_mediator);
        ArrayList<? extends IPyroObject> selObjs = new ArrayList<IPyroObject>();
        selObjs.addAll(this.d_objs);
        ArrayList<Pair<Composite, INamed>> toAutoRename = new ArrayList<Pair<Composite, INamed>>();
        for (int i = 0; i < this.d_n; ++i) {
            Matrix4d xform = this.getXFormForIteration(i + 1);
            for (IPyroObject iPyroObject : this.d_objs) {
                IPyroObject mgr = Hierarchy.getCategoryRoot(iPyroObject);
                if (!(mgr instanceof Composite)) continue;
                Composite composite = iPyroObject.getParent() instanceof Composite ? (Composite)iPyroObject.getParent() : (Composite)mgr;
                IPyroObject newObject = this.copy((Composite)mgr, composite, iPyroObject, i, xform, true, copies, toAutoRename);
                selObjs.add(newObject);
            }
        }
        double time = timer.curr();
        System.out.printf("done (%g s)%n", time);
        SelectTask wrapper = new SelectTask(this.d_mediator, selObjs);
        LinkedIdentityHashMap linkedIdentityHashMap = new LinkedIdentityHashMap();
        for (Pair pair : toAutoRename) {
            ArrayList list = (ArrayList)linkedIdentityHashMap.get(pair.v1);
            if (list == null) {
                list = new ArrayList();
                linkedIdentityHashMap.put(pair.v1, list);
            }
            list.add(pair.v2);
        }
        for (Map.Entry entry : linkedIdentityHashMap.entrySet()) {
            AutoRenameTask renameTsk = new AutoRenameTask((Composite)entry.getKey(), (Collection)entry.getValue());
            wrapper.addTask(renameTsk);
        }
        wrapper.addTask(copies);
        this.d_copyTask = wrapper;
        this.d_copyTask.run();
    }

    private IPyroObject copy(Composite mgr, Composite parent, IPyroObject o, int i, Matrix4d xform, boolean forceRename, CompositeTask task, List<Pair<Composite, INamed>> toAutoRename) {
        if (o instanceof Composite) {
            Composite group = (Composite)o;
            Composite clone = group.clone(false);
            if (forceRename) {
                clone.setName(TransformTask.generateName(group, i));
            }
            for (IPyroObject child : group.getMembers()) {
                this.copy(mgr, clone, child, i, xform, false, task, toAutoRename);
            }
            task.addTask(new AddTask(parent, new IPyroObject[]{clone}));
            return clone;
        }
        IPyroGeomSrc newObject = (IPyroGeomSrc)o.clone();
        newObject.setGeom(newObject.getGeom().transform(xform, IGeom.XformOp.RETAINED), true);
        if (newObject instanceof INamed) {
            INamed named = (INamed)((Object)newObject);
            if (this.isKeyedByName(newObject)) {
                toAutoRename.add(new Pair<Composite, INamed>(mgr, named));
            } else if (forceRename) {
                named.setName(named.getName() + "[" + (i + 1) + "]");
            }
        }
        task.addTask(new AddTask(parent, new IPyroObject[]{newObject}));
        return newObject;
    }

    private boolean isKeyedByName(Object o) {
        return Util.isKeyedByName(this.d_mediator, o);
    }

    private void undoCopyTask() {
        assert (this.d_copyTask != null);
        this.d_copyTask.undo();
    }

    private void runMoveTask() {
        Collection<IPyroGeomSrc> geoms = Hierarchy.flatten(this.d_objs, IPyroGeomSrc.class);
        if (this.d_oldGeom == null) {
            this.d_oldGeom = new ArrayList<IGeom>(geoms.size());
            for (IPyroGeomSrc obj : geoms) {
                this.d_oldGeom.add(obj.getGeom());
            }
        }
        Matrix4d xform = this.getXFormForIteration(1);
        for (IPyroGeomSrc o : geoms) {
            IGeom newGeom = o.getGeom().transform(xform, IGeom.XformOp.RETAINED);
            o.setGeom(newGeom, true);
        }
    }

    private void undoMoveTask() {
        assert (this.d_oldGeom != null);
        int ix = 0;
        Collection<IPyroGeomSrc> geoms = Hierarchy.flatten(this.d_objs, IPyroGeomSrc.class);
        for (IPyroGeomSrc o : geoms) {
            o.setGeom(this.d_oldGeom.get(ix++), false);
        }
    }

    @Override
    public void run() {
        this.d_mediator.pauseUpdates();
        if (this.d_n == 0) {
            this.runMoveTask();
        } else {
            this.runCopyTask();
        }
        this.d_mediator.resumeUpdates();
    }

    @Override
    public void undo() {
        this.d_mediator.pauseUpdates();
        if (this.d_n == 0) {
            this.undoMoveTask();
        } else {
            this.undoCopyTask();
        }
        this.d_mediator.resumeUpdates();
    }
}

