/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.output;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityReplacer;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.EmptyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IBoxCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;

public class Slice
extends APyroObject
implements IPyroGeomSrc,
IDirectDependent {
    static final long serialVersionUID = 1L;
    private IQuantity d_measurement;
    private boolean d_includeFlowVector;
    private boolean d_visible;
    private static final Color s_color = new Color(Color.PINK.getRed(), Color.PINK.getGreen(), Color.pink.getBlue(), 150);

    public Slice(IQuantity measurement, boolean includeFlowVector) {
        this.d_measurement = measurement;
        this.d_includeFlowVector = includeFlowVector;
        this.d_visible = true;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_visible = true;
        in.defaultReadObject();
    }

    @Override
    public boolean isMixFracOnly() {
        return this.getQuantity().get().mixFracOnly;
    }

    public IQuantity getQuantity() {
        return this.d_measurement;
    }

    public void setQuantity(IQuantity m) {
        this.d_measurement = m;
        this.changedEvt(new Object[0]);
    }

    public boolean includeFlowVector() {
        return this.d_includeFlowVector;
    }

    public void setIncludeFlowVector(boolean include) {
        if (this.d_includeFlowVector == include) {
            return;
        }
        this.d_includeFlowVector = include;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Slice) {
            Slice rec = (Slice)obj;
            return rec.d_includeFlowVector == this.d_includeFlowVector && rec.d_measurement.equals(this.d_measurement);
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible == visible) {
            return;
        }
        this.d_visible = visible;
        this.changedEvt(PyroMod.EVT_VISIBILITY_CHANGED);
    }

    @Override
    public IGeom getGeom() {
        return EmptyGeom.INSTANCE;
    }

    @Override
    public void setGeom(IGeom geom, boolean optimizeGeom) {
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom(this.getGeom(), (IPrimProps)new IPrimProps.Face(s_color, null, false));
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        QuantityUtil.takeDepSnapshot(deps, DLink.STRONG, this.getQuantity());
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        QuantReplacer replacer = new QuantReplacer();
        replacer.removeInvalidReplacements(old, objs, this.getQuantity());
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        QuantReplacer replacer = new QuantReplacer();
        return replacer.taskReplaceDep(old, replacement, this.getQuantity());
    }

    @Override
    public AABox getBounds() {
        return this.getGeom().getBoundingBox(new AABox());
    }

    @Override
    public void getAll(IBoxCollector result, IIsectFilter filter) {
        if (filter.acceptPickObject(this)) {
            result.add(this);
        }
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull box) {
        if (!filter.acceptPickObject(this)) {
            return;
        }
        if (this.getGeom().intersectsBox(this, filter, box)) {
            result.add(this);
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        if (!filter.acceptPickObject(this)) {
            return;
        }
        this.getGeom().pickPoints(isects, filter, this, rayBegin, rayEnd, rayDirN, tester);
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)Slice.this.getDomain());
        }

        @Override
        protected Task taskReplaceQuant(IQuantity oldMsr, IQuantity newMsr) {
            assert (newMsr != null);
            return new AReplaceRefTask<IQuantity>((Object)oldMsr, (Object)newMsr){

                @Override
                protected void set(IQuantity obj) {
                    Slice.this.setQuantity(obj);
                }
            };
        }
    }
}

