/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.hvac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.hvac.HvacAircoil;
import pyrosim.legacy_2012_1.domain.hvac.HvacComponent;
import pyrosim.legacy_2012_1.domain.hvac.HvacFan;
import pyrosim.legacy_2012_1.domain.hvac.HvacNode;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSink;
import pyrosim.legacy_2012_1.domain.signals.OneLogicInPin;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.util.Util;

public class HvacDuct
extends HvacComponent
implements ISignalSink {
    private static final long serialVersionUID = -4887397052092333390L;
    public static final String OPT_AREA_DIAMETER = "opt_area_diameter";
    public static final String OPT_AIRFLOW = "opt_none_damper_fan";
    public static final String AIRFLOW_NONE = "airflow_none";
    public static final String AIRFLOW_DAMPER = "airflow_damper";
    public static final String AIRFLOW_FAN = "airflow_fan";
    public static final String USE_LENGTH = "use_length";
    public transient String d_n1;
    public transient String d_n2;
    public TimeFunction d_func;
    private IInPin d_inPin;

    public HvacDuct(String id) {
        super(id);
        HvacDuct.setDefaults(this);
        this.d_inPin = new OneLogicInPin(this);
        this.d_func = TimeFunction.newDefault();
    }

    private static void setDefaults(HvacComponent obj) {
        obj.setProp("TYPE_ID", "DUCT");
        obj.setProp("AIRCOIL_ID", null);
        obj.setProp("AREA", new UnitDouble(0.0, SI.METER.pow(2)));
        obj.setProp("DIAMETER", new UnitDouble(0.0, (Unit)SI.METER));
        obj.setProp(OPT_AREA_DIAMETER, "AREA");
        obj.setProp(OPT_AIRFLOW, AIRFLOW_NONE);
        obj.setProp("DAMPER", false);
        obj.setProp("VOLUME_FLOW", new UnitDouble(0.0, SI.METER.pow(3).divide((Unit)SI.SECOND)));
        obj.setProp("FAN_ID", null);
        obj.setProp("LENGTH", new UnitDouble(0.0, (Unit)SI.METER));
        obj.setProp(USE_LENGTH, false);
        obj.setProp("LOSS", Arrays.asList(new UnitDouble(0.0, Unit.ONE), new UnitDouble(0.0, Unit.ONE)));
        obj.setProp("NODE_ID", Arrays.asList(null, null));
        obj.setProp("REVERSE", false);
        obj.setProp("ROUGHNESS", null);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        this.addDep(deps, "AIRCOIL_ID");
        this.addDep(deps, "FAN_ID");
        this.addDep(deps, "NODE_ID");
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof HvacNode) {
            Util.removeAllNotOfType(objs, HvacNode.class);
            List nodeIds = (List)this.getProp("NODE_ID");
            for (HvacNode n : nodeIds) {
                if (n == null || n == old) continue;
                objs.remove(n);
            }
        } else if (old instanceof HvacAircoil) {
            Util.removeAllNotOfType(objs, HvacAircoil.class);
        } else if (old instanceof HvacFan) {
            Util.removeAllNotOfType(objs, HvacFan.class);
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
        if (old instanceof HvacNode) {
            return new AUndoableTask(){
                private HvacNode d_old;
                private HvacNode d_repl;

                @Override
                public void undo() {
                    HvacNode hold = this.d_old;
                    this.d_old = this.d_repl;
                    this.d_repl = hold;
                    HvacDuct.this.setNode(this.d_repl, this.d_old);
                }

                @Override
                public void run() {
                    this.d_old = (HvacNode)old;
                    this.d_repl = (HvacNode)replacement;
                    HvacDuct.this.setNode(this.d_repl, this.d_old);
                }
            };
        }
        if (old instanceof HvacAircoil) {
            return new AReplaceRefTask<HvacAircoil>((Object)old, (Object)replacement){

                @Override
                protected void set(HvacAircoil obj) {
                    HvacDuct.this.setAircoil(obj);
                }
            };
        }
        if (old instanceof HvacFan) {
            return new AReplaceRefTask<HvacFan>((Object)old, (Object)replacement){

                @Override
                protected void set(HvacFan obj) {
                    HvacDuct.this.setFan(obj);
                }
            };
        }
        return super.taskReplaceDep(old, replacement);
    }

    private void setAircoil(HvacAircoil obj) {
        this.setProp("AIRCOIL_ID", obj);
        this.changedEvt(new Object[0]);
    }

    private void setFan(HvacFan obj) {
        this.setProp("FAN_ID", obj);
        this.changedEvt(new Object[0]);
    }

    private void setNode(HvacNode replacement, HvacNode old) {
        List nodeIds = (List)this.getProp("NODE_ID");
        ArrayList<HvacNode> newNodes = new ArrayList<HvacNode>();
        HvacNode node1 = (HvacNode)nodeIds.get(0);
        HvacNode node2 = (HvacNode)nodeIds.get(1);
        if (node1 != null && node1 == old) {
            newNodes.add(replacement);
            newNodes.add(node2);
        } else if (node2 != null && node2 == old) {
            newNodes.add(node1);
            newNodes.add(replacement);
        } else {
            newNodes.add(node1);
            newNodes.add(node2);
        }
        this.setProp("NODE_ID", newNodes);
        this.changedEvt(new Object[0]);
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public Object clone() {
        HvacDuct clone = (HvacDuct)super.clone();
        clone.d_inPin = (IInPin)this.d_inPin.clone(clone);
        clone.d_func = (TimeFunction)this.d_func.clone();
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof HvacDuct && super.equals(obj) && this.d_inPin.equals(((HvacDuct)obj).d_inPin);
    }

    public boolean isNodeAttached(HvacNode node) {
        List nodes = (List)this.getProp("NODE_ID");
        if (!nodes.isEmpty()) {
            return node.equals(nodes.get(0)) || node.equals(nodes.get(1));
        }
        return false;
    }
}

