/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.hvac;

import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.hvac.HvacComponent;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSink;
import pyrosim.legacy_2012_1.domain.signals.OneLogicInPin;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class HvacAircoil
extends HvacComponent
implements ISignalSink {
    private static final long serialVersionUID = 1L;
    public static final String OPT_AIRCOIL_MODEL = "opt_aircoil_model";
    public static final Integer AIRCOIL_MODEL_COOLANT = 0;
    public static final Integer AIRCOIL_MODEL_FIXEDQ = 1;
    private IInPin d_inPin;

    public HvacAircoil(String id) {
        super(id);
        HvacAircoil.setDefaults(this);
        this.d_inPin = new OneLogicInPin(this);
    }

    public static void setDefaults(HvacComponent obj) {
        obj.setProp("TYPE_ID", "AIRCOIL");
        obj.setProp("COOLANT_CP", new UnitDouble(0.0, SI.JOULE.divide(SI.KILOGRAM.multiply((Unit)SI.KELVIN))));
        obj.setProp("COOLANT_MDOT", new UnitDouble(0.0, SI.KILOGRAM.divide((Unit)SI.SECOND)));
        obj.setProp("COOLANT_TEMPERATURE", new UnitDouble(0.0, (Unit)SI.KELVIN));
        obj.setProp("EFFICIENCY", new UnitDouble(0.0, Unit.ONE));
        obj.setProp("FIXED_Q", new UnitDouble(0.0, SI.JOULE.divide((Unit)SI.SECOND)));
        obj.setProp(OPT_AIRCOIL_MODEL, AIRCOIL_MODEL_FIXEDQ);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public Object clone() {
        HvacAircoil clone = (HvacAircoil)super.clone();
        clone.d_inPin = (IInPin)this.d_inPin.clone(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof HvacAircoil && super.equals(obj) && this.d_inPin.equals(((HvacAircoil)obj).d_inPin);
    }
}

