/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.geom.EvacProps;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.OneLogicInPin;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IBoxCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.EmptyTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.util.LWArray;
import pyrosim.legacy_2012_1.util.Util;

public abstract class AFDSObject
extends NamedPyroObject
implements FDSObject,
IDirectDependent {
    static final long serialVersionUID = 1L;
    protected static final int FLAG_VIS = Integer.MIN_VALUE;
    @Deprecated
    protected static final int FLAG_SEL = 0x40000000;
    protected static final int DEF_FLAGS = Integer.MIN_VALUE;
    private OneLogicInPin d_inPin = new OneLogicInPin(this);
    private Object d_colors = null;
    private EvacProps d_evac = EvacProps.DEFAULT;
    private int d_flags = Integer.MIN_VALUE;

    public AFDSObject(String name) {
        super(name);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.d_flags &= 0xBFFFFFFF;
    }

    @Override
    public Object clone() {
        AFDSObject clone = (AFDSObject)super.clone();
        clone.d_inPin = (OneLogicInPin)this.d_inPin.clone(clone);
        return clone;
    }

    @Override
    protected boolean registerProximity() {
        return true;
    }

    protected boolean testFlags(int flags) {
        return (this.d_flags & flags) == flags;
    }

    protected void setFlags(int flags, boolean set, Object ... changes) {
        int before = this.d_flags;
        this.d_flags = set ? (this.d_flags |= flags) : (this.d_flags &= ~flags);
        if (this.d_flags != before) {
            this.changedEvt(changes);
        }
    }

    protected int getSetFlags() {
        return this.d_flags;
    }

    @Override
    public void setEvac(EvacProps evac) {
        if (evac.equals(this.d_evac)) {
            return;
        }
        this.d_evac = evac;
        this.changedEvt(new Object[0]);
    }

    @Override
    public EvacProps getEvac() {
        return this.d_evac;
    }

    @Override
    public void setColors(Color ... c) {
        this.d_colors = LWArray.newArray(c);
        this.changedEvt(new Object[0]);
    }

    @Override
    public Color[] getColors() {
        Color[] colorArray;
        Color[] c = LWArray.toArray(this.d_colors, Color.class);
        if (c.length == 0) {
            Color[] colorArray2 = new Color[1];
            colorArray = colorArray2;
            colorArray2[0] = null;
        } else {
            colorArray = c;
        }
        return colorArray;
    }

    @Override
    public void setVisible(boolean visible) {
        this.setFlags(Integer.MIN_VALUE, visible, PyroMod.EVT_VISIBILITY_CHANGED);
    }

    @Override
    public boolean isVisible() {
        return this.testFlags(Integer.MIN_VALUE);
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, (IPyroObject)this.d_evac.mesh);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof Mesh) {
            Util.removeAllNotOfType(objs, Grid.class);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old != this.d_evac.mesh) {
            return EmptyTask.INSTANCE;
        }
        return new AReplaceRefTask<Grid>((Object)old, (Object)replacement){

            @Override
            protected void set(Grid obj) {
                AFDSObject.this.setEvac(EvacProps.get(((AFDSObject)AFDSObject.this).d_evac.evacuation, obj));
            }
        };
    }

    @Override
    public AABox getBounds() {
        return this.getGeom().getBoundingBox(new AABox());
    }

    @Override
    public void getAll(IBoxCollector result, IIsectFilter filter) {
        if (filter.acceptPickObject(this)) {
            result.add(this);
        }
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull box) {
        if (!filter.acceptPickObject(this)) {
            return;
        }
        if (this.getGeom().intersectsBox(this, filter, box)) {
            result.add(this);
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        if (!filter.acceptPickObject(this)) {
            return;
        }
        this.getGeom().pickPoints(isects, filter, this, rayBegin, rayEnd, rayDirN, tester);
    }
}

