/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.sprayers;

import java.awt.Color;
import java.util.Set;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.devices.ADevice;
import pyrosim.legacy_2012_1.domain.devices.FreeLocSaveTask;
import pyrosim.legacy_2012_1.domain.devices.FreePointGeom;
import pyrosim.legacy_2012_1.domain.devices.IFreePointDevice;
import pyrosim.legacy_2012_1.domain.devices.sprayers.ISprayer;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.util.Util;

public abstract class ASprayer
extends ADevice
implements ISprayer,
IDirectDependent,
IFreePointDevice {
    static final long serialVersionUID = 1L;
    private SprayModel d_sprayDescription;
    private FreePointLoc d_location;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(Color.BLUE, 10.0);
    private static final IGeom s_baseGeom = new Point(new Point3d(0.0, 0.0, 0.0));

    public ASprayer(String name, SprayModel desc) {
        this(name, desc, new FreePointLoc());
    }

    public ASprayer(String name, SprayModel desc, FreePointLoc loc) {
        super(name);
        this.d_sprayDescription = desc;
        this.d_location = loc;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ASprayer)) {
            return false;
        }
        ASprayer spry = (ASprayer)obj;
        return super.equals(obj) && this.d_sprayDescription.equals(spry.d_sprayDescription) && this.d_location.equals(spry.d_location);
    }

    @Override
    public FreePointLoc getLocation() {
        return this.d_location;
    }

    @Override
    public void setLocation(FreePointLoc loc) {
        this.d_location = loc;
        this.changedEvt(new Object[0]);
    }

    public IDOF getDOF() {
        return IDOF.FREE;
    }

    protected void transform(Matrix4d xform) {
        this.setLocation(this.d_location.transform(xform));
    }

    protected void imprintGeom(Object from) {
        this.setLocation(((ASprayer)from).d_location);
    }

    protected Task taskSaveGeometry() {
        return new FreeLocSaveTask(this);
    }

    public SprayModel getSprayModel() {
        return this.d_sprayDescription;
    }

    public void setSprayModel(SprayModel desc) {
        this.d_sprayDescription = desc;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        if (this.d_sprayDescription != null) {
            deps.add(DLink.STRONG, (IPyroObject)this.d_sprayDescription);
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof SprayModel) {
            Util.removeAllNotOfType(objs, SprayModel.class);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old == this.d_sprayDescription) {
            assert (replacement != null);
            return new AReplaceRefTask<SprayModel>((Object)old, (Object)replacement){

                @Override
                public void set(SprayModel obj) {
                    ASprayer.this.setSprayModel(obj);
                }
            };
        }
        return null;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom(this.getGeom(), s_primProps);
    }

    @Override
    public IGeom getGeom() {
        return new FreePointGeom(this.d_location, s_baseGeom);
    }

    @Override
    public void setGeom(IGeom geom, boolean optimizeGeom) {
        if ((geom = Geometry.finalize(geom, optimizeGeom)) instanceof FreePointGeom) {
            FreePointGeom p = (FreePointGeom)geom;
            this.setLocation(p.loc);
        } else if (geom instanceof Point) {
            this.setLocation(this.d_location.setLoc(((Point)geom).loc));
        }
    }
}

