/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.controls;

import java.util.Arrays;
import java.util.List;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.controls.AControl;
import pyrosim.legacy_2012_1.domain.controls.CustomCtrl;
import pyrosim.legacy_2012_1.domain.devices.detectors.Timer;
import pyrosim.legacy_2012_1.domain.devices.measurers.Clock;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.ILatchable;
import pyrosim.legacy_2012_1.domain.signals.ILogicOutPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSource;
import pyrosim.legacy_2012_1.domain.signals.LogicOutPin;
import pyrosim.legacy_2012_1.domain.signals.OneLogicInPin;

public class LatchCtrl
extends AControl
implements ILatchable {
    static final long serialVersionUID = 1L;
    private IInPin d_inPin = new OneLogicInPin(this);
    private LogicOutPin d_outPin = new LogicOutPin(this);

    @Override
    protected String getDefaultName() {
        return Intl.intl("latch");
    }

    @Override
    public boolean latches(ILogicOutPin outPin) {
        return true;
    }

    @Override
    public boolean isNoop() {
        if (this.getInputPin().getConnections().size() == 1) {
            CustomCtrl custom;
            ISignalSource src = this.getInputPin().getConnectedSources().iterator().next();
            if (src instanceof Timer) {
                return true;
            }
            if (src instanceof CustomCtrl ? (custom = (CustomCtrl)src).getTripValues().size() == 1 && custom.getInputPin().getConnections().size() == 1 && custom.getInputPin().getConnections().iterator().next() instanceof Clock : src instanceof LatchCtrl) {
                return true;
            }
        }
        return super.isNoop();
    }

    @Override
    public Object clone() {
        LatchCtrl clone = (LatchCtrl)super.clone();
        clone.d_inPin = (IInPin)this.d_inPin.clone(clone);
        clone.d_outPin = (LogicOutPin)this.d_outPin.clone(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LatchCtrl)) {
            return false;
        }
        LatchCtrl op = (LatchCtrl)obj;
        return super.equals(obj) && this.d_inPin.equals(op.d_inPin);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 210174 + this.d_inPin.hashCode();
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Arrays.asList(this.d_outPin);
    }
}

