/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.CustomFDSProps;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.Variant;
import pyrosim.legacy_2012_1.domain.boundcond.surf.PredefSurf;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.dependencies.SkipDep;
import pyrosim.legacy_2012_1.domain.evac.Pers;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityReplacer;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.io.PyroSimObjectInputStream;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDoubleVR;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.DoubleVR;
import pyrosim.legacy_2012_1.thunderheadeng.util.EmptyTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.IntVR;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class SimParams
extends APyroObject {
    static final long serialVersionUID = 1L;
    private String d_jobTitle = "";
    private Time d_time = new Time();
    private Calculations d_calcs = new Calculations();
    private Environment d_env = new Environment();
    private RadiationTransport d_radi = new RadiationTransport();
    private FileOutput d_fileOutput = new FileOutput();
    private Particles d_particles = new Particles();
    private Misc d_misc;
    @SkipDep
    private Pers d_persGlobals;
    private Map<String, CustomFDSProps> d_customProps;

    public SimParams(SurfaceManager surfMgr) {
        this.d_misc = new Misc(surfMgr);
        this.d_persGlobals = SimParams.initPers();
        this.d_customProps = SimParams.createCustomPropsMap();
    }

    private static Map<String, CustomFDSProps> createCustomPropsMap() {
        LinkedHashMap<String, CustomFDSProps> props = new LinkedHashMap<String, CustomFDSProps>();
        props.put("TIME", new CustomFDSProps());
        props.put("DUMP", new CustomFDSProps());
        props.put("RADI", new CustomFDSProps());
        props.put("MISC", new CustomFDSProps());
        return props;
    }

    public Set<String> getCustomFDSTypes() {
        return this.d_customProps.keySet();
    }

    public CustomFDSProps getCustomFDSProps(String recordType) {
        return this.d_customProps.get(recordType);
    }

    public void setCustomFDSProps(String recordType, CustomFDSProps props) {
        assert (this.d_customProps.containsKey(recordType));
        this.d_customProps.put(recordType, props);
        this.changedEvt(new Object[0]);
    }

    @Override
    protected void addToDomain(PyroMod domain, IPyroObject parent) {
        super.addToDomain(domain, parent);
        this.d_time.setDomain(domain, this);
        this.d_calcs.setDomain(domain, this);
        this.d_env.setDomain(domain, this);
        this.d_radi.setDomain(domain, this);
        this.d_fileOutput.setDomain(domain, this);
        this.d_particles.setDomain(domain, this);
        this.d_misc.setDomain(domain, this);
        this.d_persGlobals.setDomain(domain, this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SimParams)) {
            return false;
        }
        SimParams params = (SimParams)obj;
        return params.d_time.equals(this.d_time) && params.d_calcs.equals(this.d_calcs) && params.d_env.equals(this.d_env) && params.d_radi.equals(this.d_radi) && params.d_fileOutput.equals(this.d_fileOutput) && params.d_particles.equals(this.d_particles) && params.d_misc.equals(this.d_misc) && params.d_persGlobals.equals(this.d_persGlobals) && params.d_customProps.equals(this.d_customProps);
    }

    @Override
    public Object clone() {
        SimParams sp = (SimParams)super.clone();
        sp.d_time = (Time)this.d_time.clone();
        sp.d_calcs = (Calculations)this.d_calcs.clone();
        sp.d_env = (Environment)this.d_env.clone();
        sp.d_radi = (RadiationTransport)this.d_radi.clone();
        sp.d_fileOutput = (FileOutput)this.d_fileOutput.clone();
        sp.d_particles = (Particles)this.d_particles.clone();
        sp.d_misc = (Misc)this.d_misc.clone();
        sp.d_persGlobals = (Pers)this.d_persGlobals.clone();
        sp.d_customProps = new LinkedHashMap<String, CustomFDSProps>();
        sp.d_customProps.putAll(this.d_customProps);
        return sp;
    }

    private static Pers initPers() {
        return new Pers("globals");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (PyroSimObjectInputStream.getVersion(in) < 31) {
            this.d_persGlobals = SimParams.initPers();
        }
        if (this.d_customProps == null) {
            this.d_customProps = SimParams.createCustomPropsMap();
        }
    }

    public String getJobTitle() {
        return this.d_jobTitle;
    }

    public void setJobTitle(String title) {
        this.d_jobTitle = title;
        this.changedEvt(new Object[0]);
    }

    public Time getTime() {
        return this.d_time;
    }

    public Calculations getCalculations() {
        return this.d_calcs;
    }

    public Environment getEnvironment() {
        return this.d_env;
    }

    public RadiationTransport getRadiTransport() {
        return this.d_radi;
    }

    public FileOutput getFileOutput() {
        return this.d_fileOutput;
    }

    public Particles getParticles() {
        return this.d_particles;
    }

    public Misc getMisc() {
        return this.d_misc;
    }

    public Pers getPersGlobals() {
        return this.d_persGlobals;
    }

    @Override
    public boolean isMixFracOnly() {
        return this.d_calcs.isMixFracOnly() || this.d_env.isMixFracOnly() || this.d_fileOutput.isMixFracOnly() || this.d_misc.isMixFracOnly() || this.d_particles.isMixFracOnly() || this.d_radi.isMixFracOnly() || this.d_time.isMixFracOnly();
    }

    public static class Misc
    extends APyroObject
    implements IDirectDependent,
    Serializable {
        static final long serialVersionUID = 1L;
        private String d_backgroundSpecies = ExSpecList.Predefined.AIR.getName();
        private Surface d_surfDefault;
        private UnitPoint3D d_textureOrigin;
        private boolean d_predictCOProd;
        private boolean d_forceMixFrac;
        private Map<String, Object> d_evacProps;
        private transient boolean d_resume = false;

        public Misc(SurfaceManager surfMgr) {
            this.d_surfDefault = (Surface)surfMgr.get(PredefSurf.INERT.name());
            this.d_textureOrigin = Geometry.UP3D_ZERO;
            this.d_predictCOProd = false;
            this.d_forceMixFrac = true;
            this.initEvacProps(surfMgr);
        }

        @Override
        public Object clone() {
            Misc clone = (Misc)super.clone();
            clone.d_evacProps = new HashMap<String, Object>(this.d_evacProps);
            return clone;
        }

        public void initEvacProps(SurfaceManager surfMgr) {
            this.d_evacProps = new HashMap<String, Object>();
            this.d_evacProps.put("EVACUATION_MC_MODE", false);
            this.d_evacProps.put("PRESSURE_ITERATIONS", 50);
            this.d_evacProps.put("TIME_ITERATIONS", 50);
            this.d_evacProps.put("EVAC_SURF_DEFAULT", surfMgr.get(PredefSurf.INERT.name()));
        }

        public void setResume(boolean val) {
            this.d_resume = val;
        }

        public boolean getAndClearResume() {
            boolean resume = this.d_resume;
            this.d_resume = false;
            return resume;
        }

        @Override
        public void takeDepSnapshot(DepList deps) {
            Surface evacSurf = (Surface)this.getEvacProp("EVAC_SURF_DEFAULT");
            deps.add(DLink.REQUIRED, (IPyroObject)this.d_surfDefault);
            deps.add(DLink.WEAK, (IPyroObject)evacSurf);
        }

        @Override
        public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
            AUndoableTask t2;
            Task t1 = old == this.getSurfDefault() ? this.taskSetSurfDefault((Surface)replacement) : null;
            AUndoableTask aUndoableTask = t2 = old == this.getEvacProp("EVAC_SURF_DEFAULT") ? new AUndoableTask(){

                @Override
                public void run() {
                    this.setEvacProp("EVAC_SURF_DEFAULT", replacement);
                }

                @Override
                public void undo() {
                    this.setEvacProp("EVAC_SURF_DEFAULT", old);
                }
            } : null;
            if (t1 != null && t2 != null) {
                CompositeTask t = new CompositeTask(this.getDomain());
                t.addTask(t1);
                t.addTask(t2);
                return t;
            }
            if (t1 != null) {
                return t1;
            }
            if (t2 != null) {
                return t2;
            }
            return EmptyTask.INSTANCE;
        }

        public boolean getForceMixFracFlag() {
            return this.d_forceMixFrac;
        }

        public void setForceMixFracFlag(boolean force) {
            this.d_forceMixFrac = force;
            this.changedEvt(new Object[0]);
        }

        public boolean predictCOProd() {
            return this.d_predictCOProd;
        }

        public Task taskSetPredictCOProd(boolean predict) {
            return new AReplaceRefTask<Boolean>((Object)this.d_predictCOProd, (Object)predict){

                @Override
                protected void set(Boolean obj) {
                    d_predictCOProd = obj;
                    this.changedEvt(new Object[0]);
                }
            };
        }

        public String getBackgroundSpecies() {
            return this.d_backgroundSpecies;
        }

        public Task taskSetBackgroundSpecies(String bgSpec) {
            return new AReplaceRefTask<String>((Object)this.d_backgroundSpecies, (Object)bgSpec){

                @Override
                protected void set(String obj) {
                    d_backgroundSpecies = obj;
                    this.changedEvt(new Object[0]);
                }
            };
        }

        public Surface getSurfDefault() {
            return this.d_surfDefault;
        }

        public void setSurfDefault(Surface surfDefault) {
            this.d_surfDefault = surfDefault;
            this.changedEvt(new Object[0]);
        }

        public void setEvacProp(String key, Object value) {
            if (this.d_evacProps.get(key) != value) {
                this.d_evacProps.put(key, value);
                this.changedEvt(new Object[0]);
            }
        }

        public Object getEvacProp(String key) {
            return this.d_evacProps.get(key);
        }

        public Map<String, Object> getEvacProps() {
            return this.d_evacProps;
        }

        @Override
        public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
            Util.removeAllNotOfType(objs, Surface.class);
        }

        public Task taskSetSurfDefault(Surface surfDefault) {
            return new AReplaceRefTask<Surface>((Object)this.d_surfDefault, (Object)surfDefault){

                @Override
                protected void set(Surface obj) {
                    this.setSurfDefault(obj);
                }
            };
        }

        public UnitPoint3D getTextureOrigin() {
            return this.d_textureOrigin;
        }

        public void setTextureOrigin(UnitPoint3D textureOrigin) {
            this.d_textureOrigin = textureOrigin;
            this.changedEvt(new Object[0]);
        }
    }

    public static class Particles
    extends APyroObject
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final IntVR MAX_PARTICLES_PER_MESH = IntVR.above(0, false);
        private boolean d_porousFloor = true;
        private boolean d_allowUndersideDroplets = false;
        private int d_maxParticlesPerMesh = 500000;

        @Override
        public Object clone() {
            return super.clone();
        }

        public boolean isPourousFloor() {
            return this.d_porousFloor;
        }

        public void setPourousFloor(boolean pourousFloor) {
            this.d_porousFloor = pourousFloor;
            this.changedEvt(new Object[0]);
        }

        public boolean getAllowUndersideDroplets() {
            return this.d_allowUndersideDroplets;
        }

        public void setAllowUndersideDroplets(boolean allowUndersideDroplets) {
            this.d_allowUndersideDroplets = allowUndersideDroplets;
            this.changedEvt(new Object[0]);
        }

        public int getMaxParticlesPerMesh() {
            return this.d_maxParticlesPerMesh;
        }

        public void setMaxParticlesPerMesh(int maxParticlesPerMesh) {
            this.d_maxParticlesPerMesh = maxParticlesPerMesh;
            this.changedEvt(new Object[0]);
        }
    }

    public static class FileOutput
    extends APyroObject
    implements Serializable,
    IDirectDependent {
        static final long serialVersionUID = 1L;
        public static final UnitDoubleVR TIME_RANGE_FILE_OUT = UnitDoubleVR.above(0.0, SIUS.getInstance().getTimeUnit(), true);
        public static final IntVR NUM_FRAMES_RANGE = IntVR.above(1, true);
        private boolean d_limitCSVColumns = true;
        private UnitDouble d_dtBoundaryFile = null;
        private UnitDouble d_dtDeviceFiles = null;
        private UnitDouble d_dtHeatReleaseRateFiles = null;
        private UnitDouble d_dtIsofFiles = null;
        private UnitDouble d_dtParticleFiles = null;
        private UnitDouble d_dtProfileDumpInterval = null;
        private UnitDouble d_dtRestartFile = new UnitDouble(300.0, (Unit)SI.SECOND);
        private UnitDouble d_dtSliceFiles = null;
        private int d_numOutputFrames = 1000;
        private boolean d_visualize3dSmoke = true;
        private IQuantity d_smokeQuantity = null;
        private ExSpec d_smokeSpec;
        private boolean d_writeSpeciesMassFile = false;
        private UnitDouble d_dtMassFiles = null;
        private boolean d_writePlot3dXYZFile = false;
        private UnitDouble d_dtPlot3dFile = null;

        @Override
        public Object clone() {
            return super.clone();
        }

        @Override
        public boolean isMixFracOnly() {
            return this.d_smokeQuantity != null ? this.d_smokeQuantity.get().mixFracOnly : false;
        }

        public boolean isLimitCSVColumns() {
            return this.d_limitCSVColumns;
        }

        public void setLimitCSVColumns(boolean limitCSVColumns) {
            this.d_limitCSVColumns = limitCSVColumns;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtBoundaryFile() {
            return this.d_dtBoundaryFile;
        }

        public void setDtBoundaryFile(UnitDouble dtBoundaryFile) {
            this.d_dtBoundaryFile = dtBoundaryFile;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtDeviceFiles() {
            return this.d_dtDeviceFiles;
        }

        public void setDtDeviceFiles(UnitDouble dtDeviceFiles) {
            this.d_dtDeviceFiles = dtDeviceFiles;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtHeatReleaseRateFiles() {
            return this.d_dtHeatReleaseRateFiles;
        }

        public void setDtHeatReleaseRateFiles(UnitDouble dtHeatReleaseRateFiles) {
            this.d_dtHeatReleaseRateFiles = dtHeatReleaseRateFiles;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtIsofFiles() {
            return this.d_dtIsofFiles;
        }

        public void setDtIsofFiles(UnitDouble dtIsofFiles) {
            this.d_dtIsofFiles = dtIsofFiles;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtParticleFiles() {
            return this.d_dtParticleFiles;
        }

        public void setDtParticleFiles(UnitDouble dtParticleFiles) {
            this.d_dtParticleFiles = dtParticleFiles;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtRestartFile() {
            return this.d_dtRestartFile;
        }

        public void setDtRestartFile(UnitDouble dtRestartFile) {
            this.d_dtRestartFile = dtRestartFile;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtSliceFiles() {
            return this.d_dtSliceFiles;
        }

        public void setDtSliceFiles(UnitDouble dtSliceFiles) {
            this.d_dtSliceFiles = dtSliceFiles;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtMassFiles() {
            return this.d_dtMassFiles;
        }

        public void setDtMassFiles(UnitDouble dtMassFiles) {
            this.d_dtMassFiles = dtMassFiles;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtPlot3dFile() {
            return this.d_dtPlot3dFile;
        }

        public void setDtPlot3dFile(UnitDouble dtPlot3dFile) {
            this.d_dtPlot3dFile = dtPlot3dFile;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getDtProfileDumpInterval() {
            return this.d_dtProfileDumpInterval;
        }

        public void setDtProfileDumpInterval(UnitDouble dtProfileDumpInterval) {
            this.d_dtProfileDumpInterval = dtProfileDumpInterval;
            this.changedEvt(new Object[0]);
        }

        public int getNumOutputFrames() {
            return this.d_numOutputFrames;
        }

        public void setNumOutputFrames(int numOutputFrames) {
            this.d_numOutputFrames = numOutputFrames;
            this.changedEvt(new Object[0]);
        }

        public boolean isVisualize3dSmoke() {
            return this.d_visualize3dSmoke;
        }

        public void setVisualize3dSmoke(boolean visualize3dSmoke) {
            this.d_visualize3dSmoke = visualize3dSmoke;
            this.changedEvt(new Object[0]);
        }

        public IQuantity getSmokeQuantity() {
            return this.d_smokeQuantity;
        }

        public void setSmokeQuantity(IQuantity msr) {
            this.d_smokeQuantity = msr;
            this.changedEvt(new Object[0]);
        }

        public static boolean isValidSmokeQuantity(Quantity msr) {
            return QuantityUtil.isSpecMassFraction(msr);
        }

        public static IObjectFilter<Quantity> getSmokeQuantityFilter() {
            return new IObjectFilter<Quantity>(){

                @Override
                public boolean shouldFilter(Quantity o) {
                    return !FileOutput.isValidSmokeQuantity(o);
                }
            };
        }

        public void convertPre28SpecToQuantity() {
            if (this.d_smokeSpec != null) {
                this.d_smokeQuantity = Quantity.SPEC_MASS_FRACTION.create(this.d_smokeSpec);
                this.d_smokeSpec = null;
            }
        }

        public boolean isWriteSpeciesMassFile() {
            return this.d_writeSpeciesMassFile;
        }

        public void setWriteSpeciesMassFile(boolean writeSpeciesMassFile) {
            this.d_writeSpeciesMassFile = writeSpeciesMassFile;
            this.changedEvt(new Object[0]);
        }

        public boolean isWritePlot3dXYZFile() {
            return this.d_writePlot3dXYZFile;
        }

        public void setWritePlot3dXYZFile(boolean writePlot3dXYZFile) {
            this.d_writePlot3dXYZFile = writePlot3dXYZFile;
            this.changedEvt(new Object[0]);
        }

        @Override
        public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
            SmokeQuantReplacer repl = new SmokeQuantReplacer((PyroMod)this.getDomain());
            repl.removeInvalidReplacements(old, objs, this.d_smokeQuantity);
        }

        @Override
        public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
            SmokeQuantReplacer repl = new SmokeQuantReplacer((PyroMod)this.getDomain());
            return repl.taskReplaceDep(old, replacement, this.d_smokeQuantity);
        }

        @Override
        public void takeDepSnapshot(DepList deps) {
            QuantityUtil.takeDepSnapshot(deps, DLink.WEAK, this.d_smokeQuantity);
        }

        private class SmokeQuantReplacer
        extends QuantityReplacer {
            public SmokeQuantReplacer(PyroMod domain) {
                super(domain);
            }

            @Override
            protected boolean canReplaceQuant(IQuantity old, IQuantity repl) {
                return FileOutput.isValidSmokeQuantity(repl.get());
            }

            @Override
            protected Task taskReplaceQuant(IQuantity oldMsr, IQuantity newMsr) {
                return new AReplaceRefTask<IQuantity>((Object)oldMsr, (Object)newMsr){

                    @Override
                    protected void set(IQuantity obj) {
                        FileOutput.this.setSmokeQuantity(obj);
                    }
                };
            }
        }
    }

    public static class RadiationTransport
    extends APyroObject
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final UnitDoubleVR TEMPERATURE_RANGE = UnitDoubleVR.above(0.0, (Unit)SI.KELVIN, true);
        public static final IntVR ANGLE_NUM_RANGE = IntVR.above(0, true);
        public static final IntVR TIME_STEP_RANGE = IntVR.above(1, true);
        public static final IntVR ANGLE_INCREMENT_RANGE = IntVR.above(1, true);
        public static final DoubleVR RADIATIVE_FRACTION_RANGE = DoubleVR.between(0.0, 1.0, true, true);
        private boolean d_radiationOn = true;
        private int d_angleIncrement = 5;
        private boolean d_includeExtraFuelBands = false;
        private UnitDouble d_constAbsorptionCoef = new UnitDouble(0.0, SI.METER.pow(-1));
        private int d_numPolarAngles = 15;
        private int d_numSolidAngles = 100;
        private UnitDouble d_radCalcPathLen = null;
        private double d_radiativeLossFraction = 0.35;
        private UnitDouble d_assumedRadSourceTemp = new UnitDouble(900.0, SI.CELSIUS);
        private int d_timeStepInc = 3;
        private boolean d_nonGrayGasAssumption = false;

        @Override
        public Object clone() {
            return super.clone();
        }

        public boolean isRadiationOn() {
            return this.d_radiationOn;
        }

        public void setRadiationOn(boolean radiationOn) {
            this.d_radiationOn = radiationOn;
            this.changedEvt(new Object[0]);
        }

        public int getAngleIncrement() {
            return this.d_angleIncrement;
        }

        public void setAngleIncrement(int angleIncrement) {
            this.d_angleIncrement = angleIncrement;
            this.changedEvt(new Object[0]);
        }

        public boolean isIncludeExtraFuelBands() {
            return this.d_includeExtraFuelBands;
        }

        public void setIncludeExtraFuelBands(boolean includeExtraFuelBands) {
            this.d_includeExtraFuelBands = includeExtraFuelBands;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getConstAbsorptionCoef() {
            return this.d_constAbsorptionCoef;
        }

        public void setConstAbsorptionCoef(UnitDouble constAbsorptionCoef) {
            this.d_constAbsorptionCoef = constAbsorptionCoef;
            this.changedEvt(new Object[0]);
        }

        public int getNumPolarAngles() {
            return this.d_numPolarAngles;
        }

        public void setNumPolarAngles(int numPolarAngles) {
            this.d_numPolarAngles = numPolarAngles;
            this.changedEvt(new Object[0]);
        }

        public int getNumSolidAngles() {
            return this.d_numSolidAngles;
        }

        public void setNumSolidAngles(int numSolidAngles) {
            this.d_numSolidAngles = numSolidAngles;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getRadCalcPathLen() {
            return this.d_radCalcPathLen;
        }

        public void setRadCalcPathLen(UnitDouble radCalcPathLen) {
            this.d_radCalcPathLen = radCalcPathLen;
            this.changedEvt(new Object[0]);
        }

        public double getRadiativeLossFraction() {
            return this.d_radiativeLossFraction;
        }

        public void setRadiativeLossFraction(double radiativeLossFraction) {
            this.d_radiativeLossFraction = radiativeLossFraction;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getAssumedRadSourceTemp() {
            return this.d_assumedRadSourceTemp;
        }

        public void setAssumedRadSourceTemp(UnitDouble assumedRadSourceTemp) {
            this.d_assumedRadSourceTemp = assumedRadSourceTemp;
            this.changedEvt(new Object[0]);
        }

        public int getTimeStepInc() {
            return this.d_timeStepInc;
        }

        public void setTimeStepInc(int timeStepInc) {
            this.d_timeStepInc = timeStepInc;
            this.changedEvt(new Object[0]);
        }

        public boolean isNonGrayGasAssumption() {
            return this.d_nonGrayGasAssumption;
        }

        public void setNonGrayGasAssumption(boolean nonGrayGasAssumption) {
            this.d_nonGrayGasAssumption = nonGrayGasAssumption;
            this.changedEvt(new Object[0]);
        }
    }

    public static class Environment
    extends APyroObject
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final DoubleVR RELATIVE_HUMIDITY_RANGE = DoubleVR.between(0.0, 100.0, true, true);
        public static final UnitDoubleVR AMBIENT_PRESSURE_RANGE = UnitDoubleVR.above(0.0, SI.PASCAL, true);
        public static final UnitDoubleVR TEMPERATURE_RANGE = UnitDoubleVR.above(0.0, (Unit)SI.KELVIN, true);
        private double d_relHumidity = 40.0;
        private UnitPoint3D d_ambVel;
        private UnitDouble d_ambTemp;
        private UnitDouble d_ambPressure;
        private UnitDouble d_atmLapseRate;
        private UnitPoint3D d_gravityAccel;
        private UnitDouble d_groundLevel;
        private Variant d_gravityX;
        private Variant d_gravityY;
        private Variant d_gravityZ;

        public Environment() {
            SIUS si = SIUS.getInstance();
            this.d_ambVel = new UnitPoint3D(0.0, 0.0, 0.0, si.getVelocityUnit());
            this.d_ambTemp = new UnitDouble(20.0, si.getTempUnit());
            this.d_ambPressure = new UnitDouble(101325.0, SI.PASCAL);
            this.d_atmLapseRate = new UnitDouble(0.0, si.getAtmGradUnit());
            this.d_groundLevel = new UnitDouble(0.0, (Unit)SI.METER);
            this.d_gravityAccel = null;
            this.d_gravityX = new Variant.UnitDoubleVar(new UnitDouble(0.0, si.getAccelUnit()));
            this.d_gravityY = new Variant.UnitDoubleVar(new UnitDouble(0.0, si.getAccelUnit()));
            this.d_gravityZ = new Variant.UnitDoubleVar(new UnitDouble(-9.81, si.getAccelUnit()));
        }

        @Override
        public Object clone() {
            return super.clone();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (in instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)in).getVersion() < 31) {
                this.d_groundLevel = new UnitDouble(0.0, (Unit)SI.METER);
            }
            if (this.d_gravityAccel != null) {
                this.setGravityAccel(this.d_gravityAccel);
                this.d_gravityAccel = null;
            }
        }

        public double getRelHumidity() {
            return this.d_relHumidity;
        }

        public void setRelHumidity(double relHumidity) {
            this.d_relHumidity = relHumidity;
            this.changedEvt(new Object[0]);
        }

        public UnitPoint3D getGravityAccel() {
            return this.d_gravityAccel;
        }

        public void setGravityAccel(UnitPoint3D grav) {
            this.d_gravityX = new Variant.UnitDoubleVar(grav.xu());
            this.d_gravityY = new Variant.UnitDoubleVar(grav.yu());
            this.d_gravityZ = new Variant.UnitDoubleVar(grav.zu());
        }

        public void setGravityAccel(Variant xVar, Variant yVar, Variant zVar) {
            this.d_gravityX = xVar;
            this.d_gravityY = yVar;
            this.d_gravityZ = zVar;
            this.changedEvt(new Object[0]);
        }

        public Variant getGravityX() {
            return this.d_gravityX;
        }

        public Variant getGravityY() {
            return this.d_gravityY;
        }

        public Variant getGravityZ() {
            return this.d_gravityZ;
        }

        public UnitDouble getAmbPressure() {
            return this.d_ambPressure;
        }

        public void setAmbPressure(UnitDouble ambPressure) {
            this.d_ambPressure = ambPressure;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getAmbTemp() {
            return this.d_ambTemp;
        }

        public void setAmbTemp(UnitDouble ambTemp) {
            this.d_ambTemp = ambTemp;
            this.changedEvt(new Object[0]);
        }

        public UnitPoint3D getAmbVel() {
            return this.d_ambVel;
        }

        public void setAmbVel(UnitPoint3D ambVel) {
            this.d_ambVel = ambVel;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getAtmLapseRate() {
            return this.d_atmLapseRate;
        }

        public void setAtmLapseRate(UnitDouble atmLapseRate) {
            this.d_atmLapseRate = atmLapseRate;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getGroundLevel() {
            return this.d_groundLevel;
        }

        public void setGroundLevel(UnitDouble groundLevel) {
            this.d_groundLevel = groundLevel;
            this.changedEvt(new Object[0]);
        }
    }

    public static class Calculations
    extends APyroObject
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final DoubleVR SC_RANGE = DoubleVR.UNBOUNDED;
        public static final DoubleVR PR_RANGE = DoubleVR.UNBOUNDED;
        public static final DoubleVR CSMAG_RANGE = DoubleVR.UNBOUNDED;
        public static final DoubleVR C_FORCED_RANGE = DoubleVR.UNBOUNDED;
        public static final DoubleVR C_HORIZONTAL_RANGE = DoubleVR.UNBOUNDED;
        public static final DoubleVR C_VERTICAL_RANGE = DoubleVR.UNBOUNDED;
        private boolean d_correctBaroclinicTorque = true;
        private boolean d_useMLTurbulentModel = false;
        private boolean d_calcDNS = false;
        private boolean d_calcIsothermal = false;
        private boolean d_gpFlameExtinction = true;
        private double d_cflMin = 0.8;
        private double d_cflMax = 1.0;
        private double d_vnMin = 0.8;
        private double d_vnMax = 1.0;
        private double d_csmag = 0.2;
        private double d_prandtlNum = 0.5;
        private double d_schmidtNum = 0.5;
        private double d_cForced = 0.037;
        private double d_cHorizontal = 1.52;
        private double d_cVertical = 1.31;

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (PyroSimObjectInputStream.getVersion(in) < 38) {
                this.d_useMLTurbulentModel = false;
                this.d_cForced = 0.037;
                this.d_cHorizontal = 1.52;
                this.d_cVertical = 1.31;
            }
        }

        @Override
        public Object clone() {
            return super.clone();
        }

        public boolean calcDNS() {
            return this.d_calcDNS;
        }

        public void setCalcDNS(boolean calcDNS) {
            this.d_calcDNS = calcDNS;
            this.changedEvt(new Object[0]);
        }

        public boolean calcIsothermal() {
            return this.d_calcIsothermal;
        }

        public void setCalcIsothermal(boolean calcIsothermal) {
            this.d_calcIsothermal = calcIsothermal;
            this.changedEvt(new Object[0]);
        }

        public boolean getGPFlameExtinction() {
            return this.d_gpFlameExtinction;
        }

        public void setGPFlameExtinction(boolean gpFlameExtinction) {
            this.d_gpFlameExtinction = gpFlameExtinction;
            this.changedEvt(new Object[0]);
        }

        public double[] getCflRange() {
            return new double[]{this.d_cflMin, this.d_cflMax};
        }

        public void setCflRange(double cflMin, double cflMax) {
            this.d_cflMin = cflMin;
            this.d_cflMax = cflMax;
            this.changedEvt(new Object[0]);
        }

        public boolean isCorrectBaroclinicTorque() {
            return this.d_correctBaroclinicTorque;
        }

        public void setCorrectBaroclinicTorque(boolean correctBaroclinicTorque) {
            this.d_correctBaroclinicTorque = correctBaroclinicTorque;
            this.changedEvt(new Object[0]);
        }

        public boolean getUseMLTurbulentModel() {
            return this.d_useMLTurbulentModel;
        }

        public void setUseMLTurbulentModel(boolean useMLTurbulentModel) {
            this.d_useMLTurbulentModel = useMLTurbulentModel;
            this.changedEvt(new Object[0]);
        }

        public double getCsmag() {
            return this.d_csmag;
        }

        public void setCsmag(double csmag) {
            this.d_csmag = csmag;
            this.changedEvt(new Object[0]);
        }

        public double getPrandtlNum() {
            return this.d_prandtlNum;
        }

        public void setPrandtlNum(double prandtlNum) {
            this.d_prandtlNum = prandtlNum;
            this.changedEvt(new Object[0]);
        }

        public double getSchmidtNum() {
            return this.d_schmidtNum;
        }

        public void setSchmidtNum(double schmidtNum) {
            this.d_schmidtNum = schmidtNum;
            this.changedEvt(new Object[0]);
        }

        public double getCForced() {
            return this.d_cForced;
        }

        public void setCForced(double cForced) {
            this.d_cForced = cForced;
            this.changedEvt(new Object[0]);
        }

        public double getCHorizontal() {
            return this.d_cHorizontal;
        }

        public void setCHorizontal(double cHorizontal) {
            this.d_cHorizontal = cHorizontal;
            this.changedEvt(new Object[0]);
        }

        public double getCVertical() {
            return this.d_cVertical;
        }

        public void setCVertical(double cVertical) {
            this.d_cVertical = cVertical;
            this.changedEvt(new Object[0]);
        }

        public double[] getVnRange() {
            return new double[]{this.d_vnMin, this.d_vnMax};
        }

        public void setVnRange(double vnMin, double vnMax) {
            this.d_vnMin = vnMin;
            this.d_vnMax = vnMax;
            this.changedEvt(new Object[0]);
        }
    }

    public static class Time
    extends APyroObject
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final UnitDoubleVR TIME_STEP_RANGE = UnitDoubleVR.above(0.0, SIUS.getInstance().getTimeUnit(), false);
        public static final IntVR WALL_INC_RANGE = IntVR.above(1, true);
        private UnitDouble d_startTime = new UnitDouble(0.0, (Unit)SI.SECOND);
        private UnitDouble d_stopTime = new UnitDouble(10.0, (Unit)SI.SECOND);
        private UnitDouble d_dt = null;
        private int d_wallIncrement = 2;
        private boolean d_lockTimeStep = false;
        private boolean d_restrictTimeStep = true;
        private Map<String, Object> d_evacProps = Time.initEvacProps();

        @Override
        public Object clone() {
            Time clone = (Time)super.clone();
            clone.d_evacProps = new HashMap<String, Object>(this.d_evacProps);
            return clone;
        }

        private static Map<String, Object> initEvacProps() {
            HashMap<String, Object> evacProps = new HashMap<String, Object>();
            evacProps.put("EVAC_DT_FLOWFIELD", new UnitDouble(0.01, (Unit)SI.SECOND));
            evacProps.put("EVAC_DT_STEADY_STATE", new UnitDouble(0.05, (Unit)SI.SECOND));
            return evacProps;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (in instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)in).getVersion() < 31) {
                this.d_restrictTimeStep = true;
                this.d_evacProps = Time.initEvacProps();
            }
        }

        public void setTimeStepLocks(boolean lock, boolean restrict) {
            this.d_lockTimeStep = lock;
            this.d_restrictTimeStep = restrict;
            this.changedEvt(new Object[0]);
        }

        public boolean lockTimeSteps() {
            return this.d_lockTimeStep;
        }

        public boolean restrictTimeSteps() {
            return this.d_restrictTimeStep;
        }

        public int getWallIncrement() {
            return this.d_wallIncrement;
        }

        public void setWallIncrement(int wallIncrement) {
            this.d_wallIncrement = wallIncrement;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getStartTime() {
            return this.d_startTime;
        }

        public void setStartTime(UnitDouble startTime) {
            this.d_startTime = startTime;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getStopTime() {
            return this.d_stopTime;
        }

        public void setStopTime(UnitDouble stopTime) {
            this.d_stopTime = stopTime;
            this.changedEvt(new Object[0]);
        }

        public UnitDouble getInitTimeStep() {
            return this.d_dt;
        }

        public void setInitTimeStep(UnitDouble timeStep) {
            this.d_dt = timeStep;
            this.changedEvt(new Object[0]);
        }

        public void setEvacProp(String key, Object prop) {
            if (this.d_evacProps.get(key) != prop) {
                this.d_evacProps.put(key, prop);
                this.changedEvt(new Object[0]);
            }
        }

        public Object getEvacProp(String key) {
            return this.d_evacProps.get(key);
        }

        public Map<String, Object> getEvacProps() {
            return this.d_evacProps;
        }
    }
}

