/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.units;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.AbstractValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.DoubleValueRange;

public class UnitDoubleValueRange
extends AbstractValueRange<UnitDouble>
implements Serializable {
    static final long serialVersionUID = 1L;

    protected UnitDoubleValueRange(UnitDouble min, UnitDouble max, boolean checkMin, boolean checkMax, boolean minInclusive, boolean maxInclusive) {
        super(min, max, checkMin, checkMax, minInclusive, maxInclusive);
    }

    public static UnitDoubleValueRange createUncheckedRange() {
        return new UnitDoubleValueRange(null, null, false, false, false, false);
    }

    public static UnitDoubleValueRange createCheckedMin(UnitDouble min, boolean inclusive) {
        return new UnitDoubleValueRange(min, null, true, false, inclusive, false);
    }

    public static UnitDoubleValueRange createCheckedMax(UnitDouble max, boolean inclusive) {
        return new UnitDoubleValueRange(null, max, false, true, false, inclusive);
    }

    public static UnitDoubleValueRange createCheckedMinAndMax(UnitDouble min, UnitDouble max, boolean minInclusive, boolean maxInclusive) {
        return new UnitDoubleValueRange(min, max, true, true, minInclusive, maxInclusive);
    }

    public static UnitDoubleValueRange createCheckedMin(double min, Unit u, boolean inclusive) {
        return new UnitDoubleValueRange(new UnitDouble(min, u), null, true, false, inclusive, false);
    }

    public static UnitDoubleValueRange createCheckedMax(double max, Unit u, boolean inclusive) {
        return new UnitDoubleValueRange(null, new UnitDouble(max, u), false, true, false, inclusive);
    }

    public static UnitDoubleValueRange createCheckedMinAndMax(double min, double max, Unit u, boolean minInclusive, boolean maxInclusive) {
        return new UnitDoubleValueRange(new UnitDouble(min, u), new UnitDouble(max, u), true, true, minInclusive, maxInclusive);
    }

    public static UnitDoubleValueRange createCheckedRange(DoubleValueRange range, Unit u) {
        if (!range.checksMin() && !range.checksMax()) {
            return UnitDoubleValueRange.createUncheckedRange();
        }
        if (!range.checksMin() && range.checksMax()) {
            return UnitDoubleValueRange.createCheckedMax(new UnitDouble((Double)range.getMaxValue(), u), range.isMaxInclusive());
        }
        if (range.checksMin() && !range.checksMax()) {
            return UnitDoubleValueRange.createCheckedMin(new UnitDouble((Double)range.getMinValue(), u), range.isMinInclusive());
        }
        return UnitDoubleValueRange.createCheckedMinAndMax(new UnitDouble((Double)range.getMinValue(), u), new UnitDouble((Double)range.getMaxValue(), u), range.isMinInclusive(), range.isMaxInclusive());
    }

    @Override
    public String getDataType() {
        return "floating-point number";
    }

    @Override
    public String format(Object value) {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance();
        df.applyPattern("##0.0####E0##");
        return ((UnitDouble)value).format(df);
    }

    public DoubleValueRange getDoubleRange(Unit u) {
        if (!this.checksMin() && !this.checksMax()) {
            return DoubleValueRange.createUncheckedRange();
        }
        if (!this.checksMin() && this.checksMax()) {
            return DoubleValueRange.createCheckedMax(((UnitDouble)this.getMaxValue()).getValue(u), this.isMaxInclusive());
        }
        if (this.checksMin() && !this.checksMax()) {
            return DoubleValueRange.createCheckedMin(((UnitDouble)this.getMinValue()).getValue(u), this.isMinInclusive());
        }
        return DoubleValueRange.createCheckedMinAndMax(((UnitDouble)this.getMinValue()).getValue(u), ((UnitDouble)this.getMaxValue()).getValue(u), this.isMinInclusive(), this.isMaxInclusive());
    }
}

