/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.io;

import java.io.File;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class ExampleFileFilter
extends FileFilter {
    private static String TYPE_UNKNOWN = "Type Unknown";
    private static String HIDDEN_FILE = "Hidden File";
    private Vector d_filters = new Vector();
    private String d_description = null;
    private String d_fullDescription = null;
    private boolean d_useExtensionsInDescription = true;

    public ExampleFileFilter() {
    }

    public ExampleFileFilter(String extension) {
        this(extension, null);
    }

    public ExampleFileFilter(String extension, String description) {
        this();
        this.addExtension(extension);
        this.setDescription(description);
    }

    public ExampleFileFilter(String[] filters) {
        this(filters, null);
    }

    public ExampleFileFilter(String[] filters, String description) {
        this();
        for (int i = 0; i < filters.length; ++i) {
            this.addExtension(filters[i]);
        }
        this.setDescription(description);
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = ExampleFileFilter.getExtension(f);
            if (extension != null && this.d_filters.contains(extension)) {
                return true;
            }
        }
        return false;
    }

    public static String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public File appendExtension(File f) {
        if (f == null) {
            return null;
        }
        String[] filters = this.getFilters();
        if (filters.length <= 0) {
            return f;
        }
        String ext = ExampleFileFilter.getExtension(f);
        if (ext != null) {
            for (int m = 0; m < filters.length; ++m) {
                if (!ext.equals(filters[m])) continue;
                return f;
            }
        }
        String name = f.getAbsolutePath();
        name = name + "." + filters[0];
        return new File(name);
    }

    public void addExtension(String extension) {
        if (extension == null) {
            return;
        }
        this.d_filters.add(extension.toLowerCase());
        this.d_fullDescription = null;
    }

    public String[] getFilters() {
        String[] filters = new String[this.d_filters.size()];
        return this.d_filters.toArray(filters);
    }

    @Override
    public String getDescription() {
        if (this.d_fullDescription == null) {
            if (this.d_description == null || this.isExtensionListInDescription()) {
                this.d_fullDescription = this.d_description == null ? "(" : this.d_description + " (";
                int numFilters = this.d_filters.size();
                if (numFilters > 0) {
                    this.d_fullDescription = this.d_fullDescription + "." + (String)this.d_filters.get(0);
                    for (int i = 1; i < numFilters; ++i) {
                        this.d_fullDescription = this.d_fullDescription + ", ." + (String)this.d_filters.get(i);
                    }
                }
                this.d_fullDescription = this.d_fullDescription + ")";
            } else {
                this.d_fullDescription = this.d_description;
            }
        }
        return this.d_fullDescription;
    }

    public void setDescription(String description) {
        this.d_description = description;
        this.d_fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.d_useExtensionsInDescription = b;
        this.d_fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.d_useExtensionsInDescription;
    }
}

