/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v16;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AbstractFDSObject;
import pyrosim.legacy_2006_2.domain.AbstractFace;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.ATask;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class AlignedBlock
extends AbstractFDSObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private UnitPoint3D d_minPoint;
    private UnitPoint3D d_maxPoint;
    private boolean d_thicken = false;
    private boolean d_permitHole = true;
    private boolean d_sawtooth = true;
    public static final byte MIN_X = 0;
    public static final byte MAX_X = 1;
    public static final byte MIN_Y = 2;
    public static final byte MAX_Y = 3;
    public static final byte MIN_Z = 4;
    public static final byte MAX_Z = 5;
    public static final int NUM_FACES = 6;
    private static final String[] FACE_NAMES = new String[]{"Min X", "Max X", "Min Y", "Max Y", "Min Z", "Max Z"};
    private static final byte X = 0;
    private static final byte Y = 1;
    private static final byte Z = 2;
    private static final int NUM_ROT_AXES = 3;
    private static final byte[][] FACE_INDEX_ROT_LU;

    public AlignedBlock(Material mat) {
        this(null, null, mat);
    }

    public AlignedBlock(UnitPoint3D minPoint, UnitPoint3D maxPoint, Material mat) {
        this(minPoint, maxPoint, "Obstruction", mat);
    }

    public AlignedBlock(UnitPoint3D minPoint, UnitPoint3D maxPoint, String description, Material mat) {
        this(minPoint, maxPoint, description, null, mat);
    }

    public AlignedBlock(UnitPoint3D minPoint, UnitPoint3D maxPoint, String description, Color c, Material mat) {
        super(description);
        this.d_minPoint = minPoint;
        this.d_maxPoint = maxPoint;
        this.d_faces = new Vector(6);
        for (byte i = 0; i <= 5; i = (byte)(i + 1)) {
            this.d_faces.add(new AlignedBlockFace(this, i, mat));
        }
        this.setColor(c);
    }

    @Override
    public Object clone() {
        AlignedBlock clone = (AlignedBlock)super.clone();
        return clone;
    }

    @Override
    protected void imprint(Object baseObject) {
        if (!(baseObject instanceof AlignedBlock)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(baseObject);
        AlignedBlock obj = (AlignedBlock)baseObject;
        Iterator<IFace> fIter = this.getFaceIterator();
        while (fIter.hasNext()) {
            ((AlignedBlockFace)fIter.next()).d_block = this;
        }
        this.d_minPoint = (UnitPoint3D)obj.d_minPoint.clone();
        this.d_maxPoint = (UnitPoint3D)obj.d_maxPoint.clone();
        this.d_thicken = obj.d_thicken;
        this.d_permitHole = obj.d_permitHole;
        this.d_sawtooth = obj.d_sawtooth;
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AlignedBlock b = (AlignedBlock)obj;
        return (this.d_minPoint == null && b.d_minPoint == null || this.d_minPoint != null && this.d_minPoint.equals(b.d_minPoint)) && (this.d_maxPoint == null && b.d_maxPoint == null || this.d_maxPoint != null && this.d_maxPoint.equals(b.d_maxPoint)) && this.d_thicken == b.d_thicken && this.d_permitHole == b.d_permitHole && this.d_sawtooth == b.d_sawtooth;
    }

    @Override
    public String getPropertyHashString() {
        BaseUnit meters = SI.METER;
        String s = super.getPropertyHashString();
        if (this.d_minPoint != null) {
            s = s + this.d_minPoint.x((Unit)meters) + "," + this.d_minPoint.y((Unit)meters) + "," + this.d_minPoint.z((Unit)meters) + ";";
        }
        if (this.d_maxPoint != null) {
            s = s + this.d_maxPoint.x((Unit)meters) + "," + this.d_maxPoint.y((Unit)meters) + "," + this.d_maxPoint.z((Unit)meters) + ";";
        }
        s = s + this.d_permitHole + "," + this.d_thicken + "," + this.d_sawtooth + ";";
        return s;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        if (stream instanceof PyroSimObjectInputStream) {
            PyroSimObjectInputStream str = (PyroSimObjectInputStream)stream;
            if (str.getVersion() < 15) {
                this.ensureKeyed();
                if (this.getName() == null) {
                    this.initDomainHelper();
                    System.out.print("Reading old Block object into AlignedBlock: ");
                    ObjectInputStream.GetField gf = stream.readFields();
                    String name = (String)gf.get("d_name", null);
                    this.taskSetName(name).run();
                    this.setVisible(true);
                    this.d_minPoint = (UnitPoint3D)gf.get("d_minPoint", null);
                    this.d_maxPoint = (UnitPoint3D)gf.get("d_maxPoint", null);
                    Material[] materials = (Material[])gf.get("d_materials", null);
                    this.d_faces = new Vector(6);
                    for (byte i = 0; i <= 5; i = (byte)(i + 1)) {
                        this.d_faces.add(new AlignedBlockFace(this, i, materials[i]));
                    }
                    this.initEvents();
                    this.d_permitHole = true;
                    this.d_sawtooth = true;
                } else {
                    stream.defaultReadObject();
                }
            } else {
                stream.defaultReadObject();
            }
        } else {
            stream.defaultReadObject();
        }
    }

    public void setMinPoint(UnitPoint3D minPoint) {
        this.d_minPoint = minPoint;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public void setMaxPoint(UnitPoint3D maxPoint) {
        this.d_maxPoint = maxPoint;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public UnitPoint3D getMinPoint() {
        return this.d_minPoint;
    }

    @Override
    public UnitPoint3D getMaxPoint() {
        return this.d_maxPoint;
    }

    public String toString() {
        String str = "";
        String name = this.getName();
        if (name != null && !name.equals("")) {
            str = str + " [" + name + "]";
        }
        return str;
    }

    @Override
    public int getNumFaces() {
        return 6;
    }

    @Override
    public Material getMaterial(int faceIndex) {
        return ((IFace)this.d_faces.get(faceIndex)).getMaterial();
    }

    @Override
    public void setMaterial(int faceIndex, Material mat) {
        ((IFace)this.d_faces.get(faceIndex)).setMaterial(mat);
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Material getMaterial() {
        Material m0 = this.getMaterial(0);
        for (int i = 0; i < 6; ++i) {
            if (m0 == this.getMaterial(i)) continue;
            return null;
        }
        return m0;
    }

    @Override
    public boolean isUniformMaterial() {
        return this.getMaterial() != null;
    }

    @Override
    public String getFDSType() {
        return "OBST";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        Vector<String> mats;
        FDSInputRecord rec = new FDSInputRecord();
        rec.setType("OBST");
        Vector<Double> coords = new Vector<Double>(6);
        Unit u = FdsSISystem.getInstance().getLengthUnit();
        coords.add(this.d_minPoint.x(u));
        coords.add(this.d_maxPoint.x(u));
        coords.add(this.d_minPoint.y(u));
        coords.add(this.d_maxPoint.y(u));
        coords.add(this.d_minPoint.z(u));
        coords.add(this.d_maxPoint.z(u));
        rec.setValue("XB", coords);
        if (this.isUniformMaterial()) {
            rec.setValue("SURF_ID", ((IFace)this.d_faces.get(0)).getMaterial().getName());
        } else if (((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(1)).getMaterial() && ((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(2)).getMaterial() && ((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(3)).getMaterial()) {
            mats = new VectorFromArray<String>(((IFace)this.d_faces.get(5)).getMaterial().getName(), ((IFace)this.d_faces.get(0)).getMaterial().getName(), ((IFace)this.d_faces.get(4)).getMaterial().getName());
            rec.setValue("SURF_IDS", mats);
        } else {
            mats = new Vector<String>(6);
            for (int i = 0; i < 6; ++i) {
                mats.add(((IFace)this.d_faces.get(i)).getMaterial().getName());
            }
            rec.setValue("SURF_ID6", mats);
        }
        Color c = this.getColor();
        if (c != null) {
            float[] rgb = c.getRGBComponents(null);
            Vector<Double> color = new Vector<Double>(3);
            color.add(Double.valueOf(rgb[0]));
            color.add(Double.valueOf(rgb[1]));
            color.add(Double.valueOf(rgb[2]));
            rec.setValue("RGB", color);
        }
        rec.setValue("PERMIT_HOLE", this.d_permitHole);
        rec.setValue("SAWTOOTH", this.d_sawtooth);
        rec.setValue("THICKEN", this.d_thicken);
        rec.setComment(this.getName());
        Collection eventRecords = this.getEventInputRecords(rec);
        if (eventRecords.size() != 0) {
            recs.addAll(eventRecords);
        } else {
            recs.add(rec);
        }
    }

    public boolean permitsHole() {
        return this.d_permitHole;
    }

    public boolean isSawtoothed() {
        return this.d_sawtooth;
    }

    public boolean isThickened() {
        return this.d_thicken;
    }

    public void setPermitsHole(boolean hole) {
        this.d_permitHole = hole;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public void setIsSawtoothed(boolean d_sawtooth) {
        this.d_sawtooth = d_sawtooth;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public void setIsThickened(boolean d_thicken) {
        this.d_thicken = d_thicken;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public String getTypeDescription() {
        return "Aligned Block";
    }

    @Override
    public boolean isRasterizable() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }

    static {
        byte[][] rotlu = FACE_INDEX_ROT_LU = new byte[3][6];
        rotlu[0][0] = 0;
        rotlu[0][1] = 1;
        rotlu[0][2] = 4;
        rotlu[0][3] = 5;
        rotlu[0][4] = 3;
        rotlu[0][5] = 2;
        rotlu[1][0] = 5;
        rotlu[1][1] = 4;
        rotlu[1][2] = 2;
        rotlu[1][3] = 3;
        rotlu[1][4] = 0;
        rotlu[1][5] = 1;
        rotlu[2][0] = 2;
        rotlu[2][1] = 3;
        rotlu[2][2] = 1;
        rotlu[2][3] = 0;
        rotlu[2][4] = 4;
        rotlu[2][5] = 5;
    }

    public static class AlignedBlockFace
    extends AbstractFace
    implements Serializable {
        static final long serialVersionUID = 1L;
        private AlignedBlock d_block;
        private byte d_index;

        public AlignedBlockFace() {
        }

        public AlignedBlockFace(AlignedBlock block, byte index, Material material) {
            super(material);
            this.d_block = block;
            this.d_index = index;
        }

        @Override
        public Object clone() {
            return super.clone();
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof AlignedBlockFace)) {
                return false;
            }
            AlignedBlockFace abf = (AlignedBlockFace)obj;
            return this.d_index == abf.d_index;
        }

        @Override
        public void setMaterial(Material m) {
            super.setMaterial(m);
        }

        @Override
        public String getName() {
            return FACE_NAMES[this.d_index];
        }

        @Override
        public void getGeometry(Geometry g) {
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            byte index;
            ObjectInputStream.GetField gf = stream.readFields();
            this.d_index = index = gf.get("d_index", (byte)0);
        }

        @Override
        public UnitPoint3D[] getVerts() {
            return null;
        }

        @Override
        public FDSObject getAttachedObj() {
            return this.d_block;
        }

        @Override
        public IFDSFragGenerator getFDSFragGenerator() {
            return null;
        }
    }

    private abstract class ModifyGeomTask
    extends ATask {
        private UnitPoint3D d_min;
        private UnitPoint3D d_max;
        private final Material[] d_mats;

        public abstract void modify();

        public ModifyGeomTask(int est, boolean undoable) {
            super(est, undoable);
            this.d_mats = new Material[6];
        }

        @Override
        public void undo() {
            ADomainObject.pauseUpdates(AlignedBlock.this);
            AlignedBlock.this.setMinPoint(this.d_min);
            AlignedBlock.this.setMaxPoint(this.d_max);
            for (int face = 0; face < 6; ++face) {
                ((IFace)AlignedBlock.this.d_faces.get(face)).setMaterial(this.d_mats[face]);
            }
            ADomainObject.resumeUpdates(AlignedBlock.this);
        }

        @Override
        public void run() {
            this.d_min = (UnitPoint3D)AlignedBlock.this.getMinPoint().clone();
            this.d_max = (UnitPoint3D)AlignedBlock.this.getMaxPoint().clone();
            for (int face = 0; face < 6; ++face) {
                this.d_mats[face] = ((IFace)AlignedBlock.this.d_faces.get(face)).getMaterial();
            }
            this.modify();
        }
    }
}

