/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.Rectifier;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.FDSColors;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.Vent;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.EventParser;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

class VentProcessor
extends AFDSRecordProcessor {
    private int d_nextVentNum = 1;
    private Hashtable d_allVents = new Hashtable(243);

    public VentProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "VENT";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        boolean err = false;
        FDSRecordFormatException caughtExc = null;
        if (!rec.getType().equals("VENT")) {
            return false;
        }
        try {
            Unit length = FdsSISystem.getInstance().getLengthUnit();
            String gridWall = null;
            Vector<UnitPoint3D[]> coordsSet = new Vector<UnitPoint3D[]>();
            Vector coords = (Vector)rec.getValue("XB");
            Vector<String> gridBasedNames = new Vector<String>();
            gridWall = (String)rec.getValue("CB");
            Double pbx = (Double)rec.getValue("PBX");
            Double pby = (Double)rec.getValue("PBY");
            Double pbz = (Double)rec.getValue("PBZ");
            int numGeomsDefined = 0;
            if (gridWall != null) {
                ++numGeomsDefined;
            }
            if (coords != null) {
                ++numGeomsDefined;
            }
            if (pbx != null) {
                ++numGeomsDefined;
            }
            if (pby != null) {
                ++numGeomsDefined;
            }
            if (pbz != null) {
                ++numGeomsDefined;
            }
            if (numGeomsDefined != 1) {
                throw new FDSRecordFormatException(rec, "The geometry of the vent must be specified through only one of the following fields:\nXB, CB, PBX, PBY, or PBZ.");
            }
            if (gridWall != null || pbx != null || pby != null || pbz != null) {
                boolean gridExists = false;
                Grid firstGrid = null;
                for (PyroMod mod : this.getSourceContainers()) {
                    if (mod.getGridManager().isEmpty()) continue;
                    gridExists = true;
                    firstGrid = mod.getGridManager().iterator().next();
                }
                if (!gridExists) {
                    throw new FDSRecordFormatException(rec, "The use of CB, PBX, PBY, or PBZ requires at least one grid to be\ndefined, but no grids exist in the model.");
                }
                UnitPoint3D minPointAllGrids = firstGrid.getMinPoint();
                UnitPoint3D maxPointAllGrids = firstGrid.getMaxPoint();
                double minxAllGrids = minPointAllGrids.x(length);
                double maxxAllGrids = maxPointAllGrids.x(length);
                double minyAllGrids = minPointAllGrids.y(length);
                double maxyAllGrids = maxPointAllGrids.y(length);
                double minzAllGrids = minPointAllGrids.z(length);
                double maxzAllGrids = maxPointAllGrids.z(length);
                for (PyroMod mod : this.getSourceContainers()) {
                    for (Grid g : mod.getGridManager()) {
                        UnitPoint3D minGridPoint = g.getMinPoint();
                        UnitPoint3D maxGridPoint = g.getMaxPoint();
                        double minx = minGridPoint.x(length);
                        double maxx = maxGridPoint.x(length);
                        double miny = minGridPoint.y(length);
                        double maxy = maxGridPoint.y(length);
                        double minz = minGridPoint.z(length);
                        double maxz = maxGridPoint.z(length);
                        if (gridWall != null) {
                            if (gridWall.equals("XBAR0")) {
                                maxx = minGridPoint.x(length);
                            } else if (gridWall.equals("XBAR")) {
                                minx = maxGridPoint.x(length);
                            } else if (gridWall.equals("YBAR0")) {
                                maxy = minGridPoint.y(length);
                            } else if (gridWall.equals("YBAR")) {
                                miny = maxGridPoint.y(length);
                            } else if (gridWall.equals("ZBAR0")) {
                                maxz = minGridPoint.z(length);
                            } else {
                                if (!gridWall.equals("ZBAR")) throw new FDSRecordFormatException(rec, gridWall + " is an invalid model boundary.");
                                minz = maxGridPoint.z(length);
                            }
                            UnitPoint3D[] ventBounds = new UnitPoint3D[]{new UnitPoint3D(minx, miny, minz, length), new UnitPoint3D(maxx, maxy, maxz, length)};
                            coordsSet.add(ventBounds);
                            String name = "Vent for " + g.getName() + " " + gridWall;
                            gridBasedNames.add(name);
                            continue;
                        }
                        if (minx < minxAllGrids) {
                            minxAllGrids = minx;
                        }
                        if (maxx > maxxAllGrids) {
                            maxxAllGrids = maxx;
                        }
                        if (miny < minyAllGrids) {
                            minyAllGrids = miny;
                        }
                        if (maxy > maxyAllGrids) {
                            maxyAllGrids = maxy;
                        }
                        if (minz < minzAllGrids) {
                            minzAllGrids = minz;
                        }
                        if (!(maxz > maxzAllGrids)) continue;
                        maxzAllGrids = maxz;
                    }
                }
                if (gridWall == null) {
                    UnitPoint3D[] ventBounds = new UnitPoint3D[2];
                    if (pbx != null) {
                        ventBounds[0] = new UnitPoint3D(pbx, minyAllGrids, minzAllGrids, length);
                        ventBounds[1] = new UnitPoint3D(pbx, maxyAllGrids, maxzAllGrids, length);
                    } else if (pby != null) {
                        ventBounds[0] = new UnitPoint3D(minxAllGrids, pby, minzAllGrids, length);
                        ventBounds[1] = new UnitPoint3D(maxxAllGrids, pby, maxzAllGrids, length);
                    } else if (pbz != null) {
                        ventBounds[0] = new UnitPoint3D(minxAllGrids, minyAllGrids, pbz, length);
                        ventBounds[1] = new UnitPoint3D(maxxAllGrids, maxyAllGrids, pbz, length);
                    }
                    coordsSet.add(ventBounds);
                    String name = "Vent #" + this.d_nextVentNum++;
                    gridBasedNames.add(name);
                }
            } else if (coords != null) {
                UnitPoint3D min = new UnitPoint3D((Double)coords.get(0), (Double)coords.get(2), (Double)coords.get(4), length);
                UnitPoint3D max = new UnitPoint3D((Double)coords.get(1), (Double)coords.get(3), (Double)coords.get(5), length);
                UnitPoint3D[] ventBounds = new UnitPoint3D[]{min, max};
                coordsSet.add(ventBounds);
            }
            for (int m = 0; m < coordsSet.size(); ++m) {
                Vent correctVent;
                UnitPoint3D[] ventBounds = (UnitPoint3D[])coordsSet.get(m);
                UnitPoint3D min = ventBounds[0];
                UnitPoint3D max = ventBounds[1];
                String gridBasedName = null;
                if (gridBasedNames.size() > 0) {
                    gridBasedName = (String)gridBasedNames.get(m);
                }
                int equalPairs = 0;
                if (min.xu().equals(max.xu())) {
                    ++equalPairs;
                }
                if (min.yu().equals(max.yu())) {
                    ++equalPairs;
                }
                if (min.zu().equals(max.zu())) {
                    ++equalPairs;
                }
                if (equalPairs != 1) {
                    throw new FDSRecordFormatException(rec, "Two of the six coordinates must be the same (i.e. xmin = xmax OR ymin = ymax OR zmin = zmax).");
                }
                Rectifier.rectify(min, max);
                Vent vent = new Vent(min, max, null, this.getParsingInfo().getDefaultMaterial());
                Object surfID = rec.getValue("SURF_ID");
                if (surfID != null) {
                    Material mat = this.getResource(surfID, Material.class);
                    if (mat == null) throw new FDSRecordFormatException(rec, "The surface, \"" + surfID + ",\" does not exist.");
                    vent.setMaterial(mat);
                } else {
                    vent.setMaterial(this.getParsingInfo().getDefaultMaterial());
                }
                Color color = this.parseColor(rec);
                if (color != null) {
                    vent.setColor(color);
                } else {
                    String colorName = (String)rec.getValue("COLOR");
                    if (colorName != null) {
                        if (colorName.equalsIgnoreCase("INVISIBLE")) {
                            vent.setVisible(false);
                        }
                        vent.setColor(FDSColors.getColor(colorName));
                    }
                }
                Double iorD = (Double)rec.getValue("IOR");
                if (iorD != null) {
                    int ior = iorD.intValue();
                    if (!vent.isFDSNormalValid(ior)) {
                        throw new FDSRecordFormatException(rec, "The specified VENT uses an incorrect value for IOR.  IOR must correspond with a value\nnormal to the plane in which the VENT lies, and it must be one of the following:\nIOR=-1 : the vent's normal is in the -x direction\nIOR=1  : the vent's normal is in the +x direction\nIOR=-2 : the vent's normal is in the -y direction\nIOR=2  : the vent's normal is in the +y direction\nIOR=-3 : the vent's normal is in the -z direction\nIOR=3  : the vent's normal is in the +z direction\n");
                    }
                    vent.setFDSNormal(ior);
                }
                boolean usingExisting = (correctVent = (Vent)EventParser.getCorrectObject(this.d_allVents, vent)) != vent;
                vent = correctVent;
                if (vent.getName() == null) {
                    String desc = rec.getComment();
                    if (desc.equals("")) {
                        desc = gridBasedName == null ? new String("Vent #" + this.d_nextVentNum++) : gridBasedName;
                    }
                    vent.taskSetName(desc).run();
                }
                if (gridBasedName != null) {
                    vent.setVisible(false);
                }
                String[] activateStrings = new String[]{"T_OPEN", "T_ACTIVATE"};
                String[] deactivateStrings = new String[]{"T_CLOSE", "T_DEACTIVATE"};
                String heatActivateString = "HEAT_ACTIVATE";
                String heatDeactivateString = "HEAT_DEACTIVATE";
                EventParser.parseEvents(this, vent, rec, activateStrings, deactivateStrings, heatActivateString, heatDeactivateString, this.getContainer().getHeatDetectors());
                if (usingExisting) continue;
                this.getContainer().getObstructions().taskAdd(vent).run();
                this.flagPyroTypeAffected(Vent.class);
                this.d_allVents.put(vent.getPropertyHashString(), vent);
            }
        }
        catch (FDSRecordFormatException e) {
            caughtExc = e;
            err = true;
        }
        catch (ClassCastException e2) {
            err = true;
        }
        catch (ArrayIndexOutOfBoundsException e3) {
            err = true;
        }
        if (!err) return true;
        if (caughtExc == null) throw new FDSRecordFormatException(rec);
        throw caughtExc;
    }

    @Override
    public void done() {
    }

    private UnitDouble makeDouble(Object value) {
        return new UnitDouble((Double)value, FdsSISystem.getInstance().getLengthUnit());
    }
}

