/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.awt.Color;
import java.util.Collection;
import java.util.Vector;
import pyrosim.Intl;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParseWarning;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordProcessor;

public abstract class AFDSRecordProcessor
implements FDSRecordProcessor {
    private FDSParsingInfo d_parsingInfo;

    public AFDSRecordProcessor(FDSParsingInfo parsingInfo) {
        this.d_parsingInfo = parsingInfo;
    }

    @Override
    public PyroMod getContainer() {
        return this.d_parsingInfo.getContainer();
    }

    public Collection<PyroMod> getSourceContainers() {
        return this.d_parsingInfo.getSourceContainers();
    }

    @Override
    public FDSParsingInfo getParsingInfo() {
        return this.d_parsingInfo;
    }

    public void flagPyroTypeAffected(Class type) {
        this.d_parsingInfo.getPyroObjectTypesAffected().add(type);
    }

    public <K, V extends IPyroObject> V getResource(K key, Class<V> pyroObjectType) {
        return this.d_parsingInfo.getResource(key, pyroObjectType);
    }

    public <K, V extends IPyroObject> boolean resourceExists(K key, Class<V> pyroObjectType) {
        return this.d_parsingInfo.resourceExists(key, pyroObjectType);
    }

    public <K, V extends IPyroObject> void makeUnique(V object, Class<V> pyroObjectType) {
        this.d_parsingInfo.makeUnique(object, pyroObjectType);
    }

    public void addWarning(FDSParseWarning warning) {
        this.d_parsingInfo.addWarning(warning);
    }

    public void addWarning(FDSInputRecord rec, String warning, String actionTaken) {
        int recLine = 0;
        String recText = "";
        if (rec != null) {
            recLine = rec.getDebugInfo().getBeginLineNum();
            recText = rec.getDebugInfo().getOriginalText();
        }
        this.d_parsingInfo.addWarning(new FDSParseWarning(recLine, warning, actionTaken, recText));
    }

    private float clamp(FDSInputRecord rec, float val) {
        if (val < 0.0f || val > 1.0f) {
            this.addWarning(rec, String.format(Intl.intl("Color component out of range: %f"), Float.valueOf(val)), Intl.intl("Clamping component to 0-1"));
        }
        if (val < 0.0f) {
            return 0.0f;
        }
        if (val > 1.0f) {
            return 1.0f;
        }
        return val;
    }

    protected Color parseColor(FDSInputRecord rec) {
        Vector color = (Vector)rec.getValue("RGB");
        if (color != null) {
            float r = this.clamp(rec, ((Double)color.get(0)).floatValue());
            float g = this.clamp(rec, ((Double)color.get(1)).floatValue());
            float b = this.clamp(rec, ((Double)color.get(2)).floatValue());
            return new Color(r, g, b);
        }
        return null;
    }
}

