/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.DirectionVector;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.ASetNameTask;
import pyrosim.legacy_2006_2.domain.ActivatableObject;
import pyrosim.legacy_2006_2.domain.DisplayablePointObject;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.domain.PartRecord;
import pyrosim.legacy_2006_2.domain.PyroResourceFinder;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.domain.dependencies.IDependent;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class SprkRecord
extends ActivatableObject
implements Serializable,
Cloneable,
DisplayablePointObject,
IDependent,
IFDSRenderable,
IPyroObject {
    private static final long serialVersionUID = 1L;
    public static final String NO_PART = "";
    private String d_label;
    private String d_make;
    private String d_partID;
    private DirectionVector d_orientation;
    private UnitPoint3D d_xyz;
    private UnitDouble d_rotation;
    private Vector d_activate;
    private Vector d_deactivate;

    public SprkRecord() {
        this(NO_PART);
    }

    public SprkRecord(String name) {
        this(name, NO_PART, NO_PART, 0.0, 0.0, -1.0, new UnitDouble(0.0, FdsSISystem.getInstance().getAngleUnit()), new UnitPoint3D(0.0, 0.0, 0.0, FdsSISystem.getInstance().getLengthUnit()));
    }

    public SprkRecord(String name, String make, String partID, double orientX, double orientY, double orientZ, UnitDouble rotation, UnitPoint3D xyz) {
        this.d_label = name;
        this.d_make = make;
        this.d_partID = partID;
        this.d_orientation = new DirectionVector(orientX, orientY, orientZ);
        this.d_rotation = rotation;
        this.d_xyz = xyz;
    }

    @Override
    public Object clone() {
        SprkRecord clone = (SprkRecord)super.clone();
        clone.d_xyz = this.d_xyz != null ? (UnitPoint3D)this.d_xyz.clone() : null;
        clone.d_rotation = this.d_rotation != null ? (UnitDouble)this.d_rotation.clone() : null;
        return clone;
    }

    public void reset() {
        this.d_label = NO_PART;
        this.d_make = NO_PART;
        this.d_partID = NO_PART;
        this.d_orientation = new DirectionVector(0.0, 0.0, -1.0);
        this.d_rotation = new UnitDouble(0.0, FdsSISystem.getInstance().getAngleUnit());
        this.d_xyz = new UnitPoint3D(0.0, 0.0, 0.0, FdsSISystem.getInstance().getLengthUnit());
        this.fireDomainEvent(new PyroDomainEvent(this, SprkRecord.class, 5));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.fixSerializable();
    }

    private void setName(String name) {
        this.d_label = name;
        this.fireDomainEvent(new PyroDomainEvent(this, SprkRecord.class, 5));
    }

    public Task taskSetName(String name) {
        return new ASetNameTask(name){

            @Override
            public void setName(String newName) {
                SprkRecord.this.setName(newName);
            }

            @Override
            protected String getName() {
                return SprkRecord.this.getLabel();
            }
        };
    }

    public void setMake(String make) {
        this.d_make = make;
        this.fireDomainEvent(new PyroDomainEvent(this, SprkRecord.class, 5));
    }

    private void setPartID(String partID) {
        this.d_partID = partID;
        this.fireDomainEvent(new PyroDomainEvent(this, SprkRecord.class, 5));
    }

    public void setOrientation(double x, double y, double z) {
        this.d_orientation.x = x;
        this.d_orientation.y = y;
        this.d_orientation.z = z;
        this.fireDomainEvent(new PyroDomainEvent(this, SprkRecord.class, 5));
    }

    public void setRotation(double rotation, Unit u) {
        this.d_rotation = new UnitDouble(rotation, u);
        this.fireDomainEvent(new PyroDomainEvent(this, SprkRecord.class, 5));
    }

    public void setXYZ(double x, double y, double z, Unit u) {
        this.d_xyz.set(x, y, z, u);
        this.fireDomainEvent(new PyroDomainEvent(this, SprkRecord.class, 5));
    }

    public String getLabel() {
        return this.d_label;
    }

    public String getMake() {
        return this.d_make;
    }

    public String getPartID() {
        return this.d_partID;
    }

    public DirectionVector getOrientation() {
        return this.d_orientation;
    }

    public UnitDouble getRotation() {
        return this.d_rotation;
    }

    public UnitPoint3D getXYZ() {
        return this.d_xyz;
    }

    @Override
    public Map getEventInputRecordMap(int eventType) {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(0, "T_ACTIVATE");
        map.put(1, "T_DEACTIVATE");
        return map;
    }

    @Override
    public String getPropertyHashString() {
        Unit angleUnit = FdsSISystem.getInstance().getAngleUnit();
        Unit lengthUnit = FdsSISystem.getInstance().getLengthUnit();
        return "LABEL=" + this.d_label + ";" + "MAKE" + "=" + this.d_make + ";" + "ORIENTATION" + "=" + this.d_orientation.x + "," + this.d_orientation.y + "," + this.d_orientation.z + ";" + "ROTATION" + "=" + this.d_rotation.getValue(angleUnit) + ";" + "XYZ" + "=" + this.d_xyz.x(lengthUnit) + ";" + this.d_xyz.y(lengthUnit) + ";" + this.d_xyz.z(lengthUnit);
    }

    @Override
    public String getFDSType() {
        return "SPRK";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        Collection eventRecords;
        FDSInputRecord rec = new FDSInputRecord();
        rec.setType("SPRK");
        rec.setValue("LABEL", this.getLabel());
        assert (this.getMake() != null);
        rec.setValue("MAKE", this.getMake());
        if (this.getOrientation().x != 0.0 || this.getOrientation().y != 0.0 || this.getOrientation().z != -1.0) {
            Vector<Double> orient = new Vector<Double>();
            orient.add(this.getOrientation().x);
            orient.add(this.getOrientation().y);
            orient.add(this.getOrientation().z);
            rec.setValue("ORIENTATION", orient);
        }
        if (!this.getPartID().equals(NO_PART)) {
            rec.setValue("PART_ID", this.getPartID());
        }
        Unit angleUnit = FdsSISystem.getInstance().getAngleUnit();
        if (this.getRotation() != null && this.getRotation().getValue(angleUnit) != 0.0) {
            rec.setValue("ROTATION", this.getRotation().getValue(angleUnit));
        }
        if (this.getXYZ() != null) {
            Unit lengthUnit = FdsSISystem.getInstance().getLengthUnit();
            Vector<Double> xyz = new Vector<Double>();
            xyz.add(this.getXYZ().x(lengthUnit));
            xyz.add(this.getXYZ().y(lengthUnit));
            xyz.add(this.getXYZ().z(lengthUnit));
            rec.setValue("XYZ", xyz);
        }
        if ((eventRecords = this.getEventInputRecords(rec)).size() != 0) {
            recs.addAll(eventRecords);
        } else {
            recs.add(rec);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SprkRecord) {
            return ((SprkRecord)obj).d_label.equals(this.d_label) && ((SprkRecord)obj).d_make.equals(this.d_make) && ((SprkRecord)obj).d_orientation.equals(this.d_orientation) && ((SprkRecord)obj).d_partID.equals(this.d_partID) && ((SprkRecord)obj).d_rotation.equals(this.d_rotation) && ((SprkRecord)obj).d_xyz.equals(this.d_xyz) && super.equals(obj);
        }
        return false;
    }

    @Override
    public UnitPoint3D getLocation() {
        return this.d_xyz;
    }

    @Override
    public Color getColor() {
        return Color.blue;
    }

    @Override
    public int getPointSize() {
        return 8;
    }

    @Override
    public String getTypeDescription() {
        return "Sprinkler";
    }

    @Override
    public void getObjectsDependedOn(Set<IDependedOn> dependencies, Class<IDependedOn> type) {
        PartRecord part;
        if (type.isAssignableFrom(PartRecord.class) && this.d_partID != null && this.d_partID.length() > 0 && (part = (PartRecord)PyroResourceFinder.find(type, this.d_partID, this.getDomains())) != null) {
            dependencies.add(part);
        }
    }

    @Override
    public boolean dependsOnObject(IDependedOn depOn) {
        return depOn instanceof PartRecord && this.d_partID != null && this.d_partID.equals(((PartRecord)depOn).getID());
    }

    public Task getSetParticleTask(String partID) {
        return new SetParticleTask(this, partID);
    }

    @Override
    public Task taskUpdateAfterDependedOnReplaced(IDependedOn old, IDependedOn replacement) {
        assert (old instanceof PartRecord);
        PartRecord deletedPart = (PartRecord)old;
        PartRecord replPart = (PartRecord)replacement;
        assert (deletedPart == null ? this.getPartID().equals(NO_PART) : deletedPart.getID().equals(this.getPartID()));
        return new SetParticleTask(this, replPart != null ? replPart.getID() : NO_PART);
    }

    @Override
    public Task taskUpdateBeforeDependedOnRenamed(IDependedOn dep, String newID) {
        assert (dep instanceof PartRecord);
        PartRecord part = (PartRecord)dep;
        assert (part == null ? this.getPartID().equals(NO_PART) : part.getID().equals(this.getPartID()));
        return new SetParticleTask(this, newID);
    }

    @Override
    public Task taskUpdateAfterDependedOnChanged(IDependedOn dep, Object info) {
        return null;
    }

    private static class SetParticleTask
    implements Task {
        private final SprkRecord d_owner;
        private final String d_old;
        private final String d_replacement;

        public SetParticleTask(SprkRecord owner, String repl) {
            this.d_owner = owner;
            this.d_old = owner.getPartID();
            this.d_replacement = repl;
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public int getEst() {
            return 0;
        }

        @Override
        public void undo() {
            this.d_owner.setPartID(this.d_old);
        }

        @Override
        public void run() {
            this.d_owner.setPartID(this.d_replacement);
        }
    }
}

