/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AFDSFaceProps;
import pyrosim.legacy_2006_2.domain.AbstractFDSObject;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.BlockFragGenerator;
import pyrosim.legacy_2006_2.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.geom.Triangle;
import pyrosim.legacy_2006_2.geom.Util;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.ATask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class Slab
extends AbstractFDSObject {
    static final long serialVersionUID = 1L;
    public static final int NUM_FACES = 5;
    private static final String[] FDS_FACE_NAMES = new String[]{"Min X", "Max X", "Min Y", "Max Y", "Min Z", "Max Z"};
    private static final int FACE_POINTS = 0;
    private static final int FACE_POINTS_EXTRUDED = 1;
    private static final int FACE_P1_P2 = 2;
    private static final int FACE_P2_P3 = 3;
    private static final int FACE_P3_P1 = 4;
    private transient boolean d_selected;
    private boolean d_thicken = false;
    private boolean d_permitHole = true;
    private boolean d_sawtooth = false;
    private UnitDouble d_thickness;
    private UnitPoint3D d_pt1;
    private UnitPoint3D d_pt2;
    private UnitPoint3D d_pt3;

    public Slab(Material mat) {
        this(new UnitPoint3D(0.0, 0.0, 0.0, (Unit)SI.METER), new UnitPoint3D(1.0, 0.0, 0.0, (Unit)SI.METER), new UnitPoint3D(0.0, 1.0, 0.0, (Unit)SI.METER), mat);
    }

    public Slab(UnitPoint3D p1, UnitPoint3D p2, UnitPoint3D p3, Material mat) {
        this(p1, p2, p3, new UnitDouble(0.2, (Unit)SI.METER), mat);
    }

    public Slab(UnitPoint3D p1, UnitPoint3D p2, UnitPoint3D p3, UnitDouble thick, Material mat) {
        this.d_faces = new Vector(5);
        for (int m = 0; m < 5; ++m) {
            this.d_faces.add(new SlabFace(this, m));
        }
        this.setPoints(p1, p2, p3);
        this.setThickness(thick);
        this.setMaterial(mat);
    }

    public void setIsSawtoothed(boolean d_sawtooth) {
        this.d_sawtooth = d_sawtooth;
        this.changed();
    }

    public void setIsThickened(boolean d_thicken) {
        this.d_thicken = d_thicken;
        this.changed();
    }

    public void setPermitsHole(boolean hole) {
        this.d_permitHole = hole;
        this.changed();
    }

    public void setPoints(UnitPoint3D p1, UnitPoint3D p2, UnitPoint3D p3) {
        this.d_pt1 = p1;
        this.d_pt2 = p2;
        this.d_pt3 = p3;
        this.changed();
    }

    public void setPoint(int index, UnitPoint3D point) {
        switch (index) {
            case 0: {
                this.d_pt1 = point;
                break;
            }
            case 1: {
                this.d_pt2 = point;
                break;
            }
            case 2: {
                this.d_pt3 = point;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.changed();
    }

    public void setThickness(UnitDouble thick) {
        this.d_thickness = thick;
        this.changed();
    }

    @Override
    protected void imprint(Object baseObject) {
        if (!(baseObject instanceof Slab)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(baseObject);
        Slab slab = (Slab)baseObject;
        Iterator<IFace> fIter = this.getFaceIterator();
        while (fIter.hasNext()) {
            ((SlabFace)fIter.next()).d_slab = this;
        }
        this.d_thickness = (UnitDouble)slab.d_thickness.clone();
        this.d_pt1 = (UnitPoint3D)slab.d_pt1.clone();
        this.d_pt2 = (UnitPoint3D)slab.d_pt2.clone();
        this.d_pt3 = (UnitPoint3D)slab.d_pt3.clone();
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    protected void fillExtraRecords(FDSInputRecord rec) {
        rec.setValue("PERMIT_HOLE", this.d_permitHole);
        rec.setValue("SAWTOOTH", this.d_sawtooth);
        rec.setValue("THICKEN", this.d_thicken);
    }

    @Override
    public String getFDSType() {
        return "OBST";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
    }

    @Override
    public int getNumFaces() {
        return 5;
    }

    @Override
    public String getTypeDescription() {
        return "Slab";
    }

    public UnitPoint3D[] getPoints() {
        UnitPoint3D[] up3D = new UnitPoint3D[]{this.d_pt1, this.d_pt2, this.d_pt3};
        return up3D;
    }

    public UnitDouble getThickness() {
        return this.d_thickness;
    }

    public boolean isSawtoothed() {
        return this.d_sawtooth;
    }

    public boolean isThickened() {
        return this.d_thicken;
    }

    public boolean permitsHole() {
        return this.d_permitHole;
    }

    @Override
    public boolean isRasterizable() {
        return true;
    }

    @Override
    public boolean isSolid() {
        return true;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }

    @Override
    public void setMaterial(int faceIndex, Material mat) {
        if (faceIndex < this.getNumFaces()) {
            for (IFace face : this.d_faces) {
                face.setMaterial(mat);
            }
            this.changed();
        }
    }

    @Override
    public Material getMaterial(int faceIndex) {
        if (faceIndex < this.getNumFaces()) {
            return ((IFace)this.d_faces.get(faceIndex)).getMaterial();
        }
        return null;
    }

    @Override
    protected Task taskSaveGeometry() {
        return new SaveGeomTask(0);
    }

    @Override
    protected void rotate(UnitPoint3D base, Vector3d rotAxis, UnitDouble amount) {
        Unit lu = Geometry.GEOM_LENGTH_UNIT;
        Point3d base3d = base.getPoint3dValue(lu);
        Matrix3d rot = Slab.getRotateMat(rotAxis, amount);
        Point3d p1 = this.d_pt1.getPoint3dValue(lu);
        Point3d p2 = this.d_pt2.getPoint3dValue(lu);
        Point3d p3 = this.d_pt3.getPoint3dValue(lu);
        Slab.rotatePoint(p1, base3d, rot);
        Slab.rotatePoint(p2, base3d, rot);
        Slab.rotatePoint(p3, base3d, rot);
        this.setPoints(new UnitPoint3D(p1, lu), new UnitPoint3D(p2, lu), new UnitPoint3D(p3, lu));
    }

    @Override
    protected void mirror(int internalPlane, UnitDouble value) {
    }

    @Override
    protected void scale(UnitPoint3D base, Tuple3d scale) {
        assert (scale.x >= 0.0 && scale.y >= 0.0 && scale.z >= 0.0);
        Unit lu = Geometry.GEOM_LENGTH_UNIT;
        Point3d base3d = base.getPoint3dValue(lu);
        Point3d p1 = this.d_pt1.getPoint3dValue(lu);
        Point3d p2 = this.d_pt2.getPoint3dValue(lu);
        Point3d p3 = this.d_pt3.getPoint3dValue(lu);
        double thickness = this.d_thickness.getValue(lu);
        Slab.scalePoint(p1, base3d, scale);
        Slab.scalePoint(p2, base3d, scale);
        Slab.scalePoint(p3, base3d, scale);
        thickness = this.scaleThickness(thickness, base3d, scale, p1, p2, p3);
        ADomainObject.pauseUpdates(this, false);
        this.setPoints(new UnitPoint3D(p1, lu), new UnitPoint3D(p2, lu), new UnitPoint3D(p3, lu));
        this.setThickness(new UnitDouble(thickness, lu));
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    private double scaleThickness(double thickness, Point3d base, Tuple3d scale, Point3d ... points) {
        Vector3d extrusionVec = Slab.getExtrusionVec(thickness, points);
        Slab.scaleVector(extrusionVec, base, scale);
        if (thickness < 0.0) {
            return -extrusionVec.length();
        }
        return extrusionVec.length();
    }

    @Override
    protected void translate(UnitPoint3D delta) {
        this.d_pt1.add(delta);
        this.d_pt2.add(delta);
        this.d_pt3.add(delta);
        this.changed();
    }

    private void changed() {
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    private static Vector3d getExtrusionVec(double thickness, Point3d ... points) {
        Vector3d extrusionVec = Slab.getNormal(points);
        extrusionVec.scale(-thickness);
        return extrusionVec;
    }

    private static Vector3d getNormal(Point3d ... points) {
        assert (points.length >= 3);
        Vector3d normal = new Vector3d();
        Vector3d v1 = new Vector3d();
        v1.sub(points[1], points[0]);
        Vector3d v2 = new Vector3d();
        v2.sub(points[2], points[0]);
        normal.cross(v1, v2);
        normal.normalize();
        return normal;
    }

    private static class SlabFace
    implements IFace,
    Serializable {
        static final long serialVersionUID = 1L;
        public Slab d_slab;
        public final int d_faceIndex;
        private Material d_material;

        public SlabFace(Slab slab, int faceIndex) {
            this.d_slab = slab;
            this.d_faceIndex = faceIndex;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public String getName() {
            return FDS_FACE_NAMES[this.d_faceIndex];
        }

        @Override
        public Material getMaterial() {
            return this.d_material;
        }

        @Override
        public void setMaterial(Material m) {
            this.d_material = m;
        }

        @Override
        public void getGeometry(Geometry g) {
            Point3d[] verts = this.getGeomVerts();
            PrimProps props = new PrimProps(this.getMaterial(), this.d_slab.getColor());
            if (verts.length == 3) {
                g.addTriangle(new Triangle(verts, props));
            } else {
                g.addQuad(new Quad(verts, props));
            }
        }

        private Point3d[] getGeomVerts() {
            Point3d[] verts;
            Unit u = Geometry.GEOM_LENGTH_UNIT;
            double thickness = this.d_slab.d_thickness.getValue(u);
            Point3d[] points = Util.convertArray(u, this.d_slab.d_pt1, this.d_slab.d_pt2, this.d_slab.d_pt3);
            if (thickness < 0.0) {
                thickness = -thickness;
                points = new Point3d[]{points[2], points[1], points[0]};
            }
            switch (this.d_faceIndex) {
                case 0: {
                    verts = new Point3d[]{points[0], points[1], points[2]};
                    break;
                }
                case 1: {
                    Vector3d extrusionVec = Slab.getExtrusionVec(thickness, points);
                    verts = new Point3d[3];
                    verts[0] = points[2];
                    verts[0].add(extrusionVec);
                    verts[1] = points[1];
                    verts[1].add(extrusionVec);
                    verts[2] = points[0];
                    verts[2].add(extrusionVec);
                    break;
                }
                case 2: {
                    Vector3d extrusionVec = Slab.getExtrusionVec(thickness, points);
                    verts = new Point3d[4];
                    verts[0] = points[0];
                    verts[1] = new Point3d(points[0]);
                    verts[1].add(extrusionVec);
                    verts[2] = new Point3d(points[1]);
                    verts[2].add(extrusionVec);
                    verts[3] = points[1];
                    break;
                }
                case 3: {
                    Vector3d extrusionVec = Slab.getExtrusionVec(thickness, points);
                    verts = new Point3d[4];
                    verts[0] = points[1];
                    verts[1] = new Point3d(points[1]);
                    verts[1].add(extrusionVec);
                    verts[2] = new Point3d(points[2]);
                    verts[2].add(extrusionVec);
                    verts[3] = points[2];
                    break;
                }
                case 4: {
                    Vector3d extrusionVec = Slab.getExtrusionVec(thickness, points);
                    verts = new Point3d[4];
                    verts[0] = points[2];
                    verts[1] = new Point3d(points[2]);
                    verts[1].add(extrusionVec);
                    verts[2] = new Point3d(points[0]);
                    verts[2].add(extrusionVec);
                    verts[3] = points[0];
                    break;
                }
                default: {
                    verts = null;
                    assert (false);
                    break;
                }
            }
            return verts;
        }

        @Override
        public Iterator getVentIterator() {
            return null;
        }

        @Override
        public boolean isSelected() {
            return this.d_slab.isSelected();
        }

        @Override
        public void setSelected(boolean selected) {
            this.d_slab.setSelected(selected);
        }

        @Override
        public FDSObject getAttachedObj() {
            return this.d_slab;
        }

        @Override
        public UnitPoint3D[] getVerts() {
            return Util.convertArray(Geometry.GEOM_LENGTH_UNIT, this.getGeomVerts());
        }

        @Override
        public IFDSFragGenerator getFDSFragGenerator() {
            return new BlockFragGenerator(new AFDSFaceProps(this){

                @Override
                public boolean isThickened() {
                    return d_slab.isThickened();
                }

                @Override
                public boolean permitsHoles() {
                    return d_slab.permitsHole();
                }

                @Override
                public boolean isSawtoothed() {
                    return d_slab.isSawtoothed();
                }
            }, FDSRasterization.getCellPriority(false, true, this.d_slab.permitsHole()));
        }
    }

    private class SaveGeomTask
    extends ATask {
        private UnitDouble d_thickness;
        private UnitPoint3D d_pt1;
        private UnitPoint3D d_pt2;
        private UnitPoint3D d_pt3;

        public SaveGeomTask(int est) {
            super(est, true);
        }

        @Override
        public void undo() {
            ADomainObject.pauseUpdates(Slab.this, false);
            Slab.this.setThickness(this.d_thickness);
            Slab.this.setPoints(this.d_pt1, this.d_pt2, this.d_pt3);
            ADomainObject.resumeUpdates(Slab.this, new FDSObjectDomainEvent(Slab.this, 5));
        }

        @Override
        public void run() {
            this.d_thickness = (UnitDouble)Slab.this.d_thickness.clone();
            this.d_pt1 = (UnitPoint3D)Slab.this.d_pt1.clone();
            this.d_pt2 = (UnitPoint3D)Slab.this.d_pt2.clone();
            this.d_pt3 = (UnitPoint3D)Slab.this.d_pt3.clone();
        }
    }
}

