/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import pyrosim.legacy_2006_2.domain.Material;

public class MaterialProfile
implements Cloneable {
    private Vector<Prop> d_allProfileProps = new Vector();
    private Hashtable<String, Prop> d_allProfilePropsFast = new Hashtable();
    private Hashtable<String, List> d_profileLists = new Hashtable();
    private Hashtable<String, Prop> d_profileProps = new Hashtable();
    private Vector<MaterialProfile> d_profileGroups = new Vector();
    private Hashtable<String, Object> d_impliedProps = new Hashtable();
    private String d_name;
    private String d_desc;
    private static final MaterialProfile d_defaultProfile = new MaterialProfile("Default Material Profile");
    public static final String DEF_PROFILE_NAME = "Default Material Profile";

    public MaterialProfile(String name) {
        this(name, name);
    }

    public MaterialProfile(String name, String desc) {
        this.d_name = name;
        this.d_desc = desc;
    }

    public String getName() {
        return this.d_name;
    }

    public String getDesc() {
        return this.d_desc;
    }

    public void addImpliedProp(String propName, Object propValue) {
        if (this.d_impliedProps.get(propName) != null) {
            this.d_impliedProps.remove(propName);
        }
        this.d_impliedProps.put(propName, propValue);
    }

    public Map<String, Object> getImpliedProps() {
        return this.d_impliedProps;
    }

    public void addRequiredMatProp(Prop prop) {
        if (this.d_allProfilePropsFast.get(prop.getName()) == null) {
            this.d_allProfileProps.add(prop);
            this.d_allProfilePropsFast.put(prop.getName(), prop);
            if (prop instanceof List) {
                this.d_profileLists.put(prop.getName(), (List)prop);
            } else {
                this.d_profileProps.put(prop.getName(), prop);
            }
        }
    }

    public void addProfileProps(MaterialProfile profile2) {
        int m;
        for (m = 0; m < profile2.getRequiredPropCount(); ++m) {
            Prop prop = profile2.getRequiredPropAt(m);
            this.addRequiredMatProp(prop);
        }
        for (m = 0; m < profile2.getProfileGroupCount(); ++m) {
            MaterialProfile group = profile2.getProfileGroupAt(m);
            this.addProfileGroup(group);
        }
        for (String key : profile2.d_impliedProps.keySet()) {
            Object prop = profile2.d_impliedProps.get(key);
            this.addImpliedProp(key, prop);
        }
    }

    public void removeProfilePropAt(int index) {
        if (index >= 0 && index < this.d_allProfileProps.size()) {
            String name = this.d_allProfileProps.get(index).getName();
            this.d_allProfileProps.remove(index);
            this.d_allProfilePropsFast.remove(name);
            this.d_profileLists.remove(name);
            this.d_profileProps.remove(name);
        }
    }

    public void removeProfilePropNamed(String name) {
        int index = this.indexOfPropName(name);
        if (index >= 0) {
            this.d_allProfileProps.remove(index);
            this.d_allProfilePropsFast.remove(name);
            this.d_profileLists.remove(name);
            this.d_profileProps.remove(name);
        }
    }

    public int indexOfPropName(String propName) {
        if (this.d_allProfilePropsFast.get(propName) == null) {
            return -1;
        }
        for (int m = 0; m < this.d_allProfileProps.size(); ++m) {
            if (!this.d_allProfileProps.get(m).getName().equals(propName)) continue;
            return m;
        }
        return -1;
    }

    public boolean containsPropNamed(String propName) {
        return this.d_allProfilePropsFast.get(propName) != null;
    }

    public Prop getRequiredPropNamed(String propName) {
        return this.d_allProfilePropsFast.get(propName);
    }

    public Prop getRequiredPropAt(int index) {
        if (index >= 0 && index < this.d_allProfileProps.size()) {
            return this.d_allProfileProps.get(index);
        }
        return null;
    }

    public int getRequiredPropCount() {
        return this.d_allProfileProps.size();
    }

    public Map<String, List> getOnlyLists() {
        return this.d_profileLists;
    }

    public Map<String, Prop> getOnlyProps() {
        return this.d_profileProps;
    }

    public void addProfileGroup(MaterialProfile profile) {
        if (!this.d_profileGroups.contains(profile)) {
            this.d_profileGroups.add(profile);
        }
    }

    public void removeProfileGroupAt(int index) {
        if (index >= 0 && index < this.d_profileGroups.size()) {
            this.d_profileGroups.remove(index);
        }
    }

    public MaterialProfile getProfileGroupAt(int index) {
        if (index >= 0 && index < this.d_profileGroups.size()) {
            return this.d_profileGroups.get(index);
        }
        return null;
    }

    public java.util.List<MaterialProfile> getGroups() {
        return this.d_profileGroups;
    }

    public int getProfileGroupCount() {
        return this.d_profileGroups.size();
    }

    public ProfilePath buildBestPathForMat(Material material) {
        ProfMatMatch match = new ProfMatMatch();
        return this.buildBestPathForMat(material, match);
    }

    public ProfilePath buildBestPathForMat(Material material, ProfMatMatch match) {
        ProfilePath path = new ProfilePath(this.d_name);
        String[] keys = material.getUsedKeys();
        for (int m = 0; m < keys.length; ++m) {
            Object val;
            Prop propMatch = this.d_profileProps.get(keys[m]);
            if (propMatch != null) {
                ++match.d_maxNumPropsUsedInMaterial;
                continue;
            }
            List listMatch = this.d_profileLists.get(keys[m]);
            if (listMatch == null || !((val = material.getValue(keys[m])) instanceof String) || !listMatch.containsProfileNamed((String)val)) continue;
            ++match.d_maxNumPropsUsedInMaterial;
        }
        match.d_maxNumPropsUsedInMaterial += this.getNumMatchingImpliedProps(material);
        match.d_numPropsInMaxPath += this.d_impliedProps.size();
        match.d_numPropsInMaxPath += this.d_profileProps.size();
        for (int n = 0; n < this.d_profileGroups.size(); ++n) {
            MaterialProfile p = this.d_profileGroups.get(n);
            ProfilePath groupPath = p.buildBestPathForMat(material, match);
            path.addGroupPath(p.getName(), groupPath);
        }
        Set<String> valueNames = Material.getValueNames();
        for (List list : this.d_profileLists.values()) {
            Object matsListValue = null;
            boolean useDefaultListProfile = false;
            if (valueNames.contains(list.getName())) {
                ++match.d_numPropsInMaxPath;
                matsListValue = material.getValue(list.getName());
                if (matsListValue == null) {
                    useDefaultListProfile = true;
                }
            }
            ProfilePath bestMatchingPath = null;
            int numMatchingImpliedForBestMatch = 0;
            ProfMatMatch bestMatchInList = null;
            for (int n = 0; n < list.getProfileCount(); ++n) {
                MaterialProfile profile = list.getProfile(n);
                if (matsListValue == null || matsListValue != null && profile.getName().equals(matsListValue)) {
                    int numImpliedMatching = profile.getNumMatchingImpliedProps(material);
                    ProfMatMatch subIndex = new ProfMatMatch();
                    ProfilePath profilePath = profile.buildBestPathForMat(material, subIndex);
                    if (bestMatchInList == null || subIndex.d_maxNumPropsUsedInMaterial > bestMatchInList.d_maxNumPropsUsedInMaterial) {
                        bestMatchingPath = profilePath;
                        bestMatchInList = subIndex;
                        numMatchingImpliedForBestMatch = numImpliedMatching;
                    } else if (subIndex.d_maxNumPropsUsedInMaterial == bestMatchInList.d_maxNumPropsUsedInMaterial) {
                        double bestMatchVal;
                        double subIndexVal = subIndex.getIndex();
                        if (subIndexVal > (bestMatchVal = bestMatchInList.getIndex())) {
                            bestMatchingPath = profilePath;
                            bestMatchInList = subIndex;
                            numMatchingImpliedForBestMatch = numImpliedMatching;
                        } else if (subIndexVal == bestMatchVal && numImpliedMatching > numMatchingImpliedForBestMatch) {
                            bestMatchingPath = profilePath;
                            bestMatchInList = subIndex;
                            numMatchingImpliedForBestMatch = numImpliedMatching;
                        }
                    }
                }
                if (n == 0 && useDefaultListProfile) break;
            }
            if (bestMatchingPath == null) continue;
            path.addPath(list.getName(), bestMatchingPath);
            match.addMatchIndex(bestMatchInList);
        }
        return path;
    }

    public int getNumMatchingImpliedProps(Material material) {
        int numMatching = 0;
        String[] keys = material.getUsedKeys();
        for (int m = 0; m < keys.length; ++m) {
            Object impliedMatch = this.d_impliedProps.get(keys[m]);
            if (impliedMatch == null || !impliedMatch.equals(material.getValue(keys[m]))) continue;
            ++numMatching;
        }
        return numMatching;
    }

    public Object clone() {
        MaterialProfile p = new MaterialProfile(this.d_name, this.d_desc);
        for (int m = 0; m < this.d_allProfileProps.size(); ++m) {
            p.addRequiredMatProp(this.d_allProfileProps.get(m));
        }
        p.d_profileGroups = (Vector)this.d_profileGroups.clone();
        p.d_impliedProps = (Hashtable)this.d_impliedProps.clone();
        return p;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MaterialProfile)) {
            return false;
        }
        MaterialProfile profile2 = (MaterialProfile)obj;
        return profile2.d_name.equals(this.d_name);
    }

    public static MaterialProfile getDefaultProfile() {
        return d_defaultProfile;
    }

    private static List getBuiltinProfiles() {
        List list = new List("Surface Type");
        new Prop("ADIABATIC", "Adiabatic");
        Prop ALPHA = new Prop("ALPHA", "Diffusivity");
        Prop A = new Prop("A", "Pre-exponential Factor");
        Prop BACKING = new Prop("BACKING", "Backing");
        Prop BURN_AWAY = new Prop("BURN_AWAY", "Allow Surface to Burn Away");
        Prop BURNING_RATE_MAX = new Prop("BURNING_RATE_MAX", "Maximum Burning Rate");
        Prop C_DELTA_RHO = new Prop("C_DELTA_RHO", "C*Delta*Rho");
        Prop C_P = new Prop("C_P", "Specific Heat");
        Prop C_P_CHAR = new Prop("C_P_CHAR", "Specific Heat of Char");
        Prop CHAR_DENSITY = new Prop("CHAR_DENSITY", "Char Density");
        Prop DELTA = new Prop("DELTA", "Wall Thickness");
        Prop DENSITY = new Prop("DENSITY", "Density");
        Prop DX_SOLID = new Prop("DX_SOLID", "First Cell Thickness");
        Prop E = new Prop("E", "Activation Energy");
        Prop E_COEFFICIENT = new Prop("E_COEFFICIENT", "Extinguishing Coefficient");
        Prop EMISSIVITY = new Prop("EMISSIVITY", "Emissivity");
        Prop FUEL_FRACTION = new Prop("FUEL_FRACTION", "Fuel Fraction");
        Prop HEAT_FLUX = new Prop("HEAT_FLUX", "Heat Flux");
        Prop HEAT_OF_COMBUSTION = new Prop("HEAT_OF_COMBUSTION", "Heat of Combustion");
        Prop HEAT_OF_VAPORIZATION = new Prop("HEAT_OF_VAPORIZATION", "Heat of Vaporization");
        Prop HRRPUA = new Prop("HRRPUA", "Heat Release Rate (HRR)");
        Prop KS = new Prop("KS", "Thermal Conductivity");
        Prop KS_CHAR = new Prop("KS_CHAR", "Thermal Conductivity of Char");
        new Prop("LEAKING", "Leaking");
        Prop MASS_FLUX_CRITICAL = new Prop("MASS_FLUX_CRITICAL", "Mass Flux at Ignition Temperature");
        Prop MOISTURE_FRACTION = new Prop("MOISTURE_FRACTION", "Water Content by Mass");
        Prop NPPC = new Prop("NPPC", "Number of Particles Per Cell");
        Prop PARTICLES = new Prop("PARTICLES", "Emit the Default Particle");
        Prop PART_ID = new Prop("PART_ID", "Emit a Custom Particle");
        new Prop("PHASE", "Phase");
        Prop PLE = new Prop("PLE", "Atmospheric Profile Exponent");
        Prop POROSITY = new Prop("POROSITY", "Porosity Fraction");
        new Prop("PROFILE", "Velocity Profile");
        Prop RAMP_C_P = new Prop("RAMP_C_P", "Apply Ramp to Specific Heat");
        Prop RAMP_C_P_CHAR = new Prop("RAMP_C_P_CHAR", "Apply Ramp to Specific Heat of Char");
        Prop RAMP_KS = new Prop("RAMP_KS", "Apply Ramp to Thermal Conductivity");
        Prop RAMP_KS_CHAR = new Prop("RAMP_KS_CHAR", "Apply Ramp to Thermal Conductivity of Char");
        Prop RAMP_Q = new Prop("RAMP_Q", "Apply Ramp to Heat Release Rate");
        Prop RAMP_V = new Prop("RAMP_V", "Apply Ramp to Velocity");
        Prop SURFACE_DENSITY = new Prop("SURFACE_DENSITY", "Surface Density");
        Prop TAU_Q = new Prop("TAU_Q", "HRR Ramp-up Time");
        Prop TAU_V = new Prop("TAU_V", "Velocity Ramp-up Time");
        Prop TMPIGN = new Prop("TMPIGN", "Ignition Temperature");
        Prop TMPWAL = new Prop("TMPWAL", "Surface Temperature");
        Prop TMPWAL0 = new Prop("TMPWAL0", "Initial Surface Temperature");
        Prop VBC = new Prop("VBC", "Velocity Slip Index");
        Prop VEL = new Prop("VEL", "Normal Velocity");
        Prop VEL_T = new Prop("VEL_T", "Tangential Velocity");
        Prop VOLUME_FLUX = new Prop("VOLUME_FLUX", "Volume Flux");
        Prop WALL_POINTS = new Prop("WALL_POINTS", "Internal Wall Points");
        Prop Z0 = new Prop("Z0", "Atmospheric Profile Origin");
        MaterialProfile bcFixedTemp = new MaterialProfile("Fixed Temperature");
        bcFixedTemp.addRequiredMatProp(TMPWAL);
        MaterialProfile bcFixedHeatFlux = new MaterialProfile("Fixed Heat Flux");
        bcFixedHeatFlux.addRequiredMatProp(HEAT_FLUX);
        MaterialProfile bcThermallyThickNoBurn = new MaterialProfile("Thermally Thick");
        bcThermallyThickNoBurn.addRequiredMatProp(TMPWAL0);
        bcThermallyThickNoBurn.addRequiredMatProp(KS);
        bcThermallyThickNoBurn.addRequiredMatProp(RAMP_KS);
        bcThermallyThickNoBurn.addRequiredMatProp(C_P);
        bcThermallyThickNoBurn.addRequiredMatProp(RAMP_C_P);
        bcThermallyThickNoBurn.addRequiredMatProp(DELTA);
        bcThermallyThickNoBurn.addRequiredMatProp(DENSITY);
        bcThermallyThickNoBurn.addRequiredMatProp(SURFACE_DENSITY);
        bcThermallyThickNoBurn.addRequiredMatProp(ALPHA);
        bcThermallyThickNoBurn.addRequiredMatProp(WALL_POINTS);
        bcThermallyThickNoBurn.addRequiredMatProp(DX_SOLID);
        MaterialProfile bcThermallyThickBurn = new MaterialProfile("Thermally Thick");
        bcThermallyThickBurn.addProfileProps(bcThermallyThickNoBurn);
        bcThermallyThickBurn.addRequiredMatProp(BURN_AWAY);
        MaterialProfile bcThermallyThickBurnIgnite = new MaterialProfile("Thermally Thick");
        bcThermallyThickBurnIgnite.addProfileProps(bcThermallyThickBurn);
        bcThermallyThickBurnIgnite.addRequiredMatProp(TMPIGN);
        MaterialProfile bcThermallyThickBurnChar = new MaterialProfile("Thermally Thick");
        bcThermallyThickBurnChar.addRequiredMatProp(KS_CHAR);
        bcThermallyThickBurnChar.addRequiredMatProp(RAMP_KS_CHAR);
        bcThermallyThickBurnChar.addRequiredMatProp(C_P_CHAR);
        bcThermallyThickBurnChar.addRequiredMatProp(RAMP_C_P_CHAR);
        bcThermallyThickBurnChar.addRequiredMatProp(CHAR_DENSITY);
        bcThermallyThickBurnChar.addRequiredMatProp(WALL_POINTS);
        bcThermallyThickBurnChar.addRequiredMatProp(DX_SOLID);
        bcThermallyThickBurnChar.addRequiredMatProp(BURN_AWAY);
        MaterialProfile bcThermallyThinNoBurn = new MaterialProfile("Thermally Thin");
        bcThermallyThinNoBurn.addRequiredMatProp(TMPWAL0);
        bcThermallyThinNoBurn.addRequiredMatProp(C_DELTA_RHO);
        bcThermallyThinNoBurn.addRequiredMatProp(C_P);
        bcThermallyThinNoBurn.addRequiredMatProp(RAMP_C_P);
        bcThermallyThinNoBurn.addRequiredMatProp(DELTA);
        bcThermallyThinNoBurn.addRequiredMatProp(DENSITY);
        bcThermallyThinNoBurn.addRequiredMatProp(SURFACE_DENSITY);
        MaterialProfile bcThermallyThinBurn = new MaterialProfile("Thermally Thin");
        bcThermallyThinBurn.addProfileProps(bcThermallyThinNoBurn);
        bcThermallyThinBurn.addRequiredMatProp(BURN_AWAY);
        MaterialProfile bcThermallyThinBurnIgnite = new MaterialProfile("Thermally Thin");
        bcThermallyThinBurnIgnite.addProfileProps(bcThermallyThinBurn);
        bcThermallyThinBurnIgnite.addRequiredMatProp(TMPIGN);
        MaterialProfile particles = new MaterialProfile("Particles");
        particles.addRequiredMatProp(NPPC);
        particles.addRequiredMatProp(PARTICLES);
        particles.addRequiredMatProp(PART_ID);
        MaterialProfile gasFire = new MaterialProfile("Burner Fire");
        gasFire.addRequiredMatProp(HRRPUA);
        gasFire.addRequiredMatProp(TAU_Q);
        gasFire.addRequiredMatProp(RAMP_Q);
        gasFire.addRequiredMatProp(HEAT_OF_COMBUSTION);
        gasFire.addRequiredMatProp(FUEL_FRACTION);
        gasFire.addRequiredMatProp(E_COEFFICIENT);
        gasFire.addRequiredMatProp(POROSITY);
        gasFire.addProfileGroup(particles);
        gasFire.addImpliedProp("PHASE", "SOLID");
        MaterialProfile flammableSolidConstantHeat = new MaterialProfile("Flammable Solid (Constant HRR)");
        flammableSolidConstantHeat.addRequiredMatProp(HRRPUA);
        flammableSolidConstantHeat.addRequiredMatProp(TAU_Q);
        flammableSolidConstantHeat.addRequiredMatProp(RAMP_Q);
        flammableSolidConstantHeat.addRequiredMatProp(HEAT_OF_COMBUSTION);
        flammableSolidConstantHeat.addRequiredMatProp(FUEL_FRACTION);
        flammableSolidConstantHeat.addRequiredMatProp(E_COEFFICIENT);
        flammableSolidConstantHeat.addRequiredMatProp(POROSITY);
        MaterialProfile fschBoundaryGroup = new MaterialProfile("Boundary Conditions");
        List bcFSCH = new List("Boundary Type");
        bcFSCH.addMaterialProfile(bcFixedTemp);
        bcFSCH.addMaterialProfile(bcFixedHeatFlux);
        bcFSCH.addMaterialProfile(bcThermallyThickBurnIgnite);
        bcFSCH.addMaterialProfile(bcThermallyThinBurnIgnite);
        fschBoundaryGroup.addRequiredMatProp(bcFSCH);
        flammableSolidConstantHeat.addProfileGroup(fschBoundaryGroup);
        flammableSolidConstantHeat.addProfileGroup(particles);
        flammableSolidConstantHeat.addImpliedProp("PHASE", "SOLID");
        MaterialProfile flammableSolidVolatileHeat = new MaterialProfile("Flammable Solid");
        flammableSolidVolatileHeat.addRequiredMatProp(HEAT_OF_VAPORIZATION);
        flammableSolidVolatileHeat.addRequiredMatProp(HEAT_OF_COMBUSTION);
        flammableSolidVolatileHeat.addRequiredMatProp(BURNING_RATE_MAX);
        flammableSolidVolatileHeat.addRequiredMatProp(FUEL_FRACTION);
        flammableSolidVolatileHeat.addRequiredMatProp(EMISSIVITY);
        flammableSolidVolatileHeat.addRequiredMatProp(BACKING);
        MaterialProfile fsvhBoundaryGroup = new MaterialProfile("Boundary Conditions");
        List bcFSVH = new List("Boundary Type");
        MaterialProfile bcFixedTempRampableFSVH = new MaterialProfile("Fixed Temperature");
        bcFixedTempRampableFSVH.addProfileProps(bcFixedTemp);
        bcFixedTempRampableFSVH.addRequiredMatProp(new Prop("TAU_Q", "Temperature Ramp-up Time"));
        bcFixedTempRampableFSVH.addRequiredMatProp(new Prop("RAMP_Q", "Apply Ramp to Surface Temperature"));
        bcFSVH.addMaterialProfile(bcFixedTempRampableFSVH);
        bcFSVH.addMaterialProfile(bcFixedHeatFlux);
        bcFSVH.addMaterialProfile(bcThermallyThickBurnIgnite);
        bcFSVH.addMaterialProfile(bcThermallyThinBurnIgnite);
        fsvhBoundaryGroup.addRequiredMatProp(bcFSVH);
        flammableSolidVolatileHeat.addProfileGroup(fsvhBoundaryGroup);
        flammableSolidVolatileHeat.addProfileGroup(particles);
        flammableSolidVolatileHeat.addImpliedProp("PHASE", "SOLID");
        MaterialProfile nonFlammableSolid = new MaterialProfile("Non-Flammable Solid");
        nonFlammableSolid.addRequiredMatProp(EMISSIVITY);
        nonFlammableSolid.addRequiredMatProp(BACKING);
        MaterialProfile nfsBoundaryGroup = new MaterialProfile("Boundary Conditions");
        List bcNFS = new List("Boundary Type");
        MaterialProfile bcFixedTempRampableNFS = new MaterialProfile("Fixed Temperature");
        bcFixedTempRampableNFS.addProfileProps(bcFixedTemp);
        bcFixedTempRampableNFS.addRequiredMatProp(new Prop("TAU_Q", "Temperature Ramp-up Time"));
        bcFixedTempRampableNFS.addRequiredMatProp(new Prop("RAMP_Q", "Apply Ramp to Surface Temperature"));
        bcNFS.addMaterialProfile(bcFixedTempRampableNFS);
        bcNFS.addMaterialProfile(bcFixedHeatFlux);
        bcNFS.addMaterialProfile(bcThermallyThickNoBurn);
        bcNFS.addMaterialProfile(bcThermallyThinNoBurn);
        nfsBoundaryGroup.addRequiredMatProp(bcNFS);
        nonFlammableSolid.addProfileGroup(nfsBoundaryGroup);
        nonFlammableSolid.addProfileGroup(particles);
        nonFlammableSolid.addImpliedProp("PHASE", "SOLID");
        MaterialProfile liquidFuel = new MaterialProfile("Liquid Fuel");
        liquidFuel.addRequiredMatProp(HEAT_OF_VAPORIZATION);
        liquidFuel.addRequiredMatProp(HEAT_OF_COMBUSTION);
        liquidFuel.addRequiredMatProp(BURNING_RATE_MAX);
        liquidFuel.addRequiredMatProp(FUEL_FRACTION);
        liquidFuel.addRequiredMatProp(EMISSIVITY);
        liquidFuel.addRequiredMatProp(BACKING);
        MaterialProfile lfBoundaryGroup = new MaterialProfile("Boundary Conditions");
        lfBoundaryGroup.addProfileProps(bcThermallyThickBurn);
        lfBoundaryGroup.addRequiredMatProp(new Prop("TMPIGN", "Boiling Temperature"));
        liquidFuel.addProfileGroup(lfBoundaryGroup);
        liquidFuel.addProfileGroup(particles);
        liquidFuel.addImpliedProp("PHASE", "LIQUID");
        MaterialProfile charringFuel = new MaterialProfile("Charring Fuel");
        charringFuel.addRequiredMatProp(HEAT_OF_VAPORIZATION);
        charringFuel.addRequiredMatProp(HEAT_OF_COMBUSTION);
        charringFuel.addRequiredMatProp(BURNING_RATE_MAX);
        charringFuel.addRequiredMatProp(FUEL_FRACTION);
        charringFuel.addRequiredMatProp(EMISSIVITY);
        charringFuel.addRequiredMatProp(BACKING);
        charringFuel.addRequiredMatProp(A);
        charringFuel.addRequiredMatProp(E);
        charringFuel.addRequiredMatProp(MASS_FLUX_CRITICAL);
        charringFuel.addRequiredMatProp(TMPIGN);
        MaterialProfile cfvBoundaryGroup = new MaterialProfile("Virgin Boundary Conditions");
        cfvBoundaryGroup.addRequiredMatProp(KS);
        cfvBoundaryGroup.addRequiredMatProp(RAMP_KS);
        cfvBoundaryGroup.addRequiredMatProp(C_P);
        cfvBoundaryGroup.addRequiredMatProp(RAMP_C_P);
        cfvBoundaryGroup.addRequiredMatProp(DELTA);
        cfvBoundaryGroup.addRequiredMatProp(DENSITY);
        cfvBoundaryGroup.addRequiredMatProp(SURFACE_DENSITY);
        cfvBoundaryGroup.addRequiredMatProp(ALPHA);
        cfvBoundaryGroup.addRequiredMatProp(MOISTURE_FRACTION);
        charringFuel.addProfileGroup(cfvBoundaryGroup);
        MaterialProfile cfcBoundaryGroup = new MaterialProfile("Char Boundary Conditions");
        cfcBoundaryGroup.addProfileProps(bcThermallyThickBurnChar);
        charringFuel.addProfileGroup(cfcBoundaryGroup);
        charringFuel.addProfileGroup(particles);
        charringFuel.addImpliedProp("PHASE", "CHAR");
        MaterialProfile liquidThermoplastic = new MaterialProfile("Liquid Thermoplastic");
        liquidThermoplastic.addRequiredMatProp(HEAT_OF_VAPORIZATION);
        liquidThermoplastic.addRequiredMatProp(HEAT_OF_COMBUSTION);
        liquidThermoplastic.addRequiredMatProp(BURNING_RATE_MAX);
        liquidThermoplastic.addRequiredMatProp(FUEL_FRACTION);
        liquidThermoplastic.addRequiredMatProp(EMISSIVITY);
        liquidThermoplastic.addRequiredMatProp(BACKING);
        liquidThermoplastic.addRequiredMatProp(A);
        liquidThermoplastic.addRequiredMatProp(E);
        liquidThermoplastic.addRequiredMatProp(MASS_FLUX_CRITICAL);
        liquidThermoplastic.addRequiredMatProp(TMPIGN);
        MaterialProfile ltBoundaryGroup = new MaterialProfile("Boundary Conditions");
        List bcLT = new List("Boundary Type");
        bcLT.addMaterialProfile(bcThermallyThickBurn);
        bcLT.addMaterialProfile(bcThermallyThinBurn);
        ltBoundaryGroup.addRequiredMatProp(bcLT);
        liquidThermoplastic.addProfileGroup(ltBoundaryGroup);
        liquidThermoplastic.addProfileGroup(particles);
        liquidThermoplastic.addImpliedProp("PHASE", "LIQUID");
        MaterialProfile charringThermoplastic = new MaterialProfile("Charring Thermoplastic");
        charringThermoplastic.addProfileProps(liquidThermoplastic);
        charringThermoplastic.addImpliedProp("PHASE", "CHAR");
        MaterialProfile fanOrWind = new MaterialProfile("Fan/Wind");
        fanOrWind.addRequiredMatProp(new Prop("TMPWAL", "Air Temperature"));
        fanOrWind.addRequiredMatProp(new Prop("TAU_Q", "Temperature Ramp-up Time"));
        fanOrWind.addRequiredMatProp(new Prop("RAMP_Q", "Apply Ramp to Air Temperature"));
        MaterialProfile profileGroup = new MaterialProfile("Air Flow");
        profileGroup.addRequiredMatProp(VEL);
        profileGroup.addRequiredMatProp(VOLUME_FLUX);
        profileGroup.addRequiredMatProp(VEL_T);
        profileGroup.addRequiredMatProp(TAU_V);
        profileGroup.addRequiredMatProp(RAMP_V);
        profileGroup.addRequiredMatProp(VBC);
        List profileList = new List("PROFILE", "Wind Profile");
        MaterialProfile topHatProfile = new MaterialProfile("TOP_HAT", "Top Hat (Default)");
        MaterialProfile parabolicProfile = new MaterialProfile("PARABOLIC", "Parabolic");
        MaterialProfile atmosphericProfile = new MaterialProfile("ATMOSPHERIC", "Atmospheric");
        atmosphericProfile.addRequiredMatProp(PLE);
        atmosphericProfile.addRequiredMatProp(Z0);
        profileList.addMaterialProfile(topHatProfile);
        profileList.addMaterialProfile(parabolicProfile);
        profileList.addMaterialProfile(atmosphericProfile);
        profileGroup.addRequiredMatProp(profileList);
        fanOrWind.addProfileGroup(profileGroup);
        fanOrWind.addProfileGroup(particles);
        fanOrWind.addImpliedProp("PHASE", "SOLID");
        MaterialProfile adiabaticProf = new MaterialProfile("Adiabatic");
        adiabaticProf.addImpliedProp("ADIABATIC", Boolean.TRUE);
        adiabaticProf.addImpliedProp("PHASE", "SOLID");
        MaterialProfile nothing = new MaterialProfile("Inert");
        list.addMaterialProfile(nothing);
        list.addMaterialProfile(adiabaticProf);
        list.addMaterialProfile(gasFire);
        list.addMaterialProfile(fanOrWind);
        list.addMaterialProfile(flammableSolidVolatileHeat);
        list.addMaterialProfile(flammableSolidConstantHeat);
        list.addMaterialProfile(nonFlammableSolid);
        list.addMaterialProfile(liquidFuel);
        list.addMaterialProfile(charringFuel);
        list.addMaterialProfile(liquidThermoplastic);
        list.addMaterialProfile(charringThermoplastic);
        return list;
    }

    static {
        d_defaultProfile.addRequiredMatProp(MaterialProfile.getBuiltinProfiles());
    }

    public static interface GroupsChangedListener {
        public void groupsChanged(Collection var1);
    }

    public static class List
    extends Prop
    implements Cloneable {
        private Vector<MaterialProfile> d_list = new Vector();

        public List(String propListName) {
            super(propListName, propListName);
        }

        public List(String propListName, String propListDesc) {
            super(propListName, propListDesc);
        }

        public void addMaterialProfile(MaterialProfile profile) {
            this.d_list.add(profile);
        }

        public MaterialProfile getProfile(int index) {
            if (index >= 0 && index < this.d_list.size()) {
                return this.d_list.get(index);
            }
            return null;
        }

        public int getProfileCount() {
            return this.d_list.size();
        }

        public MaterialProfile getProfile(String name) {
            for (MaterialProfile profile : this.d_list) {
                if (!profile.getName().equals(name)) continue;
                return profile;
            }
            return null;
        }

        public boolean containsProfileNamed(String profileName) {
            return this.getProfile(profileName) != null;
        }

        @Override
        public Object clone() {
            List l = (List)super.clone();
            l.d_list = (Vector)this.d_list.clone();
            return l;
        }
    }

    public static class Prop {
        public String d_propName;
        public String d_propDesc;

        public Prop(String propName, String propDesc) {
            this.d_propName = propName;
            this.d_propDesc = propDesc;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Prop)) {
                return false;
            }
            Prop prop = (Prop)obj;
            return this.d_propName.equals(prop.d_propName);
        }

        public String getName() {
            return this.d_propName;
        }

        public String getDesc() {
            return this.d_propDesc;
        }

        public Object clone() {
            return new Prop(this.d_propName, this.d_propDesc);
        }
    }

    public static class ProfMatMatch {
        public int d_maxNumPropsUsedInMaterial = 0;
        public int d_numPropsInMaxPath = 0;

        public void addMatchIndex(ProfMatMatch i) {
            this.d_maxNumPropsUsedInMaterial += i.d_maxNumPropsUsedInMaterial;
            this.d_numPropsInMaxPath += i.d_numPropsInMaxPath;
        }

        public double getIndex() {
            if (this.d_maxNumPropsUsedInMaterial >= this.d_numPropsInMaxPath) {
                return 1.0;
            }
            if (this.d_numPropsInMaxPath == 0 || this.d_maxNumPropsUsedInMaterial == 0) {
                return 0.0;
            }
            return (double)this.d_maxNumPropsUsedInMaterial / (double)this.d_numPropsInMaxPath;
        }
    }

    public static class ProfilePath
    implements Serializable {
        static final long serialVersionUID = 3391078738835676198L;
        private String d_profileName;
        private Map<String, ProfilePath> d_listPaths = new Hashtable<String, ProfilePath>();
        private Map<String, ProfilePath> d_groupPaths = new Hashtable<String, ProfilePath>();

        public ProfilePath(String name) {
            this.d_profileName = name;
        }

        public void addPath(String listName, ProfilePath p) {
            this.d_listPaths.put(listName, p);
        }

        public void addGroupPath(String groupName, ProfilePath groupPath) {
            this.d_groupPaths.put(groupName, groupPath);
        }

        public String getProfileName() {
            return this.d_profileName;
        }

        public Map<String, ProfilePath> getListPaths() {
            return this.d_listPaths;
        }

        public Map<String, ProfilePath> getGroupPaths() {
            return this.d_groupPaths;
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String begin) {
            ProfilePath obj;
            String s = "::" + this.d_profileName + "::\n";
            for (String key : this.d_listPaths.keySet()) {
                obj = this.d_listPaths.get(key);
                s = s + begin + "List: " + key + "->" + obj.toString(begin + "  ") + "\n";
            }
            for (String key : this.d_groupPaths.keySet()) {
                obj = this.d_groupPaths.get(key);
                s = s + begin + "Group: " + obj.toString(begin + "  ") + "\n";
            }
            return s;
        }

        public void initMat(Material mat, Set<String> valueNamesSet) {
            MaterialProfile defProfile = MaterialProfile.getDefaultProfile();
            this.conformMatRecursive(mat, defProfile, valueNamesSet);
            mat.setProfilePath(this);
        }

        private void conformMatRecursive(Material mat, MaterialProfile profile, Set<String> valueNamesSet) {
            if (!this.getProfileName().equals(profile.getName())) {
                System.out.println("Invalid profile name for Material " + mat.getName());
                return;
            }
            Iterator<String> impliedPropNameIt = profile.getImpliedProps().keySet().iterator();
            for (Object impliedProp : profile.getImpliedProps().values()) {
                String impliedPropName = impliedPropNameIt.next();
                this.setMatValue(mat, impliedPropName, impliedProp, valueNamesSet);
            }
            for (Prop prop : profile.getOnlyProps().values()) {
                Object defVal = Material.getDefaultValue(prop.getName());
                this.setMatValue(mat, prop.getName(), defVal, valueNamesSet);
            }
            for (MaterialProfile subGroup : profile.getGroups()) {
                ProfilePath subPath = this.d_groupPaths.get(subGroup.getName());
                if (subPath == null) continue;
                subPath.conformMatRecursive(mat, subGroup, valueNamesSet);
            }
            Set<String> valueNames = Material.getValueNames();
            Iterator<String> profileListNameIt = this.d_listPaths.keySet().iterator();
            for (ProfilePath listPath : this.d_listPaths.values()) {
                MaterialProfile listProfile;
                String listName = profileListNameIt.next();
                List list = profile.getOnlyLists().get(listName);
                if (list == null) {
                    System.out.println("Invalid profile list for Material " + mat.getName());
                    continue;
                }
                if (valueNames.contains(listName)) {
                    Object defVal = Material.getDefaultValue(listName);
                    this.setMatValue(mat, listName, defVal, valueNamesSet);
                }
                if ((listProfile = list.getProfile(listPath.getProfileName())) == null) {
                    System.out.println("Invalid profile for list for Material " + mat.getName());
                    continue;
                }
                listPath.conformMatRecursive(mat, listProfile, valueNamesSet);
            }
        }

        private void setMatValue(Material mat, String valueName, Object value, Set<String> valueNamesSet) {
            if (Material.isValueSetByDefault(valueName)) {
                mat.setValue(valueName, value);
            }
            valueNamesSet.add(valueName);
        }
    }
}

