/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Collection;
import java.util.Iterator;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class FDSObjectIterator
implements Iterator<FDSObject> {
    public static final FilteredStub OBJECT_FILTERED = new FilteredStub();
    private FDSComposite d_comp;
    private Iterator<? extends FDSObject> d_arrIterator;
    private Object d_current;
    private int d_currIndex;
    private int d_length;
    private FDSObject d_next;
    private boolean d_deep;
    private FDSObjectIterator d_recursiveNext;
    private ObjectFilter d_filter = new DefaultObjectFilter(this);

    public FDSObjectIterator(FDSComposite src, boolean deep) {
        this(src, deep, null);
    }

    public FDSObjectIterator(FDSComposite src, boolean deep, ObjectFilter filter) {
        this.d_comp = src;
        this.d_currIndex = 0;
        this.d_length = this.d_comp.size();
        this.d_deep = deep;
        if (filter != null) {
            this.d_filter = filter;
        }
        this.d_next = this.d_filter.prefetchNext();
    }

    public FDSObjectIterator(FDSObject[] src, boolean deep) {
        this(src, deep, null);
    }

    public FDSObjectIterator(FDSObject[] src, boolean deep, ObjectFilter filter) {
        this(new VectorFromArray<FDSObject>(src), deep, filter);
    }

    public FDSObjectIterator(Collection<? extends FDSObject> src, boolean deep) {
        this(src, deep, null);
    }

    public FDSObjectIterator(Collection<? extends FDSObject> src, boolean deep, ObjectFilter filter) {
        this.d_arrIterator = src.iterator();
        this.d_currIndex = 0;
        this.d_length = src.size();
        this.d_deep = deep;
        if (filter != null) {
            this.d_filter = filter;
        }
        this.d_next = this.d_filter.prefetchNext();
    }

    public void setFilter(ObjectFilter filter) {
        this.d_filter = filter;
        if (this.d_next != null && filter.filterObject(this.d_next) != this.d_next) {
            this.d_next = filter.prefetchNext();
        }
    }

    public ObjectFilter getFilter() {
        return this.d_filter;
    }

    @Override
    public boolean hasNext() {
        return this.d_next != null;
    }

    public Object next(ObjectFilter filter) {
        FDSObject curr = this.d_next;
        this.d_next = filter.prefetchNext();
        return curr;
    }

    @Override
    public FDSObject next() {
        FDSObject curr = this.d_next;
        this.d_next = this.d_filter.prefetchNext();
        return curr;
    }

    private FDSObject prefetchNext() {
        this.updateRecursion();
        if (this.d_recursiveNext != null) {
            return this.d_recursiveNext.next();
        }
        FDSObject next = this.getCurr();
        ++this.d_currIndex;
        return next;
    }

    private void updateRecursion() {
        if (this.d_recursiveNext != null && !this.d_recursiveNext.hasNext()) {
            this.d_recursiveNext = null;
            ++this.d_currIndex;
        }
        if (this.d_recursiveNext == null) {
            FDSObject curr;
            if (this.d_arrIterator != null && this.d_arrIterator.hasNext()) {
                this.d_current = this.d_arrIterator.next();
            }
            if ((curr = this.getCurr()) instanceof FDSComposite && this.d_deep) {
                this.d_recursiveNext = new FDSObjectIterator((FDSComposite)curr, true);
                this.updateRecursion();
            }
        }
    }

    private FDSObject getCurr() {
        if (this.d_currIndex >= this.d_length) {
            return null;
        }
        if (this.d_comp != null) {
            return this.d_comp.get(this.d_currIndex);
        }
        return (FDSObject)this.d_current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("FDSObjectIterator does not currently support the remove operation.");
    }

    private static class FilteredStub {
        private FilteredStub() {
        }
    }

    public static class DefaultObjectFilter
    extends AbstractObjectFilter {
        public DefaultObjectFilter(FDSObjectIterator it) {
            super(it);
        }

        @Override
        public FDSObject prefetchNext() {
            return this.getBaseIterator().prefetchNext();
        }

        @Override
        public Object filterObject(FDSObject obj) {
            return obj;
        }
    }

    public static abstract class AbstractObjectFilter
    implements ObjectFilter {
        private final FDSObjectIterator d_it;

        public AbstractObjectFilter(FDSObjectIterator it) {
            this.d_it = it;
        }

        protected FDSObjectIterator getBaseIterator() {
            return this.d_it;
        }

        @Override
        public FDSObject prefetchNext() {
            Object nextFiltered;
            do {
                this.d_it.d_next = this.d_it.prefetchNext();
                if (this.d_it.d_next != null) continue;
                return null;
            } while ((nextFiltered = this.filterObject(this.d_it.d_next)) == OBJECT_FILTERED);
            return (FDSObject)nextFiltered;
        }
    }

    public static interface ObjectFilter {
        public FDSObject prefetchNext();

        public Object filterObject(FDSObject var1);
    }
}

