/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AAlignedFDSObject;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;

public final class AlignedBlock
extends AAlignedFDSObject {
    static final long serialVersionUID = 1L;
    private boolean d_thicken = false;
    private boolean d_permitHole = true;
    private boolean d_sawtooth = true;

    public AlignedBlock(Material mat) {
        this(new UnitPoint3D(0.0, 0.0, 0.0, (Unit)SI.METER), new UnitPoint3D(0.0, 0.0, 0.0, (Unit)SI.METER), mat);
    }

    public AlignedBlock(String name, Material mat) {
        super(name, mat);
    }

    public AlignedBlock(UnitPoint3D minPoint, UnitPoint3D maxPoint, Material mat) {
        this(minPoint, maxPoint, "Obstruction", mat);
    }

    public AlignedBlock(UnitPoint3D minPoint, UnitPoint3D maxPoint, String description, Material mat) {
        super(minPoint, maxPoint, description, mat);
    }

    public AlignedBlock(UnitPoint3D minPoint, UnitPoint3D maxPoint, String description, Color c, Material mat) {
        super(minPoint, maxPoint, description, c, mat);
    }

    public static AlignedBlock fromLegacy(pyrosim.legacy_2006_2.legacy.v16.AlignedBlock oldBlock) {
        AlignedBlock ab = new AlignedBlock(oldBlock.getMaterial());
        AAlignedFDSObject.fromLegacy(oldBlock, ab);
        ab.d_permitHole = oldBlock.permitsHole();
        ab.d_sawtooth = oldBlock.isSawtoothed();
        ab.d_thicken = oldBlock.isThickened();
        return ab;
    }

    @Override
    protected void imprint(Object baseObject) {
        if (!(baseObject instanceof AlignedBlock)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(baseObject);
        AlignedBlock obj = (AlignedBlock)baseObject;
        this.d_thicken = obj.d_thicken;
        this.d_permitHole = obj.d_permitHole;
        this.d_sawtooth = obj.d_sawtooth;
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof AlignedBlock)) {
            return false;
        }
        AlignedBlock b = (AlignedBlock)obj;
        boolean equal = this.d_thicken == b.d_thicken && this.d_permitHole == b.d_permitHole && this.d_sawtooth == b.d_sawtooth;
        return equal;
    }

    @Override
    public String getPropertyHashString() {
        String s = super.getPropertyHashString();
        s = s + this.d_permitHole + "," + this.d_thicken + "," + this.d_sawtooth + ";";
        return s;
    }

    @Override
    public String getFDSType() {
        return "OBST";
    }

    @Override
    protected void fillExtraRecords(FDSInputRecord rec) {
        rec.setValue("PERMIT_HOLE", this.d_permitHole);
        rec.setValue("SAWTOOTH", this.d_sawtooth);
        rec.setValue("THICKEN", this.d_thicken);
    }

    public boolean permitsHole() {
        return this.d_permitHole;
    }

    public boolean isSawtoothed() {
        return this.d_sawtooth;
    }

    public boolean isThickened() {
        return this.d_thicken;
    }

    public void setPermitsHole(boolean hole) {
        this.d_permitHole = hole;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public void setIsSawtoothed(boolean d_sawtooth) {
        this.d_sawtooth = d_sawtooth;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public void setIsThickened(boolean d_thicken) {
        this.d_thicken = d_thicken;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean isRasterizable() {
        return false;
    }

    @Override
    public String getTypeDescription() {
        return "Aligned Block";
    }

    @Override
    public boolean isSolid() {
        return true;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }
}

