/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AbstractFDSObject;
import pyrosim.legacy_2006_2.domain.AbstractFace;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Prism;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.legacy.v16.AlignedBlock;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.ATask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public abstract class AAlignedFDSObject
extends AbstractFDSObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private UnitPoint3D d_minPoint;
    private UnitPoint3D d_maxPoint;
    public static final byte MIN_X = 0;
    public static final byte MAX_X = 1;
    public static final byte MIN_Y = 2;
    public static final byte MAX_Y = 3;
    public static final byte MIN_Z = 4;
    public static final byte MAX_Z = 5;
    public static final int NUM_FACES = 6;
    private static final String[] FACE_NAMES = new String[]{"Min X", "Max X", "Min Y", "Max Y", "Min Z", "Max Z"};
    private static final byte X = 0;
    private static final byte Y = 1;
    private static final byte Z = 2;
    private static final int NUM_ROT_AXES = 3;
    private static final byte[][] FACE_INDEX_ROT_LU;

    public AAlignedFDSObject(String descrition, Material mat) {
        this(new UnitPoint3D(0.0, 0.0, 0.0, (Unit)SI.METER), new UnitPoint3D(0.0, 0.0, 0.0, (Unit)SI.METER), descrition, mat);
    }

    public AAlignedFDSObject(UnitPoint3D minPoint, UnitPoint3D maxPoint, String description, Material mat) {
        this(minPoint, maxPoint, description, null, mat);
    }

    public AAlignedFDSObject(UnitPoint3D minPoint, UnitPoint3D maxPoint, String description, Color c, Material mat) {
        super(description);
        assert (minPoint.xu().compareTo(maxPoint.xu()) <= 0 && minPoint.yu().compareTo(maxPoint.yu()) <= 0 && minPoint.zu().compareTo(maxPoint.zu()) <= 0);
        this.d_minPoint = minPoint;
        this.d_maxPoint = maxPoint;
        this.d_faces = new Vector(6);
        for (byte i = 0; i <= 5; i = (byte)(i + 1)) {
            this.d_faces.add(new AAlignedFDSObjectFace(this, i, mat));
        }
        this.setColor(c);
    }

    public static void fromLegacy(AlignedBlock oldBlock, AAlignedFDSObject newBlock) {
        AbstractFDSObject.fromLegacy(oldBlock, newBlock);
        newBlock.setMinPoint(oldBlock.getMinPoint());
        newBlock.setMaxPoint(oldBlock.getMaxPoint());
    }

    @Override
    protected void imprint(Object baseObject) {
        if (!(baseObject instanceof AAlignedFDSObject)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(baseObject);
        AAlignedFDSObject obj = (AAlignedFDSObject)baseObject;
        Iterator<IFace> fIter = this.getFaceIterator();
        while (fIter.hasNext()) {
            ((AAlignedFDSObjectFace)fIter.next()).d_block = this;
        }
        this.d_minPoint = (UnitPoint3D)obj.d_minPoint.clone();
        this.d_maxPoint = (UnitPoint3D)obj.d_maxPoint.clone();
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected Task taskSaveGeometry() {
        return new SaveGeomTask(0);
    }

    @Override
    protected void translate(UnitPoint3D delta) {
    }

    @Override
    protected void scale(UnitPoint3D base, Tuple3d scale) {
        assert (scale.x >= 0.0 && scale.y >= 0.0 && scale.z >= 0.0);
        ADomainObject.pauseUpdates(this, false);
        Unit lu = Geometry.GEOM_LENGTH_UNIT;
        Point3d base3d = base.getPoint3dValue(lu);
        Point3d ptMin = this.getMinPoint().getPoint3dValue(lu);
        Point3d ptMax = this.getMaxPoint().getPoint3dValue(lu);
        AAlignedFDSObject.scalePoint(ptMin, base3d, scale);
        AAlignedFDSObject.scalePoint(ptMax, base3d, scale);
        this.setMinPoint(new UnitPoint3D(ptMin, lu));
        this.setMaxPoint(new UnitPoint3D(ptMax, lu));
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected void rotate(UnitPoint3D base, Vector3d rotAxis, UnitDouble amount) {
        Unit lu = Geometry.GEOM_LENGTH_UNIT;
        Point3d base3d = base.getPoint3dValue(lu);
        Matrix3d rot = AAlignedFDSObject.getRotateMat(rotAxis, amount);
        Point3d min = this.getMinPoint().getPoint3dValue(lu);
        Point3d max = this.getMaxPoint().getPoint3dValue(lu);
        AAlignedFDSObject.rotatePoint(min, base3d, rot);
        AAlignedFDSObject.rotatePoint(max, base3d, rot);
        this.rectifyPoints(min, max);
        ADomainObject.pauseUpdates(this);
        this.setMinPoint(new UnitPoint3D(min, lu));
        this.setMaxPoint(new UnitPoint3D(max, lu));
        this.rotateFaces(rotAxis, amount);
        ADomainObject.resumeUpdates(this);
    }

    protected void rotateFaces(Vector3d rotAxis, UnitDouble angle) {
        Vector3d closestAxis;
        double angleDeg = angle.getValue(NonSI.DEGREE_ANGLE);
        int num90s = (int)(Math.round(Math.abs(angleDeg) / 90.0) % 4L);
        if (angleDeg < 0.0) {
            num90s = 4 - num90s;
        }
        int axis = (closestAxis = this.getClosestAxis(rotAxis)).equals(Geometry.VEC3D_XPOS) ? 0 : (closestAxis.equals(Geometry.VEC3D_YPOS) ? 1 : 2);
        this.rotateFaces(axis, num90s);
    }

    protected void rotateFaces(int axis, int num90s) {
        for (int m = 0; m < num90s; ++m) {
            this.rotateFaces90(axis);
        }
    }

    protected void rotateFaces90(int axis) {
        Material[] oldMats = new Material[6];
        for (int i = 0; i < 6; ++i) {
            oldMats[i] = ((IFace)this.d_faces.get(i)).getMaterial();
        }
        for (int oldFace = 0; oldFace < 6; ++oldFace) {
            byte newFace = FACE_INDEX_ROT_LU[axis][oldFace];
            ((IFace)this.d_faces.get(newFace)).setMaterial(oldMats[oldFace]);
        }
    }

    @Override
    protected void mirror(int plane, UnitDouble value) {
    }

    protected void mirrorFaces(int plane, UnitDouble value) {
        if (plane == 0) {
            Material tempMat = this.getMaterial(0);
            this.setMaterial(0, this.getMaterial(1));
            this.setMaterial(1, tempMat);
        } else if (plane == 1) {
            Material tempMat = this.getMaterial(2);
            this.setMaterial(2, this.getMaterial(3));
            this.setMaterial(3, tempMat);
        } else {
            Material tempMat = this.getMaterial(4);
            this.setMaterial(4, this.getMaterial(5));
            this.setMaterial(5, tempMat);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof AAlignedFDSObject)) {
            return false;
        }
        AAlignedFDSObject b = (AAlignedFDSObject)obj;
        boolean equal = (this.d_minPoint == null ? b.d_minPoint == null : this.d_minPoint.equals(b.d_minPoint)) && (this.d_maxPoint == null ? b.d_maxPoint == null : this.d_maxPoint.equals(b.d_maxPoint));
        return equal;
    }

    @Override
    public String getPropertyHashString() {
        BaseUnit meters = SI.METER;
        String s = super.getPropertyHashString();
        if (this.d_minPoint != null) {
            s = s + this.d_minPoint.x((Unit)meters) + "," + this.d_minPoint.y((Unit)meters) + "," + this.d_minPoint.z((Unit)meters) + ";";
        }
        if (this.d_maxPoint != null) {
            s = s + this.d_maxPoint.x((Unit)meters) + "," + this.d_maxPoint.y((Unit)meters) + "," + this.d_maxPoint.z((Unit)meters) + ";";
        }
        return s;
    }

    public void setMinPoint(UnitPoint3D minPoint) {
        this.d_minPoint = minPoint;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public void setMaxPoint(UnitPoint3D maxPoint) {
        this.d_maxPoint = maxPoint;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public UnitPoint3D getMinPoint() {
        return this.d_minPoint;
    }

    @Override
    public UnitPoint3D getMaxPoint() {
        return this.d_maxPoint;
    }

    public String toString() {
        String str = "";
        String name = this.getName();
        if (name != null && !name.equals("")) {
            str = str + " [" + name + "]";
        }
        return str;
    }

    @Override
    public int getNumFaces() {
        return 6;
    }

    @Override
    public Material getMaterial(int faceIndex) {
        return ((IFace)this.d_faces.get(faceIndex)).getMaterial();
    }

    @Override
    public void setMaterial(int faceIndex, Material mat) {
        ((IFace)this.d_faces.get(faceIndex)).setMaterial(mat);
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Material getMaterial() {
        Material m0 = this.getMaterial(0);
        for (int i = 0; i < 6; ++i) {
            if (m0 == this.getMaterial(i)) continue;
            return null;
        }
        return m0;
    }

    @Override
    public boolean isUniformMaterial() {
        return this.getMaterial() != null;
    }

    protected abstract void fillExtraRecords(FDSInputRecord var1);

    protected void fillMaterialRecords(FDSInputRecord rec) {
        if (this.isUniformMaterial()) {
            rec.setValue("SURF_ID", ((IFace)this.d_faces.get(0)).getMaterial().getName());
        } else if (((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(1)).getMaterial() && ((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(2)).getMaterial() && ((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(3)).getMaterial()) {
            VectorFromArray<String> mats = new VectorFromArray<String>(((IFace)this.d_faces.get(5)).getMaterial().getName(), ((IFace)this.d_faces.get(0)).getMaterial().getName(), ((IFace)this.d_faces.get(4)).getMaterial().getName());
            rec.setValue("SURF_IDS", mats);
        } else {
            Vector<String> mats = new Vector<String>(6);
            for (int i = 0; i < 6; ++i) {
                mats.add(((IFace)this.d_faces.get(i)).getMaterial().getName());
            }
            rec.setValue("SURF_ID6", mats);
        }
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        FDSInputRecord rec = new FDSInputRecord();
        rec.setType(this.getFDSType());
        Vector<Double> coords = new Vector<Double>(6);
        Unit u = FdsSISystem.getInstance().getLengthUnit();
        coords.add(this.d_minPoint.x(u));
        coords.add(this.d_maxPoint.x(u));
        coords.add(this.d_minPoint.y(u));
        coords.add(this.d_maxPoint.y(u));
        coords.add(this.d_minPoint.z(u));
        coords.add(this.d_maxPoint.z(u));
        rec.setValue("XB", coords);
        Color c = this.getColor();
        if (c != null) {
            float[] rgb = c.getRGBComponents(null);
            Vector<Double> color = new Vector<Double>(3);
            color.add(Double.valueOf(rgb[0]));
            color.add(Double.valueOf(rgb[1]));
            color.add(Double.valueOf(rgb[2]));
            rec.setValue("RGB", color);
        }
        if (this.getFDSType().equals("OBST") && !this.isVisible()) {
            rec.setValue("COLOR", "INVISIBLE");
        }
        rec.setComment(this.getName());
        this.fillMaterialRecords(rec);
        this.fillExtraRecords(rec);
        Collection eventRecords = this.getEventInputRecords(rec);
        if (eventRecords.size() != 0) {
            recs.addAll(eventRecords);
        } else {
            recs.add(rec);
        }
    }

    static {
        byte[][] rotlu = FACE_INDEX_ROT_LU = new byte[3][6];
        rotlu[0][0] = 0;
        rotlu[0][1] = 1;
        rotlu[0][2] = 4;
        rotlu[0][3] = 5;
        rotlu[0][4] = 3;
        rotlu[0][5] = 2;
        rotlu[1][0] = 5;
        rotlu[1][1] = 4;
        rotlu[1][2] = 2;
        rotlu[1][3] = 3;
        rotlu[1][4] = 0;
        rotlu[1][5] = 1;
        rotlu[2][0] = 2;
        rotlu[2][1] = 3;
        rotlu[2][2] = 1;
        rotlu[2][3] = 0;
        rotlu[2][4] = 4;
        rotlu[2][5] = 5;
    }

    static class AAlignedFDSObjectFace
    extends AbstractFace
    implements Serializable {
        static final long serialVersionUID = 1L;
        private AAlignedFDSObject d_block;
        private byte d_index;

        public AAlignedFDSObjectFace() {
        }

        public AAlignedFDSObjectFace(AAlignedFDSObject block, byte index, Material material) {
            super(material);
            this.d_block = block;
            this.d_index = index;
        }

        @Override
        public Object clone() {
            return super.clone();
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof AAlignedFDSObjectFace)) {
                return false;
            }
            AAlignedFDSObjectFace abf = (AAlignedFDSObjectFace)obj;
            return this.d_index == abf.d_index;
        }

        @Override
        public void setMaterial(Material m) {
            super.setMaterial(m);
        }

        @Override
        public String getName() {
            return FACE_NAMES[this.d_index];
        }

        @Override
        public void getGeometry(Geometry g) {
            Quad q = Prism.getFaceForBox(this.d_block.getMinPoint().getValue(Geometry.GEOM_LENGTH_UNIT), this.d_block.getMaxPoint().getValue(Geometry.GEOM_LENGTH_UNIT), this.d_index, new PrimProps(this.getMaterial(), this.getGeometryColor()));
            g.addQuad(q);
        }

        protected Color getGeometryColor() {
            return this.d_block.getColor();
        }

        @Override
        public UnitPoint3D[] getVerts() {
            return null;
        }

        @Override
        public FDSObject getAttachedObj() {
            return this.d_block;
        }

        @Override
        public IFDSFragGenerator getFDSFragGenerator() {
            return null;
        }
    }

    private class SaveGeomTask
    extends ATask {
        private UnitPoint3D d_min;
        private UnitPoint3D d_max;
        private final Material[] d_mats;

        public SaveGeomTask(int est) {
            super(est, true);
            this.d_mats = new Material[6];
        }

        @Override
        public void undo() {
            ADomainObject.pauseUpdates(AAlignedFDSObject.this);
            AAlignedFDSObject.this.setMinPoint(this.d_min);
            AAlignedFDSObject.this.setMaxPoint(this.d_max);
            for (int face = 0; face < 6; ++face) {
                ((IFace)AAlignedFDSObject.this.d_faces.get(face)).setMaterial(this.d_mats[face]);
            }
            ADomainObject.resumeUpdates(AAlignedFDSObject.this);
        }

        @Override
        public void run() {
            this.d_min = (UnitPoint3D)AAlignedFDSObject.this.getMinPoint().clone();
            this.d_max = (UnitPoint3D)AAlignedFDSObject.this.getMaxPoint().clone();
            for (int face = 0; face < 6; ++face) {
                this.d_mats[face] = ((IFace)AAlignedFDSObject.this.d_faces.get(face)).getMaterial();
            }
        }
    }
}

