/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2;

import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.AbstractUnitSystem;

public class FdsSISystem
extends AbstractUnitSystem {
    private static final Unit d_rti = SI.METER.multiply((Unit)SI.SECOND).root(2);
    private static final Unit d_density = SI.KILOGRAM.divide(SI.METER.pow(3));
    private static final Unit d_atmGrad = SI.KELVIN.alternate(SI.CELSIUS.toString()).divide((Unit)SI.METER);
    private static final Unit d_accel = SI.METER.divide(SI.SECOND.pow(2));
    private static final Unit d_velocity = SI.METER.divide((Unit)SI.SECOND);
    private static final Unit d_diameter = SI.MICRO((Unit)SI.METER);
    private static final Unit d_specEnergy = SI.KILO((Unit)SI.JOULE).divide((Unit)SI.KILOGRAM);
    private static final Unit d_specHeat = SI.KILO((Unit)SI.JOULE).divide((Unit)SI.KILOGRAM).divide((Unit)SI.KELVIN);
    private static final Unit d_absorptionCoefficient = SI.METER.pow(-1);
    private static final Unit d_REACPreExpFactor = SI.CENTI((Unit)SI.METER).pow(3).divide((Unit)SI.MOLE).divide((Unit)SI.SECOND);
    private static final Unit d_energyPerMol = SI.KILO((Unit)SI.JOULE).divide(SI.KILO((Unit)SI.MOLE));
    private static final Unit d_visibility = SI.METER.pow(2).divide((Unit)SI.KILOGRAM);
    private static final Unit d_molecularWeight = SI.GRAM.divide((Unit)SI.MOLE);
    private static final Unit d_massFrac = SI.KILOGRAM.divide((Unit)SI.KILOGRAM);
    private static final Unit d_diffusion = SI.METER.pow(2).divide((Unit)SI.SECOND);
    private static final Unit d_conductivity = SI.WATT.divide((Unit)SI.METER).divide((Unit)SI.KELVIN);
    private static final Unit d_burnRate = SI.KILOGRAM.divide(SI.METER.pow(2)).divide((Unit)SI.SECOND);
    private static final Unit d_extCoefficient = SI.SECOND.pow(-1);
    private static final Unit d_hrrpua = SI.KILO((Unit)SI.WATT).divide(SI.METER.pow(2));
    private static final Unit d_hrrpuv = SI.KILO((Unit)SI.WATT).divide(SI.METER.pow(3));
    private static final Unit d_surfDensity = SI.KILOGRAM.divide(SI.METER.pow(2));
    private static final Unit d_volFlux = SI.METER.pow(3).divide((Unit)SI.SECOND);
    private static final Unit d_mixFrac = Unit.ONE.alternate("kg/kg");
    private static final Unit d_unitless = Unit.ONE;
    private static final Unit d_obscure = Unit.ONE.divide((Unit)SI.METER);
    private static final Unit d_kappa0 = Unit.ONE.divide((Unit)SI.METER);
    private static FdsSISystem s_fdsSystem;
    public static final String NAME = "SI";

    @Override
    public String getSystemName() {
        return NAME;
    }

    public static FdsSISystem getInstance() {
        if (s_fdsSystem == null) {
            s_fdsSystem = new FdsSISystem();
        }
        return s_fdsSystem;
    }

    @Override
    public Unit getDiffusionUnit() {
        return d_diffusion;
    }

    @Override
    public Unit getLengthUnit() {
        return SI.METER;
    }

    @Override
    public Unit getTempUnit() {
        return SI.CELSIUS;
    }

    @Override
    public Unit getTimeUnit() {
        return SI.SECOND;
    }

    @Override
    public Unit getRtiUnit() {
        return d_rti;
    }

    @Override
    public Unit getDensityUnit() {
        return d_density;
    }

    @Override
    public Unit getAtmGradUnit() {
        return d_atmGrad;
    }

    @Override
    public Unit getAccelUnit() {
        return d_accel;
    }

    @Override
    public Unit getAmbientPressureUnit() {
        return SI.PASCAL;
    }

    @Override
    public Unit getVelocityUnit() {
        return d_velocity;
    }

    @Override
    public Unit getDiameterUnit() {
        return d_diameter;
    }

    @Override
    public Unit getSpecEnergyUnit() {
        return d_specEnergy;
    }

    @Override
    public Unit getSpecHeatUnit() {
        return d_specHeat;
    }

    @Override
    public Unit getPipePressureUnit() {
        return NonSI.BAR;
    }

    @Override
    public Unit getAbsorptionCoefficientUnit() {
        return d_absorptionCoefficient;
    }

    @Override
    public Unit getREACPreExpFactorUnit() {
        return d_REACPreExpFactor;
    }

    @Override
    public Unit getEnergyPerMolUnit() {
        return d_energyPerMol;
    }

    @Override
    public Unit getVisibilityUnit() {
        return d_visibility;
    }

    @Override
    public Unit getMolecularWeightUnit() {
        return d_molecularWeight;
    }

    @Override
    public Unit getMassFractionUnit() {
        return d_massFrac;
    }

    @Override
    public Unit getConductivityUnit() {
        return d_conductivity;
    }

    @Override
    public Unit getAngleUnit() {
        return NonSI.DEGREE_ANGLE;
    }

    @Override
    public Unit getBurningRateUnit() {
        return d_burnRate;
    }

    @Override
    public Unit getExtinguishingCoefficientUnit() {
        return d_extCoefficient;
    }

    @Override
    public Unit getHRRPUAUnit() {
        return d_hrrpua;
    }

    @Override
    public Unit getHRRPUVUnit() {
        return d_hrrpuv;
    }

    @Override
    public Unit getSurfaceDensityUnit() {
        return d_surfDensity;
    }

    @Override
    public Unit getVolumeFluxUnit() {
        return d_volFlux;
    }

    @Override
    public Unit getMixFracUnit() {
        return d_mixFrac;
    }

    @Override
    public Unit getObscurationUnit() {
        return d_obscure;
    }

    @Override
    public Unit getKappa0Unit() {
        return d_kappa0;
    }

    @Override
    public Unit getUnitlessUnit() {
        return d_unitless;
    }
}

