/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy.v109.domain.devices.hvac;

import java.io.ObjectStreamException;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.domain.devices.ADevice;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;

public abstract class HvacDevice
extends ADevice {
    static final long serialVersionUID = 1L;
    private IQuantity d_msr;

    public HvacDevice(String name, IQuantity msr) {
        super(name);
        this.d_msr = msr;
    }

    public IQuantity getQuantity() {
        return this.d_msr;
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getDevcGeom());
    }

    @Override
    public void setGeom(IGeomNode geom) {
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return DisplayGeom.EMPTY;
    }

    protected abstract IGeom getDevcGeom();

    private static Point3d getPointForNode(HvacNode n) {
        if (n != null && n.getProp("XYZ") != null) {
            return ((UnitPoint3D)n.getProp("XYZ")).getPoint3dValue((Unit)SI.METER);
        }
        return null;
    }

    public static class DuctDevice
    extends HvacDevice {
        static final long serialVersionUID = 1L;

        public DuctDevice(String name, IQuantity msr) {
            super(name, msr);
        }

        @Override
        public IGeom getDevcGeom() {
            ObjectQuantity quant = (ObjectQuantity)this.getQuantity();
            IFilteredCollection<HvacDuct> ducts = theUtil.filter(Arrays.asList(quant.objects), HvacDuct.class);
            if (ducts.isEmpty()) {
                return EmptyGeom.INSTANCE;
            }
            HvacDuct duct = (HvacDuct)ducts.iterator().next();
            List endNodes = (List)duct.getProp("NODE_ID");
            if (endNodes == null || endNodes.isEmpty() || endNodes.get(0) == null) {
                System.err.printf("[x] Unable to find location for DUCT (%s)%n", duct.getName());
                return EmptyGeom.INSTANCE;
            }
            if (endNodes.size() < 2) {
                Point3d pt = HvacDevice.getPointForNode((HvacNode)endNodes.get(0));
                if (pt != null) {
                    return new Point(pt);
                }
                System.err.printf("[xx] Unable to find location for DUCT (%s)%n", duct.getName());
            } else {
                Point3d ptA = HvacDevice.getPointForNode((HvacNode)endNodes.get(0));
                Point3d ptB = HvacDevice.getPointForNode((HvacNode)endNodes.get(1));
                if (ptA != null && ptB != null) {
                    Point3d p = Util3D.getMidPoint(ptA, ptB);
                    return new Point(p);
                }
                System.err.printf("[xxx] Unable to find location for DUCT (%s)%n", duct.getName());
            }
            return EmptyGeom.INSTANCE;
        }

        private Object readResolve() throws ObjectStreamException {
            pyrosim.domain.devices.hvac.DuctDevice devc = new pyrosim.domain.devices.hvac.DuctDevice(this.getName(), this.getQuantity());
            devc.setGeom(this.getGeom());
            return devc;
        }
    }

    public static class NodeDevice
    extends HvacDevice {
        static final long serialVersionUID = 1L;

        public NodeDevice(String devcId, IQuantity msr) {
            super(devcId, msr);
        }

        @Override
        public IGeom getDevcGeom() {
            ObjectQuantity quant = (ObjectQuantity)this.getQuantity();
            IFilteredCollection<HvacNode> nodes = theUtil.filter(Arrays.asList(quant.objects), HvacNode.class);
            if (nodes.isEmpty()) {
                return EmptyGeom.INSTANCE;
            }
            if (quant.get() == Quantity.HVAC_NODE_PRESSURE_DIFFERENCE) {
                assert (nodes.size() == 2);
            } else {
                HvacNode node = (HvacNode)nodes.iterator().next();
                Point3d pt = HvacDevice.getPointForNode(node);
                if (pt != null) {
                    return new Point(pt);
                }
                System.err.printf("[x] Unable to find location for NodeDevice (%s)%n", node.getName());
            }
            return EmptyGeom.INSTANCE;
        }

        private Object readResolve() throws ObjectStreamException {
            pyrosim.domain.devices.hvac.NodeDevice devc = new pyrosim.domain.devices.hvac.NodeDevice(this.getName(), this.getQuantity());
            devc.setGeom(this.getGeom());
            return devc;
        }
    }
}

