/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDSObjRenderer;
import pyrosim.io.fds.v6.renderers.IObstructionRenderer;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.LinkedIdentityHashMap;

public class ObstructionRenderer
extends AFDSObjRenderer<IObstruction>
implements IObstructionRenderer {
    private final PinConnectionRenderer d_pinConns;
    private final Map<IObstruction, List<Integer>> d_obstIxes = new LinkedIdentityHashMap<IObstruction, List<Integer>>();
    private int d_obstIx = 0;

    public ObstructionRenderer(FDSRasterization raster, PinConnectionRenderer pinConns) {
        super(raster);
        this.d_pinConns = pinConns;
    }

    @Override
    public Map<IObstruction, List<Integer>> getObstIxes() {
        return this.d_obstIxes;
    }

    @Override
    protected boolean renderBlock(IFDSRecordRenderer props, AABoxGeom geom, Collection<IObstruction> srcObjs, FaceProps[] faceProps) {
        Color[] colors = new Color[faceProps.length];
        Surface[] surfs = new Surface[faceProps.length];
        for (int m = 0; m < faceProps.length; ++m) {
            colors[m] = faceProps[m].color;
            surfs[m] = faceProps[m].surface;
        }
        return this.renderBlock(props, geom, srcObjs, colors, surfs);
    }

    @Override
    protected boolean renderBlock(IFDSRecordRenderer props, IObstruction obj) {
        return this.renderBlock(props, obj.getGeom().flatten().getLocalGeom(), Collections.singleton(obj), obj.getColors(), obj.getSurfaces());
    }

    public boolean renderBlock(IFDSRecordRenderer props, IGeom geom, Collection<IObstruction> srcObjs, Color[] colors, Surface[] surfs) {
        IObstruction propSource = srcObjs.iterator().next();
        FDSRenderRecord rec = FDS6Const.newRenderRecord("OBST");
        rec.setValue("ID", propSource.getName());
        rec.setComment(propSource.getDesc());
        ObstructionRenderer.renderAABox(rec, "XB", geom.getBoundingBox(new AABox()));
        ObstructionRenderer.renderEvac(rec, "EVACUATION", "MESH_ID", propSource.getEvac());
        Color color = ObstructionRenderer.resolveSurfaceColor(colors[0], surfs[0]);
        ObstructionRenderer.renderColor(rec, propSource.isVisible(), color, "RGB", "COLOR", "TRANSPARENCY");
        rec.setValue("PERMIT_HOLE", propSource.getOptions(4), false);
        rec.setValue("THICKEN", propSource.getOptions(1), false);
        rec.setValue("ALLOW_VENT", propSource.getOptions(8), false);
        rec.setValue("BNDF_OBST", propSource.getOptions(16), false);
        rec.setValue("OUTLINE", propSource.getOptions(32), false);
        rec.setValue("REMOVABLE", propSource.getOptions(64), false);
        UnitDouble dens = propSource.getBulkDensity();
        if (dens != null) {
            rec.setValue("BULK_DENSITY", dens, false);
        }
        ObstructionRenderer.fillMaterialRecords(geom, surfs, rec);
        ObstructionRenderer.renderTextureOrigin(rec, "TEXTURE_ORIGIN", propSource, propSource.getTextureOrigin());
        ObstructionRenderer.renderCustomFDSProps(rec, propSource);
        this.d_pinConns.markForInputRetrieval(propSource.getInputPin(), rec, "CTRL_ID", "DEVC_ID");
        this.d_pinConns.renderConnections(props, propSource);
        for (IObstruction obst : srcObjs) {
            this.d_obstIxes.computeIfAbsent(obst, o -> new ArrayList()).add(this.d_obstIx);
        }
        ++this.d_obstIx;
        return true;
    }

    protected static void fillMaterialRecords(IGeom geom, Surface[] surfs, FDSRenderRecord rec) {
        if (surfs.length == 1 || pyrosim.domain.GeomUtil.isUniform(surfs)) {
            rec.setValue("SURF_ID", surfs[0].getName());
            return;
        }
        assert (surfs.length == 6);
        if (pyrosim.domain.GeomUtil.isUniform(surfs = ObstructionRenderer.swizzleSurfs(geom, surfs))) {
            rec.setValue("SURF_ID", surfs[0].getName());
            return;
        }
        if (surfs[0] == surfs[1] && surfs[0] == surfs[2] && surfs[0] == surfs[3]) {
            FDSArray<Object> mats = new FDSArray<Object>(surfs[5].getName(), surfs[0].getName(), surfs[4].getName());
            rec.setValue("SURF_IDS", mats);
        } else {
            FDSArray<Object> mats = new FDSArray<Object>(surfs[0].getName(), surfs[1].getName(), surfs[2].getName(), surfs[3].getName(), surfs[4].getName(), surfs[5].getName());
            rec.setValue("SURF_ID6", mats);
        }
    }

    private static Surface[] swizzleSurfs(IGeom geom, Surface[] surfs) {
        int m;
        int[] normals = ObstructionRenderer.getFDSFaceNormals(geom);
        if (normals == null) {
            return surfs;
        }
        assert (normals.length == surfs.length);
        Surface[] resultSurfs = new Surface[surfs.length];
        for (m = 0; m < resultSurfs.length; ++m) {
            int normal = normals[m];
            if (normal == 0) continue;
            resultSurfs[ObstructionRenderer.getFDSIndex((int)normal)] = surfs[m];
        }
        for (m = 0; m < resultSurfs.length; ++m) {
            if (resultSurfs[m] != null) continue;
            resultSurfs[m] = surfs[0];
        }
        return resultSurfs;
    }

    private static int getFDSIndex(int fdsNormal) {
        switch (fdsNormal) {
            case -1: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case -2: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case -3: {
                return 4;
            }
            case 3: {
                return 5;
            }
        }
        return -1;
    }

    private static int[] getFDSFaceNormals(IGeom geom) {
        if (geom instanceof AABoxGeom) {
            return ObstructionRenderer.getFDSFaceNormals((AABoxGeom)geom);
        }
        return ObstructionRenderer.getGeneralFDSFaceNormals(geom);
    }

    private static int[] getGeneralFDSFaceNormals(IGeom geom) {
        AABox bounds = geom.getBoundingBox(new AABox());
        Point3d center = bounds.getCenter();
        List faces = GeomUtil.explode(geom, IFace.class);
        assert (faces.size() == 6);
        Vector3d[] normals = new Vector3d[faces.size()];
        for (int m = 0; m < faces.size(); ++m) {
            assert (faces.get(m) instanceof IPolygon);
            IPolygon face = (IPolygon)faces.get(m);
            Vector3d norm = face.getNormal(true);
            if (norm.lengthSquared() > 0.0) {
                Plane3d plane = new Plane3d(norm, face.getPoint(0, 0));
                if (plane.dot(center) > 0.0) {
                    norm = Util3D.negate(norm);
                }
                normals[m] = norm;
                continue;
            }
            normals[m] = null;
        }
        int[] fdsNormals = new int[normals.length];
        for (int m = 0; m < normals.length; ++m) {
            fdsNormals[m] = normals[m] == null ? 0 : pyrosim.io.fds.v6.common.GeomUtil.toFDSVec(normals[m]);
        }
        return fdsNormals;
    }

    private static int[] getFDSFaceNormals(AABoxGeom box) {
        int[] boxNameOrder = box.getIndexToNameFaceOrder();
        int[] result = new int[boxNameOrder.length];
        for (int m = 0; m < boxNameOrder.length; ++m) {
            result[m] = ObstructionRenderer.boxNameToFDSVec(boxNameOrder[m]);
        }
        return result;
    }

    private static int boxNameToFDSVec(int boxName) {
        switch (boxName) {
            case 0: {
                return -1;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return -2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return -3;
            }
            case 5: {
                return 3;
            }
        }
        return 0;
    }
}

