/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.IHeatBasedValue;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.IPyrolysis;
import pyrosim.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.domain.boundcond.mat.LiquidReaction;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.ReacByproducts;
import pyrosim.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.domain.boundcond.mat.SolidReaction;
import pyrosim.domain.boundcond.mat.ThermalProps;
import pyrosim.domain.ramp.Ramp;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Lists;

public class MaterialRenderer
extends AFDS6Renderer {
    private final Set<Material> d_renderedMats;
    private final FDSNameMap d_nameMap;
    private final PinConnectionRenderer d_pinConns;

    public MaterialRenderer(FDSNameMap nameMap, PinConnectionRenderer pinConns) {
        this.d_nameMap = nameMap;
        this.d_renderedMats = new IdentityHashSet<Material>();
        this.d_pinConns = pinConns;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Material.class);
    }

    public boolean wasRendered(Material mat) {
        return this.d_renderedMats.contains(mat);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        Material obj = (Material)o;
        FDSRenderRecord rec = FDS6Const.newRenderRecord("MATL");
        rec.setValue("ID", obj.getName());
        String fyi = obj.getFYI().trim();
        if (fyi.length() > 0) {
            rec.setValue("FYI", fyi);
        }
        HashMap<String, Ramp> ramps = new HashMap<String, Ramp>();
        this.writeThermalProps(props, obj, rec, ramps);
        this.writePyrolysis(rec, obj.getPyrolysis());
        MaterialRenderer.renderCustomFDSProps(rec, obj);
        props.props().pushProps();
        props.props().setRenderMultiLine(true);
        props.render(rec, o);
        props.props().popProps();
        RampRenderer.render(props, ramps, this.d_pinConns);
        this.d_renderedMats.add(obj);
        return true;
    }

    private void writeThermalProps(IFDSRecordRenderer props, Material obj, FDSRenderRecord rec, Map<String, Ramp> ramps) {
        ThermalProps tp = obj.getThermalProps();
        this.writeTempDepVal(obj, rec, ramps, "SPECIFIC_HEAT", "SPECIFIC_HEAT_RAMP", tp.d_specificHeat);
        this.writeTempDepVal(obj, rec, ramps, "CONDUCTIVITY", "CONDUCTIVITY_RAMP", tp.d_conductivity);
        rec.setValue("DENSITY", tp.d_density, false);
        rec.setValue("ABSORPTION_COEFFICIENT", tp.d_absorptionCoeff, false);
        rec.setValue("EMISSIVITY", tp.d_emissivity, false);
    }

    private void writePyrolysis(FDSRenderRecord rec, IPyrolysis pyrolysis) {
        if (pyrolysis instanceof SolidPyrolysis) {
            this.writeSolidPyrolysis(rec, (SolidPyrolysis)pyrolysis);
        } else if (pyrolysis instanceof LiquidPyrolysis) {
            this.writeLiquidPyrolysis(rec, (LiquidPyrolysis)pyrolysis);
        }
    }

    private void writeSolidPyrolysis(FDSRenderRecord rec, SolidPyrolysis sp) {
        if (sp.d_heatOfCombustion != null) {
            rec.setValue("HEAT_OF_COMBUSTION", sp.d_heatOfCombustion, false);
        }
        rec.setValue("N_REACTIONS", sp.getReactions().size(), false);
        ArrayList<SolidReaction.Rate> rates = new ArrayList<SolidReaction.Rate>(sp.getReactions().size());
        ArrayList<ReacByproducts> byproducts = new ArrayList<ReacByproducts>(sp.getReactions().size());
        for (SolidReaction reac : sp.getReactions()) {
            byproducts.add(reac.d_byproducts);
            rates.add(reac.d_rate);
        }
        this.writeReacByproducts(rec, byproducts);
        this.writeSolidReacRates(rec, rates);
    }

    private void writeLiquidPyrolysis(FDSRenderRecord rec, LiquidPyrolysis sp) {
        LiquidReaction reac = sp.d_reaction;
        if (sp.d_heatOfCombust != null) {
            rec.setValue("HEAT_OF_COMBUSTION", sp.d_heatOfCombust, false);
        }
        this.writeReacByproducts(rec, Arrays.asList(reac.d_byproducts));
        this.writeLiquidReacRate(rec, reac.d_rate);
    }

    private void writeReacByproducts(FDSRenderRecord rec, List<ReacByproducts> byproducts) {
        List<Object> heats = Lists.filled(byproducts.size(), null);
        FDSArray<String> matIDs = new FDSArray<String>(new int[]{20, 10});
        FDSArray<String> specIDs = new FDSArray<String>(new int[]{20, 10});
        FDSArray<Double> nuMats = new FDSArray<Double>(new int[]{20, 10});
        FDSArray<Double> nuSpecs = new FDSArray<Double>(new int[]{20, 10});
        int[] ix = new int[2];
        for (int reacix = 0; reacix < byproducts.size(); ++reacix) {
            ReacByproducts bp = byproducts.get(reacix);
            if (bp.d_heat != null) {
                heats.set(reacix, bp.d_heat);
            }
            ix[1] = reacix;
            int matix = 0;
            int specix = 0;
            for (ReacByproducts.Residue r : bp.getResidues()) {
                if (r.d_type instanceof Material) {
                    ix[0] = matix++;
                    matIDs.set(r.d_type.getName(), ix);
                    nuMats.set(r.d_fraction, ix);
                    continue;
                }
                ix[0] = specix++;
                specIDs.set(r.d_type.getName(), ix);
                nuSpecs.set(r.d_fraction, ix);
            }
        }
        rec.setValue("HEAT_OF_REACTION", heats, false);
        rec.setValue("MATL_ID", matIDs);
        rec.setValue("NU_MATL", nuMats, false);
        rec.setValue("SPEC_ID", specIDs);
        rec.setValue("NU_SPEC", nuSpecs, false);
    }

    private void writeSolidReacRates(FDSRenderRecord rec, List<SolidReaction.Rate> rates) {
        List<Object> nts = Lists.filled(rates.size(), null);
        List<Object> igTemps = Lists.filled(rates.size(), null);
        List<Object> nss = Lists.filled(rates.size(), null);
        List<Object> as = Lists.filled(rates.size(), null);
        List<Object> es = Lists.filled(rates.size(), null);
        List<Object> refTemps = Lists.filled(rates.size(), null);
        List<Object> heatingRates = Lists.filled(rates.size(), null);
        List<Object> pyrolysisRanges = Lists.filled(rates.size(), null);
        FDSRecordSpec.ListFld heatingRateFld = (FDSRecordSpec.ListFld)rec.getSpec().fields.get("HEATING_RATE");
        FDSRecordSpec.ListFld pyroRangeFld = (FDSRecordSpec.ListFld)rec.getSpec().fields.get("PYROLYSIS_RANGE");
        for (int m = 0; m < rates.size(); ++m) {
            SolidReaction.Rate.ISpecification spec;
            SolidReaction.Rate rate = rates.get(m);
            if (rate.d_tempExponent != 0.0) {
                nts.set(m, rate.d_tempExponent);
                igTemps.set(m, rate.d_thresholdTemp);
            }
            if (rate.d_massFracExponent != 1.0) {
                nss.set(m, rate.d_massFracExponent);
            }
            if (rate.d_spec instanceof SolidReaction.Rate.AESpec) {
                spec = (SolidReaction.Rate.AESpec)rate.d_spec;
                as.set(m, spec.d_a);
                es.set(m, spec.d_e);
                continue;
            }
            assert (rate.d_spec instanceof SolidReaction.Rate.RefSpec);
            spec = (SolidReaction.Rate.RefSpec)rate.d_spec;
            refTemps.set(m, ((SolidReaction.Rate.RefSpec)spec).d_refTemp);
            if (!((SolidReaction.Rate.RefSpec)spec).d_heatingRate.equals(heatingRateFld.elementChecker.initialValue)) {
                heatingRates.set(m, ((SolidReaction.Rate.RefSpec)spec).d_heatingRate);
            }
            if (((SolidReaction.Rate.RefSpec)spec).d_pyrolysisRange.equals(pyroRangeFld.elementChecker.initialValue)) continue;
            pyrolysisRanges.set(m, ((SolidReaction.Rate.RefSpec)spec).d_pyrolysisRange);
        }
        rec.setValue("N_T", nts, false);
        rec.setValue("THRESHOLD_TEMPERATURE", igTemps, false);
        rec.setValue("N_S", nss, false);
        rec.setValue("A", as, false);
        rec.setValue("E", es, false);
        rec.setValue("REFERENCE_TEMPERATURE", refTemps, false);
        rec.setValue("HEATING_RATE", heatingRates, false);
        rec.setValue("PYROLYSIS_RANGE", pyrolysisRanges, false);
    }

    private void writeLiquidReacRate(FDSRenderRecord rec, LiquidReaction.Rate rate) {
        rec.setValue("BOILING_TEMPERATURE", rate.d_boilingTemp, true);
    }

    private void writeTempDepVal(Material mat, FDSRenderRecord rec, Map<String, Ramp> ramps, String valKey, String rampKey, IHeatBasedValue val) {
        if (val instanceof IHeatBasedValue.Constant) {
            rec.setValue(valKey, ((IHeatBasedValue.Constant)val).value, false);
        } else {
            assert (val instanceof IHeatBasedValue.Custom);
            String name = RampRenderer.createID(this.d_nameMap, mat.getName(), rampKey);
            ramps.put(name, ((IHeatBasedValue.Custom)val).value);
            rec.setValue(rampKey, name, false);
        }
    }
}

