/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3d;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDSObjRenderer;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class HoleRenderer
extends AFDSObjRenderer<IHole> {
    public static final double EXPANSION_SCALE = 0.1;
    private final PinConnectionRenderer d_pinConns;
    private final List<Pair<Grid, AABox>> d_grids;

    public HoleRenderer(FDSRasterization raster, PinConnectionRenderer pinConns) {
        super(raster);
        this.d_pinConns = pinConns;
        this.d_grids = new ArrayList<Pair<Grid, AABox>>();
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(IHole.class);
        types.add(Grid.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, Collection<? extends IPyroObject> objs) {
        for (Grid grid : theUtil.filter(objs, Grid.class)) {
            if (grid.getXDivisions().length == 0 || grid.getYDivisions().length == 0 || grid.getZDivisions().length == 0) continue;
            this.d_grids.add(new Pair<Grid, AABox>(grid, HoleRenderer.getGridTestBounds(grid)));
        }
        return super.render(props, theUtil.filter(objs, IHole.class));
    }

    @Override
    protected boolean renderBlock(IFDSRecordRenderer props, AABoxGeom geom, Collection<IHole> srcObjs, FaceProps[] faceProps) {
        Color[] colors = new Color[faceProps.length];
        for (int m = 0; m < faceProps.length; ++m) {
            colors[m] = faceProps[m].color;
        }
        return this.renderBlock(props, (IGeom)geom, srcObjs.iterator().next(), colors);
    }

    @Override
    protected boolean renderBlock(IFDSRecordRenderer props, IHole obj) {
        return this.renderBlock(props, obj.getGeom().flatten().getLocalGeom(), obj, obj.getColors());
    }

    private boolean renderBlock(IFDSRecordRenderer props, IGeom geom, IHole propSource, Color[] colors) {
        FDSRenderRecord rec = FDS6Const.newRenderRecord("HOLE");
        rec.setValue("ID", propSource.getName());
        rec.setComment(propSource.getDesc());
        geom = this.finalizeGeom(props.props(), geom);
        HoleRenderer.renderAABox(rec, "XB", geom.getBoundingBox(new AABox()));
        HoleRenderer.renderEvac(rec, "EVACUATION", "MESH_ID", propSource.getEvac());
        HoleRenderer.renderColor(rec, propSource.isVisible(), colors[0], "RGB", "COLOR", "TRANSPARENCY");
        HoleRenderer.renderCustomFDSProps(rec, propSource);
        this.d_pinConns.markForInputRetrieval(propSource.getInputPin(), rec, "CTRL_ID", "DEVC_ID");
        this.d_pinConns.renderConnections(props, propSource);
        return true;
    }

    private IGeom finalizeGeom(FDSRenderProps props, IGeom geom) {
        AABox bounds = geom.getBoundingBox(new AABox());
        double[] expansions = new double[6];
        Arrays.fill(expansions, Double.MAX_VALUE);
        boolean modified = false;
        for (Pair<Grid, AABox> pair : this.d_grids) {
            Grid grid = (Grid)pair.v1;
            AABox gridTestBounds = (AABox)pair.v2;
            if (!bounds.test((AABox)gridTestBounds, (double)1.0E-9).positive) continue;
            AABox gridBounds = grid.getBounds();
            modified |= this.testExpansion(expansions, 0, bounds.getMinX(), gridBounds.getMinX(), grid.getXDivisions());
            modified |= this.testExpansion(expansions, 1, bounds.getMaxX(), gridBounds.getMaxX(), grid.getXDivisions());
            modified |= this.testExpansion(expansions, 2, bounds.getMinY(), gridBounds.getMinY(), grid.getYDivisions());
            modified |= this.testExpansion(expansions, 3, bounds.getMaxY(), gridBounds.getMaxY(), grid.getYDivisions());
            modified |= this.testExpansion(expansions, 4, bounds.getMinZ(), gridBounds.getMinZ(), grid.getZDivisions());
            modified |= this.testExpansion(expansions, 5, bounds.getMaxZ(), gridBounds.getMaxZ(), grid.getZDivisions());
        }
        if (!modified || !props.expandBoundaryHoles()) {
            return geom;
        }
        double[] vals = new double[]{bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY(), bounds.getMinZ(), bounds.getMaxZ()};
        for (int m = 0; m < expansions.length; ++m) {
            double amount = expansions[m];
            if (amount == Double.MAX_VALUE) continue;
            if (m % 2 == 0) {
                int n = m;
                vals[n] = vals[n] - amount;
                continue;
            }
            int n = m;
            vals[n] = vals[n] + amount;
        }
        short swizzle = geom instanceof AABoxGeom ? ((AABoxGeom)geom).swizzle : (short)0;
        return new AABoxGeom(new Point3d(vals[0], vals[2], vals[4]), new Point3d(vals[1], vals[3], vals[5]), swizzle);
    }

    private boolean testExpansion(double[] expansions, int ix, double geomVal, double meshVal, UnitDouble[] divs) {
        if (ix % 2 == 0) {
            double div = divs[0].getValue(Geometry.LU);
            if (geomVal < meshVal + div * 0.5 && geomVal > meshVal - div * 0.1) {
                double expansion = geomVal - (meshVal - div * 0.1);
                if (expansion < expansions[ix]) {
                    expansions[ix] = expansion;
                }
                return true;
            }
        } else {
            double div = divs[divs.length - 1].getValue(Geometry.LU);
            if (geomVal > meshVal - div * 0.5 && geomVal < meshVal + div * 0.1) {
                double expansion = meshVal + div * 0.1 - geomVal;
                if (expansion < expansions[ix]) {
                    expansions[ix] = expansion;
                }
                return true;
            }
        }
        return false;
    }

    private static AABox getGridTestBounds(Grid grid) {
        AABox gridBounds = grid.getBounds();
        AABox gridTestBounds = new AABox(gridBounds.getMinX() + grid.getXDivisions()[0].getValue(Geometry.LU) * 0.5, gridBounds.getMinY() + grid.getYDivisions()[0].getValue(Geometry.LU) * 0.5, gridBounds.getMinZ() + grid.getZDivisions()[0].getValue(Geometry.LU) * 0.5, gridBounds.getMaxX() - grid.getXDivisions()[grid.getXDivisions().length - 1].getValue(Geometry.LU) * 0.5, gridBounds.getMaxY() - grid.getYDivisions()[grid.getYDivisions().length - 1].getValue(Geometry.LU) * 0.5, gridBounds.getMaxZ() - grid.getZDivisions()[grid.getZDivisions().length - 1].getValue(Geometry.LU) * 0.5);
        return gridTestBounds;
    }
}

