/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.gui.grid.RegularGridCreator;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;

public class GridRenderer_legacy
extends AFDS6Renderer {
    private int d_gridIx = 0;

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Grid.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        Grid obj = (Grid)o;
        this.writeMeshRecord(props, obj);
        if (!RegularGridCreator.isUniform(obj.getXDivisions())) {
            this.writeTRNRecords(props, obj, "TRNX", obj.getMinPoint().xu(), obj.getMaxPoint().xu(), obj.getXDivisions());
        }
        if (!RegularGridCreator.isUniform(obj.getYDivisions())) {
            this.writeTRNRecords(props, obj, "TRNY", obj.getMinPoint().yu(), obj.getMaxPoint().yu(), obj.getYDivisions());
        }
        if (!RegularGridCreator.isUniform(obj.getZDivisions())) {
            this.writeTRNRecords(props, obj, "TRNZ", obj.getMinPoint().zu(), obj.getMaxPoint().zu(), obj.getZDivisions());
        }
        ++this.d_gridIx;
        return true;
    }

    private void writeMeshRecord(IFDSRecordRenderer props, Grid obj) {
        FDSRenderRecord rec = FDS6Const.newRenderRecord("MESH");
        rec.setValue("ID", obj.getName());
        rec.setValue("FYI", obj.getFYI(), false);
        GridRenderer_legacy.renderColor(rec, true, obj.getColor(), "RGB", "COLOR", null);
        FDSArray<Object> ijk = new FDSArray<Object>(obj.getXDivisions().length, obj.getYDivisions().length, obj.getZDivisions().length);
        rec.setValue("IJK", ijk);
        GridRenderer_legacy.renderXB(rec, "XB", obj.getMinPoint(), obj.getMaxPoint());
        if (obj.getEvacuation()) {
            rec.setValue("EVACUATION", obj.getEvacuation());
            rec.setValue("EVAC_HUMANS", obj.getEvacHumans(), false);
            rec.setValue("EVAC_Z_OFFSET", obj.getEvacZOffset(), true);
        }
        GridRenderer_legacy.renderCustomFDSProps(rec, obj);
        props.render(rec, obj);
    }

    private void writeTRNRecords(IFDSRecordRenderer props, Grid grid, String recName, UnitDouble minu, UnitDouble maxu, UnitDouble[] divisions) {
        if (divisions.length <= 0) {
            return;
        }
        double[] vals = new double[divisions.length];
        Unit u = SIUS.getInstance().getLengthUnit();
        for (int i = 0; i < divisions.length; ++i) {
            vals[i] = divisions[i].getValue(u);
        }
        double min = minu.getValue(u);
        double max = maxu.getValue(u);
        double ccMult = (max - min) / (double)vals.length;
        double numSame = 1.0;
        double sizeLast = vals[0];
        double pc = min + sizeLast;
        double ccLast = min;
        for (int m = 1; m < vals.length; ++m) {
            if (vals[m] == sizeLast) {
                numSame += 1.0;
            } else {
                double ccCurrent = ccLast + numSame * ccMult;
                FDSRenderRecord trnRec = FDS6Const.newRenderRecord(recName);
                trnRec.setComment(grid.getName());
                trnRec.setValue("CC", new UnitDouble(ccCurrent, u));
                trnRec.setValue("PC", new UnitDouble(pc, u));
                trnRec.setValue("MESH_NUMBER", this.d_gridIx + 1);
                props.render(trnRec, grid);
                numSame = 1.0;
                sizeLast = vals[m];
                ccLast = ccCurrent;
            }
            pc += vals[m];
        }
    }
}

