/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.util.Set;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.evac.Door;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class DoorRenderer
extends AFDS6Renderer {
    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> types) {
        types.add(Door.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer props, IPyroObject o) {
        Grid flowFieldId;
        Grid meshId;
        Door obj = (Door)o;
        FDSRenderRecord rec = FDS6Const.newRenderRecord("DOOR");
        rec.setValue("ID", obj.getName());
        rec.setValue("FYI", obj.getProp("FYI"), false);
        UnitDouble[] xb = (UnitDouble[])obj.getProp("XB");
        UnitAABox xbBox = new UnitAABox(new UnitPoint3D(xb[0], xb[2], xb[4]), new UnitPoint3D(xb[1], xb[3], xb[5]));
        DoorRenderer.renderXB(rec, "XB", xbBox.getMin(), xbBox.getMax());
        UnitDouble[] xyz = (UnitDouble[])obj.getProp("XYZ");
        if (xyz != null) {
            UnitPoint3D xyzPt = new UnitPoint3D(xyz[0], xyz[1], xyz[2]);
            AFDS6Renderer.renderLoc(rec, "XYZ", xyzPt);
        }
        if ((meshId = (Grid)obj.getProp("MESH_ID")) != null) {
            rec.setValue("MESH_ID", meshId.getName());
        }
        Integer ior = (Integer)obj.getProp("IOR");
        rec.setValue("IOR", ior, false);
        NamedPyroObject toNode = (NamedPyroObject)obj.getProp("TO_NODE");
        if (toNode != null) {
            rec.setValue("TO_NODE", toNode.getName());
        }
        Boolean exitSign = (Boolean)obj.getProp("EXIT_SIGN");
        rec.setValue("EXIT_SIGN", exitSign, false);
        Boolean keepXy = (Boolean)obj.getProp("KEEP_XY");
        rec.setValue("KEEP_XY", keepXy, false);
        Grid ventFfield = (Grid)obj.getProp("VENT_FFIELD");
        if (ventFfield != null) {
            rec.setValue("VENT_FFIELD", ventFfield.getName());
        }
        if ((flowFieldId = (Grid)obj.getProp("FLOW_FIELD_ID")) != null) {
            rec.setValue("FLOW_FIELD_ID", flowFieldId.getName());
        }
        Color c = (Color)obj.getProp("RGB");
        DoorRenderer.renderColor(rec, true, c, "RGB", "COLOR", null);
        UnitDouble timeOpen = (UnitDouble)obj.getProp("TIME_OPEN");
        rec.setValue("TIME_OPEN", timeOpen);
        UnitDouble timeClose = (UnitDouble)obj.getProp("TIME_CLOSE");
        rec.setValue("TIME_CLOSE", timeClose);
        props.render(rec, o);
        return true;
    }
}

