/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.ExSpec;
import pyrosim.domain.INamed;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.appearance.MaterialCache;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.domain.boundcond.surf.AirFlow;
import pyrosim.domain.boundcond.surf.Backing;
import pyrosim.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.domain.boundcond.surf.Fuel;
import pyrosim.domain.boundcond.surf.GeneralSurfDesc;
import pyrosim.domain.boundcond.surf.HeatRelease;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ISurfDesc;
import pyrosim.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.LeakSurfDesc;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.boundcond.surf.SpeciesInjection;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.TempRegulation;
import pyrosim.domain.boundcond.surf.ZonePath;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.zones.Zone;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.ZoneParser;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.image.IImage;
import thunderheadeng.io.IOUtil;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Lists;

public class SurfaceParser
extends AFDS6Parser {
    private final ZoneParser d_zoneParser;
    private final MaterialCache d_appearanceCache;

    public SurfaceParser(FDS6ParsingInfo parsingInfo, ZoneParser zoneParser) {
        super(parsingInfo);
        this.d_zoneParser = zoneParser;
        this.d_appearanceCache = new MaterialCache(this.getContainer().getAppearances().flatten());
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("SURF");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("C_FORCED_CONSTANT", "UNSUPPORTED");
        unsupportedFields.put("C_FORCED_RE", "UNSUPPORTED");
        unsupportedFields.put("C_FORCED_PR_EXP", "UNSUPPORTED");
        unsupportedFields.put("C_FORCED_RE_EXP", "UNSUPPORTED");
        unsupportedFields.put("C_HORIZONTAL", "UNSUPPORTED");
        unsupportedFields.put("C_VERTICAL", "UNSUPPORTED");
        unsupportedFields.put("CELL_SIZE_FACTOR", "UNSUPPORTED");
        unsupportedFields.put("CONVECTION_LENGTH_SCALE", "UNSUPPORTED");
        unsupportedFields.put("CONVERT_VOLUME_TO_MASS", "UNSUPPORTED");
        unsupportedFields.put("EMISSIVITY_BACK", "UNSUPPORTED");
        unsupportedFields.put("EVAC_DEFAULT", "UNSUPPORTED");
        unsupportedFields.put("FREE_SLIP", "UNSUPPORTED");
        unsupportedFields.put("HEAT_TRANSFER_COEFFICIENT_BACK", "UNSUPPORTED");
        unsupportedFields.put("INTERNAL_HEAT_SOURCE", "UNSUPPORTED");
        unsupportedFields.put("MASS_FLUX_VAR", "UNSUPPORTED");
        unsupportedFields.put("MASS_TRANSFER_COEFFICIENT", "UNSUPPORTED");
        unsupportedFields.put("MINIMUM_LAYER_THICKNESS", "UNSUPPORTED");
        unsupportedFields.put("N_LAYER_CELLS_MAX", "UNSUPPORTED");
        unsupportedFields.put("NO_SLIP", "UNSUPPORTED");
        unsupportedFields.put("RAMP_T_I", "UNSUPPORTED");
        unsupportedFields.put("RAMP_V_X", "UNSUPPORTED");
        unsupportedFields.put("RAMP_V_Y", "UNSUPPORTED");
        unsupportedFields.put("RAMP_V_Z", "UNSUPPORTED");
        unsupportedFields.put("ROUGHNESS", "UNSUPPORTED");
        unsupportedFields.put("SPREAD_RATE", "UNSUPPORTED");
        unsupportedFields.put("STRETCH_FACTOR", "UNSUPPORTED");
        unsupportedFields.put("TGA_ANALYSIS", "UNSUPPORTED");
        unsupportedFields.put("TGA_FINAL_TEMPERATURE", "UNSUPPORTED");
        unsupportedFields.put("TGA_HEATING_RATE", "UNSUPPORTED");
        unsupportedFields.put("VEL_BULK", "UNSUPPORTED");
        unsupportedFields.put("VEL_GRAD", "UNSUPPORTED");
        unsupportedFields.put("XYZ", "UNSUPPORTED");
        unsupportedFields.put("EXTERNAL_FLUX", "UNSUPPORTED");
        unsupportedFields.put("RAMP_EF", "UNSUPPORTED");
        unsupportedFields.put("TAU_EF", "UNSUPPORTED");
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String id = (String)rec.get("ID");
        if (!this.checkName(rec, id)) {
            return false;
        }
        String fyi = (String)rec.get("FYI");
        Boolean isDefault = (Boolean)rec.get("DEFAULT", true);
        Color color = this.parseColor(rec, "RGB", "COLOR", "TRANSPARENCY", true);
        Material appearance = this.parseAppearance(rec, color);
        ISurfDesc desc = this.parseSurfaceDesc(rec);
        Surface surf = new Surface(id, color, appearance, desc);
        if (fyi != null) {
            surf.setFYI(fyi);
        }
        this.parseCustomFDSProps(surf, rec);
        int exists = this.existsStatus(rec, surf, Surface.class);
        if (exists == 2) {
            id = this.parseName(rec, "ID", Surface.class);
            surf.setName(id);
            exists = this.existsStatus(rec, surf, Surface.class);
        }
        if (exists == 2) {
            Surface existingSurf;
            if (!surf.isPredefined()) {
                this.addWarning(rec, String.format(Intl.intl("Duplicate %1$s ID found: %2$s"), rec.getType(), surf.getName()), String.format(Intl.intl("Adding to additional records section."), rec.getType()));
            }
            if ((existingSurf = this.findObject(Surface.class, surf.getName())).isPredefined()) {
                if (isDefault.booleanValue()) {
                    this.addWarning(rec, Intl.intl("Non-inert predefined surfaces should not be set as the Default Surface."), Intl.intl("Ignoring record."));
                    exists = 1;
                } else {
                    this.addWarning(rec, String.format(Intl.intl("Duplicate %1$s ID found: %2$s"), rec.getType(), surf.getName()), String.format(Intl.intl("Adding to additional records section."), rec.getType()));
                }
            }
        }
        if (exists != 0) {
            return this.convertToReturn(exists);
        }
        this.getContainer().getSurfaceMgr().add(surf);
        if (isDefault.booleanValue()) {
            this.getContainer().getSimParams().getMisc().setSurfDefault(surf);
        }
        this.flagObjectAdded(surf);
        return true;
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        for (Material appearance : this.d_appearanceCache.getAddedMaterials()) {
            this.getContainer().getAppearances().add(appearance);
            this.flagObjectAdded(appearance);
        }
    }

    private Material parseAppearance(FDSParseRecord rec, Color surfColor) {
        Texture diffTex = this.parseTexture(rec, "TEXTURE_MAP");
        if (diffTex == null) {
            return null;
        }
        Color diffColor = new Color(255, 255, 255);
        int alpha = surfColor.getAlpha();
        Color opacColor = new Color(alpha, alpha, alpha);
        MatAttrs matAttrs = new MatAttrs(IMatAttrs.DIFFUSE_COLOR, diffColor, IMatAttrs.DIFFUSE_TEXTURE, diffTex, IMatAttrs.OPACITY_COLOR, opacColor);
        UnitDouble wid = (UnitDouble)rec.get("TEXTURE_WIDTH", true);
        UnitDouble ht = (UnitDouble)rec.get("TEXTURE_HEIGHT", true);
        String name = diffTex != null ? new File(diffTex.image.getFilename()).getName() : rec.getString("ID");
        Material mat = new Material(name, matAttrs, wid, ht);
        mat = this.d_appearanceCache.add(mat);
        return mat;
    }

    private Texture parseTexture(FDSParseRecord rec, String texKey) {
        String texFn = (String)rec.get(texKey, false);
        if (texFn == null) {
            return null;
        }
        FDS6ParsingInfo pi = this.getParsingInfo();
        File imageFile = null;
        if (pi.getParsingFile() != null) {
            imageFile = IOUtil.resolvePath(texFn, new File(pi.getParsingFile()), true);
        } else {
            imageFile = new File(texFn);
            if (!imageFile.exists() || !imageFile.isFile()) {
                imageFile = null;
            }
        }
        if (imageFile == null) {
            this.addWarning(rec, String.format(Intl.intl("Unable to resolve texture path: %s"), texFn), Intl.intl("Texture Removed"));
            return null;
        }
        IImage img = MaterialDB.loadImage(imageFile.getAbsolutePath());
        if (img == null) {
            this.addWarning(rec, String.format(Intl.intl("Unable to load image for texture: %s"), imageFile.getAbsolutePath()), Intl.intl("Texture Removed"));
            return null;
        }
        return Texture.repeated(img, "uvset");
    }

    private ISurfDesc parseSurfaceDesc(FDSParseRecord rec) throws FDSRecordFormatException {
        ParticleInjection partInj = this.parsePartInj(rec);
        SpecInjList specInj = this.parseSpeciesInjection(rec);
        HeatRelease heatRelease = this.parseHeatRelease(rec);
        Fuel.IReaction reac = this.parseReaction(rec, heatRelease);
        SurfComposition surfComp = this.parseSurfComposition(rec);
        TempRegulation tempReg = this.parseTempRegulation(rec);
        ZonePath leakPath = this.parseZonePath(rec, "LEAK_PATH");
        boolean[] intake = new boolean[1];
        AirFlow airFlow = this.parseAirFlow(rec, null, intake, false);
        IGeometry geom = this.parseGeometry(rec);
        if (!surfComp.d_layers.isEmpty()) {
            if (airFlow != null) {
                this.addWarning(rec, Intl.intl("Forced air flow information cannot be specified on layered surfaces."), Intl.intl("Ignoring forced air flow information."));
            }
            if (tempReg == null) {
                tempReg = TempRegulation.newDefault();
            }
            assert (reac != null);
            boolean burnAway = (Boolean)rec.get("BURN_AWAY", true);
            return new LayeredSurfDesc(geom, null, reac, surfComp, specInj, partInj, burnAway, leakPath, tempReg);
        }
        if (heatRelease != null && airFlow == null && specInj == null) {
            if (leakPath != null) {
                this.addWarning(rec, Intl.intl("Burners cannot have a LEAK_PATH."), Intl.intl("Ignoring LEAK_PATH."));
            }
            if (tempReg == null) {
                tempReg = TempRegulation.newDefault();
            }
            BurnerSurfDesc burnerDesc = new BurnerSurfDesc(heatRelease, partInj, tempReg, geom);
            return burnerDesc;
        }
        airFlow = this.parseAirFlow(rec, specInj, intake, true);
        if (!(airFlow == null || heatRelease != null || intake[0] && specInj != null)) {
            if (leakPath != null) {
                this.addWarning(rec, Intl.intl("LEAK_PATH is not allowed on exhaust and supply surfaces."), Intl.intl("Ignoring LEAK_PATH."));
            }
            if (tempReg == null) {
                tempReg = TempRegulation.newDefault();
            }
            if (intake[0] && geom.equals(IGeometry.DEFAULT)) {
                return new InFlowSurfDesc(airFlow, tempReg);
            }
            if (!intake[0]) {
                return new BlowerSurfDesc(tempReg, airFlow, partInj, geom);
            }
        }
        if (tempReg != null && heatRelease == null && airFlow == null) {
            if (leakPath != null) {
                this.addWarning(rec, Intl.intl("LEAK_PATH is not allowed on temperature-regulated surfaces."), Intl.intl("Ignoring LEAK_PATH."));
            }
            return new ConstantTempSurfDesc(tempReg, partInj, geom);
        }
        if (tempReg != null || heatRelease != null || airFlow != null || partInj != null || specInj != null) {
            if (tempReg == null) {
                tempReg = TempRegulation.newDefault();
            }
            return new GeneralSurfDesc(tempReg, partInj, specInj, heatRelease, airFlow, geom);
        }
        if (leakPath != null) {
            return new LeakSurfDesc(leakPath);
        }
        return Surface.newBasicDesc();
    }

    private ZonePath parseZonePath(FDSParseRecord rec, String key) {
        int path2;
        if (!rec.contains(key)) {
            return null;
        }
        FDSArray ductPath = rec.getArray(key, true);
        int path1 = (Integer)ductPath.get(0);
        if (path1 == (path2 = ((Integer)ductPath.get(1)).intValue())) {
            this.addWarning(rec, String.format(Intl.intl("%s must specify two different ZONEs."), key), String.format(Intl.intl("Ignoring %s"), key));
            return null;
        }
        Zone zone1 = this.d_zoneParser.get(path1);
        Zone zone2 = this.d_zoneParser.get(path2);
        if (zone1 == null || zone2 == null) {
            int missingZone = zone1 == null ? path1 : path2;
            this.addWarning(rec, String.format(Intl.intl("Could not find ZONE %d."), missingZone), String.format(Intl.intl("Ignoring %s"), key));
            return null;
        }
        return new ZonePath(zone1, zone2);
    }

    private ParticleInjection parsePartInj(FDSParseRecord rec) {
        String partName = (String)rec.get("PART_ID");
        if (partName == null) {
            return null;
        }
        Particle particle = this.findObject(Particle.class, partName);
        if (particle == null) {
            this.addWarning(rec, String.format(Intl.intl("The particle, %s, could not be found in the model."), partName), Intl.intl("Ignoring particle."));
            return null;
        }
        int numPartsPerCell = (Integer)rec.get("NPPC", true);
        UnitDouble dtInsert = rec.getUnitDouble("DT_INSERT", true);
        TimeBasedValue<UnitDouble> massFlux = null;
        UnitDouble mf = (UnitDouble)rec.get("PARTICLE_MASS_FLUX", false);
        if (mf != null && mf.getValue(SIUS.unit(45)) > 0.0) {
            if (particle.isType(Particle.Type.TRACER)) {
                this.addWarning(rec, Intl.intl("A mass flux is specified for the particle, but the particle is massless."), Intl.intl("Ignoring mass flux."));
                massFlux = null;
            } else {
                TimeFunction tf = this.parseTimeFunction(rec, "TAU_PART", "RAMP_PART");
                massFlux = new TimeBasedValue<UnitDouble>(mf, tf);
            }
        }
        return new ParticleInjection(particle, numPartsPerCell, massFlux, dtInsert);
    }

    private SpecInjList parseSpeciesInjection(FDSParseRecord rec) {
        List massFracValues = rec.getList("MASS_FRACTION", false);
        List massFluxValues = rec.getList("MASS_FLUX", false);
        List specNames = rec.getList("SPEC_ID", false);
        int injType = -1;
        List values = null;
        if (massFracValues != null && Lists.containsNonNull(massFracValues)) {
            values = massFracValues;
            injType = 1;
        } else if (massFluxValues != null && Lists.containsNonNull(massFluxValues)) {
            values = massFluxValues;
            injType = 0;
        }
        if (values == null) {
            return null;
        }
        Object bgInj = null;
        List taus = rec.getList("TAU_MF", values.size(), false);
        List rampNames = rec.getList("RAMP_MF", values.size(), false);
        ArrayList<SpeciesInjection> injs = new ArrayList<SpeciesInjection>();
        for (int m = 0; m < values.size(); ++m) {
            Object value = values.get(m);
            if (value == null) continue;
            UnitDouble tau = (UnitDouble)taus.get(m);
            String rampName = (String)rampNames.get(m);
            TimeFunction tf = this.parseTimeFunction(rec, tau, rampName);
            ExSpec spec = this.getContainer().getExSpecList().get((String)specNames.get(m));
            if (spec == null) {
                this.addWarning(rec, String.format(Intl.intl("Species %d could not be found."), m), String.format(Intl.intl("Ignoring species %d."), m));
                continue;
            }
            injs.add(new SpeciesInjection(spec, value, tf));
        }
        if (bgInj == null && injs.isEmpty()) {
            return null;
        }
        return new SpecInjList(injType, injs);
    }

    private Backing parseBacking(FDSParseRecord rec) {
        String backingStr = (String)rec.get("BACKING", true);
        if (backingStr.equals("VOID")) {
            UnitDouble airTemp = (UnitDouble)rec.get("TMP_BACK", true);
            return new Backing.AirGap(airTemp);
        }
        if (backingStr.equals("EXPOSED")) {
            return Backing.EXPOSED;
        }
        if (backingStr.equals("INSULATED")) {
            return Backing.INSULATED;
        }
        this.addWarning(rec, String.format(Intl.intl("%s is not a recognized surface backing."), backingStr), String.format(Intl.intl("Ignoring backing."), new Object[0]));
        return Backing.newDefault();
    }

    private HeatRelease parseHeatRelease(FDSParseRecord rec) {
        UnitDouble hrrpua = (UnitDouble)rec.get("HRRPUA", false);
        UnitDouble mlrpua = rec.getUnitDouble("MLRPUA", false);
        if (hrrpua == null && mlrpua == null) {
            return null;
        }
        UnitDouble extCoeff = (UnitDouble)rec.get("E_COEFFICIENT", true);
        TimeFunction func = this.parseTimeFunction(rec, "TAU_Q", "RAMP_Q");
        if (hrrpua != null && mlrpua != null) {
            this.addWarning(rec, String.format(Intl.intl("%1$s and %2$s should not both be specified for a surface."), "HRRPUA", "MLRPUA"), String.format(Intl.intl("Ignoring %s."), "MLRPUA"));
        }
        HeatRelease.Type type = hrrpua != null ? new HeatRelease.HRRType(hrrpua, func) : new HeatRelease.MLRType(mlrpua, func);
        return new HeatRelease(type, extCoeff);
    }

    private IGeometry parseGeometry(FDSParseRecord rec) {
        boolean dim;
        UnitDouble length = rec.getUnitDouble("LENGTH", true);
        UnitDouble width = rec.getUnitDouble("WIDTH", true);
        UnitDouble inner = rec.getUnitDouble("INNER_RADIUS", false);
        UnitDouble radius = rec.getUnitDouble("RADIUS", false);
        boolean bl = dim = length != null || width != null || inner != null || radius != null;
        if (!dim && !rec.contains("GEOMETRY")) {
            return IGeometry.DEFAULT;
        }
        String geomType = rec.getString("GEOMETRY");
        if (geomType == null) {
            geomType = "CARTESIAN";
        }
        boolean thick = rec.contains("THICKNESS");
        if (geomType.equals("CARTESIAN")) {
            UnitDouble thickness = null;
            if (thick && !rec.contains("MATL_MASS_FRACTION")) {
                FDSArray thicknesses = rec.getArray("THICKNESS", true);
                thickness = (UnitDouble)thicknesses.get(0);
            }
            if (length != null && width == null || length == null && width != null) {
                this.addWarning(rec, String.format(Intl.intl("%s and %s should both be specified for a surface with geometry."), "LENGTH", "WIDTH"), Intl.intl("Ignoring geometry for surface."));
                return IGeometry.DEFAULT;
            }
            if (length != null && width != null && !thick) {
                this.addWarning(rec, Intl.intl("THICKNESS must be defined for surfaces with CARTESIAN geometry."), Intl.intl("Ignoring geometry for surface."));
                return IGeometry.DEFAULT;
            }
            return new IGeometry.Cartesian(length, width, thickness);
        }
        if (geomType.equals("SPHERICAL")) {
            if (radius != null && inner != null) {
                if (rec.contains("THICKNESS")) {
                    this.addWarning(rec, Intl.intl("Only one of INNER_RADIUS and RADIUS needs to be defined for a surface geometry."), Intl.intl("Dropping RADIUS from surface."));
                    radius = null;
                } else {
                    this.addWarning(rec, Intl.intl("Only one of INNER_RADIUS and RADIUS needs to be defined for a surface geometry."), Intl.intl("Dropping INNER_RADIUS from surface."));
                    inner = null;
                }
            } else if (radius == null && inner == null) {
                inner = rec.getUnitDouble("INNER_RADIUS", true);
            }
            if (inner != null && !thick) {
                this.addWarning(rec, Intl.intl("Thickness must be defined for spherical geometry defined by the inner radius."), Intl.intl("Ignoring geometry for surface."));
                return IGeometry.DEFAULT;
            }
            return new IGeometry.Spherical(inner, radius);
        }
        if (geomType.equals("CYLINDRICAL")) {
            if (radius != null && inner != null) {
                if (thick) {
                    this.addWarning(rec, Intl.intl("Only one of INNER_RADIUS and RADIUS needs to be defined for a surface geometry."), Intl.intl("Dropping RADIUS from surface."));
                    radius = null;
                } else {
                    this.addWarning(rec, Intl.intl("Only one of INNER_RADIUS and RADIUS needs to be defined for a surface geometry."), Intl.intl("Dropping INNER_RADIUS from surface."));
                    inner = null;
                }
            } else if (radius == null && inner == null) {
                if (thick && !rec.contains("MATL_ID")) {
                    FDSArray thicknesses = rec.getArray("THICKNESS", true);
                    radius = (UnitDouble)thicknesses.get(0);
                }
                if (radius == null) {
                    inner = rec.getUnitDouble("INNER_RADIUS", true);
                }
            }
            if (inner != null && !thick) {
                this.addWarning(rec, Intl.intl("Thickness must be defined for cylindrical geometry defined by the inner radius."), Intl.intl("Ignoring geometry for surface."));
                return IGeometry.DEFAULT;
            }
            Variant lengthVar = length != null ? Variant.constant(length) : Variant.DEFAULT;
            return new IGeometry.Cylindrical(inner, radius, lengthVar);
        }
        return null;
    }

    private TempRegulation parseTempRegulation(FDSParseRecord rec) throws FDSRecordFormatException {
        if (!(rec.contains("ADIABATIC") || rec.contains("TMP_FRONT") || rec.contains("NET_HEAT_FLUX") || rec.contains("CONVECTIVE_HEAT_FLUX") || rec.contains("HEAT_TRANSFER_MODEL") || rec.contains("EMISSIVITY") || rec.contains("HEAT_TRANSFER_COEFFICIENT"))) {
            return null;
        }
        boolean log = false;
        if (rec.contains("HEAT_TRANSFER_MODEL") && rec.getString("HEAT_TRANSFER_MODEL").equals("LOGLAW")) {
            log = true;
        }
        UnitDouble htCoef = null;
        if (rec.contains("HEAT_TRANSFER_COEFFICIENT")) {
            htCoef = rec.getUnitDouble("HEAT_TRANSFER_COEFFICIENT", true);
        }
        double emissivity = (Double)rec.get("EMISSIVITY", true);
        boolean adiabatic = (Boolean)rec.get("ADIABATIC", true);
        if (adiabatic) {
            return TempRegulation.newAdiabaticTR(htCoef, log);
        }
        if (rec.contains("NET_HEAT_FLUX")) {
            if (rec.contains("CONVECTIVE_HEAT_FLUX")) {
                throw new FDSRecordFormatException(Intl.intl("SURFs may not specify both a NET_HEAT_FLUX and CONVECTIVE_HEAT FLUX"));
            }
            if (rec.contains("TMP_FRONT")) {
                this.addWarning(rec, Intl.intl("SURF records should not specify TMP_FRONT with NET_HEAT_FLUX"), Intl.intl("Ignoring TMP_FRONT and ADIABATIC"));
            }
            UnitDouble netHeatFlux = rec.getUnitDouble("NET_HEAT_FLUX", true);
            TimeFunction netFluxRamp = this.parseTimeFunction(rec, "TAU_Q", "RAMP_Q");
            return TempRegulation.newNetHeatFluxTR(netHeatFlux, netFluxRamp, emissivity, htCoef, log);
        }
        UnitDouble temperature = rec.getUnitDouble("TMP_FRONT", true);
        TimeFunction tempRamp = this.parseTimeFunction(rec, "TAU_T", "RAMP_T");
        if (rec.contains("CONVECTIVE_HEAT_FLUX")) {
            if (rec.contains("NET_HEAT_FLUX")) {
                throw new FDSRecordFormatException(Intl.intl("SURFs may not specify both a NET_HEAT_FLUX and CONVECTIVE_HEAT FLUX"));
            }
            UnitDouble convHeatFlux = rec.getUnitDouble("CONVECTIVE_HEAT_FLUX", true);
            TimeFunction convFluxRamp = this.parseTimeFunction(rec, "TAU_Q", "RAMP_Q");
            return TempRegulation.newFixedHeatFluxTR(temperature, tempRamp, convHeatFlux, convFluxRamp, emissivity, htCoef, log);
        }
        return TempRegulation.newFixedTempTR(temperature, tempRamp, emissivity, htCoef, log);
    }

    private AirFlow parseAirFlow(FDSParseRecord rec, SpecInjList si, boolean[] intake, boolean finalPass) throws FDSRecordFormatException {
        AirFlow.IProfile profile;
        AirFlow.Rate rate;
        UnitDouble normalVel = (UnitDouble)rec.get("VEL", false);
        UnitDouble volFlux = null;
        if (rec.contains("VOLUME_FLOW")) {
            volFlux = (UnitDouble)rec.get("VOLUME_FLOW", false);
        } else if (rec.contains("VOLUME_FLUX")) {
            volFlux = (UnitDouble)rec.get("VOLUME_FLUX", false);
        }
        UnitDouble massFluxTot = (UnitDouble)rec.get("MASS_FLUX_TOTAL", false);
        if (massFluxTot != null && massFluxTot.getValueNoUnit() < 0.0) {
            if (finalPass) {
                this.addWarning(rec, String.format(Intl.intl("%s cannot be a negative value."), "MASS_FLUX_TOTAL"), String.format(Intl.intl("%s set to 0."), "MASS_FLUX_TOTAL"));
            }
            massFluxTot = SIUS.newud(0.0, 45);
        }
        if (normalVel == null && volFlux == null && massFluxTot == null && si == null) {
            return null;
        }
        int specCount = 0;
        if (normalVel != null) {
            ++specCount;
        }
        if (volFlux != null) {
            ++specCount;
        }
        if (massFluxTot != null) {
            ++specCount;
        }
        if (specCount > 1) {
            this.addWarning(rec, String.format(Intl.intl("Only one of %1$s, %2$s, and %3$s can be specified for a surface."), "VEL", "VOLUME_FLUX", "MASS_FLUX_TOTAL"), String.format(Intl.intl("Using %s."), "VEL"));
        }
        TimeFunction func = this.parseTimeFunction(rec, "TAU_V", "RAMP_V");
        FDSArray tanVel = rec.getArray("VEL_T", true);
        if (normalVel != null) {
            normalVel = this.extractFlowRate(normalVel, intake);
            si = this.validateForcedAirSpecInj(rec, si, "VEL", intake[0]);
            rate = new AirFlow.NormalVel(normalVel, (UnitDouble)tanVel.get(0), (UnitDouble)tanVel.get(1), func, si);
        } else if (volFlux != null) {
            volFlux = this.extractFlowRate(volFlux, intake);
            si = this.validateForcedAirSpecInj(rec, si, "VOLUME_FLUX", intake[0]);
            rate = new AirFlow.VolumeFlux(volFlux, (UnitDouble)tanVel.get(0), (UnitDouble)tanVel.get(1), func, si);
        } else if (massFluxTot != null) {
            massFluxTot = this.extractFlowRate(massFluxTot, intake);
            si = this.validateForcedAirSpecInj(rec, si, "MASS_FLUX_TOTAL", intake[0]);
            rate = new AirFlow.TotalMassFlux(massFluxTot, (UnitDouble)tanVel.get(0), (UnitDouble)tanVel.get(1), func, si);
        } else {
            assert (si != null);
            intake[0] = false;
            if (si.injType == 0) {
                if (!func.equals(TimeFunction.newDefault())) {
                    func = TimeFunction.newDefault();
                    if (finalPass) {
                        this.addWarning(rec, Intl.intl("Ramp Up Time is invalid when specifying mass flux on a per species basis."), Intl.intl("Ignoring Ramp Up Time."));
                    }
                }
                rate = new AirFlow.ExSpecMassFlux((UnitDouble)tanVel.get(0), (UnitDouble)tanVel.get(1), func, si);
            } else {
                rate = new AirFlow.NormalVel(SIUS.newud(0.0, 8), (UnitDouble)tanVel.get(0), (UnitDouble)tanVel.get(1), func, si);
            }
        }
        String profileName = (String)rec.get("PROFILE", true);
        if (profileName == null || profileName.equals(FDS6Const.TOP_HAT)) {
            profile = new AirFlow.TopHatProf();
        } else if (profileName.equals("PARABOLIC")) {
            profile = new AirFlow.ParabolicProf();
        } else if (profileName.equals("ATMOSPHERIC")) {
            UnitDouble origin = (UnitDouble)rec.get("Z0", true);
            double exp = (Double)rec.get("PLE", true);
            profile = new AirFlow.AtmosphericProf(exp, origin);
        } else {
            this.addWarning(rec, String.format(Intl.intl("%s is not a recognized wind profile."), profileName), Intl.intl("Using a top hat wind profile."));
            profile = new AirFlow.TopHatProf();
        }
        return new AirFlow(rate, profile);
    }

    private UnitDouble extractFlowRate(UnitDouble rate, boolean[] intake) {
        if (Double.valueOf(rate.getValueNoUnit()).compareTo(0.0) < 0) {
            intake[0] = false;
            return rate.negate();
        }
        intake[0] = true;
        return rate;
    }

    private SpecInjList validateForcedAirSpecInj(FDSParseRecord rec, SpecInjList spec, String valKey, boolean intake) {
        if (spec != null && spec.injType == 0) {
            this.addWarning(rec, String.format(Intl.intl("%1$s cannot be specified with %2$s"), valKey, "MASS_FLUX"), Intl.intl("Ignoring species for surface."));
            return null;
        }
        return spec;
    }

    private static boolean valsEqualZero(UnitDouble ... vals) {
        for (UnitDouble val : vals) {
            if (val == null || val.getValueNoUnit() == 0.0) continue;
            return false;
        }
        return true;
    }

    private Fuel.IReaction parseReaction(FDSParseRecord rec, HeatRelease heatRelease) {
        if (heatRelease == null) {
            return new Fuel.MaterialReac();
        }
        UnitDouble igTemp = (UnitDouble)rec.get("IGNITION_TEMPERATURE", false);
        Fuel.ManualReac.IIgnition ignition = igTemp != null ? new Fuel.ManualReac.TemperatureIgnite(igTemp) : new Fuel.ManualReac.ImmediateIgnite();
        UnitDouble heatOfVap = (UnitDouble)rec.get("HEAT_OF_VAPORIZATION", false);
        return new Fuel.ManualReac(heatRelease, heatOfVap, ignition);
    }

    private SurfComposition parseSurfComposition(FDSParseRecord rec) throws FDSRecordFormatException {
        List<SurfComposition.SurfLayer> layers = this.parseLayers(rec);
        UnitDouble innerTemp = (UnitDouble)rec.get("TMP_INNER", true);
        TimeFunction tempRamp = this.parseTimeFunction(rec, "TAU_T", "RAMP_T");
        Backing backing = this.parseBacking(rec);
        Double layerDivide = rec.getDouble("LAYER_DIVIDE", true);
        if (layerDivide != null) {
            String warnMsg = Intl.intl("LAYER_DIVIDE should be >= 0 and <= number of layers.");
            if (layerDivide < 0.0) {
                layerDivide = null;
                this.addWarning(rec, warnMsg, Intl.intl("Using the default LAYER_DIVIDE value."));
            } else if (layerDivide > (double)layers.size()) {
                layerDivide = layers.size();
                this.addWarning(rec, warnMsg, String.format(Intl.intl("Clamped the LAYER_DIVIDE to %d."), layers.size()));
            }
        }
        return new SurfComposition(innerTemp, tempRamp, backing, layerDivide, layers);
    }

    private List<SurfComposition.SurfLayer> parseLayers(FDSParseRecord rec) throws FDSRecordFormatException {
        ArrayList<SurfComposition.SurfLayer> layers = new ArrayList<SurfComposition.SurfLayer>();
        FDSArray matIDs = rec.getArray("MATL_ID", false);
        if (matIDs == null || !matIDs.containsNonNull()) {
            return layers;
        }
        FDSArray thicknesses = rec.getArray("THICKNESS", true);
        FDSArray massFracs = rec.getArray("MATL_MASS_FRACTION", true);
        for (int layerix = 0; layerix < FDS6Const.SURF_LAYER_DIMENSIONS[0]; ++layerix) {
            UnitDouble thickness = (UnitDouble)thicknesses.get(layerix);
            double totalFracSpecified = 0.0;
            ArrayList<SurfComposition.SurfLayer.SurfComponent> comps = new ArrayList<SurfComposition.SurfLayer.SurfComponent>();
            ArrayList<pyrosim.domain.boundcond.mat.Material> noMassFracMats = new ArrayList<pyrosim.domain.boundcond.mat.Material>();
            for (int compix = 0; compix < FDS6Const.SURF_LAYER_DIMENSIONS[1]; ++compix) {
                String matid = (String)matIDs.get(layerix, compix);
                if (matid == null) continue;
                pyrosim.domain.boundcond.mat.Material mat = this.findObject(pyrosim.domain.boundcond.mat.Material.class, matid);
                if (mat == null) {
                    throw new FDSRecordFormatException(rec, String.format(Intl.intl("Could not find MATL %s."), matid));
                }
                Double massFrac = (Double)massFracs.get(layerix, compix);
                if (massFrac == null) {
                    noMassFracMats.add(mat);
                    continue;
                }
                totalFracSpecified += massFrac.doubleValue();
                comps.add(new SurfComposition.SurfLayer.SurfComponent(massFrac, mat));
            }
            if (comps.isEmpty() && noMassFracMats.isEmpty()) continue;
            if (comps.isEmpty() && noMassFracMats.size() == 1) {
                comps.add(new SurfComposition.SurfLayer.SurfComponent(1.0, (pyrosim.domain.boundcond.mat.Material)noMassFracMats.get(0)));
            } else {
                if (totalFracSpecified > 1.0000001) {
                    throw new FDSRecordFormatException(rec, String.format(Intl.intl("Material mass fractions in layer %d add to more than 1."), layerix + 1));
                }
                if (totalFracSpecified < 0.9999999 && noMassFracMats.isEmpty()) {
                    throw new FDSRecordFormatException(rec, String.format(Intl.intl("Material mass fractions in layer %d add to less than 1."), layerix + 1));
                }
                if (!noMassFracMats.isEmpty()) {
                    this.addWarning(rec, String.format(Intl.intl("A mass fraction was not specified for every material in layer %d."), layerix + 1), String.format(Intl.intl("Distributing remaining mass fraction evenly among materials with no specified mass fraction."), layerix + 1));
                    double distFrac = (1.0 - totalFracSpecified) / (double)noMassFracMats.size();
                    if (distFrac != 0.0) {
                        for (pyrosim.domain.boundcond.mat.Material mat : noMassFracMats) {
                            comps.add(new SurfComposition.SurfLayer.SurfComponent(distFrac, mat));
                        }
                    }
                }
            }
            layers.add(new SurfComposition.SurfLayer(thickness, comps));
        }
        return layers;
    }

    @Override
    protected <T extends INamed> int existsStatus(FDSParseRecord rec, T obj, Class<T> clazz) {
        if (!this.getNames(clazz).isRegistered(obj.getName())) {
            return 0;
        }
        T existingInFile = this.findReplacementObject(clazz, obj.getName());
        if (existingInFile == null) {
            return 0;
        }
        T existing = this.findObject(clazz, obj.getName());
        if (existing != null && existing.equals(obj)) {
            return 1;
        }
        return 2;
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
        String rampData = PyroSimObjectInputStream.migrateBurnerTempRegToAdvanced(this.getParsingInfo().getContainer().getSurfaceMgr().flatten(), null);
        this.getParsingInfo().getContainer().setUnprocessedRecords(this.getParsingInfo().getContainer().getUnprocessedRecords() + rampData);
    }
}

