/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.output.ProfList;
import pyrosim.domain.output.ProfRec;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class ProfParser
extends AFDS6Parser {
    public ProfParser(FDS6ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("PROF");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        int WARN_IOR = 2;
        int WARN_QUANTITY = 4;
        int WARN_XYZ = 8;
        int warn = 0;
        if (!rec.contains("IOR")) {
            warn |= 2;
        }
        if (!rec.contains("QUANTITY")) {
            warn |= 4;
        }
        if (!rec.contains("XYZ")) {
            warn |= 8;
        }
        String act = Intl.intl("PROF Record Ignored");
        if ((warn & 2) > 0) {
            this.addWarning(rec, Intl.intl("Unable to process PROF record: IOR missing"), act);
        }
        if ((warn & 4) > 0) {
            this.addWarning(rec, Intl.intl("Unable to process PROF record: QUANTITY missing"), act);
        }
        if ((warn & 8) > 0) {
            this.addWarning(rec, Intl.intl("Unable to process PROF record: XYZ missing"), act);
        }
        if (warn > 0) {
            return false;
        }
        String id = this.getValidName(rec, "ID", ProfRec.class);
        IQuantity qMsre = this.parseQuantity(rec, "QUANTITY", null, null, null, null, null, 256L, act, true, false, true);
        if (qMsre == null) {
            return false;
        }
        int ior = rec.getInteger("IOR");
        FDSArray xyz = rec.getArray("XYZ", true);
        UnitPoint3D xyzPt = new UnitPoint3D((UnitDouble)xyz.get(0), (UnitDouble)xyz.get(1), (UnitDouble)xyz.get(2));
        ProfRec prof = new ProfRec(id, ior, qMsre, xyzPt);
        int exists = this.existsStatus(rec, prof, ProfRec.class);
        if (exists != 0) {
            return this.convertToReturn(exists);
        }
        ProfList profList = this.getContainer().getProfList();
        profList.add(prof);
        this.flagObjectAdded(prof);
        return true;
    }
}

