/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.domain.APyroObject;
import pyrosim.domain.AWriteablePyroObject;
import pyrosim.domain.FloorManager;
import pyrosim.domain.Grid;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.AndOp;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.NotOp;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacLeak;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.view.ViewList;
import pyrosim.gui.actions.ExportPyroFloorsAction;
import pyrosim.gui.actions.ExportPyroViewsAction;
import pyrosim.io.GE1File;
import pyrosim.io.PyroGeomFile;
import pyrosim.io.fds.FDSEnabledFilter;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.INIWriter;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.RTree;
import thunderheadeng.image.IImage;
import thunderheadeng.image.Image;
import thunderheadeng.io.FileSystem;
import thunderheadeng.io.streamsrc.IStreamSrc;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Sets;
import thunderheadeng.util.theUtil;

public abstract class FDSRenderer {
    private final PyroMod d_model;
    private final FDSRenderProps d_props;

    public Collection<IPyroObject> collectPyroObjects() {
        LinkedIdentityHashSet objs = new LinkedIdentityHashSet();
        objs.add(this.d_model.getSimParams());
        objs.addAll(this.d_model.getObstructions().flatten());
        objs.addAll(this.d_model.getGridManager().flatten());
        objs.addAll(this.d_model.getBridges().flatten());
        objs.addAll(Util.sort(this.d_model.getZoneMgr()));
        objs.addAll(Util.sort(this.d_model.getExSpecList().getInitialFractions()));
        if (this.d_model.getExSpecList().getBackgroundSpecies() != null) {
            objs.add(this.d_model.getExSpecList().getBackgroundSpecies());
        }
        objs.addAll(this.d_model.getReactions().getActiveReactions());
        objs.addAll(((APyroObject)this.d_model.getHvacList()).flatten(HvacLeak.class));
        objs.addAll(this.d_model.getDevices().flatten());
        objs.add(this.d_model.getBoundaryOutput());
        objs.add(this.d_model.getPlot3d());
        objs.addAll(this.d_model.getIsofList().flatten());
        objs.addAll(this.d_model.getProfList().flatten());
        objs.addAll(this.d_model.getSlcfList().flatten());
        objs.addAll(this.d_model.getSlcf3dList().flatten());
        objs.addAll(this.d_model.getMsrStatMgr().flatten());
        objs.addAll(this.d_model.getViews().flatten());
        if (this.d_model.getFdsEvacEnabled()) {
            objs.addAll(this.d_model.getPersList().flatten());
            objs.addAll(this.d_model.getExitList().flatten());
            objs.addAll(this.d_model.getEvacList().flatten());
            objs.addAll(this.d_model.getEntrList().flatten());
            objs.addAll(this.d_model.getEvhoList().flatten());
            objs.addAll(this.d_model.getDoorList().flatten());
            objs.addAll(this.d_model.getCorrList().flatten());
            objs.addAll(this.d_model.getEvssList().flatten());
        }
        objs.addAll(this.collectForceToWriteObjs());
        assert (!objs.contains(null));
        return theUtil.filter(objs, new FDSEnabledFilter());
    }

    private Collection<IPyroObject> collectForceToWriteObjs() {
        ArrayList<IPyroObject> objs = new ArrayList<IPyroObject>();
        Predicate<IPyroObject> p = o -> o instanceof AWriteablePyroObject && ((AWriteablePyroObject)o).isForceWrite();
        objs.addAll(this.d_model.getExSpecList().flatten(p));
        objs.addAll(this.d_model.getReactions().flatten(p));
        objs.addAll(this.d_model.getSurfaceMgr().flatten(p));
        objs.addAll(this.d_model.getMaterialMgr().flatten(p));
        objs.addAll(this.d_model.getPartList().flatten(p));
        objs.addAll(this.d_model.getHeatLinkModels().flatten(p));
        objs.addAll(this.d_model.getSmokeLinkModels().flatten(p));
        objs.addAll(this.d_model.getSprinklerLinkModels().flatten(p));
        objs.addAll(this.d_model.getSprayModels().flatten(p));
        objs.addAll(this.d_model.getHvacList().flatten(p));
        return objs;
    }

    public abstract void renderObjects(IFDSRecordRenderer var1, Collection<? extends IPyroObject> var2, DepSnapshot var3, Map<IImage, String> var4);

    protected abstract void renderFileForVersion(File var1, Collection<? extends IPyroObject> var2, DepSnapshot var3) throws IOException;

    protected FDSRenderer(PyroMod model, FDSRenderProps props) {
        this.d_model = model;
        this.d_props = props.clone();
    }

    public FDSRenderProps getProps() {
        return this.d_props;
    }

    protected PyroMod getModel() {
        return this.d_model;
    }

    public void renderFile(File file) throws IOException {
        this.renderFile(file, this.collectPyroObjects());
    }

    public void renderFile(File file, Collection<? extends IPyroObject> pyroObjects) throws IOException {
        Prep fobjs = this.prepareObjs(pyroObjects, PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEPYROGEOM), this.d_model.getUnprocessedRecords());
        this.renderFileForVersion(file, fobjs.objs, fobjs.deps);
    }

    public void renderAllObjects(IFDSRecordRenderer props, Map<IImage, String> imgFilenames) {
        Collection<IPyroObject> allObjs = this.collectPyroObjects();
        this.renderObjects(props, allObjs, imgFilenames);
    }

    public void renderObjects(IFDSRecordRenderer props, Collection<? extends IPyroObject> objs, Map<IImage, String> imgFilenames) {
        Prep prep = this.prepareObjs(objs, false, "");
        this.renderObjects(props, prep.objs, prep.deps, imgFilenames);
    }

    private static boolean getAdditionalRecordsHasGeom(String unproc) {
        if (unproc.isEmpty()) {
            return false;
        }
        try {
            HashSet<String> types = Sets.fromArrayHS("OBST", "HOLE", "VENT");
            Pattern recPattern = Pattern.compile("&\\s*([a-zA-Z0-9]+)[^/&]*/");
            Matcher matcher = recPattern.matcher(unproc);
            while (matcher.find()) {
                String type = matcher.group(1);
                if (!types.contains(type.toUpperCase())) continue;
                return true;
            }
        }
        catch (Throwable t) {
            assert (false);
            t.printStackTrace();
        }
        return false;
    }

    public Prep prepareObjs(Collection<? extends IPyroObject> objs, boolean writePyroGeom, String unprocRecords) {
        ArrayList<IPyroObject> objList = new ArrayList<IPyroObject>(objs);
        if (writePyroGeom || this.d_model.getRastOptions().immersedBoundary) {
            this.d_props.setLinkPyroGeom(!FDSRenderer.getAdditionalRecordsHasGeom(unprocRecords));
            FDSRenderer.splitObstructions(this.d_props, this.d_model.getRastOptions(), objList);
        }
        DepSnapshot dp = new DepSnapshot();
        for (IPyroObject obj : objList) {
            dp.takeSnapshot(obj);
        }
        return new Prep(objList, dp);
    }

    protected static boolean writeGE1(File outDir, String filename, PyroMod model, Map<IImage, String> imgFilenames) throws IOException {
        return GE1File.writeFile(new File(outDir, filename).getAbsolutePath(), model, imgFilenames);
    }

    private static Predicate<IHole> getPrecutHoleFilter(RasterizationOptions rastOptions, boolean pyroGeomLinked) {
        boolean immersed = rastOptions.immersedBoundary;
        if (immersed) {
            return Filters.alwaysTrue();
        }
        if (!pyroGeomLinked) {
            return Filters.alwaysFalse();
        }
        return h -> !h.getInputPin().getConnections().isEmpty();
    }

    protected static boolean writeGeom(File outDir, String filename, PyroMod model, Collection<? extends IPyroObject> allObjs, boolean linked, Map<IObstruction, List<Integer>> obstIxes, Map<Vent, Integer> ventIxes, boolean force) throws IOException {
        Predicate<IHole> holeFilter = FDSRenderer.getPrecutHoleFilter(model.getRastOptions(), linked).negate();
        return PyroGeomFile.write(outDir, filename, model, allObjs, linked, obstIxes, ventIxes, force, holeFilter);
    }

    private static void splitObstructions(FDSRenderProps props, RasterizationOptions rastOptions, List<IPyroObject> objs) {
        IFilteredCollection<IHole> precutHoles = theUtil.filter(objs, IHole.class, FDSRenderer.getPrecutHoleFilter(rastOptions, props.getLinkPyroGeom()));
        if (precutHoles.isEmpty()) {
            return;
        }
        RTree<IHole> holeSearch = new RTree<IHole>();
        for (IHole hole : precutHoles) {
            holeSearch.insert(hole.getBounds(), hole);
        }
        List<IHole> toRemove = Collections.synchronizedList(new ArrayList<IHole>(precutHoles));
        List<Pair> toAdd = Collections.synchronizedList(new ArrayList());
        Function<ISignalSink, ControlBridge> getCtrlBridge = o -> {
            ControlBridge octrl;
            if (!o.getInputPin().getConnections().isEmpty() && !(octrl = (ControlBridge)o.getInputPin().getConnectedSources().iterator().next()).getInputPin().getConnections().isEmpty()) {
                return octrl;
            }
            return null;
        };
        ExecutorService threads = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (int m = 0; m < objs.size(); ++m) {
            IPyroObject obj = objs.get(m);
            if (!(obj instanceof IObstruction)) continue;
            IObstruction obst = (IObstruction)obj;
            threads.submit(() -> {
                Supplier<Collection<? extends IHole>> getNearHoles = () -> {
                    ArrayList potHoles = new ArrayList();
                    holeSearch.find(new AABoxTest(obst.getBounds(), 1.0E-6), (h, ctmt) -> potHoles.add(h));
                    return potHoles;
                };
                List<Pair<IObstruction, IHole>> resultObsts = obst.intersectHoles(getNearHoles);
                if (resultObsts.isEmpty()) {
                    return;
                }
                toRemove.add((IHole)obj);
                for (Pair<IObstruction, IHole> pair : resultObsts) {
                    if (pair.v2 != null && getCtrlBridge.apply((ISignalSink)pair.v2) == null) continue;
                    toAdd.add(pair);
                }
            });
        }
        threads.shutdown();
        try {
            threads.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        objs.removeAll(toRemove);
        HashMap<Pair, ControlBridge> newCtrls = new HashMap<Pair, ControlBridge>();
        for (Pair p : toAdd) {
            IObstruction obst = (IObstruction)p.v1;
            IHole hole = (IHole)p.v2;
            if (hole != null) {
                ControlBridge holeCtrl = getCtrlBridge.apply(hole);
                assert (holeCtrl != null);
                ControlBridge obstCtrl = getCtrlBridge.apply(obst);
                ControlBridge ctrl = newCtrls.computeIfAbsent(new Pair<ControlBridge, ControlBridge>(obstCtrl, holeCtrl), pair -> {
                    String bridgeName = String.format("%s_invert", holeCtrl.getName());
                    AControl newLogic = new NotOp();
                    newLogic.getInputPin().connect(holeCtrl.getInputPin().getConnections().iterator().next());
                    if (obstCtrl != null) {
                        bridgeName = String.format("%s_and_%s", obstCtrl.getName(), bridgeName);
                        AndOp and = new AndOp();
                        and.getInputPin().connect(newLogic.getOutputPins().get(0));
                        and.getInputPin().connect(obstCtrl.getInputPin().getConnections().iterator().next());
                        newLogic = and;
                    }
                    ControlBridge ictrl = new ControlBridge(bridgeName);
                    ictrl.getInputPin().connect(newLogic.getOutputPins().get(0));
                    return ictrl;
                });
                obst.getInputPin().disconnectAll();
                obst.getInputPin().connect(ctrl.getOutputPins().get(0));
            }
            objs.add(obst);
        }
    }

    protected static void write(File outDir, String filename, boolean writeGE1, Collection<? extends IPyroObject> objs) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(outDir, filename)));){
            AABox gridBounds = new AABox();
            for (Grid grid : Hierarchy.flatten(objs, Grid.class)) {
                gridBounds.add(grid.getBounds());
            }
            INIWriter writer = new INIWriter(gridBounds);
            writer.write(out, writeGE1, PyroPrefs.getBoolean(PyroPrefs.RESULTS_DISPLAYGE1), !PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEVIEWS), objs);
        }
    }

    protected static void writeViews(File outDir, String filename, ViewList views) {
        try {
            ExportPyroViewsAction.writeViewsFile(new File(outDir, filename), views);
        }
        catch (IOException e) {
            System.out.println(String.format("Could not write file: %s", filename));
        }
    }

    protected static void writeFloors(File outDir, String filename, FloorManager floors) {
        try {
            ExportPyroFloorsAction.writeFloorsFile(new File(outDir, filename), floors);
        }
        catch (IOException e) {
            System.out.println(String.format("Could not write file: %s", filename));
        }
    }

    protected static Map<IImage, String> copyImages(MaterialDB texDB, File outDir, Collection<? extends IPyroObject> objs) {
        LinkedIdentityHashMap<IImage, String> imgFNMap = new LinkedIdentityHashMap<IImage, String>();
        for (Surface surface : theUtil.filter(objs, Surface.class)) {
            Texture tex;
            Material ti = surface.getAppearance();
            if (ti == null || (tex = ti.getAttributes().getTexture(MatChannel.DIFFUSE)) == null) continue;
            imgFNMap.put(tex.image, null);
        }
        for (Map.Entry entry : imgFNMap.entrySet()) {
            IImage img = (IImage)entry.getKey();
            String fn = FDSRenderer.writeImage(outDir, img.getFilename(), img);
            entry.setValue(fn);
        }
        return imgFNMap;
    }

    protected static String writeImage(File outDir, String imgName, IImage img) {
        File imageFile = new File(img.getFilename());
        String imageName = imageFile.getName();
        File outputImageFile = new File(outDir, imageName);
        int saveOptions = 1;
        if (!outputImageFile.exists()) {
            System.out.printf("Saving image %s...", imageName);
            img.save(outputImageFile.getAbsolutePath(), saveOptions);
            System.out.println("Done");
        } else if (FDSRenderer.getWriteAlternateImage(img, outputImageFile)) {
            String imageNameAlt = String.format("%d-%dx%d.png", imgName.hashCode(), img.getWidth(), img.getHeight());
            outputImageFile = new File(outDir, imageNameAlt);
            System.out.printf("A file called \"%s\" already exists! Using alternate name \"%s\"%n", imageName, imageNameAlt);
            img.save(outputImageFile.getPath(), saveOptions);
            imageName = imageNameAlt;
        }
        return imageName;
    }

    private static boolean getWriteAlternateImage(IImage img, File outputImageFile) {
        String outPath = outputImageFile.getPath();
        IStreamSrc src = FileSystem.INSTANCE.getStreamSrc(outPath, 3);
        try {
            Image existing = Image.load(outPath, src);
            if (img.makeHashable().equals(existing)) {
                System.out.printf("Image \"%s\" already exists and is equal. Write skipped.%n", outputImageFile.getName());
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static String getProperCHID(String requestedCHID, int maxChidLength) {
        if (requestedCHID == null) {
            return null;
        }
        String newCHID = requestedCHID.trim();
        File temp = new File(newCHID);
        int extIndex = (newCHID = temp.getName()).lastIndexOf(46);
        if (extIndex >= 0) {
            newCHID = newCHID.substring(0, extIndex);
        }
        newCHID = newCHID.replace('.', '_');
        if ((newCHID = newCHID.replace(' ', '_')).length() > maxChidLength) {
            newCHID = newCHID.substring(0, maxChidLength);
        }
        return newCHID;
    }

    public static String getProperTitle(String requestedTitle, int maxTitleLength) {
        if (requestedTitle == null) {
            return null;
        }
        String newTitle = requestedTitle.trim();
        if (newTitle.length() > maxTitleLength) {
            newTitle = newTitle.substring(0, maxTitleLength);
        }
        return newTitle;
    }

    public static class Prep {
        public final Collection<? extends IPyroObject> objs;
        public final DepSnapshot deps;

        public Prep(Collection<? extends IPyroObject> objs, DepSnapshot deps) {
            this.objs = objs;
            this.deps = deps;
        }
    }

    public static class Filenames {
        public final File dir;
        public final String chid;
        public final String fds;
        public final String ge1;
        public final String geom;
        public final String ini;
        public final String views;
        public final String floors;

        public Filenames(File fdsFile) {
            String filename;
            this.fds = filename = fdsFile.getName();
            this.dir = fdsFile.getParentFile();
            this.chid = FDSRenderer.getProperCHID(filename, 50);
            this.ge1 = this.chid + ".ge1";
            this.geom = this.chid + ".pyrogeom";
            this.ini = this.chid + ".ini";
            this.views = this.chid + '.' + "views";
            this.floors = this.chid + '.' + "pyrofloors";
        }
    }
}

