/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Stack;
import java.util.function.Function;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.io.fds.EnabledFilter;
import thunderheadeng.util.Formatter;
import thunderheadeng.util.theUtil;

public class FDSRenderProps
implements Cloneable {
    private Stack<Object> d_propStack;
    private final String d_newline;
    private boolean d_mergeFDSCells = true;
    private boolean d_expandBoundaryHoles = false;
    private boolean d_linkPyroGeom = true;
    private IDecimalFormatter d_formatter = new ScientificFormatter();
    private boolean d_renderMultiLine = false;
    private String d_fieldSep = ", ";
    private IRasterGridSupplier d_getRasterGrids = FDSRenderProps::getDefaultRasterGrids;

    public FDSRenderProps() {
        this.d_propStack = new Stack();
        this.d_newline = System.getProperty("line.separator");
    }

    public static Collection<Grid> getDefaultRasterGrids(Collection<? extends IPyroObject> renderObjs) {
        return theUtil.filter(renderObjs, Grid.class, new EnabledFilter());
    }

    public FDSRenderProps clone() {
        try {
            FDSRenderProps clone = (FDSRenderProps)super.clone();
            clone.d_propStack = new Stack();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    public void imprint(FDSRenderProps props) {
        props.pushProps();
        this.popProps(props.d_propStack);
    }

    public String getNewline() {
        return this.d_newline;
    }

    public void pushProps() {
        this.d_propStack.push(this.d_formatter);
        this.d_propStack.push(this.d_renderMultiLine);
        this.d_propStack.push(this.d_fieldSep);
        this.d_propStack.push(this.d_mergeFDSCells);
        this.d_propStack.push(this.d_expandBoundaryHoles);
        this.d_propStack.push(this.d_getRasterGrids);
        this.d_propStack.push(this.d_linkPyroGeom);
    }

    public void popProps() {
        this.popProps(this.d_propStack);
    }

    public Stack<Object> getProps() {
        return this.d_propStack;
    }

    private void popProps(Stack<Object> propStack) {
        this.d_linkPyroGeom = (Boolean)propStack.pop();
        this.d_getRasterGrids = (IRasterGridSupplier)propStack.pop();
        this.d_expandBoundaryHoles = (Boolean)propStack.pop();
        this.d_mergeFDSCells = (Boolean)propStack.pop();
        this.d_fieldSep = (String)propStack.pop();
        this.d_renderMultiLine = (Boolean)propStack.pop();
        this.d_formatter = (IDecimalFormatter)propStack.pop();
    }

    public void setRasterGridSupplier(IRasterGridSupplier func) {
        this.d_getRasterGrids = func;
    }

    public IRasterGridSupplier getRasterGridSupplier() {
        return this.d_getRasterGrids;
    }

    public boolean expandBoundaryHoles() {
        return this.d_expandBoundaryHoles;
    }

    public void setExpandBoundaryHoles(boolean expand) {
        this.d_expandBoundaryHoles = expand;
    }

    public boolean getLinkPyroGeom() {
        return this.d_linkPyroGeom;
    }

    public void setLinkPyroGeom(boolean link) {
        this.d_linkPyroGeom = link;
    }

    public boolean mergeFDSCells() {
        return this.d_mergeFDSCells;
    }

    public void setMergeFDSCells(boolean merge) {
        this.d_mergeFDSCells = merge;
    }

    public void setDecimalFormatter(IDecimalFormatter formatter) {
        this.d_formatter = formatter;
    }

    public IDecimalFormatter getDecimalFormatter() {
        return this.d_formatter;
    }

    public boolean renderMultiLine() {
        return this.d_renderMultiLine;
    }

    public void setRenderMultiLine(boolean multiLine) {
        this.d_renderMultiLine = multiLine;
        this.d_fieldSep = this.d_renderMultiLine ? "," + this.d_newline + "      " : ", ";
    }

    public String getFieldSep() {
        return this.d_fieldSep;
    }

    public String renderDouble(double val) {
        return this.d_formatter.format(val);
    }

    public static class AlignedFormatter
    implements IDecimalFormatter {
        public final int width;
        public final int numDecimals;
        private final DecimalFormat d_format;

        public AlignedFormatter(int width, int numDecimals) {
            this.width = width;
            this.numDecimals = numDecimals;
            this.d_format = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
            char[] pattern = new char[numDecimals + 2];
            Arrays.fill(pattern, '0');
            pattern[1] = 46;
            this.d_format.applyPattern(new String(pattern));
        }

        @Override
        public String format(double val) {
            int m;
            String result = this.d_format.format(val);
            if (result.length() >= this.width) {
                return result;
            }
            char[] chars = new char[this.width];
            int end = this.width - result.length();
            for (m = 0; m < end; ++m) {
                chars[m] = 32;
            }
            for (m = end; m < this.width; ++m) {
                chars[m] = result.charAt(m - end);
            }
            return new String(chars);
        }
    }

    public static class GeneralFormatter
    implements IDecimalFormatter {
        private final Formatter d_formatter;
        public final int precision;

        public GeneralFormatter(int precision) {
            this.precision = precision;
            this.d_formatter = new Formatter(Locale.US);
        }

        @Override
        public String format(double val) {
            return this.d_formatter.format(val, this.precision);
        }
    }

    @Deprecated
    public static class EasyReadFormatter
    implements IDecimalFormatter {
        private static final DecimalFormat DECIMAL_FORMAT_4 = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        private static final DecimalFormat DECIMAL_FORMAT_2;

        @Override
        public String format(double val) {
            if (Math.abs(val) >= 0.01 && Math.abs(val) <= 0.4999) {
                return DECIMAL_FORMAT_4.format(val);
            }
            if (Math.abs(val) >= 0.5 && Math.abs(val) <= 999.0 || val == 0.0) {
                return DECIMAL_FORMAT_2.format(val);
            }
            return ScientificFormatter.SCIENTIFIC_FORMAT.format(val);
        }

        static {
            DECIMAL_FORMAT_4.applyPattern("0.0000");
            DECIMAL_FORMAT_2 = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
            DECIMAL_FORMAT_2.applyPattern("0.00");
        }
    }

    public static class ScientificFormatter
    implements IDecimalFormatter {
        private static final DecimalFormat SCIENTIFIC_FORMAT = (DecimalFormat)DecimalFormat.getInstance(Locale.US);

        @Override
        public String format(double val) {
            return SCIENTIFIC_FORMAT.format(val);
        }

        static {
            SCIENTIFIC_FORMAT.applyPattern("0.0000000E000");
        }
    }

    public static interface IDecimalFormatter {
        public String format(double var1);
    }

    public static interface IRasterGridSupplier
    extends Function<Collection<? extends IPyroObject>, Collection<Grid>> {
    }
}

