/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.io.fds.FDSGrammar;
import pyrosim.io.fds.FDSParseException;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseResult;
import pyrosim.io.fds.FDSParsingInfo;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.FDSStringRenderer;
import pyrosim.io.fds.IFDSRecordParser;
import thunderheadeng.io.TextFileEncoding;

public abstract class FDSParser {
    protected abstract FDSParsingInfo createParsingInfo(String var1, PyroMod var2, PyroMod var3);

    protected abstract List<? extends IFDSRecordParser> createParsers(FDSParsingInfo var1);

    protected abstract Map<String, FDSRecordSpec> getRecordSpecs();

    protected abstract String getFinishRecType();

    public FDSParseResult parseFile(String filename, PyroMod model) throws IOException, FDSParseException {
        return this.parseFile(filename, model, model);
    }

    public FDSParseResult parseFile(String filename, PyroMod writeModel, PyroMod readModel) throws IOException, FDSParseException {
        CharSequence buffer = FDSParser.getBufferFromFile(filename);
        return this.parseBuffer(filename, buffer, writeModel, readModel);
    }

    public FDSParseResult parseBuffer(CharSequence buffer, PyroMod model) throws IOException, FDSParseException {
        return this.parseBuffer(buffer, model, model);
    }

    public FDSParseResult parseBuffer(CharSequence buffer, PyroMod writeModel, PyroMod readModel) throws IOException, FDSParseException {
        return this.parseBuffer(null, buffer, writeModel, readModel);
    }

    public FDSParseResult parseRecords(List<FDSParseRecord> recs, PyroMod model) throws IOException, FDSParseException {
        return this.parseRecords(recs, model, model);
    }

    public FDSParseResult parseRecords(List<FDSParseRecord> recs, PyroMod writeModel, PyroMod readModel) throws IOException, FDSParseException {
        FDSParsingInfo pi = this.createParsingInfo(null, writeModel, readModel);
        this.parseRecords(recs, (String)null, pi);
        return pi.getParseResult();
    }

    protected FDSParseResult parseBuffer(String filename, CharSequence buffer, PyroMod writeModel, PyroMod readModel) throws IOException, FDSParseException {
        FDSParsingInfo pi = this.createParsingInfo(filename, writeModel, readModel);
        return this.parseBuffer(filename, buffer, pi);
    }

    protected FDSParseResult parseBuffer(String filename, CharSequence buffer, FDSParsingInfo pi) throws IOException, FDSParseException {
        List<FDSParseRecord> records = FDSGrammar.parse(buffer, filename, pi.getParseResult().warningReport, this.getRecordSpecs(), this.getFinishRecType());
        this.parseRecords(records, null, pi);
        return pi.getParseResult();
    }

    /*
     * Exception decompiling
     */
    protected static CharSequence getBufferFromFile(String filename) throws IOException, UnsupportedEncodingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void parseRecords(List<FDSParseRecord> records, String filename, FDSParsingInfo parsingInfo) throws IOException, FDSParseException {
        parsingInfo.getContainer().pauseUpdates(false);
        this.parse(parsingInfo, records);
        if (!parsingInfo.getParseResult().unparsedRecords.isEmpty()) {
            String unprocessedRecordsStr = parsingInfo.getContainer().getUnprocessedRecords();
            FDSStringRenderer props = new FDSStringRenderer(unprocessedRecordsStr, new FDSRenderProps());
            for (FDSParseRecord rec : parsingInfo.getParseResult().unparsedRecords) {
                FDSRenderRecord renRec = FDSRenderRecord.fromParseRecord(rec);
                props.render(renRec, null);
            }
            parsingInfo.getContainer().setUnprocessedRecords(props.toString());
        }
        parsingInfo.getContainer().resumeUpdates();
        parsingInfo.getContainer().getEvents().changed(parsingInfo.getContainer(), PyroMod.EVT_FILENAME_CHANGED, PyroMod.EVT_MODEL_CHANGED);
    }

    private void parse(FDSParsingInfo pi, List<FDSParseRecord> recs) throws FDSParseException {
        List<? extends IFDSRecordParser> parsers = this.createParsers(pi);
        IdentityHashMap parserRecMap = new IdentityHashMap();
        for (IFDSRecordParser iFDSRecordParser : parsers) {
            parserRecMap.put(iFDSRecordParser, new ArrayList());
        }
        HashMap<String, ArrayList<IFDSRecordParser>> typeParserMap = new HashMap<String, ArrayList<IFDSRecordParser>>();
        HashMap<String, LinkedHashMap<String, String>> hashMap = new HashMap<String, LinkedHashMap<String, String>>();
        for (IFDSRecordParser iFDSRecordParser : parsers) {
            HashSet<String> types = new HashSet<String>();
            iFDSRecordParser.getRecordTypes(types);
            for (String type : types) {
                ArrayList<IFDSRecordParser> typeParsers = (ArrayList<IFDSRecordParser>)typeParserMap.get(type);
                if (typeParsers == null) {
                    typeParsers = new ArrayList<IFDSRecordParser>();
                    typeParserMap.put(type, typeParsers);
                }
                typeParsers.add(iFDSRecordParser);
                LinkedHashMap<String, String> unsupportedFields = (LinkedHashMap<String, String>)hashMap.get(type);
                if (unsupportedFields == null) {
                    unsupportedFields = new LinkedHashMap<String, String>();
                    hashMap.put(type, unsupportedFields);
                }
                iFDSRecordParser.getUnsupportedFields(type, unsupportedFields);
            }
        }
        for (FDSParseRecord fDSParseRecord : recs) {
            List typeParsers = (List)typeParserMap.get(fDSParseRecord.getType());
            if (typeParsers == null) {
                pi.addWarning(fDSParseRecord, String.format(Intl.intl("%s records are not yet supported."), fDSParseRecord.getType()), Intl.intl("Adding to additional records section."));
                pi.getParseResult().unparsedRecords.add(fDSParseRecord);
                continue;
            }
            for (IFDSRecordParser parser : typeParsers) {
                ((List)parserRecMap.get(parser)).add(fDSParseRecord);
            }
        }
        ArrayDeque<Runnable> postProcessActions = new ArrayDeque<Runnable>();
        Set<FDSParseRecord> set = pi.getParseResult().unparsedRecords;
        for (IFDSRecordParser iFDSRecordParser : parsers) {
            List records = (List)parserRecMap.get(iFDSRecordParser);
            iFDSRecordParser.process(records, set);
            for (FDSParseRecord rec : records) {
                if (rec.getAdditionalRec() == null) continue;
                postProcessActions.add(rec.getAdditionalRec());
                rec.setAdditionalRecord(null);
            }
        }
        for (Runnable runnable : postProcessActions) {
            runnable.run();
        }
        for (IFDSRecordParser iFDSRecordParser : parsers) {
            iFDSRecordParser.postProcess();
        }
        for (FDSParseRecord fDSParseRecord : recs) {
            if (pi.getParseResult().unparsedRecords.contains(fDSParseRecord)) continue;
            LinkedHashMap unsupportedFields = new LinkedHashMap((Map)hashMap.get(fDSParseRecord.getType()));
            unsupportedFields.keySet().retainAll(fDSParseRecord.getProperties().keySet());
            if (unsupportedFields.isEmpty()) continue;
            HashMap fields = new HashMap();
            for (Map.Entry unsupportedEntr : unsupportedFields.entrySet()) {
                String fieldsStr;
                if (!fields.containsKey(unsupportedEntr.getValue())) {
                    fields.put(unsupportedEntr.getValue(), "");
                }
                if ((fieldsStr = (String)fields.get(unsupportedEntr.getValue())).length() > 0) {
                    fieldsStr = fieldsStr + ", ";
                }
                fieldsStr = fieldsStr + (String)unsupportedEntr.getKey();
                fields.put(unsupportedEntr.getValue(), fieldsStr);
            }
            for (Map.Entry warning : fields.entrySet()) {
                String action;
                String msg;
                if (((String)warning.getKey()).equals("UNSUPPORTED")) {
                    msg = String.format(Intl.intl("These fields are not yet supported: %s"), warning.getValue());
                    action = pi.getParseResult().extractedUnsupportedRecs.contains(fDSParseRecord) ? "<html><p>" + Intl.intl("Adding to <b>Additional Fields</b> of extracted object.") + "</p></html>" : Intl.intl("Ignoring unsupported fields. Behavior of the model may change.");
                } else {
                    msg = String.format(Intl.intl("These fields are deprecated as of %s: %s"), warning.getKey(), warning.getValue());
                    action = Intl.intl("Ignoring unsupported fields. Behavior of the model may change.");
                }
                pi.addWarning(fDSParseRecord, msg, action);
            }
        }
    }

    private static /* synthetic */ String lambda$getBufferFromFile$412(TextFileEncoding e) {
        return e.name;
    }
}

