/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.zones;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.bridge.BridgeList;
import pyrosim.domain.zones.Leak;
import pyrosim.domain.zones.LeakUtil;
import pyrosim.domain.zones.Zone;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.AABoxGeomEditor;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.SortCache;

public class ZonePnl
extends guiPanel
implements IEditor<Zone> {
    private static final long serialVersionUID = -1186846390114269095L;
    private final guiTextField d_nameFld;
    private final ColorButton d_colorBtn;
    private final AABoxGeomEditor d_boxPnl;
    private final LeakTblMdl d_leakTblMdl;
    private final guiTable d_leakTable;
    private final PyroMod d_mediator;

    public ZonePnl(PyroMod mediator) {
        super(new GridBagLayout());
        this.d_mediator = mediator;
        guiLabel nameLbl = new guiLabel(Intl.intl("Name:"));
        this.d_nameFld = new guiTextField();
        this.d_nameFld.setEditable(false);
        guiLabel colorLbl = new guiLabel(Intl.intl("Color:"));
        this.d_colorBtn = new ColorButton();
        this.d_colorBtn.setMinimumSize(this.d_colorBtn.getPreferredSize());
        this.d_boxPnl = new AABoxGeomEditor(false, true);
        TitleSeparator geomLbl = new TitleSeparator(Intl.intl("Bounding Box"));
        TitleSeparator leakLbl = new TitleSeparator(Intl.intl("Leakage Areas"));
        this.d_leakTblMdl = new LeakTblMdl();
        this.d_leakTable = new guiTable((TableModel)this.d_leakTblMdl, 0);
        guiTableEditor tblEditor = new guiTableEditor(this.d_leakTable, 0);
        this.d_leakTable.setPreferredScrollableViewportSize(new Dimension(300, 100));
        int row = 0;
        GridBagUtil.add(this, nameLbl, 0, ++row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_nameFld, 1, row, 1, 1, 0, 6, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, colorLbl, 0, ++row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_colorBtn, 1, row, 1, 1, 0, 6, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, leakLbl, 0, ++row, 2, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, tblEditor, 0, ++row, 2, 1, 0, 12, 6, 0, 1, 1.0, 1.0, 17);
        GridBagUtil.add(this, geomLbl, 0, ++row, 2, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, this.d_boxPnl, 0, ++row, 2, 1, 0, 12, 0, 0, 2, 1.0, 0.0, 17);
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public Zone preview(Zone previewObj) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.save(previewObj);
        return previewObj;
    }

    @Override
    public void init(Zone dataObj) {
        this.setEnabled(dataObj != null && !dataObj.isOuter());
        if (dataObj != null) {
            this.d_nameFld.setText(dataObj.getName());
            this.d_colorBtn.setColor(dataObj.getColor());
            this.d_boxPnl.load(new AABoxGeom(GeomUtil.getBounds(dataObj)));
            this.d_leakTblMdl.load(dataObj, this.d_mediator);
        }
        this.setModified(false);
    }

    @Override
    public Zone commit(final Zone dataObj) {
        if (dataObj.isOuter()) {
            return dataObj;
        }
        AOneTimeTask t = new AOneTimeTask(){

            @Override
            public void run() {
                ZonePnl.this.save(dataObj);
                ZonePnl.this.d_leakTblMdl.save(dataObj, PyroSim.getApp().getMediator().getBridges());
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(t, Intl.intl("Edit Zone"));
        this.setModified(false);
        return dataObj;
    }

    protected void save(Zone dataObj) {
        if (dataObj.isOuter()) {
            return;
        }
        dataObj.setColor(this.d_colorBtn.getColor());
        AABoxGeom boxGeom = this.d_boxPnl.save();
        dataObj.setBox(new UnitAABox(boxGeom.getBoundingBox(new AABox()), Geometry.LU));
    }

    public void previewLeakTblMdl(Zone zone, BridgeList bridges) {
        this.d_leakTblMdl.save(zone, bridges);
    }

    private static class LeakTblMdl
    extends AbstractTableModel {
        private static final long serialVersionUID = 7104561013331363347L;
        private static final int COL_ZONE = 0;
        private static final int COL_LEAK_AREA = 1;
        private final Unit d_areaUnit = PyroSim.getApp().getUnitSystem().getUnit(68);
        private SortCache<Zone> d_sortedZones;
        private Map<Zone, UnitDouble> d_leaks = new LinkedIdentityHashMap<Zone, UnitDouble>();

        public LeakTblMdl() {
            this.d_sortedZones = new SortCache(Collections.EMPTY_LIST);
        }

        public void load(final Zone zone, PyroMod mediator) {
            Collection<Zone> zones = mediator.getZoneMgr().flatten(new Predicate<Zone>(){

                @Override
                public boolean test(Zone o) {
                    return o != zone;
                }
            });
            this.d_sortedZones = new SortCache<Zone>(Util.sort(zones));
            this.d_leaks.clear();
            for (Leak leak : LeakUtil.getLeaks(mediator, zone)) {
                Zone otherZone = leak.otherZone(zone);
                this.d_leaks.put(otherZone, leak.area);
            }
            this.fireTableDataChanged();
        }

        public void save(Zone zone, BridgeList bridges) {
            ArrayList<Leak> oldLeaks = new ArrayList<Leak>(LeakUtil.getLeaks(bridges, zone));
            bridges.removeAll(oldLeaks);
            ArrayList<Leak> newLeaks = new ArrayList<Leak>(this.d_leaks.size());
            for (Map.Entry<Zone, UnitDouble> entry : this.d_leaks.entrySet()) {
                Leak leak = new Leak(zone, entry.getKey(), entry.getValue());
                newLeaks.add(leak);
            }
            bridges.addAll(newLeaks);
        }

        @Override
        public int getRowCount() {
            return this.d_sortedZones.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Double.class;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Intl.intl("Zone");
                }
                case 1: {
                    return Intl.intl("Leak Area") + " (" + this.d_areaUnit + ")";
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Zone zone = this.d_sortedZones.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return zone.getName();
                }
                case 1: {
                    UnitDouble la = this.d_leaks.get(zone);
                    return la == null ? 0.0 : la.getValue(this.d_areaUnit);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex != 1) {
                return;
            }
            Double val = (Double)value;
            if (val != null && val < 0.0) {
                return;
            }
            Zone zone = this.d_sortedZones.get(rowIndex);
            if (val == null || val == 0.0) {
                this.d_leaks.remove(zone);
            } else {
                this.d_leaks.put(zone, new UnitDouble(val, this.d_areaUnit));
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }
}

