/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.particle;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.particle.ConstColoring;
import pyrosim.domain.particle.DropletColoring;
import pyrosim.domain.particle.IColoring;
import pyrosim.domain.particle.Output;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.particle.ParticleList;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.variant.Variant;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.ExSpecComboBox;
import pyrosim.gui.comboboxes.SurfaceComboBox;
import pyrosim.gui.controls.ControlSelPnl;
import pyrosim.gui.particle.PartDescCombo;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.DoubleVR;

public class ParticleParamPanel
extends guiPanel
implements IEditor<Particle> {
    private static final long serialVersionUID = 3131792268053380236L;
    private final guiTextField d_fyi;
    private final ControlSelPnl d_ctrl;
    private final JTabbedPane d_tabs;
    private final guiDialog d_parent;
    private final ParticleList d_partList;
    private final PartDescCombo d_particleCombo;
    private DropletsPanel d_dropletsPanel;
    private InjectionPanel d_injectionPanel;
    private SizeDistributionPanel d_sizeDistPanel;
    private LiquidPropsPanel d_liquidPropsPanel;
    private SolidPropsPanel d_solidPropsPanel;
    private DragPropsPanel d_dragPropsPanel;
    private TracerPropsPanel d_tracerPropsPanel;
    private CustomFDSPanel d_advancedPnl;
    private UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
    private final String LIQUID = Intl.intl("Liquid");
    private final String SOLID = Intl.intl("Solid");
    private final String DRAG = Intl.intl("Drag");
    private final String COLORING = Intl.intl("Coloring");
    private final String SIZE_DISTRIBUTION = Intl.intl("Size Distribution");
    private final String PROPERTIES = Intl.intl("Tracer");
    private final String INJECTION = Intl.intl("Injection");
    private final String ADVANCED = Intl.intl("Advanced");

    public ParticleParamPanel(guiDialog parent) {
        PyroSim pySim = PyroSim.getApp();
        PyroMod pyMod = pySim.getMediator();
        this.d_partList = pyMod.getPartList();
        this.setLayout(new GridBagLayout());
        this.d_parent = parent;
        this.d_fyi = new guiTextField();
        this.d_ctrl = new ControlSelPnl(pyMod.getControls());
        this.d_dropletsPanel = new DropletsPanel();
        this.d_injectionPanel = new InjectionPanel();
        this.d_sizeDistPanel = new SizeDistributionPanel();
        this.d_liquidPropsPanel = new LiquidPropsPanel();
        this.d_solidPropsPanel = new SolidPropsPanel();
        this.d_dragPropsPanel = new DragPropsPanel();
        this.d_tracerPropsPanel = new TracerPropsPanel();
        this.d_advancedPnl = new CustomFDSPanel(7);
        this.d_tabs = new JTabbedPane();
        this.d_tabs.addTab(this.COLORING, this.d_dropletsPanel);
        this.d_tabs.addTab(this.LIQUID, this.d_liquidPropsPanel);
        this.d_tabs.addTab(this.SOLID, this.d_solidPropsPanel);
        this.d_tabs.addTab(this.SIZE_DISTRIBUTION, this.d_sizeDistPanel);
        this.d_tabs.addTab(this.INJECTION, this.d_injectionPanel);
        this.d_tabs.addTab(this.ADVANCED, this.d_advancedPnl);
        this.d_tabs.setPreferredSize(PyroGuiUtil.determineMinimumTabbedPaneSize(this.d_dropletsPanel, this.d_injectionPanel, this.d_liquidPropsPanel, this.d_solidPropsPanel, this.d_tracerPropsPanel, this.d_advancedPnl));
        this.d_particleCombo = new PartDescCombo();
        this.d_particleCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ParticleParamPanel.this.updateTabs();
            }
        });
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(Intl.intl("Description:"), this.d_fyi, 1.0, 0);
        this.d_ctrl.add(gb);
        gb.addRow(Intl.intl("Particle Type:"), this.d_particleCombo, 0);
        gb.addRow(this.d_tabs, new double[]{1.0, 1.0}, new int[]{0, 0});
        gb.finalizeRows();
        this.setEnabled(false);
        this.setModified(false);
    }

    @Override
    public Particle commit(final Particle dataObj) {
        AOneTimeTask t = new AOneTimeTask(){

            @Override
            public void run() {
                ParticleParamPanel.this.saveParticle(dataObj, false);
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(t, Intl.intl("Edit Particle"));
        this.setModified(false);
        return dataObj;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(Particle dataObj) {
        this.setEnabled(dataObj != null);
        this.clearPanels();
        if (dataObj != null) {
            this.loadParticle(dataObj);
        }
        this.setModified(false);
    }

    @Override
    public Particle preview(Particle particle) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.saveParticle(particle, true);
        return particle;
    }

    private void updateTabs() {
        String selection = (String)this.d_particleCombo.getSelectedItem();
        this.d_tabs.removeAll();
        if (selection == PartDescCombo.LIQUID) {
            this.d_tabs.addTab(this.LIQUID, this.d_liquidPropsPanel);
            this.d_tabs.addTab(this.DRAG, this.d_dragPropsPanel);
            this.d_tabs.addTab(this.SIZE_DISTRIBUTION, this.d_sizeDistPanel);
            this.d_tabs.addTab(this.COLORING, this.d_dropletsPanel);
            this.d_tabs.addTab(this.INJECTION, this.d_injectionPanel);
        } else if (selection == PartDescCombo.MASSLESS_TRACER) {
            this.d_tabs.addTab(this.PROPERTIES, this.d_tracerPropsPanel);
        } else if (selection == PartDescCombo.SOLID) {
            this.d_tabs.addTab(this.SOLID, this.d_solidPropsPanel);
            this.d_tabs.addTab(this.DRAG, this.d_dragPropsPanel);
            this.d_tabs.addTab(this.COLORING, this.d_dropletsPanel);
            this.d_tabs.addTab(this.INJECTION, this.d_injectionPanel);
        } else {
            this.d_tabs.addTab(this.PROPERTIES, new guiPanel());
        }
        this.d_tabs.addTab(this.ADVANCED, this.d_advancedPnl);
    }

    private void loadParticle(Particle dataObj) {
        this.d_fyi.setText(dataObj.getFYI());
        this.d_ctrl.setSourceObjs(Arrays.asList(dataObj));
        this.d_ctrl.load(Arrays.asList((OneLogicInPin)dataObj.getInputPin()));
        this.d_sizeDistPanel.loadData(dataObj);
        this.d_dragPropsPanel.loadData(dataObj);
        this.d_dropletsPanel.loadColorPanel(dataObj.getColoring());
        this.d_injectionPanel.loadOutput(dataObj.getOutput());
        this.d_liquidPropsPanel.loadData(dataObj.getSpecies(), dataObj.isStatic());
        this.d_solidPropsPanel.loadData(dataObj.getSurface(), dataObj.isStatic());
        this.d_tracerPropsPanel.loadData(dataObj.getOutput(), dataObj.getColoring());
        this.d_particleCombo.initDesc(dataObj.getType());
        this.d_advancedPnl.clear();
        this.d_advancedPnl.load(Collections.singleton(dataObj), new CustomFDSPanel.AdvPropWrapper<Boolean>(dataObj.isForceWrite(), 1));
    }

    private void clearPanels() {
        this.d_fyi.setText("");
        this.d_sizeDistPanel.loadData(null);
        this.d_dropletsPanel.loadColorPanel(null);
        this.d_injectionPanel.loadOutput(null);
        this.d_liquidPropsPanel.loadData(null, null);
        this.d_solidPropsPanel.loadData(null, null);
        this.d_tracerPropsPanel.loadData(null, null);
        this.d_advancedPnl.clear();
    }

    private void saveParticle(Particle part, boolean isPreview) {
        part.setFYI(this.d_fyi.getText());
        this.d_ctrl.save(Arrays.asList((OneLogicInPin)part.getInputPin()));
        String selection = (String)this.d_particleCombo.getSelectedItem();
        if (selection == PartDescCombo.MASSLESS_TRACER) {
            part.setType(Particle.Type.TRACER);
            part.setColoring(this.d_tracerPropsPanel.getColoring());
            part.setOutput(this.d_tracerPropsPanel.getOutput());
        } else if (selection == PartDescCombo.LIQUID) {
            part.setType(Particle.Type.LIQUID);
            this.d_dragPropsPanel.saveData(part);
            this.d_sizeDistPanel.saveData(part);
            this.d_liquidPropsPanel.saveData(part, isPreview);
            part.setColoring(this.d_dropletsPanel.saveIColoring());
            part.setOutput(this.d_injectionPanel.saveOutput());
        } else if (selection == PartDescCombo.SOLID) {
            part.setType(Particle.Type.SOLID);
            this.d_dragPropsPanel.saveData(part);
            part.setSurface(this.d_solidPropsPanel.getSurf());
            part.setStatic(this.d_solidPropsPanel.getStatic());
            part.setColoring(this.d_dropletsPanel.saveIColoring());
            part.setOutput(this.d_injectionPanel.saveOutput());
        }
        this.d_advancedPnl.save(Collections.singleton(part));
    }

    private class ColorPanel
    extends guiPanel {
        private static final long serialVersionUID = -7265518323123983717L;
        private ColorButton d_colorButton;
        private guiRadioButton d_defaultRB;
        private guiRadioButton d_specifyRB;
        private guiRadioButton d_byDropletRB;
        private guiCheckBox d_ageCB;
        private guiCheckBox d_tempCB;
        private guiCheckBox d_diamCB;
        private guiCheckBox d_velCB;
        private guiCheckBox d_massCB;

        public ColorPanel() {
            this.setLayout(new GridBagLayout());
            int row = 0;
            this.d_colorButton = new ColorButton();
            this.d_colorButton.setMinimumSize(this.d_colorButton.getPreferredSize());
            this.d_defaultRB = new guiRadioButton(Intl.intl("Default"));
            this.d_defaultRB.setSelected(true);
            this.d_specifyRB = new guiRadioButton(Intl.intl("Specify") + ":");
            this.d_byDropletRB = new guiRadioButton(Intl.intl("By Droplet Property") + ":");
            ButtonGroup group = new ButtonGroup();
            group.add(this.d_defaultRB);
            group.add(this.d_specifyRB);
            group.add(this.d_byDropletRB);
            this.d_ageCB = new guiCheckBox(Intl.intl("Age"));
            this.d_tempCB = new guiCheckBox(Intl.intl("Temperature"));
            this.d_diamCB = new guiCheckBox(Intl.intl("Diameter"));
            this.d_velCB = new guiCheckBox(Intl.intl("Velocity"));
            this.d_massCB = new guiCheckBox(Intl.intl("Mass"));
            guiPanel colorOpts = new guiPanel();
            colorOpts.setLayout(new GridLayout(2, 3));
            colorOpts.add(this.d_ageCB);
            colorOpts.add(this.d_velCB);
            colorOpts.add(this.d_tempCB);
            colorOpts.add(this.d_massCB);
            colorOpts.add(this.d_diamCB);
            GridBagUtil.add(this, this.d_defaultRB, 0, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_specifyRB, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_colorButton, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_byDropletRB, 0, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, colorOpts, 0, row++, 2, 1, 0, 12, 6, 0, 0, 1.0, 0.0, 17);
            GridBagUtil.addGlue(this);
            LinkStatus.link((AbstractButton)this.d_byDropletRB, colorOpts);
            LinkStatus.link((AbstractButton)this.d_specifyRB, this.d_colorButton);
        }

        public void loadData(IColoring color) {
            this.d_ageCB.setSelected(false);
            this.d_tempCB.setSelected(false);
            this.d_diamCB.setSelected(false);
            this.d_velCB.setSelected(false);
            this.d_massCB.setSelected(false);
            this.d_colorButton.setColor(this.getBackground());
            if (color instanceof ConstColoring) {
                this.d_colorButton.setColor(((ConstColoring)color).color);
                this.d_specifyRB.setSelected(true);
            } else if (color instanceof DropletColoring) {
                DropletColoring dropCol = (DropletColoring)color;
                this.d_byDropletRB.setSelected(true);
                this.d_ageCB.setSelected(dropCol.d_properties.contains(4));
                this.d_tempCB.setSelected(dropCol.d_properties.contains(0));
                this.d_diamCB.setSelected(dropCol.d_properties.contains(1));
                this.d_velCB.setSelected(dropCol.d_properties.contains(2));
                this.d_massCB.setSelected(dropCol.d_properties.contains(3));
            } else {
                this.d_defaultRB.setSelected(true);
            }
        }

        public IColoring saveData() {
            if (this.d_specifyRB.isSelected()) {
                return new ConstColoring(this.d_colorButton.getColor());
            }
            if (this.d_byDropletRB.isSelected()) {
                LinkedHashSet<Integer> colorProps = new LinkedHashSet<Integer>(5);
                if (this.d_tempCB.isSelected()) {
                    colorProps.add(0);
                }
                if (this.d_diamCB.isSelected()) {
                    colorProps.add(1);
                }
                if (this.d_velCB.isSelected()) {
                    colorProps.add(2);
                }
                if (this.d_massCB.isSelected()) {
                    colorProps.add(3);
                }
                if (this.d_ageCB.isSelected()) {
                    colorProps.add(4);
                }
                return new DropletColoring(colorProps);
            }
            return null;
        }
    }

    private class SizeDistributionPanel
    extends guiPanel {
        private static final long serialVersionUID = 4627992393007325702L;
        private ValueField<UnitDouble> d_medDiameter;
        private ValueField<UnitDouble> d_minDiameter;
        private ValueField<UnitDouble> d_maxDiameter;
        private ValueField<Double> d_sigma;
        private ValueField<Double> d_gamma;
        private final guiLabel d_medDiameterLbl;
        private guiComboBox d_distributionCB;
        private final String CONST = Intl.intl("Constant");
        private final String ROSIN = Intl.intl("Rosin-Rammler ");
        private final String LOGNORMAL = Intl.intl("Lognormal");
        private final String ROSINLOGNORMAL = Intl.intl("Rosin-Rammler-Lognormal");

        public SizeDistributionPanel() {
            this.setLayout(new GridBagLayout());
            int row = 0;
            this.d_medDiameterLbl = new guiLabel(Intl.intl("Median Diameter:"));
            final guiLabel minLbl = new guiLabel(Intl.intl("Minimum Diameter:"));
            final guiLabel maxLbl = new guiLabel(Intl.intl("Maximum Diameter:"));
            final guiLabel sigmaLbl = new guiLabel(Intl.intl("Sigma D:"));
            final guiLabel gammaLbl = new guiLabel(Intl.intl("Gamma D:"));
            Unit diamUnit = ParticleParamPanel.this.d_currentUS.getUnit(61);
            UnitDoubleVR diamRange = UnitDoubleVR.above(new UnitDouble(0.0, diamUnit), false);
            this.d_medDiameter = ValueFields.udFld(UnitSystem.getSource(90), diamRange);
            this.d_medDiameter.setNullAllowed(true);
            this.d_minDiameter = ValueFields.udFld(UnitSystem.getSource(90), diamRange);
            this.d_maxDiameter = ValueFields.udFld(UnitSystem.getSource(90), diamRange);
            ValueFields.getFormat(this.d_maxDiameter).alias(new UnitDouble(Double.POSITIVE_INFINITY, diamUnit), "Infinity");
            this.d_sigma = ValueFields.doubleFld();
            this.d_gamma = ValueFields.doubleFld();
            guiLabel comboLbl = new guiLabel(Intl.intl("Distribution:"));
            this.d_distributionCB = new guiComboBox<String>((T[])new String[]{this.CONST, this.ROSIN, this.LOGNORMAL, this.ROSINLOGNORMAL});
            this.d_distributionCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        return;
                    }
                    if (SizeDistributionPanel.this.d_distributionCB.getSelectedItem().equals(SizeDistributionPanel.this.CONST)) {
                        SizeDistributionPanel.this.d_sigma.setEnabled(false);
                        sigmaLbl.setEnabled(false);
                        SizeDistributionPanel.this.d_gamma.setEnabled(false);
                        gammaLbl.setEnabled(false);
                        SizeDistributionPanel.this.d_minDiameter.setEnabled(false);
                        minLbl.setEnabled(false);
                        SizeDistributionPanel.this.d_maxDiameter.setEnabled(false);
                        maxLbl.setEnabled(false);
                    } else if (SizeDistributionPanel.this.d_distributionCB.getSelectedItem().equals(SizeDistributionPanel.this.ROSIN)) {
                        SizeDistributionPanel.this.d_sigma.setEnabled(false);
                        sigmaLbl.setEnabled(false);
                        SizeDistributionPanel.this.d_gamma.setEnabled(true);
                        gammaLbl.setEnabled(true);
                        SizeDistributionPanel.this.d_minDiameter.setEnabled(true);
                        minLbl.setEnabled(true);
                        SizeDistributionPanel.this.d_maxDiameter.setEnabled(true);
                        maxLbl.setEnabled(true);
                    } else if (SizeDistributionPanel.this.d_distributionCB.getSelectedItem().equals(SizeDistributionPanel.this.LOGNORMAL)) {
                        SizeDistributionPanel.this.d_sigma.setEnabled(true);
                        sigmaLbl.setEnabled(true);
                        SizeDistributionPanel.this.d_gamma.setEnabled(false);
                        gammaLbl.setEnabled(false);
                        SizeDistributionPanel.this.d_minDiameter.setEnabled(true);
                        minLbl.setEnabled(true);
                        SizeDistributionPanel.this.d_maxDiameter.setEnabled(true);
                        maxLbl.setEnabled(true);
                    } else {
                        SizeDistributionPanel.this.d_sigma.setEnabled(false);
                        sigmaLbl.setEnabled(false);
                        SizeDistributionPanel.this.d_gamma.setEnabled(true);
                        gammaLbl.setEnabled(true);
                        SizeDistributionPanel.this.d_minDiameter.setEnabled(true);
                        minLbl.setEnabled(true);
                        SizeDistributionPanel.this.d_maxDiameter.setEnabled(true);
                        maxLbl.setEnabled(true);
                    }
                }
            });
            GridBagUtil.add(this, this.d_medDiameterLbl, 0, row, 1, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_medDiameter, 1, row++, 1, 1, 12, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, comboLbl, 0, row, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_distributionCB, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, minLbl, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_minDiameter, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, maxLbl, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_maxDiameter, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, sigmaLbl, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_sigma, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, gammaLbl, 0, row, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_gamma, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            UnitDouble min;
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            UnitDouble max = (UnitDouble)this.d_maxDiameter.getValue();
            if (max.compareTo(min = (UnitDouble)this.d_minDiameter.getValue()) < 0) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(ParticleParamPanel.this, Intl.intl("The minimum diameter must be less than or equal to the maximum diameter."), Intl.intl("Diameter Range Error"), 0);
                }
                if (allowModify) {
                    this.d_minDiameter.grabFocus();
                }
                return false;
            }
            return true;
        }

        public void loadData(Particle part) {
            if (part == null) {
                this.d_distributionCB.setSelectedItem(null);
                return;
            }
            if (part.getType() != Particle.Type.SOLID) {
                this.d_medDiameter.setEnabled(true);
                this.d_medDiameterLbl.setEnabled(true);
                if (part.getDiameter().getType() == Variant.Type.CONSTANT) {
                    this.d_medDiameter.setValue((UnitDouble)part.getDiameter().val);
                }
            } else {
                this.d_medDiameter.setValue(null);
                this.d_medDiameter.setEnabled(false);
                this.d_medDiameterLbl.setEnabled(false);
            }
            this.d_minDiameter.setValue(part.getMinDiameter());
            this.d_maxDiameter.setValue(part.getMaxDiameter());
            this.d_sigma.setValue(0.0);
            if (part.getSigmaD() != null) {
                this.d_sigma.setValue(part.getSigmaD());
            }
            this.d_gamma.setValue(part.getGammaD());
            if (part.getDistribution() == Particle.Distribution.CONST) {
                this.d_distributionCB.setSelectedItem(this.CONST);
            } else if (part.getDistribution() == Particle.Distribution.ROSIN) {
                this.d_distributionCB.setSelectedItem(this.ROSIN);
            } else if (part.getDistribution() == Particle.Distribution.LOGNORMAL) {
                this.d_distributionCB.setSelectedItem(this.LOGNORMAL);
            } else {
                this.d_distributionCB.setSelectedItem(this.ROSINLOGNORMAL);
            }
        }

        public void saveData(Particle part) {
            if (this.d_distributionCB.getSelectedItem().equals(this.CONST)) {
                part.setConstDistribution((UnitDouble)this.d_medDiameter.getValue());
            } else if (this.d_distributionCB.getSelectedItem().equals(this.ROSIN)) {
                part.setRosinRammler((UnitDouble)this.d_medDiameter.getValue(), (UnitDouble)this.d_minDiameter.getValue(), (UnitDouble)this.d_maxDiameter.getValue(), (Double)this.d_gamma.getValue());
            } else if (this.d_distributionCB.getSelectedItem().equals(this.LOGNORMAL)) {
                part.setLognormal((UnitDouble)this.d_medDiameter.getValue(), (UnitDouble)this.d_minDiameter.getValue(), (UnitDouble)this.d_maxDiameter.getValue(), (Double)this.d_sigma.getValue());
            } else if (this.d_distributionCB.getSelectedItem().equals(this.ROSINLOGNORMAL)) {
                part.setRosinRammlerLognormal((UnitDouble)this.d_medDiameter.getValue(), (UnitDouble)this.d_minDiameter.getValue(), (UnitDouble)this.d_maxDiameter.getValue(), (Double)this.d_gamma.getValue());
            }
        }
    }

    private class DropletsPanel
    extends guiPanel {
        private static final long serialVersionUID = -4557273216401335452L;
        private ColorPanel d_colorPanel;

        public DropletsPanel() {
            this.setLayout(new GridBagLayout());
            int row = 0;
            this.d_colorPanel = new ColorPanel();
            TitleSeparator colorTitle = new TitleSeparator(Intl.intl("Color"));
            GridBagUtil.add(this, colorTitle, 0, row++, 1, 1, 12, 12, 6, 12, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_colorPanel, 0, row++, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void loadColorPanel(IColoring color) {
            this.d_colorPanel.loadData(color);
        }

        public IColoring saveIColoring() {
            return this.d_colorPanel.saveData();
        }
    }

    private class OutputPanel
    extends guiPanel {
        private static final long serialVersionUID = 1855642288511461510L;
        private ValueField<UnitDouble> d_duration;
        private ValueField<Integer> d_samplingFactor;

        public OutputPanel() {
            this.setLayout(new GridBagLayout());
            int row = 1;
            this.d_duration = ValueFields.udFld(UnitSystem.getSource(2));
            this.d_samplingFactor = ValueFields.intFld();
            guiLabel durationLab = new guiLabel(Intl.intl("Duration") + ":");
            guiLabel samplingFactorLab = new guiLabel(Intl.intl("Sampling Factor") + ":");
            GridBagUtil.add(this, durationLab, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_duration, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, samplingFactorLab, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_samplingFactor, 1, row++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void loadData(Output o) {
            Output defO = new Output(10);
            this.d_duration.setValue(defO.d_age);
            this.d_samplingFactor.setValue(defO.d_samplingFactor);
            if (o == null) {
                return;
            }
            this.d_duration.setValue(o.d_age);
            this.d_samplingFactor.setValue(o.d_samplingFactor);
        }

        public Output saveData() {
            return new Output((UnitDouble)this.d_duration.getValue(), (Integer)this.d_samplingFactor.getValue());
        }
    }

    private class TracerPropsPanel
    extends guiPanel {
        private static final long serialVersionUID = 390889945969660698L;
        private OutputPanel d_outputPanel;
        private ColorButton d_colorButton;
        private guiCheckBox d_colorCB;

        public TracerPropsPanel() {
            this.setLayout(new GridBagLayout());
            this.d_outputPanel = new OutputPanel();
            this.d_colorButton = new ColorButton();
            this.d_colorButton.setMinimumSize(this.d_colorButton.getPreferredSize());
            this.d_colorCB = new guiCheckBox(Intl.intl("Color") + ":");
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(this.d_colorCB, this.d_colorButton, 0);
            gb.addFilledRow(new TitleSeparator(Intl.intl("Injection")));
            gb.indent();
            gb.addFilledRow(this.d_outputPanel);
            gb.finalizeRows();
            LinkStatus.link((AbstractButton)this.d_colorCB, this.d_colorButton);
        }

        public void loadData(Output output, IColoring coloring) {
            if (coloring != null && coloring instanceof ConstColoring) {
                this.d_colorButton.setColor(((ConstColoring)coloring).color);
                this.d_colorCB.setSelected(true);
            } else {
                this.d_colorButton.setColor(this.getBackground());
                this.d_colorCB.setSelected(false);
            }
            this.d_outputPanel.loadData(output);
        }

        public IColoring getColoring() {
            if (this.d_colorCB.isSelected()) {
                return new ConstColoring(this.d_colorButton.getColor());
            }
            return null;
        }

        public Output getOutput() {
            return this.d_outputPanel.saveData();
        }
    }

    private class DragPropsPanel
    extends guiPanel {
        private static final long serialVersionUID = -1513256999197008249L;
        private guiRadioButton d_cylinderDragRB;
        private guiRadioButton d_screenDragRB;
        private guiRadioButton d_sphereDragRB;
        private guiRadioButton d_coefDragRB;
        private ValueField<Double> d_dragCoef;
        private ValueField<UnitDouble> d_denseVolFrac;

        public DragPropsPanel() {
            this.setLayout(new GridBagLayout());
            this.d_cylinderDragRB = new guiRadioButton(Intl.intl("Cylinder"));
            this.d_screenDragRB = new guiRadioButton(Intl.intl("Screen"));
            this.d_sphereDragRB = new guiRadioButton(Intl.intl("Sphere"));
            this.d_coefDragRB = new guiRadioButton(Intl.intl("Specify Drag Coefficient"));
            this.d_dragCoef = ValueFields.doubleFld(DoubleVR.above(0.0, true));
            this.d_denseVolFrac = ValueFields.udFld(DoubleVR.between(0.0, 1.0, true, true), SIUS.unit(87), UnitSystem.getSource(87));
            new guiButtonGroup(this.d_cylinderDragRB, this.d_screenDragRB, this.d_sphereDragRB, this.d_coefDragRB);
            LinkStatus.link((AbstractButton)this.d_coefDragRB, this.d_dragCoef);
            GridBagHelper gbh = new GridBagHelper(this, true);
            gbh.addFilledRow(new TitleSeparator(Intl.intl("Drag Options")));
            gbh.indent();
            gbh.addRow(this.d_sphereDragRB);
            gbh.addRow(this.d_cylinderDragRB);
            gbh.addRow(this.d_screenDragRB);
            gbh.addRow(this.d_coefDragRB, this.d_dragCoef);
            gbh.addRow(new guiLabel(Intl.intl("Dense Volume Fraction")), this.d_denseVolFrac);
            gbh.finalizeRows();
        }

        public void loadData(Particle part) {
            this.d_dragCoef.setValue(0.0);
            if (part.getDragType() == Particle.Drag.CYLINDER) {
                this.d_cylinderDragRB.setSelected(true);
            } else if (part.getDragType() == Particle.Drag.SPHERE) {
                this.d_sphereDragRB.setSelected(true);
            } else if (part.getDragType() == Particle.Drag.SCREEN) {
                this.d_screenDragRB.setSelected(true);
            } else if (part.getDragType() == Particle.Drag.COEF) {
                this.d_coefDragRB.setSelected(true);
                this.d_dragCoef.setValue(part.getDragCoef());
            }
            this.d_denseVolFrac.setValue(new UnitDouble(part.getDenseVolumeFraction(), ParticleParamPanel.this.d_currentUS.getUnit(87)));
        }

        public void saveData(Particle part) {
            part.setDenseVolumeFraction(((UnitDouble)this.d_denseVolFrac.getValue()).getValueNoUnit());
            if (this.d_cylinderDragRB.isSelected()) {
                part.setDrag(Particle.Drag.CYLINDER);
            } else if (this.d_sphereDragRB.isSelected()) {
                part.setDrag(Particle.Drag.SPHERE);
            } else if (this.d_screenDragRB.isSelected()) {
                part.setDrag(Particle.Drag.SCREEN);
            } else if (this.d_coefDragRB.isSelected()) {
                part.setDrag(Particle.Drag.COEF);
                part.setDragCoef((Double)this.d_dragCoef.getValue());
            } else assert (false);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return super.validateData(showWarn, allowModify);
        }
    }

    private class SolidPropsPanel
    extends guiPanel {
        private static final long serialVersionUID = 8213330190161215232L;
        private final guiComboBox d_surfCombo;
        private final MovementPanel d_movementPnl;

        public SolidPropsPanel() {
            this.setLayout(new GridBagLayout());
            PyroMod pySim = PyroSim.getApp().getMediator();
            this.d_surfCombo = new SurfaceComboBox(pySim.getSurfaceMgr(), null);
            JButton editSurfaces = new JButton(Intl.intl("Edit Surfaces") + "...");
            ActionListener editAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (arg0.getSource() instanceof JButton) {
                        Actions.editSurfaces((Surface)SolidPropsPanel.this.d_surfCombo.getSelectedItem());
                    }
                }
            };
            editSurfaces.addActionListener(editAction);
            this.d_movementPnl = new MovementPanel();
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(Intl.intl("Surface:"), this.d_surfCombo, editSurfaces);
            gb.addFilledRow(new TitleSeparator(Intl.intl("Movement")));
            gb.indent();
            gb.addFilledRow(this.d_movementPnl);
            gb.finalizeRows();
        }

        public void loadData(Surface surf, Boolean isStatic) {
            this.d_surfCombo.setSelectedItem(surf);
            this.d_movementPnl.setStatic(isStatic);
        }

        public Surface getSurf() {
            return (Surface)this.d_surfCombo.getSelectedItem();
        }

        public Boolean getStatic() {
            return this.d_movementPnl.isStatic();
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (this.getSurf() == null) {
                if (showWarn) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Must select a valid Surface."));
                }
                return false;
            }
            return super.validateData(showWarn, allowModify);
        }
    }

    private class LiquidPropsPanel
    extends guiPanel {
        private static final long serialVersionUID = 7274442464895531032L;
        private final guiComboBox d_specCombo;
        private final MovementPanel d_movementPnl;

        public LiquidPropsPanel() {
            this.setLayout(new GridBagLayout());
            PyroMod pySim = PyroSim.getApp().getMediator();
            this.d_specCombo = new ExSpecComboBox(pySim.getExSpecList());
            this.d_specCombo.setPreferredSize(new Dimension(100, this.d_specCombo.getPreferredSize().height));
            JButton editSpecs = new JButton(Intl.intl("Edit Species") + "...");
            ActionListener editAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (arg0.getSource() instanceof JButton) {
                        Actions.editSpecies((ExSpec)LiquidPropsPanel.this.d_specCombo.getSelectedItem());
                    }
                }
            };
            editSpecs.addActionListener(editAction);
            this.d_movementPnl = new MovementPanel();
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(Intl.intl("Species:"), this.d_specCombo, editSpecs);
            gb.addFilledRow(new TitleSeparator(Intl.intl("Movement")));
            gb.indent();
            gb.addFilledRow(this.d_movementPnl);
            gb.finalizeRows();
        }

        public void loadData(ExSpec spec, Boolean isStatic) {
            this.d_specCombo.setSelectedItem(spec);
            this.d_movementPnl.setStatic(isStatic);
        }

        public void saveData(Particle part, boolean isPreview) {
            ExSpec spec = (ExSpec)this.d_specCombo.getSelectedItem();
            part.setSpecies(spec);
            part.setStatic(this.d_movementPnl.isStatic());
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            boolean validSpec = true;
            if (showWarn) {
                if (this.d_specCombo.getSelectedItem() != null) {
                    validSpec = Actions.isValidSpecies((ExSpec)this.d_specCombo.getSelectedItem());
                } else {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Must select a valid Species."));
                    validSpec = false;
                }
            }
            return validSpec && super.validateData(showWarn, allowModify);
        }
    }

    private static class MovementPanel
    extends guiPanel {
        private static final long serialVersionUID = 7584064701758365701L;
        private final guiRadioButton d_cantMoveRB;
        private final guiRadioButton d_canMoveRB = new guiRadioButton(Intl.intl("Particles Can Move"));
        private ButtonGroup d_groupMovement;

        public MovementPanel() {
            this.d_cantMoveRB = new guiRadioButton(Intl.intl("Particles Are Stationary"));
            this.d_canMoveRB.setSelected(true);
            this.d_groupMovement = new ButtonGroup();
            this.d_groupMovement.add(this.d_canMoveRB);
            this.d_groupMovement.add(this.d_cantMoveRB);
            this.setLayout(new GridBagLayout());
            int row = 0;
            GridBagUtil.add(this, this.d_canMoveRB, 0, row++, 2, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_cantMoveRB, 0, row++, 2, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void setStatic(Boolean isStatic) {
            if (isStatic == null) {
                this.unselect();
            } else {
                this.d_canMoveRB.setSelected(isStatic == false);
                this.d_cantMoveRB.setSelected(isStatic);
            }
        }

        public Boolean isStatic() {
            if (this.d_cantMoveRB.isSelected()) {
                return true;
            }
            return false;
        }

        public void unselect() {
            this.d_groupMovement.remove(this.d_canMoveRB);
            this.d_groupMovement.remove(this.d_cantMoveRB);
            this.d_canMoveRB.setSelected(false);
            this.d_cantMoveRB.setSelected(false);
            this.d_groupMovement.add(this.d_canMoveRB);
            this.d_groupMovement.add(this.d_cantMoveRB);
        }
    }

    private class InjectionPanel
    extends guiPanel {
        private static final long serialVersionUID = -831451803607726793L;
        private final OutputPanel d_outputPanel;

        public InjectionPanel() {
            this.setLayout(new GridBagLayout());
            this.d_outputPanel = new OutputPanel();
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addFilledRow(this.d_outputPanel);
            gb.finalizeRows();
        }

        public void loadOutput(Output output) {
            this.d_outputPanel.loadData(output);
        }

        public Output saveOutput() {
            return this.d_outputPanel.saveData();
        }
    }
}

