/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.DefaultCellEditor;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.output.Isosurface;
import pyrosim.domain.output.IsosurfaceMgr;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.quantity.StaticQuantity;
import pyrosim.domain.quantity.VelocitySign;
import pyrosim.gui.output.guiOutputUtil;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.Task;

public class IsofDialog
extends guiDialog {
    private static final long serialVersionUID = -2175863594477471684L;
    private final PyroMod d_pyroMod = PyroSim.getApp().getMediator();
    private final UnitSystem d_unitSystem = PyroSim.getApp().getUnitSystem();
    private final IsosurfaceMgr d_isofList = this.d_pyroMod.getIsofList();
    private final guiTable d_table;
    private final IsofTableModel d_model = new IsofTableModel();
    private final guiComboBox<VelocitySign> d_velSignCB;

    public IsofDialog(JFrame parent) {
        super((Window)parent, Intl.intl("Animated Isosurfaces"), 9);
        this.d_table = new guiTable((TableModel)this.d_model, 0);
        TableColumn contoursCol = this.d_table.getColumnModel().getColumn(2);
        contoursCol.setCellRenderer(new UnitDoubleListRenderer());
        contoursCol.setCellEditor(new UnitDoubleListEditor());
        JScrollPane tablesp = new JScrollPane(this.d_table);
        TableColumn checkCol = this.d_table.getColumnModel().getColumn(0);
        checkCol.setMaxWidth(checkCol.getPreferredWidth());
        contoursCol.setPreferredWidth(200);
        this.d_table.autoSizeColumns(true, 200);
        final guiLabel velSignLbl = new guiLabel(Intl.intl("Velocity Sign:"));
        velSignLbl.setToolTipText("VELO_INDEX");
        this.d_velSignCB = new guiComboBox<VelocitySign>(VelocitySign.values());
        guiPanel mainPanel = this.getDialogPane();
        mainPanel.setLayout(new GridBagLayout());
        guiLabel formatNote = new guiLabel(Intl.intl("Multiple contour values must be separated by a semi-colon (;)."));
        int row = 0;
        GridBagUtil.add(mainPanel, tablesp, 0, row++, 2, 1, 0, 18, 6, 12, 1, 1.0, 1.0, 17);
        GridBagUtil.add(mainPanel, formatNote, 0, row++, 2, 1, 0, 18, 12, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, velSignLbl, 0, row, 1, 1, 0, 18, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.d_velSignCB, 1, row++, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        this.d_model.loadValues();
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.loadPreferredSize(PyroPrefs.LastIsofDlgSizeX.key.toString(), PyroPrefs.LastIsofDlgSizeY.key.toString());
        this.d_model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tme) {
                int row = tme.getFirstRow();
                int col = tme.getColumn();
                if (col == 0) {
                    if (((Boolean)IsofDialog.this.d_model.getValueAt(row, col)).booleanValue()) {
                        IsofDialog.this.d_table.changeSelection(row, 2, false, false);
                    }
                    IsofDialog.this.updateVelIndexComps(new Component[]{velSignLbl, IsofDialog.this.d_velSignCB});
                } else if (col == 2) {
                    List val = (List)IsofDialog.this.d_model.getValueAt(row, col);
                    boolean enabled = val != null && !val.isEmpty();
                    IsofDialog.this.d_model.setValueAt(enabled, row, 0);
                }
            }
        });
        this.updateVelIndexComps(velSignLbl, this.d_velSignCB);
    }

    private void updateVelIndexComps(Component ... comps) {
        int ix = (Integer)this.d_model.d_ixMap.get(Quantity.VELOCITY.create());
        boolean enabled = this.d_model.d_enableStatus[ix];
        for (Component comp : comps) {
            comp.setEnabled(enabled);
        }
    }

    @Override
    public int doModal() {
        int result = super.doModal();
        this.savePreferredSize(PyroPrefs.LastIsofDlgSizeX.key.toString(), PyroPrefs.LastIsofDlgSizeY.key.toString());
        if (result == 1) {
            this.d_model.saveValues();
        }
        return result;
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        return this.d_model.validateData();
    }

    private String renderUDList(JTable table, int row, int col, List<UnitDouble> list) {
        IQuantity quant = this.d_model.d_availQuant[row];
        Unit u = this.d_unitSystem.getUnit(quant.get().unitType);
        StringBuffer buffer = new StringBuffer();
        if (!list.isEmpty()) {
            for (int m = 0; m < list.size(); ++m) {
                if (m != 0) {
                    buffer.append("; ");
                }
                buffer.append(Global.format(list.get(m).getValue(u)));
            }
        }
        return buffer.toString();
    }

    private List<UnitDouble> parseUDList(IQuantity msr, String text) {
        Unit u = this.d_unitSystem.getUnit(msr.get().unitType);
        ArrayList<UnitDouble> result = new ArrayList<UnitDouble>();
        StringTokenizer tok = new StringTokenizer(text, " ;");
        while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken().trim();
            try {
                double value = Global.parseDouble(nextTok);
                result.add(new UnitDouble(value, u));
            }
            catch (ParseException e) {
                return null;
            }
        }
        return result;
    }

    private class UnitDoubleListEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -1074854858125563035L;
        private IQuantity d_editingQuant;
        private List<UnitDouble> d_list;

        public UnitDoubleListEditor() {
            super(new JTextField());
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JTextField field = (JTextField)this.getComponent();
            this.d_editingQuant = IsofDialog.this.d_model.d_availQuant[row];
            this.d_list = (List)value;
            field.setText(IsofDialog.this.renderUDList(table, row, column, this.d_list));
            return field;
        }

        @Override
        public boolean stopCellEditing() {
            JTextField field = (JTextField)this.getComponent();
            List result = IsofDialog.this.parseUDList(this.d_editingQuant, field.getText());
            if (result == null) {
                return false;
            }
            this.d_list = result;
            super.stopCellEditing();
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            return this.d_list;
        }
    }

    private class UnitDoubleListRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 7427803260924126284L;

        public UnitDoubleListRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            List list = (List)value;
            this.setText(IsofDialog.this.renderUDList(table, row, column, list));
            return comp;
        }
    }

    private class IsofTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 4722072538908121092L;
        private final Map<IQuantity, Integer> d_ixMap;
        private final IQuantity[] d_availQuant;
        private final boolean[] d_enableStatus;
        private final List<UnitDouble>[] d_contours;

        public IsofTableModel() {
            QuantityUtil.TypeFilter filter = new QuantityUtil.TypeFilter(32L, new QuantityType[0]);
            ArrayList<StaticQuantity> quantities = new ArrayList<StaticQuantity>();
            quantities.addAll(QuantityUtil.generateAllObjectQuanties(IsofDialog.this.d_pyroMod, filter, true));
            quantities.addAll(QuantityUtil.generateStaticQuantities(filter, true));
            this.d_availQuant = quantities.toArray(new IQuantity[quantities.size()]);
            this.d_ixMap = new HashMap<IQuantity, Integer>();
            int ix = 0;
            for (IQuantity m : this.d_availQuant) {
                this.d_ixMap.put(m, ix++);
            }
            this.d_enableStatus = new boolean[this.d_availQuant.length];
            Arrays.fill(this.d_enableStatus, false);
            this.d_contours = new List[this.d_availQuant.length];
            for (int m = 0; m < this.d_availQuant.length; ++m) {
                this.d_contours[m] = new ArrayList<UnitDouble>();
            }
        }

        public boolean validateData() {
            for (int m = 0; m < this.getRowCount(); ++m) {
                List vals;
                if (!((Boolean)this.getValueAt(m, 0)).booleanValue() || !(vals = (List)this.getValueAt(m, 2)).isEmpty()) continue;
                IsofDialog.this.showMessageBox(Intl.intl("Each enabled quantity must have a list of contour values."));
                return false;
            }
            return true;
        }

        public void loadValues() {
            for (Isosurface iso : IsofDialog.this.d_isofList.flatten()) {
                int ix = this.d_ixMap.get(iso.getQuantity());
                this.setValueAt(true, ix, 0);
                this.setValueAt(iso.getContours(), ix, 2);
                if (!iso.getQuantity().get().equals((Object)Quantity.VELOCITY)) continue;
                IsofDialog.this.d_velSignCB.setSelectedItem((Object)iso.getVelocitySign());
            }
        }

        public void saveValues() {
            ArrayList<Isosurface> newIsofs = new ArrayList<Isosurface>();
            for (int m = 0; m < this.getRowCount(); ++m) {
                if (!this.d_enableStatus[m]) continue;
                IQuantity msr = this.d_availQuant[m];
                List vals = (List)this.getValueAt(m, 2);
                Isosurface isof = new Isosurface(msr, vals);
                if (msr.get().equals((Object)Quantity.VELOCITY)) {
                    isof.setVelocitySign((VelocitySign)((Object)IsofDialog.this.d_velSignCB.getSelectedItem()));
                }
                newIsofs.add(isof);
            }
            Task task = guiOutputUtil.taskReplaceObjs(IsofDialog.this.d_isofList, newIsofs);
            IsofDialog.this.d_pyroMod.getTaskManager().exec(task, Intl.intl("Save Isosurfaces"));
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.d_availQuant.length;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Intl.intl("Output");
                }
                case 1: {
                    return Intl.intl("Quantity");
                }
                case 2: {
                    return Intl.intl("Contour Values");
                }
                case 3: {
                    return Intl.intl("Unit");
                }
            }
            return null;
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return List.class;
                }
                case 3: {
                    return Unit.class;
                }
            }
            assert (false);
            return null;
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.d_enableStatus[row];
                }
                case 1: {
                    return this.d_availQuant[row].getDescription();
                }
                case 2: {
                    return this.d_contours[row];
                }
                case 3: {
                    return IsofDialog.this.d_unitSystem.getUnit(this.d_availQuant[row].get().unitType);
                }
            }
            assert (false);
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0 || col == 2;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            boolean modified = true;
            switch (col) {
                case 0: {
                    if (value == null) break;
                    this.d_enableStatus[row] = (Boolean)value;
                    break;
                }
                case 2: {
                    ArrayList<UnitDouble> vals = value == null ? new ArrayList<UnitDouble>(0) : new ArrayList((List)value);
                    IQuantity msr = this.d_availQuant[row];
                    Unit unit = IsofDialog.this.d_unitSystem.getUnit(msr.get().unitType);
                    for (int m = 0; m < vals.size(); ++m) {
                        UnitDouble val = (UnitDouble)vals.get(m);
                        if (UnitDouble.areCompatible(val.getUnit(), unit)) continue;
                        vals.set(m, new UnitDouble(val.getValueNoUnit(), unit));
                    }
                    this.d_contours[row] = vals;
                    break;
                }
                default: {
                    assert (false);
                    modified = false;
                }
            }
            if (modified) {
                this.fireTableCellUpdated(row, col);
            }
        }
    }
}

