/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import javax.swing.AbstractButton;
import pyrosim.Intl;
import pyrosim.domain.rasterization.RasterizationOptions;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;

public class RastOptionsPnl
extends guiPanel {
    private static final long serialVersionUID = 3650442097395719689L;
    public static final int OPTION_BLOCK_SIZE = 1;
    public static final int OPTION_GROUPING = 2;
    public static final int OPTION_THICKENING = 4;
    public static final int OPTION_MERGING = 8;
    public static final int OPTION_FILTERING = 16;
    public static final int ALL_OPTIONS = 31;
    private final int d_options;
    private final guiRadioButton d_useGroups;
    private final guiRadioButton d_useComposites;
    private final guiRadioButton d_smallBlocks;
    private final guiRadioButton d_largeBlocks;
    private final guiRadioButton d_perObjThicken;
    private final guiRadioButton d_forceThicken;
    private final guiRadioButton d_rasterizeAll;
    private final guiRadioButton d_rasterizeUnaligned;
    private final guiCheckBox d_mergeIdentical;
    private final guiCheckBox d_sepDisconnected;
    private final guiCheckBox d_ignoreNames;

    public RastOptionsPnl() {
        this(31);
    }

    public RastOptionsPnl(int options) {
        super(new GridBagLayout());
        this.d_options = options;
        this.d_rasterizeUnaligned = new guiRadioButton(Intl.intl("Rasterize only non axis-aligned objects."));
        this.d_rasterizeUnaligned.setToolTipText(Intl.intl("This option allows only non axis-aligned objects to be converted, which may be faster."));
        this.d_rasterizeAll = new guiRadioButton(Intl.intl("Rasterize all objects"));
        this.d_rasterizeAll.setToolTipText(Intl.intl("This option forces all obstructions and holes to be rounded to a grid cell boundary.  This option may slow block conversion."));
        this.d_largeBlocks = new guiRadioButton(Intl.intl("Allow resulting blocks to span multiple mesh cells."));
        this.d_largeBlocks.setToolTipText(Intl.intl("This option reduces the number of resulting blocks."));
        this.d_smallBlocks = new guiRadioButton(Intl.intl("Force blocks to be no larger than one grid cell thick."));
        this.d_smallBlocks.setToolTipText(Intl.intl("This option results in many blocks being created."));
        this.d_perObjThicken = new guiRadioButton(Intl.intl("Allow thin obstructions."));
        this.d_perObjThicken.setToolTipText(Intl.intl("This option allows resulting blocks to be thin (if appropriate) unless the THICKEN flag is set on the originating obstruction."));
        this.d_forceThicken = new guiRadioButton(Intl.intl("Force all obstructions to be thickened."));
        this.d_forceThicken.setToolTipText(Intl.intl("This option forces all resulting blocks to be at least one grid cell thick."));
        this.d_useComposites = new guiRadioButton(Intl.intl("Group blocks into composite objects."));
        this.d_useComposites.setToolTipText(Intl.intl("This option reduces the number of resulting objects, but each object must be \"exploded\" to edit the blocks."));
        this.d_useGroups = new guiRadioButton(Intl.intl("Create an object for each block and add to a group."));
        this.d_useGroups.setToolTipText(Intl.intl("This option creates many objects, but requires no additional steps to edit the individual blocks."));
        this.d_mergeIdentical = new guiCheckBox(Intl.intl("Merge objects with identical properties."));
        this.d_mergeIdentical.setToolTipText(Intl.intl("This option eliminates overlapping blocks when objects with identical properties overlap."));
        this.d_sepDisconnected = new guiCheckBox(Intl.intl("Separate disjoint objects."));
        this.d_ignoreNames = new guiCheckBox(Intl.intl("Ignore names while merging."));
        LinkStatus.link((AbstractButton)this.d_mergeIdentical, this.d_sepDisconnected, this.d_ignoreNames);
        int row = 0;
        row = this.addOption(16, row, Intl.intl("Conversion Filtering"), this.d_rasterizeUnaligned, this.d_rasterizeAll);
        row = this.addOption(16, row, Intl.intl("Grouping"), this.d_useComposites, this.d_useGroups);
        row = this.addOption(16, row, Intl.intl("Block Size"), this.d_largeBlocks, this.d_smallBlocks);
        row = this.addOption(16, row, Intl.intl("Thickening"), this.d_perObjThicken, this.d_forceThicken);
        if (this.testOption(8)) {
            GridBagUtil.add(this, this.d_mergeIdentical, 0, ++row, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, this.d_sepDisconnected, 0, ++row, 1, 1, 0, 18, 6, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, this.d_ignoreNames, 0, ++row, 1, 1, 0, 18, 6, 0, 2, 1.0, 0.0, 17);
        }
        GridBagUtil.addGlue(this);
    }

    private int addOption(int testFlag, int row, String label, guiRadioButton btn1, guiRadioButton btn2) {
        if (!this.testOption(testFlag)) {
            return row;
        }
        new guiButtonGroup(btn1, btn2);
        TitleSeparator lbl = new TitleSeparator(label);
        GridBagUtil.add(this, lbl, 0, ++row, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, btn1, 0, ++row, 1, 1, 0, 12, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, btn2, 0, ++row, 1, 1, 0, 12, 6, 0, 2, 1.0, 0.0, 17);
        return row;
    }

    private boolean testOption(int option) {
        return (this.d_options & option) == option;
    }

    public void load(RasterizationOptions props) {
        RastOptionsPnl.loadPref(props.largeBlocks, this.d_largeBlocks, this.d_smallBlocks);
        RastOptionsPnl.loadPref(props.geomGroups, this.d_useComposites, this.d_useGroups);
        RastOptionsPnl.loadPref(props.forceThicken, this.d_forceThicken, this.d_perObjThicken);
        RastOptionsPnl.loadPref(props.rasterizeAligned, this.d_rasterizeAll, this.d_rasterizeUnaligned);
        this.d_mergeIdentical.setSelected(props.mergeIdentical);
        this.d_sepDisconnected.setSelected(props.separateDisconnected);
        this.d_ignoreNames.setSelected(props.ignoreMergeNames);
    }

    private static void loadPref(boolean val, guiRadioButton trueBtn, guiRadioButton falseBtn) {
        if (val) {
            trueBtn.setSelected(true);
        } else {
            falseBtn.setSelected(true);
        }
    }

    public RasterizationOptions save() {
        return new RasterizationOptions(true, this.d_largeBlocks.isSelected(), this.d_mergeIdentical.isSelected(), this.d_sepDisconnected.isSelected(), this.d_ignoreNames.isSelected(), this.d_forceThicken.isSelected(), this.d_useComposites.isSelected(), this.d_rasterizeAll.isSelected());
    }
}

