/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import org.jscience.physics.units.NonSI;
import pyrosim.FDSVersion;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.Version;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.PyroActionMap;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.dialogs.CustomKeyAcceleratorDlg;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.gui.GPUInfoPnl;
import thunderheadeng.scene3d.gui.RenderPrefs;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;

public class PreferencesDialog
extends guiDialog {
    private static final long serialVersionUID = -6104217703945371899L;
    private final Map<Tabs, PrefsPanel> d_tabPanels;
    private final PyroMod d_pyroMod;

    public PreferencesDialog(Supplier<IPropertySet> getRenderPref, Supplier<IPropertySet> getRenderComp) {
        this(getRenderPref, getRenderComp, Tabs.PYROSIM);
    }

    public PreferencesDialog(Supplier<IPropertySet> getRenderPref, Supplier<IPropertySet> getRenderComp, Tabs defTab) {
        super((Window)Application.getApp().getActiveFrame(), Intl.intl("Preferences"), 9);
        PyroSim pySim = (PyroSim)Application.getApp();
        this.d_pyroMod = pySim.getMediator();
        JTabbedPane tabs = new JTabbedPane();
        HashMap tabMap = new HashMap();
        this.d_tabPanels = new LinkedHashMap<Tabs, PrefsPanel>();
        BiConsumer<Tabs, PrefsPanel> addTab = (tab, panel) -> {
            this.d_tabPanels.put((Tabs)((Object)tab), (PrefsPanel)panel);
            panel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            int tabIx = tabs.getTabCount();
            tabs.add(tab.desc, (Component)panel);
            tabMap.put(tab, tabIx);
        };
        addTab.accept(Tabs.PYROSIM, new PyroSimPanel());
        addTab.accept(Tabs.RECORDVIEW, new RecordViewPanel());
        addTab.accept(Tabs.FDS, new FDSPanel());
        addTab.accept(Tabs.RESULTS, new ResultsPanel());
        PyroSim app = PyroSim.getApp();
        Supplier<IRenderSurface.OpenGLInfo> getRenderInfo = () -> app.get3DView().getRenderComp().getOpenGLInfo();
        addTab.accept(Tabs.RENDERING, new DisplayPanel(getRenderPref, getRenderComp, getRenderInfo));
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.add((Component)tabs, "Center");
        this.loadValues();
        tabs.setSelectedIndex((Integer)tabMap.get((Object)defTab));
    }

    public void loadValues() {
        for (PrefsPanel p : this.d_tabPanels.values()) {
            p.loadData();
        }
    }

    public void saveData() {
        this.d_pyroMod.pauseUpdates();
        for (PrefsPanel p : this.d_tabPanels.values()) {
            p.saveData();
        }
        PyroSim.getApp().superSavePreferences();
        this.d_pyroMod.resumeUpdates();
    }

    public static <T> void setPref(TypedProp<T> prop, T value) {
        PyroSim.setPref(prop, value, false);
    }

    public static void setPref(PyroPrefs.UDProp prop, UnitDouble value) {
        PyroSim.setPref(prop, value.getValue(prop.d_storeUnit), false);
    }

    private static class ExeFileChooserPanel {
        private static final Icon OPEN_ICON = PyroGuiUtil.loadTeciIcon("Open16.gif");
        private final guiPanel d_parent;
        private final String d_preferenceKey;
        private final guiLabel d_label;
        private final guiTextField d_locationTF;
        private final JButton d_locationBtn;
        private final guiLabel d_versionLbl;
        private final boolean d_detectVersionComp;

        public ExeFileChooserPanel(guiPanel parent, String locKey, String desc) {
            this(parent, locKey, desc, false);
        }

        public ExeFileChooserPanel(final guiPanel parent, String locKey, String desc, boolean detectFDSComp) {
            this.d_parent = parent;
            this.d_preferenceKey = locKey;
            this.d_detectVersionComp = detectFDSComp;
            this.d_label = new guiLabel(desc);
            this.d_locationTF = new guiTextField();
            this.d_locationTF.setEditable(false);
            this.d_locationTF.setColumns(35);
            this.d_locationBtn = new JButton(OPEN_ICON);
            this.d_locationBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.getFile(parent);
                    if (d_detectVersionComp) {
                        this.detectFDSVersion(d_locationTF.getText());
                    }
                }
            });
            if (this.d_detectVersionComp) {
                this.d_versionLbl = new guiLabel(Version.FDS_DESIGN.toString());
                Dimension prototype = this.d_versionLbl.getPreferredSize();
                this.d_versionLbl.setPreferredSize(new Dimension(prototype.width * 11 / 10, prototype.height));
                this.d_versionLbl.setToolTipText(this.d_versionLbl.getText());
                this.d_versionLbl.setText("");
            } else {
                this.d_versionLbl = null;
            }
        }

        private void detectFDSVersion(String fdsExeLoc) {
            new Thread(() -> {
                try {
                    FDSVersion version = FDSVersion.detectCompability(new File(fdsExeLoc));
                    ExeFileChooserPanel.updateLabel(this.d_versionLbl, version.toString(), this.d_versionLbl.getText());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    ExeFileChooserPanel.updateLabel(this.d_versionLbl, Intl.intl("Version: ?"), t.getClass().getSimpleName() + ": " + t.getLocalizedMessage());
                }
            }).start();
        }

        private static void updateLabel(guiLabel label, String text, String tooltip) {
            EventQueue.invokeLater(() -> {
                label.setText(text);
                label.setToolTipText(tooltip);
            });
        }

        public void addToPanel(GridBagHelper gb) {
            gb.addIdentRow(this.d_label, this.d_locationTF, 1.0, this.d_locationBtn, this.d_versionLbl);
        }

        public void load(PyroSim app) {
            String loc = PyroPrefs.getFDSLoc(this.d_preferenceKey, true);
            if (loc == null) {
                loc = "";
            }
            this.d_locationTF.setText(loc);
            if (this.d_detectVersionComp) {
                this.detectFDSVersion(loc);
            }
        }

        public void save(PyroSim app) {
            String loc = this.d_locationTF.getText();
            PyroPrefs.setFDSLoc(this.d_preferenceKey, loc);
            PyroSim.getApp().getMediator().changedEvt(PyroMod.EVT_PREFS_CHANGED);
        }

        public void getFile(guiPanel parent) {
            File chosenFile = PyroSim.getFilenames().getOpenFile((Component)parent, new File(this.d_locationTF.getText()), "exe", Intl.intl("Executable Files"));
            if (chosenFile == null) {
                return;
            }
            this.d_locationTF.setText(chosenFile.getAbsolutePath());
        }
    }

    private static class ResultsPanel
    extends PrefsPanel {
        private static final long serialVersionUID = 3807312583474227091L;
        private final guiCheckBox d_showInCad;
        private final guiCheckBox d_showMesh;
        private final guiCheckBox d_writePyroGeom;
        private final guiCheckBox d_writeGE1;
        private final guiCheckBox d_writeIni;
        private final guiCheckBox d_writeViews;

        public ResultsPanel() {
            super(new GridBagLayout());
            TitleSeparator initTitle = new TitleSeparator(Intl.intl("Initialization"));
            this.d_showInCad = new guiCheckBox(Intl.intl("Show GE1 file by default"));
            this.d_showInCad.setToolTipText(Intl.intl("Shows the GE1 file immediately when Smokeview is launched"));
            this.d_showMesh = new guiCheckBox(Intl.intl("Include mesh boundaries in CAD files"));
            this.d_showMesh.setToolTipText(Intl.intl("Whether to include the mesh boundaries in exported CAD files (GE1, PyroGeom)"));
            this.d_writePyroGeom = new guiCheckBox(Intl.intl("Output PyroGeom file"));
            this.d_writePyroGeom.setToolTipText("<html>" + Intl.intl("Outputs a CAD data file for the PyroSim 3D Results"));
            this.d_writeGE1 = new guiCheckBox(Intl.intl("Output GE1 file"));
            this.d_writeGE1.setToolTipText("<html>" + Intl.intl("Outputs a CAD data file for Smokeview (also viewable in the PyroSim 3D Results)."));
            this.d_writeIni = new guiCheckBox(Intl.intl("Output INI file"));
            this.d_writeIni.setToolTipText("<html>" + Intl.intl("Writes the Smokeview INI file (NOTE: view information is only<br>included if the Views file is turned off)."));
            this.d_writeViews = new guiCheckBox(Intl.intl("Output Views file"));
            this.d_writeViews.setToolTipText(Intl.intl("Writes the Views file for PyroSim 3D Results, containing view information."));
            guiUtil.link((AbstractButton)this.d_writeGE1, this.d_showInCad);
            GridBagHelper gbh = new GridBagHelper(this);
            gbh.addFilledRow(initTitle);
            gbh.addIdentRow(this.d_showMesh);
            gbh.addFilledRow(new TitleSeparator(Intl.intl("PyroSim 3D Results Files")));
            gbh.indent();
            gbh.addRow(this.d_writeViews);
            gbh.addRow(this.d_writePyroGeom);
            gbh.unindent();
            gbh.addFilledRow(new TitleSeparator(Intl.intl("Smokeview Files")));
            gbh.indent();
            gbh.addRow(this.d_writeIni);
            gbh.addRow(this.d_writeGE1);
            gbh.addIdentRow(this.d_showInCad);
            gbh.unindent();
            gbh.finalizeRows();
        }

        @Override
        public void loadData() {
            this.d_showInCad.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_DISPLAYGE1));
            this.d_showMesh.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_MESHBOUNDS));
            this.d_writePyroGeom.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEPYROGEOM));
            this.d_writeGE1.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEGE1));
            this.d_writeIni.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITESMVINI));
            this.d_writeViews.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEVIEWS));
        }

        @Override
        public void saveData() {
            PreferencesDialog.setPref(PyroPrefs.RESULTS_DISPLAYGE1, this.d_showInCad.isSelected());
            PreferencesDialog.setPref(PyroPrefs.RESULTS_MESHBOUNDS, this.d_showMesh.isSelected());
            PreferencesDialog.setPref(PyroPrefs.RESULTS_WRITEPYROGEOM, this.d_writePyroGeom.isSelected());
            PreferencesDialog.setPref(PyroPrefs.RESULTS_WRITEGE1, this.d_writeGE1.isSelected());
            PreferencesDialog.setPref(PyroPrefs.RESULTS_WRITESMVINI, this.d_writeIni.isSelected());
            PreferencesDialog.setPref(PyroPrefs.RESULTS_WRITEVIEWS, this.d_writeViews.isSelected());
        }
    }

    private static class FDSPanel
    extends PrefsPanel {
        private static final long serialVersionUID = 2220889344058346621L;
        private final guiComboBox<FDSVersion> d_fdsCompCB;
        private final ExeFileChooserPanel d_svExe;
        private final ExeFileChooserPanel d_fdsExe;
        private final guiCheckBox d_autosaveFileOnRun;
        private final guiCheckBox d_runSV;

        public FDSPanel() {
            super(new GridBagLayout());
            guiLabel fdsCompLbl = new guiLabel("FDS Compability:");
            this.d_fdsCompCB = new guiComboBox<FDSVersion>(FDSVersion.getSupported());
            boolean x64 = PyroSim.is64Bit();
            TitleSeparator fdsExecutablesLbl = new TitleSeparator(Intl.intl("Executable Locations") + (x64 ? " (x64)" : ""));
            TitleSeparator fdsExecutionLbl = new TitleSeparator(Intl.intl("Execution"));
            this.d_autosaveFileOnRun = new guiCheckBox(Intl.intl("Auto-save PyroSim model before running FDS"), false);
            this.d_runSV = new guiCheckBox(Intl.intl("Run Results when FDS simulation completes"), true);
            guiLabel compatibilityLbl = new guiLabel(String.format(Intl.intl("NOTE: PyroSim is designed to work with FDS %s and later."), Version.FDS_DESIGN));
            compatibilityLbl.setFont(compatibilityLbl.getFont().deriveFont(1));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addFilledRow(fdsExecutablesLbl);
            this.d_svExe = new ExeFileChooserPanel(this, "sv.location", Intl.intl("Smokeview:"));
            this.d_fdsExe = new ExeFileChooserPanel(this, "location", Intl.intl("FDS:"), true);
            this.d_fdsExe.addToPanel(gb);
            this.d_svExe.addToPanel(gb);
            gb.addIdentRow(compatibilityLbl, GridBagHelper.REMAINING);
            gb.addFilledRow(fdsExecutionLbl);
            gb.addIdentRow(this.d_autosaveFileOnRun, 0);
            if (this.d_fdsCompCB.getModel().getSize() > 1) {
                gb.addIdentRow(fdsCompLbl, this.d_fdsCompCB);
            }
            gb.addIdentRow(this.d_runSV, 0);
            gb.finalizeRows();
        }

        @Override
        public void loadData() {
            PyroSim pySim = PyroSim.getApp();
            this.d_fdsCompCB.setSelectedItem(pySim.getFDSCompability());
            this.d_fdsExe.load(pySim);
            this.d_svExe.load(pySim);
            this.d_autosaveFileOnRun.setSelected(PyroPrefs.getBoolean(PyroPrefs.AUTOSAVE_ON_RUN_FDS));
            boolean runSV = PyroPrefs.getBoolean(PyroPrefs.PREF_RUNSV);
            this.d_runSV.setSelected(runSV);
        }

        @Override
        public void saveData() {
            PyroSim pySim = PyroSim.getApp();
            pySim.setFDSCompability(this.d_fdsCompCB.getSelectedItem());
            this.d_fdsExe.save(pySim);
            this.d_svExe.save(pySim);
            PreferencesDialog.setPref(PyroPrefs.AUTOSAVE_ON_RUN_FDS, this.d_autosaveFileOnRun.isSelected());
            PreferencesDialog.setPref(PyroPrefs.PREF_RUNSV, this.d_runSV.isSelected());
        }
    }

    private static class RecordViewPanel
    extends PrefsPanel {
        private static final long serialVersionUID = -6926992930099772676L;
        private guiComboBox d_fontSizeCombo;
        private guiCheckBox d_enableSyntaxHi;

        public RecordViewPanel() {
            super(new GridBagLayout());
            GridBagHelper gbh = new GridBagHelper(this);
            guiLabel fontSizeLabel = new guiLabel(Intl.intl("Font Size:"));
            String[] sizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36"};
            this.d_fontSizeCombo = new guiComboBox(Arrays.asList(sizes)){
                private static final long serialVersionUID = -3857544167298911010L;

                @Override
                public boolean validateData(boolean showWarn, boolean allowModify) {
                    super.validateData(showWarn, allowModify);
                    try {
                        float f = Float.parseFloat(this.getSelectedItem() + "");
                        if ((double)f < 1.0) {
                            throw new Exception("Invalid font size.");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (showWarn) {
                            String msg = String.format(Intl.intl("Invalid font size."), new Object[0]);
                            this.showMessageBox(msg);
                            this.requestFocusHack();
                        }
                        return false;
                    }
                    return true;
                }
            };
            this.d_fontSizeCombo.setEditable(true);
            gbh.addRow(fontSizeLabel, 2, this.d_fontSizeCombo);
            this.d_enableSyntaxHi = new guiCheckBox(Intl.intl("Enable Syntax Highlighting"));
            gbh.addRow(this.d_enableSyntaxHi, 3);
            gbh.finalizeRows();
        }

        @Override
        public void loadData() {
            float fontSize = PyroPrefs.getFloat(PyroPrefs.RECORD_VIEW_FONTSIZE);
            this.d_fontSizeCombo.setSelectedItem(Float.valueOf(fontSize));
            boolean enableSyntaxHiFlag = PyroPrefs.getBoolean(PyroPrefs.SYNTAX_HIGHLIGHT_ENABLE);
            this.d_enableSyntaxHi.setSelected(enableSyntaxHiFlag);
        }

        @Override
        public void saveData() {
            PreferencesDialog.setPref(PyroPrefs.RECORD_VIEW_FONTSIZE, Float.valueOf(Float.parseFloat("" + this.d_fontSizeCombo.getSelectedItem())));
            PreferencesDialog.setPref(PyroPrefs.SYNTAX_HIGHLIGHT_ENABLE, this.d_enableSyntaxHi.isSelected());
        }
    }

    private static class PyroSimPanel
    extends PrefsPanel {
        private static final long serialVersionUID = 2460256735511807191L;
        private final guiCheckBox d_easyReadFormatBox;
        private final ValueField<Integer> d_easyReadPrecision;
        private final ValueField<Integer> d_numMRUFiles;
        private final guiCheckBox d_autosave;
        private final ValueField<UnitDouble> d_autosaveInterval;
        private final guiCheckBox d_createBackupOnOpen;
        private final guiCheckBox d_recordPreview;
        private final guiCheckBox d_showSplash;

        public PyroSimPanel() {
            super(new GridBagLayout());
            TitleSeparator fileFormatLabel = new TitleSeparator(Intl.intl("FDS File Format"));
            this.d_easyReadFormatBox = new guiCheckBox(Intl.intl("Format FDS file for easy reading"));
            this.d_easyReadPrecision = ValueFields.intFld(IntVR.above(2, true));
            guiLabel precisionLbl = new guiLabel(Intl.intl("Max precision:"));
            LinkStatus.link((AbstractButton)this.d_easyReadFormatBox, this.d_easyReadPrecision, precisionLbl);
            TitleSeparator autosaveLabel = new TitleSeparator(Intl.intl("Options"));
            this.d_numMRUFiles = ValueFields.intFld(IntVR.between(1, 30, true, true));
            this.d_autosave = new guiCheckBox(Intl.intl("Autosave:"));
            UnitDouble tenMin = new UnitDouble(10.0, NonSI.MINUTE);
            UnitDoubleVR aboveOneMin = UnitDoubleVR.above(new UnitDouble(0.0, NonSI.MINUTE), false);
            this.d_autosaveInterval = ValueFields.udFld(tenMin, aboveOneMin, UnitSystem.getSource(2));
            LinkStatus.link((AbstractButton)this.d_autosave, this.d_autosaveInterval);
            this.d_createBackupOnOpen = new guiCheckBox(Intl.intl("Create Backup on Open"));
            this.d_recordPreview = new guiCheckBox(Intl.intl("Record Preview"));
            this.d_showSplash = new guiCheckBox(Intl.intl("Show Splash Screen on Startup"));
            guiLabel editHotkeyLbl = new guiLabel(Intl.intl("Keyboard Shortcuts:"));
            JButton editHotkeys = new JButton(Intl.intl("Edit..."));
            editHotkeys.addActionListener(e -> {
                CustomKeyAcceleratorDlg dlg = new CustomKeyAcceleratorDlg(Application.getApp().getActiveFrame(), new PyroActionMap.PyroShortcutUIHelper());
                if (dlg.doModal() == 1) {
                    dlg.saveData();
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addFilledRow(fileFormatLabel);
            gb.addIdentRow(this.d_easyReadFormatBox, 0);
            gb.indent();
            gb.addIdentRow(precisionLbl, this.d_easyReadPrecision);
            gb.unindent();
            gb.addFilledRow(autosaveLabel);
            gb.addIdentRow(new guiLabel(Intl.intl("Number of Recent Files:")), this.d_numMRUFiles);
            gb.addIdentRow(this.d_autosave, this.d_autosaveInterval);
            gb.addIdentRow(this.d_createBackupOnOpen, 0);
            gb.addIdentRow(this.d_recordPreview, 0);
            gb.addIdentRow(this.d_showSplash, 0);
            gb.addIdentRow(editHotkeyLbl, editHotkeys);
            gb.finalizeRows();
        }

        @Override
        public void loadData() {
            PyroSim pySim = PyroSim.getApp();
            FDSRenderProps props = pySim.getFDSRenderProps();
            FDSRenderProps.IDecimalFormatter formatter = props.getDecimalFormatter();
            this.d_easyReadFormatBox.setSelected(formatter instanceof FDSRenderProps.GeneralFormatter);
            if (formatter instanceof FDSRenderProps.GeneralFormatter) {
                this.d_easyReadPrecision.setValue(((FDSRenderProps.GeneralFormatter)formatter).precision);
            } else {
                this.d_easyReadPrecision.setValue(PyroPrefs.getInt(PyroPrefs.FDSFormatGenPrecision));
            }
            this.d_numMRUFiles.setValue(pySim.getMRUMenu().getNumMenuItems());
            this.d_autosave.setSelected(PyroPrefs.getBoolean(PyroPrefs.PREF_USEAUTOSAVE));
            this.d_autosaveInterval.setValue(PyroPrefs.getUnitDouble(PyroPrefs.PREF_AUTOSAVE_INTERVAL));
            this.d_createBackupOnOpen.setSelected(PyroPrefs.getBoolean(PyroPrefs.PREF_CREATE_BACKUP_ON_OPEN));
            this.d_recordPreview.setSelected(PyroPrefs.getBoolean(PyroPrefs.PREF_RECORD_PREVIEW));
            this.d_showSplash.setSelected(pySim.getPrefs().getBoolean(Application.PROP_SHOWSPLASH));
        }

        @Override
        public void saveData() {
            PyroSim pySim = PyroSim.getApp();
            FDSRenderProps props = pySim.getFDSRenderProps();
            FDSRenderProps.IDecimalFormatter formatter = this.d_easyReadFormatBox.isSelected() ? new FDSRenderProps.GeneralFormatter((Integer)this.d_easyReadPrecision.getValue()) : new FDSRenderProps.ScientificFormatter();
            props.setDecimalFormatter(formatter);
            pySim.getMRUMenu().setNumMenuItems((Integer)this.d_numMRUFiles.getValue());
            PreferencesDialog.setPref(PyroPrefs.PREF_USEAUTOSAVE, this.d_autosave.isSelected());
            PreferencesDialog.setPref(PyroPrefs.PREF_AUTOSAVE_INTERVAL, (UnitDouble)this.d_autosaveInterval.getValue());
            PreferencesDialog.setPref(PyroPrefs.PREF_CREATE_BACKUP_ON_OPEN, this.d_createBackupOnOpen.isSelected());
            PreferencesDialog.setPref(PyroPrefs.PREF_RECORD_PREVIEW, this.d_recordPreview.isSelected());
            PreferencesDialog.setPref(Application.PROP_SHOWSPLASH, this.d_showSplash.isSelected());
        }
    }

    private static class DisplayPanel
    extends PrefsPanel {
        private static final long serialVersionUID = -1830210112889756964L;
        private final guiCheckBox d_useFastColorRedraws = new guiCheckBox(Intl.intl("Hardware accelerated cursor"), false);
        private final guiCheckBox d_useFastDepthRedraws;
        private final RenderPrefs.PrefsUI d_rprefs;

        public DisplayPanel(Supplier<IPropertySet> getRenderPref, Supplier<IPropertySet> getRenderComp, Supplier<IRenderSurface.OpenGLInfo> getRenderInfo) {
            super(new GridBagLayout());
            this.d_useFastColorRedraws.setToolTipText(Intl.intl("Accelerates drawing and editing objects in complex models."));
            this.d_useFastDepthRedraws = new guiCheckBox(Intl.intl("Hardware accelerated 3D editing (only available on some hardware)"), false);
            this.d_rprefs = new RenderPrefs.PrefsUI("PyroSim");
            LinkStatus.link((AbstractButton)this.d_useFastColorRedraws, this.d_useFastDepthRedraws);
            this.d_useFastColorRedraws.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (!d_useFastColorRedraws.isSelected()) {
                        d_useFastDepthRedraws.setSelected(false);
                    }
                }
            });
            Consumer<IPropertySet> loadPrefs = prefs -> this.loadData((IPropertySet)prefs, true, false);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addTitle(Intl.intl("GPU Information"));
            gb.addIdentRow(new GPUInfoPnl(getRenderInfo, true), 1.0, 0);
            gb.addSeparator();
            gb.addRow(new Object[]{RenderPrefs.getRenderPrefsBtns(getRenderPref, getRenderComp, loadPrefs), 1.0, 0, GridBagHelper.Anchor.CENTER});
            gb.indent();
            gb.addRow(this.d_useFastColorRedraws, 0);
            this.d_rprefs.addTo(gb);
            gb.finalizeRows();
        }

        @Override
        public void loadData() {
            this.loadData(PyroPrefs.instance(), false, true);
        }

        private void loadData(IPropertySet props, boolean onlyIfDefined, boolean clearRestart) {
            guiUtil.loadPref(props, onlyIfDefined, this.d_useFastColorRedraws, PyroPrefs.PREF_DRAWCOLORBUFFER);
            guiUtil.loadPref(props, onlyIfDefined, this.d_useFastDepthRedraws, PyroPrefs.PREF_DRAWDEPTHBUFFER);
            this.d_rprefs.loadData(props, onlyIfDefined, clearRestart);
        }

        @Override
        public void saveData() {
            PreferencesDialog.setPref(PyroPrefs.PREF_DRAWCOLORBUFFER, this.d_useFastColorRedraws.isSelected());
            PreferencesDialog.setPref(PyroPrefs.PREF_DRAWDEPTHBUFFER, this.d_useFastDepthRedraws.isSelected());
            TeciProps tprops = new TeciProps();
            this.d_rprefs.saveData(tprops);
            PyroSim.setPrefs(tprops, false);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            return this.d_rprefs.validateData(showWarn, allowModify);
        }
    }

    public static enum Tabs {
        PYROSIM(Intl.intl("PyroSim")),
        RECORDVIEW(Intl.intl("Record View")),
        FDS(Intl.intl("FDS")),
        RESULTS(Intl.intl("Results")),
        RENDERING(Intl.intl("Rendering"));

        public final String desc;

        private Tabs(String desc) {
            this.desc = desc;
        }
    }

    private static abstract class PrefsPanel
    extends guiPanel {
        private static final long serialVersionUID = 1906931603730818333L;

        public PrefsPanel(LayoutManager lmgr) {
            super(lmgr);
        }

        public abstract void loadData();

        public abstract void saveData();
    }
}

