/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.signals;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.domain.signals.AInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import thunderheadeng.util.IHasher;
import thunderheadeng.util.IdentityHasher;
import thunderheadeng.util.ListSet;

public abstract class AMultiInPin
extends AInPin {
    static final long serialVersionUID = 1L;
    private final int d_maxConnections;
    @SkipDep
    private ListSet<IOutPin> d_connections;

    public AMultiInPin(ISignalSink sink, int numPossibleConnections) {
        super(sink);
        this.d_connections = numPossibleConnections != Integer.MAX_VALUE ? new ListSet<Object>((IHasher<Object>)IdentityHasher.INSTANCE, (T[])new Object[]{numPossibleConnections}) : new ListSet(IdentityHasher.INSTANCE);
        this.d_maxConnections = numPossibleConnections;
    }

    @Override
    public Object clone() {
        AMultiInPin clone = (AMultiInPin)super.clone();
        clone.d_connections = new ListSet<IOutPin>((IHasher<IOutPin>)IdentityHasher.INSTANCE, (Collection<IOutPin>)this.d_connections);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AMultiInPin)) {
            return false;
        }
        AMultiInPin pin = (AMultiInPin)obj;
        return super.equals(obj) && this.d_maxConnections == pin.d_maxConnections;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 231503 + this.d_maxConnections;
    }

    @Override
    public boolean canConnect(IOutPin pin2) {
        return super.canConnect(pin2) && this.d_connections.size() < this.d_maxConnections;
    }

    @Override
    public void connect(IOutPin pin2) {
        assert (this.canConnect(pin2));
        this.d_connections.add(pin2);
        super.connect(pin2);
    }

    @Override
    public boolean disconnect(IOutPin pin2) {
        if (!this.d_connections.remove(pin2)) {
            return false;
        }
        return super.disconnect(pin2);
    }

    @Override
    public boolean disconnectAll() {
        this.d_connections.clear();
        return true;
    }

    @Override
    public Set<? extends IOutPin> getConnections() {
        return Collections.unmodifiableSet(this.d_connections);
    }
}

