/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.rasterization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Point3i;
import org.jscience.physics.units.Unit;
import pyrosim.PyroMod;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.rasterization.FDSObjectRasterization;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.domain.rasterization.IFDSObjProps;
import pyrosim.domain.rasterization.IFragGenerator;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.geom.Geometry;
import pyrosim.geom.Util;
import pyrosim.geom.rasterization.IRaster3D;
import pyrosim.geom.rasterization.Raster3D_V2;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.util.AdjacencyMerger;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.MergedCell;
import thunderheadeng.util.Pair;
import thunderheadeng.util.SortCache;
import thunderheadeng.util.theUtil;

public class FDSRasterization {
    private static final int INTERIOR_GROUP = -1;
    private final PyroMod d_domain;
    private final Map<Grid, IRaster3D> d_gridRasterMap = new LinkedIdentityHashMap<Grid, IRaster3D>();
    private static final theUtil.DoubleComparator s_gridAlignComp = new theUtil.DoubleComparator(){

        @Override
        public int compare(double v1, double v2) {
            return theUtil.compare(v2, v1, 1.0E-6);
        }
    };

    public FDSRasterization(PyroMod mediator) {
        this.d_domain = mediator;
    }

    public FDSRasterization(PyroMod mediator, Collection<? extends Grid> grids) {
        this(mediator);
        this.addRasters(grids);
    }

    private static IRaster3D createRaster(double[] xDiv, double[] yDiv, double[] zDiv) {
        return new Raster3D_V2(xDiv, yDiv, zDiv);
    }

    public RasterizationOptions getRastOptions() {
        return this.d_domain.getRastOptions();
    }

    private SortCache<FaceProps> getFaceProps(Collection<? extends FDSObject> objs) {
        LinkedHashSet<FaceProps> faceProps = new LinkedHashSet<FaceProps>();
        for (FDSObject fDSObject : objs) {
            IFDSObjProps fragGen = this.retrieveRasterProps(fDSObject, this.d_gridRasterMap.values());
            if (fragGen == null) continue;
            int numFaces = fDSObject.getGeom().getNumPrims(1);
            for (int m = 0; m < numFaces; ++m) {
                faceProps.add(fragGen.getFace(m));
            }
        }
        return new SortCache<FaceProps>(faceProps, false);
    }

    public FDSObjectRasterization rasterize(FDSObject obj) {
        FDSObjectRasterization[] rast = this.rasterize(Arrays.asList(obj));
        return rast.length > 0 ? rast[0] : null;
    }

    public FDSObjectRasterization[] rasterize(FDSObject ... objs) {
        return this.rasterize(Arrays.asList(objs));
    }

    public FDSObjectRasterization[] rasterize(Collection<? extends FDSObject> objs) {
        Map<IFragGenerator, List<FDSObject>> separated = this.separateByFragGen(objs);
        ArrayList<FDSObjectRasterization> rast = new ArrayList<FDSObjectRasterization>(separated.size());
        for (Map.Entry<IFragGenerator, List<FDSObject>> entry : separated.entrySet()) {
            this.rasterize(rast, entry.getKey(), entry.getValue());
        }
        return rast.toArray(new FDSObjectRasterization[rast.size()]);
    }

    private Map<IFragGenerator, List<FDSObject>> separateByFragGen(Collection<? extends FDSObject> objs) {
        LinkedHashMap<IFragGenerator, List<FDSObject>> map = new LinkedHashMap<IFragGenerator, List<FDSObject>>();
        for (FDSObject fDSObject : objs) {
            IFDSObjProps rastProps = this.retrieveRasterProps(fDSObject, this.d_gridRasterMap.values());
            if (rastProps == null) continue;
            IFragGenerator fragGen = rastProps.getFragGenerator(this.getRastOptions());
            ArrayList<FDSObject> simObjs = (ArrayList<FDSObject>)map.get(fragGen);
            if (simObjs == null) {
                simObjs = new ArrayList<FDSObject>(2);
                map.put(fragGen, simObjs);
            }
            simObjs.add(fDSObject);
        }
        return map;
    }

    protected void rasterize(List<FDSObjectRasterization> rasts, IFragGenerator fragGen, List<? extends FDSObject> objs) {
        SortCache<FaceProps> faceProps = this.getFaceProps(objs);
        if (faceProps.size() == 0) {
            return;
        }
        RasterizationOptions rastProps = this.d_domain.getRastOptions();
        AABox tempBounds = new AABox();
        int encodeShift = FDSRasterization.calculateShift(objs.size());
        List[] result = new List[objs.size()];
        for (Map.Entry<Grid, IRaster3D> entry : this.d_gridRasterMap.entrySet()) {
            Grid grid = entry.getKey();
            IRaster3D finalRaster = entry.getValue();
            IRaster3D currRaster = null;
            if (!grid.isEnabled()) continue;
            AABox gridBounds = grid.getGeom().getBoundingBox(new AABox());
            int rastCount = 0;
            for (int n = 0; n < objs.size(); ++n) {
                IFDSObjProps objProps;
                FDSObject obj = objs.get(n);
                int evac = obj.getEvac().evacuation;
                if (evac == 2 && !grid.getEvacuation() || evac == 1 && grid.getEvacuation() || (objProps = this.retrieveRasterProps(obj, this.d_gridRasterMap.values())) == null) continue;
                List<Pair<TransformInfo, IGeom>> rastObjs = obj.getGeom().quickFlatten(1);
                int faceOffset = 0;
                for (Pair<TransformInfo, IGeom> rastObj : rastObjs) {
                    IGeom geom = (IGeom)rastObj.v2;
                    tempBounds.reset();
                    AABox objBounds = ((TransformInfo)rastObj.v1).getBounds(geom, tempBounds);
                    if (!FDSRasterization.outsideMesh(gridBounds, objBounds)) {
                        ++rastCount;
                        if (currRaster == null) {
                            currRaster = finalRaster;
                        } else if (currRaster == finalRaster) {
                            currRaster = FDSRasterization.createRaster(grid);
                        }
                        currRaster.clear();
                        this.rasterize(rastProps, currRaster, objProps, (TransformInfo)rastObj.v1, geom, faceProps, faceOffset, encodeShift, n, result);
                        if (currRaster != finalRaster) {
                            finalRaster.merge(currRaster);
                        }
                    }
                    faceOffset += geom.getNumPrims(1);
                }
            }
            finalRaster.finalizeData();
            boolean separateDisconnected = this.getRastOptions().separateDisconnected && rastCount > 1;
            this.retrieveRasterizations(finalRaster, faceProps, rastProps.largeBlocks, separateDisconnected, encodeShift, result);
            finalRaster.clear();
        }
        ArrayList<FDSObject> nonRastObjs = new ArrayList<FDSObject>();
        LinkedIdentityHashMap<List, ArrayList<FDSObject>> map = new LinkedIdentityHashMap<List, ArrayList<FDSObject>>();
        for (int m = 0; m < objs.size(); ++m) {
            FDSObject obj = objs.get(m);
            List geomList = result[m];
            if (geomList != null) {
                ArrayList<FDSObject> objList = (ArrayList<FDSObject>)map.get(geomList);
                if (objList == null) {
                    objList = new ArrayList<FDSObject>();
                    map.put(geomList, objList);
                }
                objList.add(obj);
                continue;
            }
            nonRastObjs.add(obj);
        }
        if (!nonRastObjs.isEmpty()) {
            FDSObjectRasterization rast = new FDSObjectRasterization(fragGen, nonRastObjs, new Pair[0]);
            rasts.add(rast);
        }
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getKey();
            Pair[] arr = list.toArray(new Pair[list.size()]);
            FDSObjectRasterization rast = new FDSObjectRasterization(fragGen, (List)entry.getValue(), arr);
            rasts.add(rast);
        }
    }

    private static boolean outsideMesh(AABox gridBounds, AABox objBounds) {
        return FDSRasterization.outsideMesh(gridBounds.getMinX(), gridBounds.getMaxX(), objBounds.getMinX(), objBounds.getMaxX()) || FDSRasterization.outsideMesh(gridBounds.getMinY(), gridBounds.getMaxY(), objBounds.getMinY(), objBounds.getMaxY()) || FDSRasterization.outsideMesh(gridBounds.getMinZ(), gridBounds.getMaxZ(), objBounds.getMinZ(), objBounds.getMaxZ());
    }

    private static boolean outsideMesh(double gridMin, double gridMax, double objMin, double objMax) {
        return !theUtil.eq(objMin, objMax, 1.0E-9) && (theUtil.eq(objMin, gridMax, 1.0E-9) || theUtil.eq(objMax, gridMin, 1.0E-9));
    }

    private static List<Pair<IGeom, Integer>> flatten(IGeom geom) {
        ArrayList<Pair<IGeom, Integer>> nonGroups = new ArrayList<Pair<IGeom, Integer>>();
        FDSRasterization.getNonGroups(geom, 0, nonGroups);
        return nonGroups;
    }

    private static void getNonGroups(IGeom geom, int faceOffset, List<Pair<IGeom, Integer>> nonGroups) {
        if (geom instanceof GeomGroup) {
            GeomGroup group = (GeomGroup)geom;
            for (IGeom child : group.children) {
                FDSRasterization.getNonGroups(child, faceOffset, nonGroups);
                faceOffset += child.getNumPrims(1);
            }
        } else {
            nonGroups.add(new Pair<IGeom, Integer>(geom, faceOffset));
        }
    }

    private static List<Pair<IGeom, FaceProps[]>> getGeomList(List<Pair<IGeom, FaceProps[]>>[] allGeoms, int ... sources) {
        List<Pair<IGeom, FaceProps[]>> list;
        if (sources.length == 1) {
            List<Pair<IGeom, FaceProps[]>> objGeoms = allGeoms[sources[0]];
            if (objGeoms == null) {
                allGeoms[sources[0]] = objGeoms = new ArrayList<Pair<IGeom, FaceProps[]>>(2);
            }
            return objGeoms;
        }
        ArrayList<Pair<IGeom, FaceProps[]>> objGeoms = null;
        for (int source : sources) {
            list = allGeoms[source];
            if (objGeoms != null && (list == null || list.size() <= objGeoms.size())) continue;
            objGeoms = list;
        }
        if (objGeoms == null) {
            objGeoms = new ArrayList();
        }
        for (int source : sources) {
            list = allGeoms[source];
            if (list != null && list != objGeoms) {
                objGeoms.addAll(list);
            }
            allGeoms[source] = objGeoms;
        }
        return objGeoms;
    }

    private void rasterize(RasterizationOptions rastProps, IRaster3D raster, IFDSObjProps fragGen, TransformInfo ti, IGeom geom, SortCache<FaceProps> faceProps, int faceOffset, int encodeShift, int objid, List<Pair<IGeom, FaceProps[]>>[] rastGeom) {
        assert (!(geom instanceof GeomGroup));
        if (!this.shouldRasterize(ti, geom, Arrays.asList(raster))) {
            AABoxGeom aaGeom = geom instanceof AABoxGeom ? (AABoxGeom)geom : new AABoxGeom(ti.getBounds(geom, new AABox()));
            FaceProps[] props = new FaceProps[6];
            for (int m = 0; m < 6; ++m) {
                props[m] = fragGen.getFace(m + faceOffset);
            }
            if (FDSRasterization.areAllEqual(props)) {
                props = new FaceProps[]{props[0]};
            }
            FDSRasterization.getGeomList(rastGeom, objid).add(new Pair<AABoxGeom, FaceProps[]>(aaGeom, props));
        } else {
            boolean thicken = rastProps.forceThicken || fragGen.thickenEnabled();
            List faces = thunderheadeng.geometry.objs.GeomUtil.explode(geom.transform(ti, 0), IFace.class);
            if (!geom.isShell()) {
                ArrayList<Integer> faceGroups = new ArrayList<Integer>(faces.size());
                ArrayList<Point3d[]> polys = new ArrayList<Point3d[]>(faces.size());
                for (int m = 0; m < faces.size(); ++m) {
                    int faceGroup = faceProps.indexOf(fragGen.getFace(m + faceOffset));
                    IFace face = (IFace)faces.get(m);
                    List<IPolygon> facePolys = GeomUtil.toPolys(face, 0.1, true);
                    for (IPolygon poly : facePolys) {
                        polys.add(PolyUtil.getAllVerts(poly, false));
                        faceGroups.add(faceGroup);
                    }
                }
                int[] fGroups = theUtil.toIntArray(faceGroups);
                int intGroup = FDSRasterization.getInteriorGroup(fGroups);
                intGroup = FDSRasterization.encodeId(encodeShift, objid, intGroup);
                for (int m = 0; m < fGroups.length; ++m) {
                    fGroups[m] = FDSRasterization.encodeId(encodeShift, objid, fGroups[m]);
                }
                raster.rasterizeSolid(thicken, intGroup, fGroups, (Point3d[][])polys.toArray((T[])new Point3d[polys.size()][]));
            } else {
                ArrayList<Point3d[]> polys = new ArrayList<Point3d[]>(faces.size());
                ArrayList<Integer> faceIds = new ArrayList<Integer>(faces.size());
                for (int m = 0; m < faces.size(); ++m) {
                    int fg = faceProps.indexOf(fragGen.getFace(m + faceOffset));
                    int id = FDSRasterization.encodeId(encodeShift, objid, fg);
                    IFace face = (IFace)faces.get(m);
                    for (IPolygon poly : GeomUtil.toPolys(face, 0.1, true)) {
                        Point3d[] verts = PolyUtil.getAllVerts(poly, false);
                        polys.add(verts);
                        faceIds.add(id);
                    }
                }
                raster.rasterizeShell(thicken, FDSRasterization.encodeId(encodeShift, objid, -1), theUtil.toIntArray(faceIds), theUtil.toArray(polys, Point3d[].class));
            }
        }
    }

    private static int calculateShift(int numObjs) {
        if (numObjs == 0) {
            return 0;
        }
        return (int)Math.ceil(Math.log(numObjs) / Math.log(2.0));
    }

    private static int encodeId(int shift, int objid, int facePropId) {
        int result = facePropId << shift;
        return result |= objid;
    }

    private static int[] decodeId(int shift, int groupId) {
        int objMask = (1 << shift) - 1;
        int objid = groupId & objMask;
        int facePropId = groupId >> shift;
        return new int[]{objid, facePropId};
    }

    private static int getInteriorGroup(int[] faceGroups) {
        if (faceGroups.length > 0) {
            int group = faceGroups[0];
            for (int m = 1; m < faceGroups.length; ++m) {
                if (faceGroups[m] == group) continue;
                return -1;
            }
            return group;
        }
        return -1;
    }

    private void retrieveRasterizations(IRaster3D raster, SortCache<FaceProps> faceProps, boolean merge, boolean separateDisconnected, int encodeShift, List<Pair<IGeom, FaceProps[]>>[] rastGeom) {
        IRaster3D.CellListing[] listings;
        double[] divx = raster.getXDiv();
        double[] divy = raster.getYDiv();
        double[] divz = raster.getZDiv();
        for (IRaster3D.CellListing listing : listings = raster.getListings(separateDisconnected)) {
            int[] sources = FDSRasterization.extractSources(listing, encodeShift);
            List<Pair<IGeom, FaceProps[]>> geoms = FDSRasterization.getGeomList(rastGeom, sources);
            if (merge) {
                this.getFragGeom(FDSRasterization.mergeCells(listing.cell, new MultiPropMerger()), new int[]{1, 1, 1}, new int[]{0, 1, 2, 3, 4, 5}, divx, divy, divz, faceProps, geoms);
                this.getFragGeom(FDSRasterization.mergeCells(listing.xy, new PlaneMultiPropMerger(AdjacencyMerger.Dir.Z)), new int[]{1, 1, 0}, new int[]{4, 5}, divx, divy, divz, faceProps, geoms);
                this.getFragGeom(FDSRasterization.mergeCells(listing.xz, new PlaneMultiPropMerger(AdjacencyMerger.Dir.Y)), new int[]{1, 0, 1}, new int[]{2, 3}, divx, divy, divz, faceProps, geoms);
                this.getFragGeom(FDSRasterization.mergeCells(listing.yz, new PlaneMultiPropMerger(AdjacencyMerger.Dir.X)), new int[]{0, 1, 1}, new int[]{0, 1}, divx, divy, divz, faceProps, geoms);
                continue;
            }
            this.getFragGeom(listing.cell, new int[]{1, 1, 1}, new int[]{0, 1, 2, 3, 4, 5}, divx, divy, divz, faceProps, geoms);
            this.getFragGeom(listing.xy, new int[]{1, 1, 0}, new int[]{4, 5}, divx, divy, divz, faceProps, geoms);
            this.getFragGeom(listing.xz, new int[]{1, 0, 1}, new int[]{2, 3}, divx, divy, divz, faceProps, geoms);
            this.getFragGeom(listing.yz, new int[]{0, 1, 1}, new int[]{0, 1}, divx, divy, divz, faceProps, geoms);
        }
    }

    private static int[] extractSources(IRaster3D.CellListing listing, int shift) {
        HashSet<Integer> sources = new HashSet<Integer>();
        FDSRasterization.extractSources(listing.cell, sources, shift);
        FDSRasterization.extractSources(listing.xy, sources, shift);
        FDSRasterization.extractSources(listing.xz, sources, shift);
        FDSRasterization.extractSources(listing.yz, sources, shift);
        return theUtil.toIntArray(sources);
    }

    private static void extractSources(Pair<Point3i, int[]>[] cellListings, Set<Integer> sources, int shift) {
        for (int m = 0; m < cellListings.length; ++m) {
            Pair<Point3i, int[]> pair = cellListings[m];
            for (int n = 0; n < ((int[])pair.v2).length; ++n) {
                int[] decoded = FDSRasterization.decodeId(shift, ((int[])pair.v2)[n]);
                sources.add(decoded[0]);
                ((int[])pair.v2)[n] = decoded[1];
            }
            if (!FDSRasterization.areAllSame((int[])pair.v2)) continue;
            cellListings[m] = new Pair(pair.v1, new int[]{((int[])pair.v2)[0]});
        }
    }

    private void getFragGeom(Pair<Point3i, int[]>[] rast, int[] adds, int[] facePositions, double[] divx, double[] divy, double[] divz, SortCache<FaceProps> faceProps, List<Pair<IGeom, FaceProps[]>> rastGeom) {
        for (Pair<Point3i, int[]> cell : rast) {
            Point3i loc = (Point3i)cell.v1;
            int[] groups = (int[])cell.v2;
            AABoxGeom geom = new AABoxGeom(new Point3d(divx[loc.x], divy[loc.y], divz[loc.z]), new Point3d(divx[loc.x + adds[0]], divy[loc.y + adds[1]], divz[loc.z + adds[2]]), 0);
            FaceProps[] props = this.getProps(faceProps, groups, facePositions);
            rastGeom.add(new Pair<AABoxGeom, FaceProps[]>(geom, props));
        }
    }

    private void getFragGeom(Collection<MergedCell<MultiProps>> rast, int[] adds, int[] facePositions, double[] divx, double[] divy, double[] divz, SortCache<FaceProps> faceProps, List<Pair<IGeom, FaceProps[]>> rastGeom) {
        for (MergedCell<MultiProps> cell : rast) {
            AABoxGeom geom = new AABoxGeom(new Point3d(divx[cell.x1], divy[cell.y1], divz[cell.z1]), new Point3d(divx[cell.x2 + adds[0]], divy[cell.y2 + adds[1]], divz[cell.z2 + adds[2]]), 0);
            FaceProps[] props = this.getProps(faceProps, ((MultiProps)cell.val).props, facePositions);
            rastGeom.add(new Pair<AABoxGeom, FaceProps[]>(geom, props));
        }
    }

    private FaceProps[] getProps(SortCache<FaceProps> faceProps, int[] groups, int[] facePositions) {
        Object[] props;
        if (FDSRasterization.areAllSame(groups)) {
            props = new FaceProps[]{this.getProp(faceProps, groups, groups[0])};
        } else {
            props = new FaceProps[6];
            Arrays.fill(props, this.getProp(faceProps, groups, groups[0]));
            for (int m = 0; m < Math.min(facePositions.length, 6); ++m) {
                props[facePositions[m]] = this.getProp(faceProps, groups, groups[m]);
            }
        }
        return props;
    }

    private FaceProps getProp(SortCache<FaceProps> props, int[] allGroups, int groupid) {
        if (groupid == -1) {
            for (int group : allGroups) {
                if (group == -1) continue;
                return props.get(group);
            }
            return new FaceProps(this.d_domain.getDefaultSurface(), null);
        }
        return props.get(groupid);
    }

    private static boolean areAllSame(int[] vals) {
        if (vals.length == 1) {
            return true;
        }
        int val = vals[0];
        for (int m = 1; m < vals.length; ++m) {
            if (vals[m] == val) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean areAllEqual(T[] vals) {
        if (vals.length == 1) {
            return true;
        }
        T val = vals[0];
        for (int m = 1; m < vals.length; ++m) {
            if (vals[m].equals(val)) continue;
            return false;
        }
        return true;
    }

    private static boolean compareProps(int props1, int props2) {
        return props1 == -1 || props2 == -1 || props1 == props2;
    }

    private static int[] expand(int[] vals, int count, int[] result) {
        if (vals.length == 1) {
            for (int m = 0; m < count; ++m) {
                result[m] = vals[0];
            }
            return result;
        }
        return vals;
    }

    private static Collection<MergedCell<MultiProps>> mergeCells(Pair<Point3i, int[]>[] rasts, AdjacencyMerger.IMergeQuery<MultiProps> merger) {
        ArrayList mergeCells = new ArrayList();
        for (Pair<Point3i, int[]> rast : rasts) {
            MergedCell<MultiProps> mcell = new MergedCell<MultiProps>(new MultiProps((int[])rast.v2), ((Point3i)rast.v1).x, ((Point3i)rast.v1).x, ((Point3i)rast.v1).y, ((Point3i)rast.v1).y, ((Point3i)rast.v1).z, ((Point3i)rast.v1).z);
            mergeCells.add(mcell);
        }
        return AdjacencyMerger.mergeCells(mergeCells, merger);
    }

    public void update(Events events) {
        boolean reset = false;
        for (EventChannel<PyroMod> eventChannel : events.getAffectedChannels(PyroMod.class, new Class[0])) {
            if (!eventChannel.containsChange(PyroMod.EVT_MODEL_CHANGED)) continue;
            reset = true;
            break;
        }
        if (reset) {
            this.reset();
        } else {
            for (EventChannel<IPyroObject> eventChannel : events.getAffectedChannels(Grid.class, new Class[0])) {
                this.addRasters(eventChannel.getAddedObjs());
                this.removeRasters(eventChannel.getRemovedObjs());
                this.updateRasters(eventChannel.getChangedObjs(EventChannel.EVT_GENERAL));
            }
        }
    }

    private void reset() {
        this.d_gridRasterMap.clear();
        if (this.d_domain != null) {
            this.addRasters(this.d_domain.getGridManager().flatten());
        }
    }

    private static IRaster3D createRaster(Grid g) {
        Unit lu = Geometry.LU;
        double[] xDiv = Util.convertArray(g.getXLinePositions(), lu);
        double[] yDiv = Util.convertArray(g.getYLinePositions(), lu);
        double[] zDiv = Util.convertArray(g.getZLinePositions(), lu);
        return FDSRasterization.createRaster(xDiv, yDiv, zDiv);
    }

    public void addRasters(Collection<? extends Grid> grids) {
        for (Grid grid : grids) {
            IRaster3D raster = FDSRasterization.createRaster(grid);
            this.d_gridRasterMap.put(grid, raster);
        }
    }

    public void removeRasters(Collection<? extends Grid> grids) {
        for (Grid grid : grids) {
            this.d_gridRasterMap.remove(grid);
        }
    }

    public void updateRasters(Collection<? extends Grid> grids) {
        Unit lu = Geometry.LU;
        for (Grid grid : grids) {
            IRaster3D raster = this.d_gridRasterMap.get(grid);
            assert (raster != null);
            double[] xDiv = Util.convertArray(grid.getXLinePositions(), lu);
            double[] yDiv = Util.convertArray(grid.getYLinePositions(), lu);
            double[] zDiv = Util.convertArray(grid.getZLinePositions(), lu);
            raster.setDivisions(xDiv, yDiv, zDiv);
        }
    }

    public Map<Grid, IRaster3D> getGridRasters() {
        return this.d_gridRasterMap;
    }

    public Collection<IRaster3D> getRasters() {
        return this.d_gridRasterMap.values();
    }

    public Collection<Grid> getRasterGrids() {
        return this.d_gridRasterMap.keySet();
    }

    public boolean shouldRasterize(FDSObject obj) {
        return this.shouldRasterize(obj, this.getRasters());
    }

    private boolean shouldRasterize(FDSObject obj, Collection<? extends IRaster3D> rasters) {
        if (obj.getFragGenerator() == null) {
            return false;
        }
        IGeomNode node = obj.getGeom();
        if (!node.getChildren().isEmpty()) {
            return true;
        }
        return this.shouldRasterize(node.getLocalTransform().getInfo(), node.getLocalGeom(), rasters);
    }

    private boolean shouldRasterize(TransformInfo ti, IGeom geom, Collection<? extends IRaster3D> rasters) {
        if (!geom.isAxisAlignedBlock(ti)) {
            return true;
        }
        if (!this.d_domain.getRastOptions().rasterizeAligned) {
            return false;
        }
        AABox bounds = ti.getBounds(geom, new AABox());
        Point3d[] verts = bounds.getVerts();
        for (IRaster3D iRaster3D : rasters) {
            double[] xdiv = iRaster3D.getXDiv();
            double[] ydiv = iRaster3D.getYDiv();
            double[] zdiv = iRaster3D.getZDiv();
            for (Point3d p : verts) {
                int loc = theUtil.binarySearch(xdiv, p.x, s_gridAlignComp);
                if (loc < 0) {
                    return true;
                }
                loc = theUtil.binarySearch(ydiv, p.y, s_gridAlignComp);
                if (loc < 0) {
                    return true;
                }
                loc = theUtil.binarySearch(zdiv, p.z, s_gridAlignComp);
                if (loc >= 0) continue;
                return true;
            }
        }
        return false;
    }

    private IFDSObjProps retrieveRasterProps(FDSObject obj, Collection<? extends IRaster3D> rasters) {
        return this.shouldRasterize(obj, rasters) ? obj.getFragGenerator() : null;
    }

    private static class MultiPropMerger
    implements AdjacencyMerger.IMergeQuery<MultiProps> {
        private final int[] props1 = new int[6];
        private final int[] props2 = new int[6];

        private MultiPropMerger() {
        }

        @Override
        public MultiProps merge(MultiProps v1, MultiProps v2, AdjacencyMerger.Dir dir) {
            switch (dir) {
                case X: {
                    return this.mergeX(v1, v2);
                }
                case Y: {
                    return this.mergeY(v1, v2);
                }
                case Z: {
                    return this.mergeZ(v1, v2);
                }
            }
            return null;
        }

        private MultiProps mergeX(MultiProps v1, MultiProps v2) {
            return this.merge(v1, v2, 2, 4);
        }

        private MultiProps mergeY(MultiProps v1, MultiProps v2) {
            return this.merge(v1, v2, 0, 4);
        }

        private MultiProps mergeZ(MultiProps v1, MultiProps v2) {
            return this.merge(v1, v2, 0, 2);
        }

        private MultiProps merge(MultiProps v1, MultiProps v2, int f0, int f1) {
            int[] props2;
            int[] props1 = FDSRasterization.expand(v1.props, 6, this.props1);
            if (FDSRasterization.compareProps(props1[f0], (props2 = FDSRasterization.expand(v2.props, 6, this.props2))[f0]) && FDSRasterization.compareProps(props1[f0 + 1], props2[f0 + 1]) && FDSRasterization.compareProps(props1[f1], props2[f1]) && FDSRasterization.compareProps(props1[f1 + 1], props2[f1 + 1])) {
                int[] newProps = new int[6];
                for (int m = 0; m < 6; m += 2) {
                    newProps[m] = props1[m] != -1 ? props1[m] : props2[m];
                    newProps[m + 1] = props2[m + 1] != -1 ? props2[m + 1] : props1[m + 1];
                }
                return new MultiProps(newProps);
            }
            return null;
        }
    }

    private static class PlaneMultiPropMerger
    implements AdjacencyMerger.IMergeQuery<MultiProps> {
        private final int[] props1 = new int[2];
        private final int[] props2 = new int[2];
        private final AdjacencyMerger.Dir dir;

        public PlaneMultiPropMerger(AdjacencyMerger.Dir dir) {
            this.dir = dir;
        }

        @Override
        public MultiProps merge(MultiProps v1, MultiProps v2, AdjacencyMerger.Dir dir) {
            int[] props2;
            if (dir.equals((Object)this.dir)) {
                return null;
            }
            int[] props1 = FDSRasterization.expand(v1.props, 2, this.props1);
            if (props1[0] == (props2 = FDSRasterization.expand(v2.props, 2, this.props2))[0] && props1[1] == props2[1]) {
                return v1;
            }
            return null;
        }
    }

    private static class MultiProps {
        public final int[] props;

        public MultiProps(int[] props) {
            this.props = props;
        }
    }
}

